/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.utils;

import com.newtouch.base.enums.ConditionType;
import com.newtouch.base.vo.GenerateConditionParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class ConditionUtil
implements Serializable {
    private static Map<String, String> conditionMap = new HashMap<String, String>();
    private static final String PLACEHOLDER = "?";

    public static Tuple2<String, Object[]> generatePlaceholderConditionByList(List<GenerateConditionParam> params) {
        return params.stream().map(ConditionUtil::generatePlaceholderCondition).reduce(Tuples.of((Object)"", (Object)Lists.newArrayList()), (a, b) -> {
            ((List)a.getT2()).addAll((Collection)b.getT2());
            return Tuples.of((Object)((String)a.getT1() + " " + (String)b.getT1()), (Object)a.getT2());
        }).mapT2(list -> list.toArray(new Object[0]));
    }

    public static Tuple2<String, List<Object>> generatePlaceholderCondition(GenerateConditionParam param) {
        ArrayList placeholderList = Lists.newArrayList();
        StringBuilder sql = new StringBuilder();
        String relationType = param.getRelationType();
        List<Object> columnValue = param.getColumnValue();
        String columnName = param.getColumnName();
        String tableName = param.getTableName();
        String operator = param.getOperator();
        Boolean needParentheses = param.getNeedParentheses();
        List<GenerateConditionParam> childCondition = param.getChildCondition();
        if (StringUtils.isNotBlank((CharSequence)relationType)) {
            sql.append(" ").append(relationType).append(" ");
        }
        Tuple2 chileCondition = null;
        if (CollectionUtils.isNotEmpty(childCondition)) {
            chileCondition = childCondition.stream().map(ConditionUtil::generatePlaceholderCondition).reduce(Tuples.of((Object)"", (Object)Lists.newArrayList()), (a, b) -> {
                ((List)a.getT2()).addAll((Collection)b.getT2());
                return Tuples.of((Object)((String)a.getT1() + " " + (String)b.getT1()), (Object)a.getT2());
            });
        }
        if (StringUtils.isNotBlank((CharSequence)columnName) && CollectionUtils.isNotEmpty(columnValue)) {
            String condition;
            if (StringUtils.isNotBlank((CharSequence)tableName)) {
                sql.append(tableName).append(".");
            }
            if ((condition = conditionMap.get(operator)).contains("valueList")) {
                ArrayList list = Lists.newArrayList();
                for (int i = 0; i < columnValue.size(); ++i) {
                    list.add(PLACEHOLDER);
                    placeholderList.add(columnValue.get(i));
                }
                condition = condition.replace("${valueList}", StringUtils.join((Iterable)list, (String)","));
            } else {
                for (int i = 0; i < columnValue.size(); ++i) {
                    condition = condition.replace("${value" + i + "}", PLACEHOLDER);
                    if ("like".equals(operator) || "unlike".equals(operator)) {
                        placeholderList.add("'%" + columnValue.get(i) + "%'");
                        continue;
                    }
                    placeholderList.add(columnValue.get(i));
                }
            }
            sql.append(columnName).append(" ").append(condition);
        }
        if (needParentheses.booleanValue() && CollectionUtils.isNotEmpty(childCondition) && Objects.nonNull(chileCondition)) {
            sql.append("(").append(((String)chileCondition.getT1()).substring(5)).append(")");
            placeholderList.addAll((Collection)chileCondition.getT2());
        }
        return Tuples.of((Object)sql.toString(), (Object)placeholderList);
    }

    static {
        conditionMap = ConditionType.toMap();
    }
}

