/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.utils;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.uniapis.logger.Ulog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class EasyExcelUtil {
    private EasyExcelUtil() {
    }

    public static void writeExcel(HttpServletResponse response, String fileName, String sheetName, List<String> columnList, List<String> fieldList, List<Map<String, Object>> objectList) {
        try {
            if (StringUtils.isEmpty((CharSequence)sheetName)) {
                sheetName = "Sheet1";
            }
            if (response == null) {
                ((ExcelWriterBuilder)EasyExcel.write((String)fileName).head(EasyExcelUtil.head(columnList))).sheet(sheetName).doWrite(EasyExcelUtil.dataList(fieldList, objectList));
            } else {
                ((ExcelWriterBuilder)EasyExcel.write((OutputStream)EasyExcelUtil.getOutputStream(fileName, response)).head(EasyExcelUtil.head(columnList))).sheet(sheetName).doWrite(EasyExcelUtil.dataList(fieldList, objectList));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static List<List<String>> head(List<String> columnList) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (String col : columnList) {
            ArrayList<String> head = new ArrayList<String>();
            head.add(col);
            list.add(head);
        }
        return list;
    }

    private static List<List<Object>> dataList(List<String> fieldList, List<Map<String, Object>> mapList) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        for (Map<String, Object> map : mapList) {
            ArrayList<Object> data = new ArrayList<Object>();
            for (String field : fieldList) {
                data.add(map.get(field));
            }
            list.add(data);
        }
        return list;
    }

    private static OutputStream getOutputStream(String fileName, HttpServletResponse response) throws Exception {
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf8");
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()) + ".xlsx");
            response.setHeader("Pragma", "public");
            response.setHeader("Cache-Control", "no-store");
            response.addHeader("Cache-Control", "max-age=0");
            return response.getOutputStream();
        }
        catch (IOException e) {
            throw new Exception("\u5bfc\u51faexcel\u8868\u683c\u5931\u8d25!", e);
        }
    }

    public static List<Map<String, Object>> readExcel(InputStream inputStream) {
        final ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        try {
            EasyExcel.read((InputStream)inputStream, (ReadListener)new AnalysisEventListener<Map<String, Object>>(){
                private Map<Integer, String> headMap;

                public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
                    this.headMap = headMap;
                    Ulog.info((String)("\u8868\u5934\u4fe1\u606f\uff1a" + headMap));
                }

                public void invoke(Map<String, Object> valueData, AnalysisContext context) {
                    HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                    for (int i = 0; i < valueData.size(); ++i) {
                        String key = this.headMap.get(i);
                        Object value = valueData.get(i);
                        paramsMap.put(key, value);
                    }
                    dataList.add(paramsMap);
                }

                public void doAfterAllAnalysed(AnalysisContext context) {
                    Ulog.info((String)("Excel\u8bfb\u53d6\u5b8c\u6210,\u884c\u6570\uff1a" + dataList.size()));
                }
            }).sheet().doRead();
            return dataList;
        }
        catch (Exception e) {
            Ulog.error((String)("\u6587\u4ef6\u4e0d\u5b58\u5728" + e.getMessage()));
            return null;
        }
    }
}

