/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import com.newtouch.base.config.ObsConfig;
import com.newtouch.base.config.SyAccountConfig;
import com.newtouch.base.service.SysDataService;
import com.newtouch.base.utils.hwobs.HWYObsAPIUtis;
import com.newtouch.base.utils.hwobs.HWYObsSDKUtis;
import com.newtouch.base.utils.obs.ObjectStorageDownLoadUtil;
import com.newtouch.base.utils.obs.ObjectStorageUploadUtil;
import com.newtouch.material.model.ScglMaterial;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.DateUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysDataServiceImpl
implements SysDataService {
    @Autowired
    private ObjectStorageUploadUtil objectStorageUploadUtil;
    @Autowired
    private ObjectStorageDownLoadUtil objectStorageDownLoadUtil;
    @Autowired
    private SyAccountConfig syAccountConfig;
    @Autowired
    AbsModelRepository dao;
    @Autowired
    HWYObsAPIUtis hwyObsAPIUtis;
    @Autowired
    HWYObsSDKUtis hwyObsSDKUtis;
    @Autowired
    ObsConfig obsConfig;
    private static final List<String> FILE_TYPE_LIST = new ArrayList<String>(Arrays.asList("GIF", "JPG", "JPEG", "PNG", "MP4", "PDF", "HTML", "gif", "jpg", "jpeg", "png", "mp4", "pdf", "html"));

    @Override
    public ReturnMsg uploadFile(MultipartFile file, String fileType) {
        Return msg = new Return();
        String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        if (!FILE_TYPE_LIST.contains(suffix)) {
            msg.setFailMsg("\u4e0a\u4f20\u7684\u7d20\u6750\u7c7b\u578b\u4e0d\u662fGIF,JPG,JPEG,PNG,mp4,pdf,html\u683c\u5f0f");
            return msg.msg();
        }
        String fileName = fileType + "/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "." + suffix;
        String pathName = this.syAccountConfig.getUploadUrl() + fileName;
        try {
            File fileNew = new File(pathName);
            FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)fileNew);
            String key = this.syAccountConfig.getObsUrl() + fileName;
            String url = this.objectStorageUploadUtil.putObject(key, fileNew);
            msg.getDataTable().put("url", url);
            msg.getDataTable().put("key", key);
            msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        }
        catch (Exception e) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
        }
        return msg.msg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnMsg downloadFile(String key, HttpServletResponse response) {
        InputStream inStream = this.objectStorageDownLoadUtil.getObject(key);
        OutputStream baos = null;
        try {
            int len;
            byte[] buffer = new byte[1024];
            baos = new ByteArrayOutputStream();
            while ((len = inStream.read(buffer)) != -1) {
                ((ByteArrayOutputStream)baos).write(buffer, 0, len);
            }
            response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            String fileName = key;
            if (key.contains("/")) {
                String[] split = key.split("/");
                fileName = split[split.length - 1];
            }
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            ServletOutputStream stream = response.getOutputStream();
            stream.write(((ByteArrayOutputStream)baos).toByteArray());
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                baos.flush();
                ((ByteArrayOutputStream)baos).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnMsg getObjectStorage(String key, HttpServletResponse response) {
        InputStream inStream = this.objectStorageDownLoadUtil.getObject(key);
        String fileType = key.substring(key.indexOf(".") + 1);
        OutputStream baos = null;
        try {
            int len;
            byte[] buffer = new byte[1024];
            baos = new ByteArrayOutputStream();
            while ((len = inStream.read(buffer)) != -1) {
                ((ByteArrayOutputStream)baos).write(buffer, 0, len);
            }
            if ("mp4".equals(fileType)) {
                response.addHeader("Content-Type", "video/mp4;charset=UTF-8");
            } else if ("jpg".equalsIgnoreCase(fileType) || "png".equalsIgnoreCase(fileType) || "gif".equalsIgnoreCase(fileType)) {
                response.setContentType("image/" + fileType.toLowerCase());
            } else if ("pdf".equalsIgnoreCase(fileType)) {
                response.setContentType("application/pdf");
            } else if ("html".equalsIgnoreCase(fileType)) {
                response.setContentType("text/html");
            } else {
                response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
                response.setContentType("application/octet-stream;charset=ISO8859-1");
                String fileName = key;
                if (key.contains("/")) {
                    String[] split = key.split("/");
                    fileName = split[split.length - 1];
                }
                response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
                response.setCharacterEncoding("UTF-8");
            }
            ServletOutputStream stream = response.getOutputStream();
            stream.write(((ByteArrayOutputStream)baos).toByteArray());
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                baos.flush();
                ((ByteArrayOutputStream)baos).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public ReturnMsg uploadFileById(File file, String filePath, String id) throws FileNotFoundException {
        Return msg = new Return();
        FileInputStream inputStream = new FileInputStream(file);
        String fileName = this.obsConfig.getObsPath() + filePath + "/" + id;
        String pathName = this.syAccountConfig.getUploadUrl() + filePath + "/" + id;
        try {
            File fileNew = new File(pathName);
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)fileNew);
            msg.getDataTable().put("url", pathName);
            msg.getDataTable().put("key", fileName.replace(this.obsConfig.getObsPath(), this.obsConfig.getObsSplitPath()));
            msg.getDataTable().put("imagePath", fileName);
            msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.info((String)("\u4e0a\u4f20\u7d20\u6750\u6587\u4ef6\u5f02\u5e38--->" + e.getMessage()));
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
        }
        return msg.msg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnMsg downloadAuthorized(String[] key, HttpServletResponse response) throws IOException {
        InputStream inStream = this.hwyObsSDKUtis.getObject(key[0]);
        OutputStream baos = null;
        try {
            int len;
            byte[] buffer = new byte[1024];
            baos = new ByteArrayOutputStream();
            while ((len = inStream.read(buffer)) != -1) {
                ((ByteArrayOutputStream)baos).write(buffer, 0, len);
            }
            response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            String fileName = key[0];
            if (key[0].contains("/")) {
                String[] split = key[0].split("/");
                fileName = split[split.length - 1];
            }
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            ServletOutputStream stream = response.getOutputStream();
            stream.write(((ByteArrayOutputStream)baos).toByteArray());
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                baos.flush();
                ((ByteArrayOutputStream)baos).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnMsg downloadMaterial(String[] key, HttpServletResponse response) throws IOException {
        String downloadFilename = "\u7d20\u6750\u6750\u6599-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".zip";
        response.setContentType("application/octet-stream");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + URLEncoder.encode(downloadFilename, "UTF-8"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            for (String keyPath : key) {
                int r;
                byte[] buffer;
                File fileMaterial = new File(keyPath);
                String fileType = keyPath.substring(keyPath.lastIndexOf("."));
                InputStream inStream = this.hwyObsSDKUtis.getObject(keyPath);
                if (".peg".equals(fileType) || ".jpg".equals(fileType) || ".png".equals(fileType) || ".gif".equals(fileType)) {
                    zos.putNextEntry(new ZipEntry("\u56fe\u7247" + File.separator + this.getFileName(keyPath)));
                    if (null == inStream) continue;
                    buffer = new byte[1024];
                    while ((r = inStream.read(buffer)) != -1) {
                        zos.write(buffer, 0, r);
                    }
                    continue;
                }
                if (".mp4".equals(fileType)) {
                    zos.putNextEntry(new ZipEntry("\u97f3\u9891" + File.separator + this.getFileName(keyPath)));
                    if (null == inStream) continue;
                    buffer = new byte[1024];
                    while ((r = inStream.read(buffer)) != -1) {
                        zos.write(buffer, 0, r);
                    }
                    continue;
                }
                if (".pdf".equals(fileType)) {
                    zos.putNextEntry(new ZipEntry("pdf" + File.separator + this.getFileName(keyPath)));
                    if (null == inStream) continue;
                    buffer = new byte[1024];
                    while ((r = inStream.read(buffer)) != -1) {
                        zos.write(buffer, 0, r);
                    }
                    continue;
                }
                if (!".html".equals(fileType)) continue;
                zos.putNextEntry(new ZipEntry("html" + File.separator + this.getFileName(keyPath)));
                if (null == inStream) continue;
                buffer = new byte[1024];
                while ((r = inStream.read(buffer)) != -1) {
                    zos.write(buffer, 0, r);
                }
            }
            IOUtils.closeQuietly((OutputStream)zos);
            byte[] bytes = baos.toByteArray();
            IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                baos.flush();
                baos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public ReturnMsg hwyObsListAllMyBuckets() {
        Return msg = new Return();
        String s = this.hwyObsAPIUtis.listAllMyBuckets();
        msg.getDataTable().put("buckets", s);
        return msg.msg();
    }

    @Override
    public ReturnMsg putObjectToBucket(MultipartFile file, String fileType) {
        Return msg = new Return();
        String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        String fileName = fileType + "/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "." + suffix;
        String objectPath = this.obsConfig.getObsPath() + fileName;
        String pathName = this.syAccountConfig.getUploadUrl() + fileName;
        try {
            File fileNew = new File(pathName);
            Ulog.info((String)("nas\u6587\u4ef6\u8def\u5f84--->" + pathName));
            FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)fileNew);
            Ulog.info((String)("obs\u6587\u4ef6\u8def\u5f84--->" + objectPath));
            msg.getDataTable().put("url", pathName);
            msg.getDataTable().put("imagePath", objectPath);
            msg.getDataTable().put("key", objectPath.replace(this.obsConfig.getObsPath(), this.obsConfig.getObsSplitPath()));
            msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.info((String)("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38--->" + e.getMessage()));
            Ulog.debug((Object)e);
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
        }
        return msg.msg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnMsg downloadObjectFromBucket(String objectPath, HttpServletResponse response) {
        InputStream inStream = this.hwyObsSDKUtis.getObject(objectPath);
        String fileType = objectPath.substring(objectPath.indexOf(".") + 1);
        OutputStream baos = null;
        try {
            int len;
            byte[] buffer = new byte[1024];
            baos = new ByteArrayOutputStream();
            while ((len = inStream.read(buffer)) != -1) {
                ((ByteArrayOutputStream)baos).write(buffer, 0, len);
            }
            if ("mp4".equals(fileType)) {
                response.addHeader("Content-Type", "video/mp4;charset=UTF-8");
            } else if ("jpg".equalsIgnoreCase(fileType) || "png".equalsIgnoreCase(fileType) || "gif".equalsIgnoreCase(fileType)) {
                response.setContentType("image/" + fileType.toLowerCase());
            } else if ("pdf".equalsIgnoreCase(fileType)) {
                response.setContentType("application/pdf");
            } else if ("html".equalsIgnoreCase(fileType)) {
                response.setContentType("text/html");
            } else {
                response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
                response.setContentType("application/octet-stream;charset=ISO8859-1");
                String fileName = objectPath;
                if (objectPath.contains("/")) {
                    String[] split = objectPath.split("/");
                    fileName = split[split.length - 1];
                }
                response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
                response.setCharacterEncoding("UTF-8");
            }
            ServletOutputStream stream = response.getOutputStream();
            stream.write(((ByteArrayOutputStream)baos).toByteArray());
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                baos.flush();
                ((ByteArrayOutputStream)baos).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String getFileName(String filePath) {
        String fileName = ((ScglMaterial)this.dao.findOne(ScglMaterial.n().where().addEq(ScglMaterial.FILE_NAME, (Object)filePath).model())).getMaterialName();
        return fileName;
    }
}

