/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import com.newtouch.base.service.ScpzTagsService;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.newtouch.material.model.ScpzTags;
import com.uniapis.cache.CacheManager;
import com.uniapis.model.sys.SysEnum;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ScpzTagsServiceImpl
implements ScpzTagsService {
    @Autowired
    AbsModelRepository dao;

    @Override
    public ReturnMsg addTag(ScpzTags scpzTags) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)((Object)scpzTags))) {
            msg.setFailMsg("\u65b0\u589e\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)scpzTags.getTagName())) {
            msg.setFailMsg("\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (scpzTags.getTagName().length() > 32) {
            msg.setFailMsg("\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u8d8532\u5b57\u7b26\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)scpzTags.getTagCategories())) {
            scpzTags.setTagCategories("common");
        } else {
            scpzTags.setTagCategories(scpzTags.getTagCategories());
        }
        ScpzTags scpzTagsCheck = new ScpzTags();
        scpzTagsCheck.where().addEq(ScpzTags.TAG_NAME, (Object)scpzTags.getTagName());
        scpzTagsCheck.where().addEq(ScpzTags.TAG_CATEGORIES, (Object)scpzTags.getTagCategories());
        List all = this.dao.findAll((AbsModel)scpzTagsCheck);
        if (!ObjectUtils.isEmpty((Object)all)) {
            msg.setFailMsg("\u540c\u4e00\u5206\u7c7b\u4e0b\u7684\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            return msg.msg();
        }
        String uUid = UUID.shortUUID();
        scpzTags.setTagId(uUid);
        this.dao.save((AbsModel)scpzTags);
        msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg delTag(ScpzTags scpzTags) {
        Return msg = new Return();
        String tagId = scpzTags.getTagId();
        if (tagId == null) {
            msg.setFailMsg("\u6240\u9009\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        ScpzMaterialTagsRelation scpzMaterialTagsRelationCheck = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelationCheck.where().addEq(ScpzMaterialTagsRelation.TAG_ID, (Object)tagId);
        List scpzMaterialTagsRelationCheckList = this.dao.findAll((AbsModel)scpzMaterialTagsRelationCheck);
        if (!ObjectUtils.isEmpty((Object)scpzMaterialTagsRelationCheckList)) {
            msg.setFailMsg("\u6807\u7b7e\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
            return msg.msg();
        }
        ScpzTags scpzTagsDel = new ScpzTags();
        scpzTagsDel.where().addEq(ScpzTags.TAG_ID, (Object)tagId);
        this.dao.delete((AbsModel)scpzTagsDel);
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg editTag(ScpzTags scpzTags) {
        Return msg = new Return();
        String tagId = scpzTags.getTagId();
        String tagName = scpzTags.getTagName();
        String tagCategories = scpzTags.getTagCategories();
        if (tagId == null) {
            msg.setFailMsg("\u6240\u9009\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (tagName == null) {
            msg.setFailMsg("\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (tagCategories == null) {
            msg.setFailMsg("\u6807\u7b7e\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (scpzTags.getTagName().length() > 32) {
            msg.setFailMsg("\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u8d8532\u5b57\u7b26\uff01");
            return msg.msg();
        }
        ScpzTags scpzTagsEdit = new ScpzTags();
        scpzTagsEdit.setTagName(tagName);
        scpzTagsEdit.where().addEq(ScpzTags.TAG_ID, (Object)tagId);
        this.dao.update((AbsModel)scpzTagsEdit);
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryTagRelationsList(String tagId, String tagBelongsList) {
        Return msg = new Return();
        ArrayList resList = new ArrayList();
        String[] tagBelongs = tagBelongsList.split(",");
        ScpzMaterialTagsRelation scpzMaterialTagsRelation = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation.where().addEq(ScpzMaterialTagsRelation.TAG_ID, (Object)tagId);
        for (String tagBelong : tagBelongs) {
            scpzMaterialTagsRelation.where().addLike(ScpzMaterialTagsRelation.TAG_BELONGS, (Object)tagBelong);
            scpzMaterialTagsRelation.setOrderBy(ScpzMaterialTagsRelation.CRT_DATE.desc());
            resList.addAll(this.dao.findAll((AbsModel)scpzMaterialTagsRelation));
        }
        msg.setDataList(resList, ScpzMaterialTagsRelation.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryTagRelationList(String tagId, String tagBelongs) {
        Return msg = new Return();
        ScpzMaterialTagsRelation scpzMaterialTagsRelation = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation.where().addLike(ScpzMaterialTagsRelation.TAG_ID, (Object)tagId);
        scpzMaterialTagsRelation.where().addLike(ScpzMaterialTagsRelation.TAG_BELONGS, (Object)tagBelongs);
        scpzMaterialTagsRelation.setOrderBy(ScpzMaterialTagsRelation.CRT_DATE.desc());
        List tagRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation);
        msg.setDataList(tagRelationList, ScpzMaterialTagsRelation.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryTagList(String tagName) {
        Return msg = new Return();
        SysEnum sysEnum = new SysEnum();
        sysEnum.where().addEq(SysEnum.ENUM_TYPE, (Object)"tag_categories");
        List sysEnums = this.dao.findAll((AbsModel)sysEnum);
        ArrayList tagCategoriesList = new ArrayList();
        for (SysEnum anEnum : sysEnums) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ScpzTags scpzTags = new ScpzTags();
            scpzTags.where().addEq(ScpzTags.TAG_CATEGORIES, (Object)anEnum.getEnumCode());
            scpzTags.where().addLike(ScpzTags.TAG_NAME, (Object)tagName);
            List tagList = this.dao.findAll((AbsModel)scpzTags);
            map.put("tag_categories", anEnum.getEnumCode());
            map.put("tag_list", tagList);
            tagCategoriesList.add(map);
        }
        msg.setDataTable(Stream.of(new Object[][]{{"tag_categories_list", tagCategoriesList}}).collect(Collectors.toMap(data -> (String)data[0], data -> (List)data[1])));
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addTagCategories(SysEnum sysEnum) {
        Return msg = new Return();
        if (sysEnum.getEnumCode().isEmpty()) {
            msg.setFailMsg("\u8bf7\u8f93\u5165\u6807\u7b7e\u5206\u7c7b\u7f16\u7801");
            return msg.msg();
        }
        if (sysEnum.getEnumName().isEmpty()) {
            msg.setFailMsg("\u8bf7\u8f93\u5165\u6807\u7b7e\u5206\u7c7b\u540d\u79f0");
            return msg.msg();
        }
        if (sysEnum.getEnumName().length() > 64) {
            msg.setFailMsg("\u6807\u7b7e\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u8d8564\u4f4d\u5b57\u7b26");
            return msg.msg();
        }
        List sysEnums = this.dao.findAll(SysEnum.n().where().addEq(SysEnum.ENUM_CODE, (Object)sysEnum.getEnumCode()).addEq(SysEnum.ENUM_TYPE, (Object)"tag_categories").model());
        if (!sysEnums.isEmpty()) {
            msg.setFailMsg("\u6807\u7b7e\u5206\u7c7b\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff01");
            return msg.msg();
        }
        sysEnums = this.dao.findAll(SysEnum.n().where().addEq(SysEnum.ENUM_NAME, (Object)sysEnum.getEnumName()).addEq(SysEnum.ENUM_TYPE, (Object)"tag_categories").model());
        if (!sysEnums.isEmpty()) {
            msg.setFailMsg("\u6807\u7b7e\u5206\u7c7b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            return msg.msg();
        }
        int maxEnumOrder = this.getMaxEnumOrder();
        if (sysEnum.getEnumOrder() == null || sysEnum.getEnumOrder() > maxEnumOrder + 1) {
            sysEnum.setEnumOrder(Integer.valueOf(maxEnumOrder + 1));
        } else {
            if (sysEnum.getEnumOrder() < 1) {
                sysEnum.setEnumOrder(Integer.valueOf(1));
            }
            String updateSql = "update sys_enum se set se.enum_order = se.enum_order + 1 where se.enum_order between ? and ? \uff03NOTCHECK";
            this.dao.update(updateSql, new Object[]{sysEnum.getEnumOrder(), maxEnumOrder});
        }
        sysEnum.setEnumId(UUID.shortUUID());
        sysEnum.setUpEnum("I5CNP8Ff");
        sysEnum.setEnumType("tag_categories");
        this.dao.save((AbsModel)sysEnum);
        CacheManager.removeHash((String)"dicType", (Object[])new Object[]{"tag_categories"});
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    private int getMaxEnumOrder() {
        SysEnum tagCategories = new SysEnum();
        tagCategories.where().addEq(SysEnum.ENUM_TYPE, (Object)"tag_categories");
        tagCategories.groupBy().max(SysEnum.ENUM_ORDER);
        SysEnum anEnum = (SysEnum)this.dao.findOne((AbsModel)tagCategories);
        int maxEnumOrder = !StrUtils.isNull((Object)anEnum.getOtherProperty("max_enum_order").toString()) ? Integer.parseInt(anEnum.getOtherProperty("max_enum_order").toString()) : 0;
        return maxEnumOrder;
    }

    @Override
    public ReturnMsg delTagCategories(SysEnum sysEnum) {
        Return msg = new Return();
        String enumCode = sysEnum.getEnumCode();
        String enumId = sysEnum.getEnumId();
        if (sysEnum.getEnumCode().isEmpty()) {
            msg.setFailMsg("\u6807\u7b7e\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        ScpzTags scpzTagsCheck = new ScpzTags();
        scpzTagsCheck.where().addEq(ScpzTags.TAG_CATEGORIES, (Object)enumCode);
        List scpzTagsCheckList = this.dao.findAll((AbsModel)scpzTagsCheck);
        if (!ObjectUtils.isEmpty((Object)scpzTagsCheckList)) {
            msg.setFailMsg("\u6807\u7b7e\u5206\u7c7b\u4e0b\u5b58\u5728\u6807\u7b7e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
            return msg.msg();
        }
        SysEnum one = (SysEnum)this.dao.findOne(SysEnum.n().where().addEq(SysEnum.ENUM_ID, (Object)enumId).model());
        int deleteOrder = one.getEnumOrder();
        int maxEnumOrder = this.getMaxEnumOrder();
        String updateSql = "update sys_enum se set se.enum_order = se.enum_order - 1 where se.enum_order between ? and ? \uff03NOTCHECK";
        this.dao.update(updateSql, new Object[]{deleteOrder + 1, maxEnumOrder});
        SysEnum sysEnumDel = new SysEnum();
        sysEnumDel.where().addEq(SysEnum.ENUM_ID, (Object)enumId);
        this.dao.delete((AbsModel)sysEnumDel);
        CacheManager.removeHash((String)"dicType", (Object[])new Object[]{"tag_categories"});
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg editTagCategories(SysEnum sysEnum) {
        Return msg = new Return();
        if (sysEnum.getEnumId().isEmpty()) {
            msg.setFailMsg("\u6240\u9009\u6807\u7b7e\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (sysEnum.getEnumName().isEmpty()) {
            msg.setFailMsg("\u6807\u7b7e\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (sysEnum.getEnumName().length() > 64) {
            msg.setFailMsg("\u6807\u7b7e\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u8d8564\u4f4d\u5b57\u7b26");
            return msg.msg();
        }
        SysEnum sysEnumCheck = new SysEnum();
        sysEnumCheck.where().addEq(SysEnum.ENUM_NAME, (Object)sysEnum.getEnumName());
        sysEnumCheck.where().addEq(SysEnum.ENUM_TYPE, (Object)"tag_categories");
        List sysEnumCheckList = this.dao.findAll((AbsModel)sysEnumCheck);
        if (!ObjectUtils.isEmpty((Object)sysEnumCheckList)) {
            msg.setFailMsg("\u6807\u7b7e\u5206\u7c7b\u5b58\u5728\u91cd\u590d\uff01");
            return msg.msg();
        }
        SysEnum sysEnumEdit = new SysEnum();
        sysEnumEdit.setEnumName(sysEnum.getEnumName());
        sysEnumEdit.where().addEq(SysEnum.ENUM_ID, (Object)sysEnum.getEnumId());
        this.dao.update((AbsModel)sysEnumEdit);
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        CacheManager.removeHash((String)"dicType", (Object[])new Object[]{"tag_categories"});
        return msg.msg();
    }
}

