/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.flow.vo;

import com.newtouch.flow.param.QueryTagsRelationParam;
import com.newtouch.flow.param.QueryTagsRelationReturn;
import com.newtouch.issue.model.WtIssue;
import com.newtouch.issue.param.QueryWtIssueParam;
import com.newtouch.issue.service.IWtIssueService;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class WtIssueVo {
    private AbsModelRepository dao = (AbsModelRepository)SpringContext.getBean(AbsModelRepository.class);
    private IWtIssueService iWtIssueService = (IWtIssueService)SpringContext.getBean(IWtIssueService.class);
    private List<WtIssue> wtIssues;

    public List<WtIssue> load(String json) {
        HashSet<String> questionUrlSet = new HashSet<String>();
        this.getQuestionUrl(JsonUtils.json2Map((String)json), questionUrlSet);
        this.wtIssues = this.getWtIssue(questionUrlSet);
        return this.wtIssues;
    }

    private List<WtIssue> getWtIssue(Set<String> urls) {
        ArrayList<WtIssue> wtIssueList = new ArrayList<WtIssue>();
        for (String url : urls) {
            String patternString = "([^&?=]+)=([^&?=]*)";
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(url);
            QueryWtIssueParam queryWtIssueParam = new QueryWtIssueParam();
            while (matcher.find()) {
                if (matcher.group(1).equals("tagIds") & !StrUtils.isNull((Object)matcher.group(2))) {
                    String tagIdsStr = matcher.group(2).replaceAll("\\[|\\]", "");
                    String[] tagIds = tagIdsStr.split(",");
                    List<String> tagIdsList = Arrays.asList(tagIds);
                    queryWtIssueParam.setTagIds(tagIdsList);
                }
                if (matcher.group(1).equals("tag_belongs") & !StrUtils.isNull((Object)matcher.group(2))) {
                    queryWtIssueParam.setTagBelongs(matcher.group(2));
                }
                if (matcher.group(1).equals("allFlag")) {
                    queryWtIssueParam.setAllFlag(matcher.group(2));
                }
                if (!matcher.group(1).equals("issueName")) continue;
                queryWtIssueParam.setIssueName(matcher.group(2));
            }
            QueryTagsRelationParam tag = new QueryTagsRelationParam();
            tag.setRelationTab("wt_issue");
            tag.setRelationField("issue_uuid");
            tag.setTagBelongs(queryWtIssueParam.getTagBelongs());
            tag.setTagsId(queryWtIssueParam.getTagIds());
            ReturnMsg msgTag = this.iWtIssueService.queryTagsRelation(tag);
            List tagsList = msgTag.getDataList(QueryTagsRelationReturn.class);
            List idList = null;
            Map<Object, Object> listMaps = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)tagsList)) {
                idList = tagsList.stream().map(QueryTagsRelationReturn::getRelationFk).collect(Collectors.toList());
                listMaps = tagsList.stream().collect(Collectors.groupingBy(QueryTagsRelationReturn::getRelationFk));
            }
            WtIssue wtIssue = new WtIssue();
            if (!StrUtils.isNull((Object)queryWtIssueParam.getIssueName())) {
                wtIssue.where().addLike(WtIssue.ISSUE_NAME, (Object)queryWtIssueParam.getIssueName());
            }
            if (CollectionUtils.isNotEmpty(queryWtIssueParam.getTagIds())) {
                if (CollectionUtils.isEmpty(idList)) {
                    ArrayList<WtIssue> wtIssueListCheck = new ArrayList<WtIssue>();
                    return wtIssueListCheck;
                }
                wtIssue.where().addIn(WtIssue.ISSUE_UUID, idList);
            }
            wtIssue.where().addEq(WtIssue.DATA_FLAG, (Object)1);
            wtIssue.setOrderBy(WtIssue.CRT_DATE.desc());
            List mapList = new ArrayList();
            String allFlag = queryWtIssueParam.getAllFlag();
            mapList = !StrUtils.isNull((Object)allFlag) && "Y".equals(allFlag) ? this.dao.findAll((AbsModel)wtIssue, Boolean.valueOf(false)) : this.dao.findAll((AbsModel)wtIssue, Boolean.valueOf(true));
            Map<Object, Object> finalListMaps = listMaps;
            mapList.stream().forEach(o -> {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)finalListMaps.get(o.getIssueUuid())))) {
                    o.setTags((List)finalListMaps.get(o.getIssueUuid()));
                }
            });
            wtIssueList.addAll(mapList);
        }
        return wtIssueList;
    }

    private void getQuestionUrl(Map<String, Object> map, Set<String> list) {
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            Object value = map.get(key);
            if (value instanceof List) {
                ((List)value).stream().forEach(o -> {
                    if (o instanceof Map) {
                        this.getQuestionUrl((Map)o, list);
                    }
                    if (o instanceof String) {
                        if (((String)key).contains("attr_json")) {
                            this.getQuestionUrl(JsonUtils.json2Map((String)((String)o)), list);
                        }
                        if (((String)o).contains("/wtIssue/queryWtIssueList.serv")) {
                            list.add((String)o);
                        }
                    }
                });
            }
            if (value instanceof Map) {
                this.getQuestionUrl((Map)value, list);
            }
            if (!(value instanceof String)) continue;
            if (key.contains("attr_json")) {
                this.getQuestionUrl(JsonUtils.json2Map((String)((String)value)), list);
                continue;
            }
            if (!((String)value).contains("/wtIssue/queryWtIssueList.serv")) continue;
            list.add((String)value);
        }
    }

    public List<WtIssue> getWtIssues() {
        return this.wtIssues;
    }

    public void setWtIssues(List<WtIssue> wtIssues) {
        this.wtIssues = wtIssues;
    }
}

