/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.transformer.util;

import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import com.newtouch.base.model.JkDataInfo;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TreeBuilder {
    List<JkDataInfo> nodes = new ArrayList<JkDataInfo>();
    ReadContext context;

    public String buildTree(List<JkDataInfo> nodes) {
        TreeBuilder treeBuilder = new TreeBuilder(nodes);
        return treeBuilder.buildJSONTree();
    }

    public String buildTreeWithValue(List<JkDataInfo> nodes, ReadContext context) {
        TreeBuilder treeBuilder = new TreeBuilder(nodes, context);
        return treeBuilder.buildJSONTreeWithValue();
    }

    public TreeBuilder() {
    }

    public TreeBuilder(List<JkDataInfo> nodes) {
        this.nodes = nodes;
    }

    public TreeBuilder(List<JkDataInfo> nodes, ReadContext context) {
        this.nodes = nodes;
        this.context = context;
    }

    public String buildJSONTree() {
        Object nodeTree = this.buildTree();
        return JsonUtils.toJson((Object)nodeTree);
    }

    public String buildJSONTreeWithValue() {
        Object nodeTree = this.buildTreeWithValue();
        return JsonUtils.toJson((Object)nodeTree);
    }

    public Object buildTree() {
        JkDataInfo root = this.nodes.stream().filter(p -> StrUtils.isNull((Object)p.getUpNode())).findFirst().get();
        if ("List".equals(root.getNodeType())) {
            return null;
        }
        HashMap treeNodes = new HashMap();
        root.setNodeElement(treeNodes);
        List<JkDataInfo> rootNodes = this.getRootNodes(root);
        for (JkDataInfo rootNode : rootNodes) {
            this.buildChildNodes(root, rootNode);
        }
        return treeNodes;
    }

    public Object buildTreeWithValue() {
        JkDataInfo root = this.nodes.stream().filter(p -> StrUtils.isNull((Object)p.getUpNode())).findFirst().get();
        if ("List".equals(root.getNodeType())) {
            return null;
        }
        HashMap treeNodes = new HashMap();
        root.setNodeElement(treeNodes);
        List<JkDataInfo> rootNodes = this.getRootNodes(root);
        for (JkDataInfo rootNode : rootNodes) {
            this.buildChildNodesWithValue(root, rootNode);
        }
        return treeNodes;
    }

    public void buildChildNodes(JkDataInfo parentNode, JkDataInfo curNode) {
        List<JkDataInfo> children = this.getChildNodes(curNode);
        if ("List".equals(curNode.getNodeType())) {
            LinkedList curNodeElemnt = new LinkedList();
            curNode.setNodeElement(curNodeElemnt);
            String parentNodeType = parentNode.getNodeType();
            if ("Map".equals(parentNodeType)) {
                ((Map)parentNode.getNodeElement()).put(curNode.getNodeNo(), curNodeElemnt);
            }
            if (!children.isEmpty()) {
                for (JkDataInfo child : children) {
                    this.buildChildNodes(curNode, child);
                }
            }
        } else if ("Map".equals(curNode.getNodeType())) {
            String parentNodeType = parentNode.getNodeType();
            HashMap curNodeElemnt = new HashMap();
            curNode.setNodeElement(curNodeElemnt);
            if ("List".equals(parentNodeType)) {
                ((List)parentNode.getNodeElement()).add(curNodeElemnt);
            } else if ("Map".equals(parentNodeType)) {
                ((Map)parentNode.getNodeElement()).put(curNode.getNodeNo(), curNodeElemnt);
            }
            if (!children.isEmpty()) {
                for (JkDataInfo child : children) {
                    this.buildChildNodes(curNode, child);
                }
            }
        } else {
            String parentNodeType = parentNode.getNodeType();
            if ("Map".equals(parentNodeType)) {
                if ("Integer".equals(curNode.getNodeType())) {
                    ((Map)parentNode.getNodeElement()).put(curNode.getNodeNo(), StrUtils.isNull((Object)curNode.getNodeValue()) ? 0 : Integer.valueOf(curNode.getNodeValue()));
                } else {
                    ((Map)parentNode.getNodeElement()).put(curNode.getNodeNo(), StrUtils.isNull((Object)curNode.getNodeValue()) ? "" : curNode.getNodeValue());
                }
            }
        }
    }

    public void buildChildNodesWithValue(JkDataInfo parentNode, JkDataInfo curNode) {
        List<JkDataInfo> children = this.getChildNodes(curNode);
        if ("List".equals(curNode.getNodeType())) {
            LinkedList curNodeElemnt = new LinkedList();
            curNode.setNodeElement(curNodeElemnt);
            String parentNodeType = parentNode.getNodeType();
            if ("Map".equals(parentNodeType)) {
                ((Map)parentNode.getNodeElement()).put(curNode.getNodeNo(), curNodeElemnt);
            }
            if (!children.isEmpty()) {
                for (JkDataInfo child : children) {
                    this.buildChildNodesWithValue(curNode, child);
                }
            }
        } else if ("Map".equals(curNode.getNodeType())) {
            String parentNodeType = parentNode.getNodeType();
            if ("List".equals(parentNodeType)) {
                String jsonPath = parentNode.getJkMappingRule().getMappingRule().concat(".length()");
                Object obj = this.context.read(jsonPath, new Predicate[0]);
                int length = Integer.parseInt(StrUtils.trimStr((Object)obj));
                for (int i = 0; i < length; ++i) {
                    HashMap curNodeElemnt = new HashMap();
                    curNode.setNodeElement(curNodeElemnt);
                    if (!children.isEmpty()) {
                        for (JkDataInfo child : children) {
                            String orginalMappingRule = child.getJkMappingRule().getMappingRule();
                            child.getJkMappingRule().setMappingRule(orginalMappingRule.replaceFirst("#i#", String.valueOf(i)));
                            this.buildChildNodesWithValue(curNode, child);
                            child.getJkMappingRule().setMappingRule(orginalMappingRule);
                        }
                    }
                    ((List)parentNode.getNodeElement()).add(curNodeElemnt);
                }
            } else if ("Map".equals(parentNodeType)) {
                HashMap curNodeElemnt = new HashMap();
                curNode.setNodeElement(curNodeElemnt);
                ((Map)parentNode.getNodeElement()).put(curNode.getNodeNo(), curNodeElemnt);
                if (!children.isEmpty()) {
                    for (JkDataInfo child : children) {
                        this.buildChildNodesWithValue(curNode, child);
                    }
                }
            }
        } else {
            Object obj = this.context.read(curNode.getJkMappingRule().getMappingRule(), new Predicate[0]);
            String curNodeElemnt = StrUtils.trimStr((Object)obj);
            String parentNodeType = parentNode.getNodeType();
            if ("Map".equals(parentNodeType)) {
                ((Map)parentNode.getNodeElement()).put(curNode.getNodeNo(), curNodeElemnt);
            }
        }
    }

    public List<JkDataInfo> getChildNodes(JkDataInfo pnode) {
        ArrayList<JkDataInfo> childNodes = new ArrayList<JkDataInfo>();
        for (JkDataInfo n : this.nodes) {
            if (!pnode.getDataUuid().equals(n.getUpNode())) continue;
            childNodes.add(n);
        }
        return childNodes;
    }

    public boolean rootNode(JkDataInfo node) {
        boolean isRootNode = true;
        for (JkDataInfo n : this.nodes) {
            if (!StrUtils.isNull((Object)node.getUpNode())) continue;
            isRootNode = false;
            break;
        }
        return isRootNode;
    }

    public List<JkDataInfo> getRootNodes(JkDataInfo root) {
        ArrayList<JkDataInfo> rootNodes = new ArrayList<JkDataInfo>();
        for (JkDataInfo n : this.nodes) {
            if (!root.getDataUuid().equals(n.getUpNode())) continue;
            rootNodes.add(n);
        }
        return rootNodes;
    }
}

