/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.transformer.controller;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ReadContext;
import com.newtouch.base.model.JkDataInfo;
import com.newtouch.base.model.JkMappingRule;
import com.newtouch.base.transformer.service.TransformerService;
import com.newtouch.base.transformer.util.TreeBuilder;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/transformer"})
public class TransformerController {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private TransformerService transformerService;

    @PostMapping(value={"/transToTarget.serv"})
    public void transToTarget() throws IOException {
        String path = "D:\\ideawork\\gitlab\\nms\\nms-page-conf\\src\\main\\java\\com\\newtouch\\base\\transformer\\jsonFile\\areaSimple.json";
        String inputJson = FileUtils.readFileToString((File)new File(path), (String)"utf-8");
        DocumentContext context = JsonPath.parse((String)inputJson);
        JkDataInfo data = JkDataInfo.n();
        data.setJkUuid("123");
        data.where().addEq(JkDataInfo.JK_UUID, (Object)data.getJkUuid());
        List nodes = this.dao.findAll((AbsModel)data);
        for (JkDataInfo node : nodes) {
            JkMappingRule mappingRule = JkMappingRule.n();
            mappingRule.setTargetDataUuid(node.getDataUuid());
            mappingRule.where().addEq(JkMappingRule.TARGET_DATA_UUID, (Object)node.getDataUuid());
            JkMappingRule rule = (JkMappingRule)this.dao.findOne((AbsModel)mappingRule);
            if (rule == null) continue;
            node.setJkMappingRule(rule);
            JkDataInfo sourceDataInfo = (JkDataInfo)this.dao.findOne(JkDataInfo.n().where().addEq(JkDataInfo.DATA_UUID, (Object)rule.getSourceDataUuid()).model());
            rule.setSourceDataInfo(sourceDataInfo);
        }
        String json = new TreeBuilder().buildTreeWithValue(nodes, (ReadContext)context);
        System.out.println(json);
    }

    @PostMapping(value={"/importTreeStruct.do"})
    public String saveTreeStruct(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        ReturnMsg msg = this.transformerService.importTreeStruct(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/exportTreeStruct.do"})
    public void exportTreeStruct(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        this.transformerService.exportTreeStruct(param, response);
    }

    @PostMapping(value={"/getTreeStruct.do"})
    public String getTreeStruct(HttpServletRequest request) {
        JkDataInfo targetData = (JkDataInfo)((Object)RequestUtils.getRequestMap((HttpServletRequest)request, JkDataInfo.class));
        ReturnMsg msg = this.transformerService.getTreeStruct(targetData);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/editNode.do"})
    public String eitNode(HttpServletRequest request) {
        JkDataInfo jkDataInfo = (JkDataInfo)((Object)RequestUtils.getRequestMap((HttpServletRequest)request, JkDataInfo.class));
        ReturnMsg msg = this.transformerService.eitNode(jkDataInfo);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/delNode.do"})
    public String delNode(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        ArrayList dataUuids = (ArrayList)param.get("data_uuids");
        ReturnMsg msg = this.transformerService.delNode(dataUuids);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/queryByDataUUid.do"})
    public String queryByDataUUid(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        String dataUuid = (String)param.get("data_uuid");
        ReturnMsg msg = this.transformerService.queryByDataUUid(dataUuid);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/linkNodes.do"})
    public String linkNodes(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        ReturnMsg msg = this.transformerService.linkNodes(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/cancelLink.do"})
    public String cancelLink(HttpServletRequest request) {
        JkDataInfo jkDataInfo = (JkDataInfo)((Object)RequestUtils.getRequestMap((HttpServletRequest)request, JkDataInfo.class));
        ReturnMsg msg = this.transformerService.cancelLink(jkDataInfo);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/checkDeleteTransformerData.do"})
    public String checkDeleteTransformerData(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        String jkUuid = (String)param.get("jkUuid");
        if (StrUtils.isNull((Object)jkUuid)) {
            throw new BusinessException("\u5165\u53c2jkUuid\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String dataType = (String)param.get("dataType");
        if (StrUtils.isNull((Object)dataType)) {
            throw new BusinessException("\u5165\u53c2dataType\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String dataClass = (String)param.get("dataClass");
        if (StrUtils.isNull((Object)dataClass)) {
            throw new BusinessException("\u5165\u53c2dataClass\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        ReturnMsg msg = this.transformerService.checkDeleteTransformerData(jkUuid, dataType, dataClass);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/deleteTransformerData.do"})
    public String deleteSourceData(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        String jkUuid = (String)param.get("jkUuid");
        if (StrUtils.isNull((Object)jkUuid)) {
            throw new BusinessException("\u5165\u53c2jkUuid\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String dataType = (String)param.get("dataType");
        if (StrUtils.isNull((Object)dataType)) {
            throw new BusinessException("\u5165\u53c2dataType\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String dataClass = (String)param.get("dataClass");
        if (StrUtils.isNull((Object)dataClass)) {
            throw new BusinessException("\u5165\u53c2dataClass\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        ReturnMsg msg = this.transformerService.deleteTransformerData(jkUuid, dataType, dataClass);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

