/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import com.newtouch.base.enums.BaseEnum;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.model.QsnPaper;
import com.newtouch.base.model.QsnPaperTemplate;
import com.newtouch.base.service.FormTemplateService;
import com.newtouch.base.service.PaperTemplateRelationService;
import com.newtouch.base.vo.FmTemplateSaveVo;
import com.newtouch.base.vo.export.PaperAllInfo;
import com.newtouch.base.vo.export.QueryPaperAllInfoVo;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaperTemplateRelationServiceImpl
implements PaperTemplateRelationService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    FormTemplateService formTemplateService;

    @Override
    public ReturnMsg queryPaperTemplateRelation(String paperUuid) {
        Return msg = new Return();
        String sqlqsnPaperTemplate = "SELECT a.*, b.template_name , b.template_type FROM qsn_paper_template a JOIN fm_template b ON a.template_id = b.template_id WHERE a.paper_uuid LIKE ? ";
        ArrayList<String> param = new ArrayList<String>();
        param.add(paperUuid);
        List qsnPaperTemplateRes = this.dao.findAll(sqlqsnPaperTemplate, QsnPaperTemplate.class, new AbsModelRepository.Args[]{this.dao.args(param)});
        msg.setDataList(qsnPaperTemplateRes, QsnPaperTemplate.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg delectPaperTemplateRelation(Map<String, Object> paramMap) {
        Return msg = new Return();
        List delList = (List)paramMap.get("del_list");
        if (null == delList || delList.isEmpty()) {
            msg.setWarnMsg("\u8bf7\u9009\u62e9\u8981\u53d6\u6d88\u5173\u8054\u7684\u8868\u5355\uff01");
            return msg.msg();
        }
        for (Map del : delList) {
            QsnPaperTemplate qsnPaperTemplate = new QsnPaperTemplate();
            String serno = StrUtils.trimStr(del.get("serno"));
            qsnPaperTemplate.where().addEq(AbsModel.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType()).addEq(QsnPaperTemplate.SERNO, (Object)serno);
            this.dao.delete((AbsModel)qsnPaperTemplate);
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryTemplate(String paperUuid, String templateName) {
        Return msg = new Return();
        FmTemplate fmTemplate = new FmTemplate();
        fmTemplate.where().addEq(AbsModel.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType()).addNotEq(FmTemplate.TEMPLATE_TYPE, (Object)"page");
        fmTemplate.where().addLike(FmTemplate.TEMPLATE_NAME, (Object)templateName);
        List fmTemplateRes = this.dao.findAll((AbsModel)fmTemplate);
        msg.setDataList(fmTemplateRes, FmTemplate.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryTemplateIdByPaperUuid(String paperUuid, String useScene) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)paperUuid) || StrUtils.isNull((Object)useScene)) {
            msg.setFailMsg(new Message("6040001", "\u95ee\u5377\u7f16\u53f7/\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        QsnPaperTemplate qsnPaperTemplateCheck = new QsnPaperTemplate();
        qsnPaperTemplateCheck.where().addEq(QsnPaperTemplate.PAPER_UUID, (Object)paperUuid);
        qsnPaperTemplateCheck.where().addEq(QsnPaperTemplate.USE_SCENE, (Object)useScene);
        QsnPaperTemplate qsnPaperTemplate = (QsnPaperTemplate)this.dao.findOne((AbsModel)qsnPaperTemplateCheck);
        if (StrUtils.isNull((Object)((Object)qsnPaperTemplate))) {
            QsnPaper qsnPaper = new QsnPaper();
            qsnPaper.where().addEq(QsnPaper.PAPER_UUID, (Object)paperUuid);
            qsnPaper = (QsnPaper)this.dao.findOne((AbsModel)qsnPaper);
            String paperType = qsnPaper.getPaperType();
            if ("inform".equals(paperType) || "qsn".equals(paperType)) {
                String collId = qsnPaper.getCollId();
                String paperName = qsnPaper.getPaperName();
                String deliveryPlatform = qsnPaper.getDeliveryPlatform();
                QsnPaperTemplate qsnPaperTemplateSave = new QsnPaperTemplate();
                String templateId = UUID.uuid();
                qsnPaperTemplateSave.setTemplateId(templateId);
                qsnPaperTemplateSave.setPaperUuid(paperUuid);
                qsnPaperTemplateSave.setUseScene(useScene);
                this.dao.save((AbsModel)qsnPaperTemplateSave);
                FmTemplateSaveVo fmTemplateSaveVo = new FmTemplateSaveVo();
                fmTemplateSaveVo.setCollId(collId);
                fmTemplateSaveVo.setTemplateId(templateId);
                fmTemplateSaveVo.setTemplateName(paperName);
                fmTemplateSaveVo.setTemplateType(paperType);
                fmTemplateSaveVo.setUseScene(useScene);
                fmTemplateSaveVo.setTemplateCode(UUID.shortUUID());
                fmTemplateSaveVo.setTemplateBelongs("form");
                fmTemplateSaveVo.setDeliveryPlatform(deliveryPlatform);
                this.formTemplateService.initAddOrUpdate(fmTemplateSaveVo);
                msg.setDataTable(new Object[]{qsnPaperTemplateSave});
                return msg.msg();
            }
        }
        msg.setDataTable(new Object[]{qsnPaperTemplate});
        return msg.msg();
    }

    @Override
    public ReturnMsg addPaperTemplateRelation(String paperUuid, FmTemplate fmTemplate, String useScene) {
        Return msg = new Return();
        fmTemplate.setIsEdit("Y");
        this.formTemplateService.createFormTemplate(fmTemplate);
        QsnPaperTemplate qsnPaperTemplateCheck = new QsnPaperTemplate();
        qsnPaperTemplateCheck.where().addEq(QsnPaperTemplate.TEMPLATE_ID, (Object)fmTemplate.getTemplateId());
        List all = this.dao.findAll((AbsModel)qsnPaperTemplateCheck);
        if (CollectionUtils.isEmpty((Collection)all)) {
            QsnPaperTemplate qsnPaperTemplate = new QsnPaperTemplate();
            qsnPaperTemplate.setPaperUuid(paperUuid);
            qsnPaperTemplate.setUseScene(useScene);
            qsnPaperTemplate.setTemplateId(fmTemplate.getTemplateId());
            this.dao.save((AbsModel)qsnPaperTemplate);
            msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
            return msg.msg();
        }
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryPaperAllInfo(QueryPaperAllInfoVo queryPaperAllInfoVo) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)queryPaperAllInfoVo.getPaperUuid()) || StrUtils.isNull((Object)queryPaperAllInfoVo.getUseScene())) {
            msg.setFailMsg(new Message("0000000", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        String paperUuid = queryPaperAllInfoVo.getPaperUuid();
        String useScene = queryPaperAllInfoVo.getUseScene();
        PaperAllInfo paperAllInfoRespVo = new PaperAllInfo();
        paperAllInfoRespVo.load(paperUuid);
        msg.setDataTable(new Object[]{paperAllInfoRespVo});
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }
}

