/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.flow.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.newtouch.base.config.ObsConfig;
import com.newtouch.base.config.TemplateConfig;
import com.newtouch.base.enums.BaseEnum;
import com.newtouch.base.model.Component;
import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.base.model.DsnRulesParam;
import com.newtouch.base.model.DsnRulesTemplate;
import com.newtouch.base.model.FmCollection;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.model.FmTemplateAttributes;
import com.newtouch.base.model.FmTemplateText;
import com.newtouch.base.param.FkRulesReqParam;
import com.newtouch.base.param.SaveRuleUsedParam;
import com.newtouch.base.service.DynamicFormService;
import com.newtouch.base.service.FmAttributesTypeService;
import com.newtouch.base.service.FormTemplateService;
import com.newtouch.base.service.RuleUsedService;
import com.newtouch.base.service.SysDataService;
import com.newtouch.base.utils.FilesUtil;
import com.newtouch.base.utils.UUIDUtils;
import com.newtouch.base.utils.hwobs.HWYObsSDKUtis;
import com.newtouch.base.vo.ExportDataVo;
import com.newtouch.base.vo.FmJsonReqParam;
import com.newtouch.base.vo.FmTemplateVo;
import com.newtouch.flow.model.FmEmbedded;
import com.newtouch.flow.model.FmFlow;
import com.newtouch.flow.model.FmFlowRelation;
import com.newtouch.flow.model.FmNode;
import com.newtouch.flow.model.FmNodeTemplate;
import com.newtouch.flow.model.FmProductFlow;
import com.newtouch.flow.model.FmRouter;
import com.newtouch.flow.param.AddTagsRelationParam;
import com.newtouch.flow.param.DeleteFmFlowParam;
import com.newtouch.flow.param.MaterialDataList;
import com.newtouch.flow.param.QueryChildFlowParam;
import com.newtouch.flow.param.QueryFmFlowParam;
import com.newtouch.flow.param.QueryTagsRelationParam;
import com.newtouch.flow.param.QueryTagsRelationReturn;
import com.newtouch.flow.param.UpdateStateParam;
import com.newtouch.flow.service.IFmFlowService;
import com.newtouch.flow.uploadParam.ComponentParam;
import com.newtouch.flow.uploadParam.EmbeddedParam;
import com.newtouch.flow.uploadParam.MaterialParam;
import com.newtouch.flow.uploadParam.NodeAndTemplateParam;
import com.newtouch.flow.vo.FlowVo;
import com.newtouch.flow.vo.FmFlowCopyVo;
import com.newtouch.issue.model.WtIssue;
import com.newtouch.issue.param.QueryWtIssueParam;
import com.newtouch.issue.service.IWtIssueService;
import com.newtouch.issue.service.impl.WtIssueServiceImpl;
import com.newtouch.material.model.ScglAuthorized;
import com.newtouch.material.model.ScglMaterial;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.newtouch.material.model.ScpzReference;
import com.newtouch.material.model.ScpzTags;
import com.newtouch.nms.sip.model.SipProductSyncTask;
import com.newtouch.tags.service.impl.TagsServiceImpl;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import com.uniapis.web.utils.RequestUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FmFlowServiceImpl
implements IFmFlowService {
    private static final String FLOW_CACHE_KEY = "FLOW_";
    @Autowired
    AbsModelRepository dao;
    @Autowired
    private TemplateConfig templateConfig;
    @Autowired
    DynamicFormService dynamicFormService;
    @Autowired
    private RuleUsedService ruleUsedService;
    @Autowired
    private FmAttributesTypeService fmAttributesTypeService;
    private static final String ALLOW_SUFFIX = ".zip";
    @Autowired
    FormTemplateService formTemplateService;
    @Autowired
    private IWtIssueService iWtIssueService;
    @Autowired
    private WtIssueServiceImpl wtIssueServiceImpl;
    @Autowired
    private SysDataService sysDataService;
    @Autowired
    HWYObsSDKUtis hwyObsSDKUtis;
    @Autowired
    private ObsConfig obsConfig;
    @Autowired
    private TagsServiceImpl tagsService;

    @Override
    public ReturnMsg queryFmFlowList(QueryFmFlowParam queryFmFlowParam, String collId) {
        Return msg = new Return();
        QueryTagsRelationParam tag = new QueryTagsRelationParam();
        tag.setRelationTab("fm_flow");
        tag.setRelationField("flow_uuid");
        tag.setTagBelongs(queryFmFlowParam.getTagBelongs());
        tag.setTagsId(queryFmFlowParam.getTagIds());
        ReturnMsg msgTag = this.iWtIssueService.queryTagsRelation(tag);
        List tagsList = msgTag.getDataList(QueryTagsRelationReturn.class);
        List idList = null;
        Map<Object, Object> listMaps = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)tagsList)) {
            idList = tagsList.stream().map(QueryTagsRelationReturn::getRelationFk).collect(Collectors.toList());
            listMaps = tagsList.stream().collect(Collectors.groupingBy(QueryTagsRelationReturn::getRelationFk));
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        stringBuilder.append("select fm.* ");
        stringBuilder.append("from fm_flow fm where 1=1 ");
        if (!StrUtils.isNull((Object)collId)) {
            stringBuilder.append("and fm.coll_id = ? ");
            list.add(collId);
        }
        if (!StrUtils.isNull((Object)queryFmFlowParam.getFlowName())) {
            stringBuilder.append("and fm.flow_name like ? ");
            list.add("%" + queryFmFlowParam.getFlowName() + "%");
        }
        if (!StrUtils.isNull((Object)queryFmFlowParam.getDeliveryPlatform())) {
            String deliveryPlatformList = queryFmFlowParam.getDeliveryPlatform();
            String[] platformList = deliveryPlatformList.split(",");
            List<String> platformIdList = Arrays.asList(platformList);
            stringBuilder.append("and ( ");
            for (int i = 0; i < platformIdList.size(); ++i) {
                if (i == platformIdList.size() - 1) {
                    stringBuilder.append("fm.delivery_platform like ? ");
                    list.add("%" + platformIdList.get(i) + "%");
                    continue;
                }
                stringBuilder.append("fm.delivery_platform like ?  or ");
                list.add("%" + platformIdList.get(i) + "%");
            }
            stringBuilder.append(")");
        }
        if (CollectionUtils.isNotEmpty(queryFmFlowParam.getTagIds())) {
            if (CollectionUtils.isEmpty(idList)) {
                ArrayList fmFlowList = new ArrayList();
                msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
                msg.setDataList(fmFlowList, FmFlow.class);
                return msg.msg();
            }
            stringBuilder.append("and ( fm.flow_uuid in ( ");
            for (int i = 0; i < idList.size(); ++i) {
                if (i == idList.size() - 1) {
                    stringBuilder.append("? ");
                } else {
                    stringBuilder.append("?, ");
                }
                list.add((String)idList.get(i));
            }
            stringBuilder.append("))");
        }
        stringBuilder.append("and fm.data_flag = ? ");
        list.add("1");
        stringBuilder.append("order by fm.crt_date desc \uff03NOTCHECK");
        List mapList = this.dao.findAll(stringBuilder.toString(), FmFlow.class, Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(list)});
        Map<Object, Object> finalListMaps = listMaps;
        mapList.stream().forEach(o -> {
            List fmFlowRelations = this.dao.findAll(FmFlowRelation.n().where().addEq(FmFlowRelation.FLOW_UUID, (Object)o.getFlowUuid()).model());
            if (CollectionUtils.isNotEmpty((Collection)fmFlowRelations)) {
                List childFlowList = this.dao.findAll(FmFlow.n().where().addIn(FmFlow.FLOW_UUID, (String[])fmFlowRelations.stream().map(FmFlowRelation::getChildFlowUuid).toArray(String[]::new)).model());
                o.putOtherProperty("childFlow", childFlowList);
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)finalListMaps.get(o.getFlowUuid())))) {
                o.setTags((List)finalListMaps.get(o.getFlowUuid()));
            }
        });
        msg.setDataList(mapList, FmFlow.class);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg insertFmFlow(FmFlow fmFlow) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)fmFlow.getFlowName())) {
            msg.setFailMsg("\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)fmFlow.getCollId())) {
            msg.setFailMsg("\u6a21\u5757id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)fmFlow.getDeliveryPlatform())) {
            msg.setFailMsg("\u9500\u552e\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        int ints = fmFlow.getFlowDesc().getBytes(Charset.forName("UTF-8")).length;
        if (!StrUtils.isNull((Object)fmFlow.getFlowDesc()) && fmFlow.getFlowDesc().getBytes(Charset.forName("UTF-8")).length >= 512) {
            msg.setFailMsg("\u6d41\u7a0b\u63cf\u8ff0\u4e0d\u80fd\u8d85\u8fc7512\u5b57\u7b26\uff01");
            return msg.msg();
        }
        String uUid = UUID.uuid();
        fmFlow.setFlowUuid(uUid);
        FmFlow flowCheck = new FmFlow();
        flowCheck.where().addEq(FmFlow.COLL_ID, (Object)fmFlow.getCollId());
        flowCheck.where().addEq(FmFlow.FLOW_NAME, (Object)fmFlow.getFlowName());
        List fmFlowDb = this.dao.findAll((AbsModel)flowCheck);
        if (CollectionUtils.isNotEmpty((Collection)fmFlowDb)) {
            msg.setFailMsg("\u540c\u4e00\u6a21\u5757\u4e0b\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            return msg.msg();
        }
        fmFlow.setIsEnable("N");
        this.dao.save((AbsModel)fmFlow);
        msg.setDataTable(new Object[]{fmFlow});
        msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg updateFmFlow(FmFlow fmFlow) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)fmFlow.getFlowName())) {
            msg.setFailMsg("\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)fmFlow.getCollId())) {
            msg.setFailMsg("\u6a21\u5757id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)fmFlow.getDeliveryPlatform())) {
            msg.setFailMsg("\u9500\u552e\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        FmFlow flowCheck = new FmFlow();
        flowCheck.where().addEq(FmFlow.COLL_ID, (Object)fmFlow.getCollId());
        flowCheck.where().addEq(FmFlow.FLOW_NAME, (Object)fmFlow.getFlowName());
        flowCheck.where().addNotEq(FmFlow.FLOW_UUID, (Object)fmFlow.getFlowUuid());
        List fmFlowDb = this.dao.findAll((AbsModel)flowCheck);
        if (CollectionUtils.isNotEmpty((Collection)fmFlowDb)) {
            msg.setFailMsg("\u540c\u4e00\u6a21\u5757\u4e0b\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            return msg.msg();
        }
        FmProductFlow fmProductFlowSelect = new FmProductFlow();
        fmProductFlowSelect.where().addEq(FmProductFlow.FLOW_UUID, (Object)fmFlow.getFlowUuid());
        fmProductFlowSelect.where().addEq(FmProductFlow.STATE, (Object)"ON");
        List fmProductFlowDbList = this.dao.findAll((AbsModel)fmProductFlowSelect);
        if (CollectionUtils.isNotEmpty((Collection)fmProductFlowDbList)) {
            msg.setFailMsg(new Message("6080002", "\u5df2\u7ecf\u5173\u8054\u4ea7\u54c1\u7684\u6d41\u7a0b,\u4e0d\u53ef\u8fdb\u884c\u4fee\u6539"));
            return msg.msg();
        }
        fmFlow.where().addEq(FmFlow.FLOW_UUID, (Object)fmFlow.getFlowUuid());
        this.dao.update((AbsModel)fmFlow);
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryFlowRelate(DeleteFmFlowParam deleteFmFlowParam) {
        Return msg = new Return();
        if (CollectionUtils.isEmpty(deleteFmFlowParam.getFlowUuids())) {
            msg.getDataTable().put("deleteFlag", "no");
            msg.setSuccessMsg("\u6d41\u7a0buuid\u4e0d\u80fd\u4e3a\u7a7a").msg();
            return msg.msg();
        }
        FmProductFlow fmProductFlowSelect = new FmProductFlow();
        fmProductFlowSelect.where().addIn(FmProductFlow.FLOW_UUID, deleteFmFlowParam.getFlowUuids());
        List fmProductFlowDbList = this.dao.findAll((AbsModel)fmProductFlowSelect);
        if (CollectionUtils.isNotEmpty((Collection)fmProductFlowDbList)) {
            msg.getDataTable().put("deleteFlag", "if");
            msg.setSuccessMsg(new Message("6080002", "\u5df2\u7ecf\u5173\u8054\u4ea7\u54c1\u7684\u6d41\u7a0b\uff0c\u4e0d\u53ef\u8fdb\u884c\u5220\u9664\u3002"));
            return msg.msg();
        }
        FmFlowRelation fmFlowRelationSelect = new FmFlowRelation();
        fmFlowRelationSelect.where().addIn(FmFlowRelation.CHILD_FLOW_UUID, deleteFmFlowParam.getFlowUuids());
        List fmFlowRelationDbList = this.dao.findAll((AbsModel)fmFlowRelationSelect);
        if (CollectionUtils.isNotEmpty((Collection)fmFlowRelationDbList)) {
            msg.getDataTable().put("deleteFlag", "if");
            msg.setSuccessMsg(new Message("6080002", "\u5b50\u6d41\u7a0b\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u8fdb\u884c\u5220\u9664\u3002"));
            return msg.msg();
        }
        msg.getDataTable().put("deleteFlag", "pass");
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteFmFlow(DeleteFmFlowParam deleteFmFlowParam) {
        Return msg = new Return();
        if (ObjectUtil.isEmpty(deleteFmFlowParam.getFlowUuids())) {
            return msg.setFailMsg("\u6d41\u7a0buuid\u4e0d\u80fd\u4e3a\u7a7a").msg();
        }
        FmProductFlow fmProductFlowSelect = new FmProductFlow();
        fmProductFlowSelect.where().addIn(FmProductFlow.FLOW_UUID, deleteFmFlowParam.getFlowUuids());
        List fmProductFlowDbList = this.dao.findAll((AbsModel)fmProductFlowSelect);
        if (CollectionUtils.isNotEmpty((Collection)fmProductFlowDbList)) {
            msg.setFailMsg(new Message("6080002", "\u5df2\u7ecf\u5173\u8054\u4ea7\u54c1\u7684\u6d41\u7a0b\uff0c\u4e0d\u53ef\u8fdb\u884c\u5220\u9664\u3002"));
            return msg.msg();
        }
        FmFlow fmFlowSelect = new FmFlow();
        fmFlowSelect.where().addIn(FmFlow.FLOW_UUID, deleteFmFlowParam.getFlowUuids());
        fmFlowSelect.where().addEq(FmFlow.IS_MASTER, (Object)"N");
        fmFlowSelect.where().addEq(FmFlow.IS_ENABLE, (Object)"Y");
        List fmFlowRelationDbList = this.dao.findAll((AbsModel)fmFlowSelect);
        if (CollectionUtils.isNotEmpty((Collection)fmFlowRelationDbList)) {
            msg.setFailMsg(new Message("6080002", "\u5b50\u6d41\u7a0b\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u8fdb\u884c\u5220\u9664\u3002"));
            return msg.msg();
        }
        FmFlow flow = new FmFlow();
        flow.where().addIn(FmFlow.FLOW_UUID, deleteFmFlowParam.getFlowUuids());
        this.dao.delete((AbsModel)flow);
        List fmRouterList = this.dao.findAll(FmRouter.n().where().addIn(FmRouter.FLOW_UUID, deleteFmFlowParam.getFlowUuids()).model());
        for (FmRouter fmRouter : fmRouterList) {
            this.ruleUsedService.deleteByRelateFks(fmRouter.getRouterUuid(), "fm_router");
        }
        this.dao.delete(FmRouter.n().where().addIn(FmRouter.FLOW_UUID, deleteFmFlowParam.getFlowUuids()).model());
        this.dao.delete(FmNodeTemplate.n().where().addIn(FmNodeTemplate.FLOW_UUID, deleteFmFlowParam.getFlowUuids()).model());
        List fmNodeList = this.dao.findAll(FmNode.n().where().addIn(FmNode.FLOW_UUID, deleteFmFlowParam.getFlowUuids()).model());
        for (FmNode fmNode : fmNodeList) {
            this.ruleUsedService.deleteByRelateFks(fmNode.getNodeNo(), "fm_node");
        }
        this.dao.delete(FmNode.n().where().addIn(FmNode.FLOW_UUID, deleteFmFlowParam.getFlowUuids()).model());
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg exportFlowJson(String[] flowUuidList, HttpServletResponse response) {
        Return msg = new Return();
        SipProductSyncTask task = new SipProductSyncTask();
        task.setFuncModule("FLOW");
        task.setIsZipDel("1");
        task.setTaskType("EXP");
        task.setCrtDate(new Date());
        StringJoiner joiner = new StringJoiner(",");
        String zipFile = "";
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String baseAddress = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
        if (flowUuidList != null && flowUuidList.length > 0) {
            ArrayList<ExportDataVo> exportDataVos = new ArrayList<ExportDataVo>();
            for (String paperUuid : flowUuidList) {
                ExportDataVo exportDataVo = new ExportDataVo();
                FmFlow flow = new FmFlow();
                flow.where().addEq(FmFlow.FLOW_UUID, (Object)paperUuid);
                FmFlow flowList = (FmFlow)this.dao.findOne((AbsModel)flow);
                if (flowList == null) continue;
                exportDataVo.setName(flowList.getFlowName());
                joiner.add(flowList.getFlowName());
                ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
                scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)paperUuid);
                scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)"flow_uuid");
                scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)"fm_flow");
                List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation1);
                for (ScpzMaterialTagsRelation s : scpzMaterialTagsRelationList) {
                    ScpzTags scpzTags = (ScpzTags)this.dao.findOne(ScpzTags.n().where().addEq(ScpzTags.TAG_ID, (Object)s.getTagId()).model());
                    s.setScpzTags(scpzTags);
                }
                flowList.setScpzMaterialTagsRelationList(scpzMaterialTagsRelationList);
                FmCollection fmCollection = new FmCollection();
                fmCollection.where().addEq(FmCollection.COLL_ID, (Object)flowList.getCollId());
                fmCollection = (FmCollection)this.dao.findOne((AbsModel)fmCollection);
                flowList.setCollection(fmCollection);
                FmRouter fmRouter = new FmRouter();
                fmRouter.where().addEq(FmRouter.FLOW_UUID, (Object)flowList.getFlowUuid());
                List fmRouterList = this.dao.findAll((AbsModel)fmRouter);
                for (FmRouter f : fmRouterList) {
                    FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
                    fkRulesReqParam.setRelateField("router_uuid");
                    fkRulesReqParam.setRelateTab("fm_router");
                    fkRulesReqParam.setRelateFk(f.getRouterUuid());
                    List saveRuleUsedParams = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
                    f.setRules(saveRuleUsedParams);
                }
                flowList.setFmRouterList(fmRouterList);
                FmNode fmNode = new FmNode();
                fmNode.where().addEq(FmNode.FLOW_UUID, (Object)flowList.getFlowUuid());
                List fmNodeList = this.dao.findAll((AbsModel)fmNode);
                for (FmNode fmNode1 : fmNodeList) {
                    FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
                    fkRulesReqParam.setRelateField("node_no");
                    fkRulesReqParam.setRelateTab("fm_node");
                    fkRulesReqParam.setRelateFk(fmNode1.getNodeNo());
                    List saveRuleUsedParams = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
                    fmNode1.setRules(saveRuleUsedParams);
                }
                flowList.setFmNodeList(fmNodeList);
                HashSet<String> templateIds = new HashSet<String>();
                fmNodeList.stream().forEach(t -> {
                    if (!StrUtils.isNull((Object)t.getRelateFk())) {
                        templateIds.add(t.getRelateFk().trim());
                    }
                });
                List<FmTemplate> fmTemplates = this.queryFmTemplateList(templateIds);
                if (fmTemplates.isEmpty()) {
                    msg.setFailMsg("\u8be5\u6d41\u7a0b\u6ca1\u6709\u5173\u8054\u4efb\u4f55\u9875\u9762\uff01");
                    return msg.msg();
                }
                FmJsonReqParam reqVo = new FmJsonReqParam();
                HashSet components = new HashSet();
                HashSet<FmEmbedded> embeddeds = new HashSet<FmEmbedded>();
                for (FmTemplate fmTemplate : fmTemplates) {
                    reqVo.setTemplateId(fmTemplate.getTemplateId());
                    List<FmTemplateAttributes> attr = this.dynamicFormService.getAttrListJson(reqVo);
                    fmTemplate.setAttrList(attr);
                    FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
                    fkRulesReqParam.setRelateField("template_id");
                    fkRulesReqParam.setRelateTab("fm_template");
                    fkRulesReqParam.setRelateFk(fmTemplate.getTemplateId());
                    List saveRuleUsedParams = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
                    fmTemplate.setRules(saveRuleUsedParams);
                    List<ScpzMaterialTagsRelation> scpzTagsRelationList = this.tagsService.findScpzMaterialTagsRelationList(fmTemplate.getTemplateId(), "template_id", "fm_template");
                    fmTemplate.setScpzMaterialTagsRelationList(scpzTagsRelationList);
                    if (attr != null && attr.size() > 0) {
                        attr.stream().forEach(o -> {
                            if (!StrUtils.isNull((Object)o.getAttrJson())) {
                                this.getAttrIds(JsonUtils.json2Map((String)o.getAttrJson()), components);
                            }
                        });
                    }
                    if (StrUtils.isNull((Object)fmTemplate.getEmbeddedJson())) continue;
                    List list = JsonUtils.json2List((String)fmTemplate.getEmbeddedJson());
                    list.forEach(l -> {
                        FmEmbedded fmEmbedded = new FmEmbedded();
                        fmEmbedded.setEmbeddedElementCn((String)l.get("embedded_element_cn"));
                        fmEmbedded.setEmbeddedElementEn((String)l.get("embedded_element_en"));
                        fmEmbedded.setDeliveryPlatform((String)l.get("delivery_platform"));
                        List embeddeds1 = this.dao.findAll(FmEmbedded.n().where().addEq(FmEmbedded.EMBEDDED_ELEMENT_CN, (Object)((String)l.get("embedded_element_cn"))).addEq(FmEmbedded.EMBEDDED_ELEMENT_EN, (Object)((String)l.get("embedded_element_en"))).addIn(FmEmbedded.DELIVERY_PLATFORM, Arrays.asList(((String)l.get("delivery_platform")).split(","))).model());
                        embeddeds.addAll(embeddeds1);
                    });
                }
                List componentLis = this.dao.findAll(Component.n().where().addIn(Component.COMPONENT_TYPE, components.stream().collect(Collectors.toList())).addEq(Component.COMPONENT_CLASS, (Object)"page").model());
                componentLis.forEach(o -> {
                    if (!StrUtils.isNull((Object)o.getEmbeddedJson())) {
                        List list = JsonUtils.json2List((String)o.getEmbeddedJson());
                        list.forEach(l -> {
                            FmEmbedded fmEmbedded = new FmEmbedded();
                            fmEmbedded.setEmbeddedElementCn((String)l.get("embedded_element_cn"));
                            fmEmbedded.setEmbeddedElementEn((String)l.get("embedded_element_en"));
                            fmEmbedded.setDeliveryPlatform((String)l.get("delivery_platform"));
                            List embeddeds1 = this.dao.findAll(FmEmbedded.n().where().addEq(FmEmbedded.EMBEDDED_ELEMENT_CN, (Object)((String)l.get("embedded_element_cn"))).addEq(FmEmbedded.EMBEDDED_ELEMENT_EN, (Object)((String)l.get("embedded_element_en"))).addIn(FmEmbedded.DELIVERY_PLATFORM, Arrays.asList(((String)l.get("delivery_platform")).split(","))).model());
                            embeddeds.addAll(embeddeds1);
                        });
                    }
                });
                flowList.setFmTemplateList(fmTemplates);
                exportDataVo.setComponentLis(componentLis);
                exportDataVo.setEmbeddeds(embeddeds);
                HashSet<String> questionUrlSet = new HashSet<String>();
                exportDataVo.setJson(JsonUtils.toJson((Object)((Object)flowList)));
                this.getQuestionUrl(JsonUtils.json2Map((String)exportDataVo.getJson()), questionUrlSet);
                List<WtIssue> wtIssues = this.getWtIssue(questionUrlSet);
                flowList.setWtIssueList(wtIssues);
                exportDataVo.setJson(JsonUtils.toJson((Object)((Object)flowList)));
                MaterialDataList materialDataList = this.getMaterial(JsonUtils.json2Map((String)exportDataVo.getJson()));
                exportDataVo.setMaterialDataList(materialDataList);
                exportDataVos.add(exportDataVo);
            }
            try {
                for (ExportDataVo data : exportDataVos) {
                    FilesUtil.createFile(baseAddress + "/" + data.getName() + "/" + data.getName() + ".json");
                    FilesUtil.writeToFile(baseAddress + "/" + data.getName() + "/" + data.getName() + ".json", data.getJson(), false);
                    FilesUtil.createFile(baseAddress + "/" + data.getName() + "/" + "component" + ".txt");
                    FilesUtil.writeToFile(baseAddress + "/" + data.getName() + "/" + "component" + ".txt", JsonUtils.toJson(data.getComponentLis()), false);
                    FilesUtil.createFile(baseAddress + "/" + data.getName() + "/" + "embedded" + ".txt");
                    FilesUtil.writeToFile(baseAddress + "/" + data.getName() + "/" + "embedded" + ".txt", JsonUtils.toJson(data.getEmbeddeds()), false);
                    if (StrUtils.isNull((Object)data.getMaterialDataList()) || data.getMaterialDataList().getStringSet().isEmpty()) continue;
                    FilesUtil.createFile(baseAddress + "/" + data.getName() + "/" + "fileList" + ".txt");
                    FilesUtil.writeToFile(baseAddress + "/" + data.getName() + "/" + "fileList" + ".txt", JsonUtils.toJson((Object)data.getMaterialDataList()), false);
                    data.getMaterialDataList().getStringSet().stream().forEach(o -> {
                        try {
                            String[] str = new String[]{};
                            String objectPath = o;
                            if (o.contains("/smp/")) {
                                str = o.split("/smp/");
                                objectPath = str[str.length - 1];
                            }
                            if (o.contains("/pscp-service/")) {
                                str = o.split("/pscp-service/");
                                objectPath = str[str.length - 1];
                            }
                            InputStream inStream = this.hwyObsSDKUtis.getObject(objectPath);
                            String filePath = baseAddress + "/" + data.getName() + "/" + "fileList" + "/" + objectPath;
                            File file = new File(filePath);
                            if (!file.getParentFile().exists() || !file.isDirectory()) {
                                file.getParentFile().mkdirs();
                            }
                            BufferedInputStream in = null;
                            BufferedOutputStream out = null;
                            in = new BufferedInputStream(inStream);
                            out = new BufferedOutputStream(new FileOutputStream(filePath));
                            int len = -1;
                            byte[] b = new byte[1024];
                            while ((len = in.read(b)) != -1) {
                                out.write(b, 0, len);
                            }
                            in.close();
                            out.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
                zipFile = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + ALLOW_SUFFIX;
                Ulog.info((String)("baseAddress----" + baseAddress));
                Ulog.info((String)("zipFile----" + zipFile));
                String zip = FileUtils.zip((String)baseAddress, (String)zipFile, (String[])new String[]{".txt", ".json", ".xlsx", ".png", ".jpg", "jpeg", "gif", "mp4", "pdf"});
                Ulog.info((String)("zip----" + zip));
                File file = new File(zipFile);
                FileInputStream inputStream = new FileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                inputStream.read(data);
                inputStream.close();
                response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
                response.setContentType("application/octet-stream;charset=ISO8859-1");
                response.addHeader("Content-Length", "" + file.length());
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + ALLOW_SUFFIX, "UTF-8"));
                ServletOutputStream stream = response.getOutputStream();
                stream.write(data);
                stream.flush();
                stream.close();
                FilesUtil.delFile(baseAddress);
                String taskName = joiner.toString();
                task.setTaskName(taskName);
                task.setTaskState("FINISH");
                task.setFinishDate(new Date());
                task.setZipPath(zipFile);
                this.dao.save((AbsModel)task);
            }
            catch (Exception e) {
                e.printStackTrace();
                String taskName = joiner.toString();
                task.setTaskName(taskName);
                task.setTaskState("FAIL");
                task.setErrorInfo(e.getMessage());
                task.setFinishDate(new Date());
                this.dao.save((AbsModel)task);
            }
        }
        return null;
    }

    @Override
    public ReturnMsg exportNew(String[] flowUuidList, HttpServletResponse response) {
        Return msg = new Return();
        SipProductSyncTask task = new SipProductSyncTask();
        task.setFuncModule("FLOW");
        task.setIsZipDel("1");
        task.setTaskType("EXP");
        task.setCrtDate(new Date());
        StringJoiner joiner = new StringJoiner(",");
        String zipFile = "";
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String baseAddress = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
        if (flowUuidList != null && flowUuidList.length > 0) {
            ArrayList<FlowVo> flowVos = new ArrayList<FlowVo>();
            for (String paperUuid : flowUuidList) {
                FlowVo flowVo = new FlowVo();
                flowVo = flowVo.load(paperUuid);
                flowVos.add(flowVo);
            }
            try {
                for (FlowVo data : flowVos) {
                    FilesUtil.createFile(baseAddress + "/" + data.getFlowName() + "/" + data.getFlowName() + ".json");
                    FilesUtil.writeToFile(baseAddress + "/" + data.getFlowName() + "/" + data.getFlowName() + ".json", JsonUtils.toJson((Object)((Object)data)), false);
                    FilesUtil.createFile(baseAddress + "/" + data.getFlowName() + "/" + "component" + ".txt");
                    FilesUtil.writeToFile(baseAddress + "/" + data.getFlowName() + "/" + "component" + ".txt", JsonUtils.toJson(data.getComponents()), false);
                    FilesUtil.createFile(baseAddress + "/" + data.getFlowName() + "/" + "embedded" + ".txt");
                    FilesUtil.writeToFile(baseAddress + "/" + data.getFlowName() + "/" + "embedded" + ".txt", JsonUtils.toJson(data.getEmbeddeds()), false);
                    if (StrUtils.isNull((Object)data.getMaterialDataListVo()) || data.getMaterialDataListVo().getStringSet().isEmpty()) continue;
                    FilesUtil.createFile(baseAddress + "/" + data.getFlowName() + "/" + "fileList" + ".txt");
                    FilesUtil.writeToFile(baseAddress + "/" + data.getFlowName() + "/" + "fileList" + ".txt", JsonUtils.toJson((Object)data.getMaterialDataListVo()), false);
                    data.getMaterialDataListVo().getStringSet().stream().forEach(o -> {
                        try {
                            String[] str = new String[]{};
                            String objectPath = o;
                            if (o.contains("/smp/")) {
                                str = o.split("/smp/");
                                objectPath = str[str.length - 1];
                            }
                            if (o.contains("/pscp-service/")) {
                                str = o.split("/pscp-service/");
                                objectPath = str[str.length - 1];
                            }
                            InputStream inStream = this.hwyObsSDKUtis.getObject(objectPath);
                            String filePath = baseAddress + "/" + data.getFlowName() + "/" + "fileList" + "/" + objectPath;
                            File file = new File(filePath);
                            if (!file.getParentFile().exists() || !file.isDirectory()) {
                                file.getParentFile().mkdirs();
                            }
                            BufferedInputStream in = null;
                            BufferedOutputStream out = null;
                            in = new BufferedInputStream(inStream);
                            out = new BufferedOutputStream(new FileOutputStream(filePath));
                            int len = -1;
                            byte[] b = new byte[1024];
                            while ((len = in.read(b)) != -1) {
                                out.write(b, 0, len);
                            }
                            in.close();
                            out.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
                zipFile = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + ALLOW_SUFFIX;
                Ulog.info((String)("baseAddress----" + baseAddress));
                Ulog.info((String)("zipFile----" + zipFile));
                String zip = FileUtils.zip((String)baseAddress, (String)zipFile, (String[])new String[]{".txt", ".json", ".xlsx", ".png", ".jpg", "jpeg", "gif", "mp4", "pdf"});
                Ulog.info((String)("zip----" + zip));
                File file = new File(zipFile);
                FileInputStream inputStream = new FileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                inputStream.read(data);
                inputStream.close();
                response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
                response.setContentType("application/octet-stream;charset=ISO8859-1");
                response.addHeader("Content-Length", "" + file.length());
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + ALLOW_SUFFIX, "UTF-8"));
                ServletOutputStream stream = response.getOutputStream();
                stream.write(data);
                stream.flush();
                stream.close();
                FilesUtil.delFile(baseAddress);
                String taskName = joiner.toString();
                task.setTaskName(taskName);
                task.setTaskState("FINISH");
                task.setFinishDate(new Date());
                task.setZipPath(zipFile);
                this.dao.save((AbsModel)task);
            }
            catch (Exception e) {
                e.printStackTrace();
                String taskName = joiner.toString();
                task.setTaskName(taskName);
                task.setTaskState("FAIL");
                task.setErrorInfo(e.getMessage());
                task.setFinishDate(new Date());
                this.dao.save((AbsModel)task);
            }
        }
        return null;
    }

    private void getAttrIds(Map<String, Object> map, Set<String> list) {
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            Object value = map.get(key);
            if (value instanceof List) {
                ((List)value).stream().forEach(o -> {
                    if (o instanceof Map) {
                        this.getAttrIds((Map)o, list);
                    }
                    if (o instanceof String && ((String)key).contains("component_type")) {
                        list.add((String)value);
                    }
                });
            }
            if (value instanceof Map) {
                this.getAttrIds((Map)value, list);
            }
            if (!(value instanceof String) || !key.contains("component_type")) continue;
            list.add((String)value);
        }
    }

    private void getQuestionUrl(Map<String, Object> map, Set<String> list) {
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            Object value = map.get(key);
            if (value instanceof List) {
                ((List)value).stream().forEach(o -> {
                    if (o instanceof Map) {
                        this.getQuestionUrl((Map)o, list);
                    }
                    if (o instanceof String) {
                        if (((String)key).contains("attr_json")) {
                            this.getQuestionUrl(JsonUtils.json2Map((String)((String)o)), list);
                        }
                        if (((String)o).contains("/wtIssue/queryWtIssueList.serv")) {
                            list.add((String)o);
                        }
                    }
                });
            }
            if (value instanceof Map) {
                this.getQuestionUrl((Map)value, list);
            }
            if (!(value instanceof String)) continue;
            if (key.contains("attr_json")) {
                this.getQuestionUrl(JsonUtils.json2Map((String)((String)value)), list);
                continue;
            }
            if (!((String)value).contains("/wtIssue/queryWtIssueList.serv")) continue;
            list.add((String)value);
        }
    }

    @Override
    public MaterialDataList getMaterial(Map<String, Object> map) {
        HashSet<String> stringSet = new HashSet<String>();
        this.getFileList(map, stringSet);
        HashSet<String> imgs = new HashSet<String>();
        HashSet<String> removes = new HashSet<String>();
        for (String s : stringSet) {
            String[] strs;
            if (!s.contains("img src")) continue;
            removes.add(s);
            for (String str : strs = s.split("\"")) {
                if (!str.contains("/smp/page/") && !str.contains("/pscp-service/page/") && !str.contains(this.obsConfig.getObsSplitPath())) continue;
                imgs.add(str);
            }
        }
        removes.stream().forEach(o -> stringSet.remove(o));
        stringSet.addAll(imgs);
        HashSet<String> imgss = new HashSet<String>();
        stringSet.forEach(o -> {
            if (o.contains("'")) {
                String[] str;
                for (String s : str = o.split("'")) {
                    if ((!s.contains("https://") || s.contains("html")) && !s.contains("staticData")) continue;
                    if (s.contains(")") || s.contains("(")) {
                        s.replace(")", "");
                        s.replace("(", "");
                    }
                    if (s.startsWith("/")) {
                        s = s.substring(1);
                    }
                    imgss.add(s);
                }
            } else if (o.contains(",")) {
                String[] str;
                for (String s : str = o.split(",")) {
                    if ((!s.contains("https://") || s.contains("html")) && !s.contains("staticData")) continue;
                    if (s.contains(")") || s.contains("(")) {
                        s.replace(")", "");
                        s.replace("(", "");
                    }
                    if (s.startsWith("/")) {
                        s = s.substring(1);
                    }
                    imgss.add(s);
                }
            } else {
                imgss.add((String)o);
            }
        });
        MaterialDataList materialDataList = new MaterialDataList();
        if (CollectionUtils.isEmpty(imgss)) {
            return null;
        }
        materialDataList.setStringSet(imgss);
        List scglMaterials = this.dao.findAll(ScglMaterial.n().where().addIn(ScglMaterial.FILE_NAME, new ArrayList<String>(imgss)).model());
        materialDataList.setScglMaterials(scglMaterials);
        if (CollectionUtils.isEmpty((Collection)scglMaterials)) {
            return materialDataList;
        }
        List scglMaterialIds = scglMaterials.stream().map(ScglMaterial::getMaterialId).collect(Collectors.toList());
        List scpzReferences = this.dao.findAll(ScpzReference.n().where().addIn(ScpzReference.MATERIAL_ID, scglMaterialIds).model());
        materialDataList.setScpzReferences(scpzReferences);
        List scglAuthorizeds = this.dao.findAll(ScglAuthorized.n().where().addIn(ScglAuthorized.MATERIAL_ID, scglMaterialIds).model());
        materialDataList.setScglAuthorizeds(scglAuthorizeds);
        List scpzMaterialTagsRelations = this.dao.findAll(ScpzMaterialTagsRelation.n().where().addIn(ScpzMaterialTagsRelation.RELATION_FK, scglMaterialIds).model());
        materialDataList.setScpzMaterialTagsRelations(scpzMaterialTagsRelations);
        List tagIds = scpzMaterialTagsRelations.stream().map(ScpzMaterialTagsRelation::getTagId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tagIds)) {
            List scpzTags = this.dao.findAll(ScpzTags.n().where().addIn(ScpzTags.TAG_ID, tagIds).model());
            if (CollectionUtils.isEmpty((Collection)scpzTags)) {
                materialDataList.setScpzTags(new ArrayList<ScpzTags>());
            } else {
                materialDataList.setScpzTags(scpzTags);
            }
        }
        return materialDataList;
    }

    private void getFileList(Map<String, Object> map, Set<String> list) {
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            Object value = map.get(key);
            if (value instanceof List) {
                ((List)value).stream().forEach(o -> {
                    if (o instanceof Map) {
                        this.getFileList((Map)o, list);
                    }
                    if (o instanceof String) {
                        if (((String)key).contains("_json") && !key.equals("embedded_json")) {
                            this.getFileList(JsonUtils.json2Map((String)((String)o)), list);
                        }
                        if (((String)o).contains("/smp/page/") || ((String)o).contains("/pscp-service/page/") || ((String)o).contains(this.obsConfig.getObsSplitPath())) {
                            list.add((String)o);
                        }
                    }
                });
            }
            if (value instanceof Map) {
                this.getFileList((Map)value, list);
            }
            if (!(value instanceof String)) continue;
            if (key.contains("_json") && !key.equals("embedded_json")) {
                this.getFileList(JsonUtils.json2Map((String)((String)value)), list);
                continue;
            }
            if (!((String)value).contains("/smp/page/") && !((String)value).contains("/pscp-service/page/") && !((String)value).contains(this.obsConfig.getObsSplitPath())) continue;
            list.add((String)value);
        }
    }

    private List<WtIssue> getWtIssue(Set<String> urls) {
        ArrayList<WtIssue> wtIssueList = new ArrayList<WtIssue>();
        for (String url : urls) {
            String patternString = "([^&?=]+)=([^&?=]*)";
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(url);
            QueryWtIssueParam queryWtIssueParam = new QueryWtIssueParam();
            while (matcher.find()) {
                if (matcher.group(1).equals("tagIds") & !StrUtils.isNull((Object)matcher.group(2))) {
                    String tagIdsStr = matcher.group(2).replaceAll("\\[|\\]", "");
                    String[] tagIds = tagIdsStr.split(",");
                    List<String> tagIdsList = Arrays.asList(tagIds);
                    queryWtIssueParam.setTagIds(tagIdsList);
                }
                if (matcher.group(1).equals("tag_belongs") & !StrUtils.isNull((Object)matcher.group(2))) {
                    queryWtIssueParam.setTagBelongs(matcher.group(2));
                }
                if (matcher.group(1).equals("allFlag")) {
                    queryWtIssueParam.setAllFlag(matcher.group(2));
                }
                if (!matcher.group(1).equals("issueName")) continue;
                queryWtIssueParam.setIssueName(matcher.group(2));
            }
            QueryTagsRelationParam tag = new QueryTagsRelationParam();
            tag.setRelationTab("wt_issue");
            tag.setRelationField("issue_uuid");
            tag.setTagBelongs(queryWtIssueParam.getTagBelongs());
            tag.setTagsId(queryWtIssueParam.getTagIds());
            ReturnMsg msgTag = this.iWtIssueService.queryTagsRelation(tag);
            List tagsList = msgTag.getDataList(QueryTagsRelationReturn.class);
            List idList = null;
            Map<Object, Object> listMaps = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)tagsList)) {
                idList = tagsList.stream().map(QueryTagsRelationReturn::getRelationFk).collect(Collectors.toList());
                listMaps = tagsList.stream().collect(Collectors.groupingBy(QueryTagsRelationReturn::getRelationFk));
            }
            WtIssue wtIssue = new WtIssue();
            if (!StrUtils.isNull((Object)queryWtIssueParam.getIssueName())) {
                wtIssue.where().addLike(WtIssue.ISSUE_NAME, (Object)queryWtIssueParam.getIssueName());
            }
            if (CollectionUtils.isNotEmpty(queryWtIssueParam.getTagIds())) {
                if (CollectionUtils.isEmpty(idList)) {
                    ArrayList<WtIssue> wtIssueListCheck = new ArrayList<WtIssue>();
                    return wtIssueListCheck;
                }
                wtIssue.where().addIn(WtIssue.ISSUE_UUID, idList);
            }
            wtIssue.where().addEq(WtIssue.DATA_FLAG, (Object)1);
            wtIssue.setOrderBy(WtIssue.CRT_DATE.desc());
            List mapList = new ArrayList();
            String allFlag = queryWtIssueParam.getAllFlag();
            mapList = !StrUtils.isNull((Object)allFlag) && "Y".equals(allFlag) ? this.dao.findAll((AbsModel)wtIssue, Boolean.valueOf(false)) : this.dao.findAll((AbsModel)wtIssue, Boolean.valueOf(true));
            Map<Object, Object> finalListMaps = listMaps;
            mapList.stream().forEach(o -> {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)finalListMaps.get(o.getIssueUuid())))) {
                    o.setTags((List)finalListMaps.get(o.getIssueUuid()));
                }
            });
            wtIssueList.addAll(mapList);
        }
        return wtIssueList;
    }

    public List<FmTemplate> queryFmTemplateList(HashSet<String> templateIds) {
        Return msg = new Return();
        ArrayList<FmTemplate> fmTemplates = new ArrayList<FmTemplate>();
        for (String templateId : templateIds) {
            FmTemplate fmTemplate = new FmTemplate();
            fmTemplate.where().addEq(FmTemplate.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
            fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
            FmTemplate fmTemplate1 = (FmTemplate)this.dao.findOne((AbsModel)fmTemplate);
            if (fmTemplate1 == null) continue;
            fmTemplates.add(fmTemplate1);
        }
        return fmTemplates;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReturnMsg uploadFlow(MultipartFile zipFile) {
        String txtStr;
        StringBuilder sb;
        InputStreamReader reader;
        Object txtStr2;
        SipProductSyncTask task = new SipProductSyncTask();
        task.setCrtDate(new Date());
        String pathName = this.templateConfig.getUploadFormCollectPath() + "/upload/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = this.unzipFile(zipFile, pathName);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
            return msg.msg();
        }
        File importDir = new File(pathName);
        ArrayList<File> fileList = new ArrayList<File>();
        this.getAllFiles(importDir, fileList, ".json");
        Ulog.info((String)("\u83b7\u53d6\u9700\u8981\u8bfb\u53d6\u7684\u6587\u4ef6" + JsonUtils.toJson(fileList)));
        StringJoiner joiner = new StringJoiner(",");
        for (File file : fileList) {
            try {
                InputStreamReader reader2 = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
                Throwable throwable = null;
                try {
                    Object rules;
                    int ch = 0;
                    StringBuilder sb2 = new StringBuilder();
                    while ((ch = ((Reader)reader2).read()) != -1) {
                        sb2.append((char)ch);
                    }
                    String jsonStr = sb2.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u6d41\u7a0b\u6570\u636e\u4e3a" + jsonStr));
                    FmFlow flow = (FmFlow)((Object)JsonUtils.json2Class((String)jsonStr, FmFlow.class));
                    joiner.add(flow.getFlowName());
                    FmFlow flowOld = new FmFlow();
                    flowOld.where().addEq(FmFlow.FLOW_UUID, (Object)flow.getFlowUuid()).model();
                    this.dao.delete((AbsModel)flowOld);
                    this.dao.save((AbsModel)flow);
                    ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
                    scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)flow.getFlowUuid());
                    scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)"flow_uuid");
                    scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)"fm_flow");
                    List<ScpzMaterialTagsRelation> scpzMaterialTagsRelationList = flow.getScpzMaterialTagsRelationList();
                    this.dao.delete((AbsModel)scpzMaterialTagsRelation1);
                    this.dao.save(scpzMaterialTagsRelationList);
                    for (ScpzMaterialTagsRelation s : scpzMaterialTagsRelationList) {
                        ScpzTags scpzTagsJson = s.getScpzTags();
                        ScpzTags scpzTagsOld = new ScpzTags();
                        scpzTagsOld.where().addEq(ScpzTags.TAG_ID, (Object)s.getTagId());
                        this.dao.delete((AbsModel)scpzTagsOld);
                        this.dao.save((AbsModel)scpzTagsJson);
                    }
                    FmCollection fmCollection = flow.getCollection();
                    FmCollection fmCollectionOld = new FmCollection();
                    fmCollectionOld.where().addEq(FmCollection.COLL_ID, (Object)fmCollection.getCollId()).model();
                    this.dao.delete((AbsModel)fmCollectionOld);
                    this.dao.save((AbsModel)fmCollection);
                    List<FmRouter> fmRouterList = flow.getFmRouterList();
                    FmRouter fmRouterOld = new FmRouter();
                    fmRouterOld.where().addEq(FmRouter.FLOW_UUID, (Object)flow.getFlowUuid()).model();
                    this.dao.delete((AbsModel)fmRouterOld);
                    this.dao.save(fmRouterList);
                    for (FmRouter fmRouter : fmRouterList) {
                        this.ruleUsedService.deleteByRelateFks(fmRouter.getRouterUuid(), "fm_router");
                        if (!CollectionUtils.isNotEmpty(fmRouter.getRules())) continue;
                        List<SaveRuleUsedParam> rules2 = fmRouter.getRules();
                        Iterator<SaveRuleUsedParam> iterator = rules2.iterator();
                        while (iterator.hasNext()) {
                            SaveRuleUsedParam saveRuleUsedParam = iterator.next();
                            this.ruleUsedService.saveRuleUsed(saveRuleUsedParam);
                        }
                    }
                    List<FmNode> fmNodeList = flow.getFmNodeList();
                    FmNode fmNodeOld = new FmNode();
                    fmNodeOld.where().addEq(FmNode.FLOW_UUID, (Object)flow.getFlowUuid()).model();
                    this.dao.delete((AbsModel)fmNodeOld);
                    this.dao.save(fmNodeList);
                    for (FmNode fmNode : fmNodeList) {
                        this.ruleUsedService.deleteByRelateFks(fmNode.getNodeNo(), "fm_node");
                        if (!CollectionUtils.isNotEmpty(fmNode.getRules())) continue;
                        rules = fmNode.getRules();
                        Iterator<Object> iterator = rules.iterator();
                        while (iterator.hasNext()) {
                            SaveRuleUsedParam saveRuleUsedParam = (SaveRuleUsedParam)iterator.next();
                            this.ruleUsedService.saveRuleUsed(saveRuleUsedParam);
                        }
                    }
                    List<FmTemplate> fmTemplates = flow.getFmTemplateList();
                    Map<String, String> typeMap = this.fmAttributesTypeService.getAttrMap();
                    if (typeMap == null) {
                        msg.setFailMsg(new Message("6030003", "\u6570\u636e\u5e93\u7f3a\u5c11\u9875\u9762\u5bf9\u5e94\u5173\u7cfb"));
                        rules = msg.msg();
                        return rules;
                    }
                    if (StrUtils.isNull(fmTemplates)) continue;
                    for (FmTemplate fmTemplate : fmTemplates) {
                        String templateId = fmTemplate.getTemplateId();
                        FmTemplate fmTemplateDb = (FmTemplate)this.dao.findOne(FmTemplate.n().where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId).model());
                        int tableCount = this.dao.delete(FmTemplate.n().where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId).model());
                        this.ruleUsedService.deleteByRelateFks(templateId, "fm_template");
                        FmTemplateAttributes attr = new FmTemplateAttributes();
                        attr.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId);
                        List allOldAttr = this.dao.findAll((AbsModel)attr);
                        if (CollectionUtils.isNotEmpty((Collection)allOldAttr)) {
                            for (FmTemplateAttributes attributes : allOldAttr) {
                                this.ruleUsedService.deleteByRelateFks(attributes.getAttrId(), "fm_template_attributes");
                            }
                        }
                        int columnCount = this.dao.delete(FmTemplateAttributes.n().where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).model());
                        Ulog.info((String)("\u5220\u9664\u6a21\u677f\u548c\u5c5e\u6027\u5173\u7cfb\u6210\u529f--\u6a21\u677f\u9875\u9762:" + tableCount + "--\u6a21\u677f\u9875\u9762\u6240\u5c5e\u5c5e\u6027:" + columnCount));
                        ReturnMsg returnMsg = this.dynamicFormService.createFormTemplate(fmTemplate, fmTemplateDb, allOldAttr, typeMap);
                        Ulog.info((String)RequestUtils.return2Json((ReturnMsg)returnMsg));
                        if (!returnMsg.isSuccessflag()) {
                            msg.getDtildMsg().addAll(returnMsg.getMsgList());
                        }
                        this.tagsService.saveScpzMaterialTagsRelationList(templateId, "template_id", "fm_template", fmTemplate.getScpzMaterialTagsRelationList());
                    }
                    List<WtIssue> wtIssueList = flow.getWtIssueList();
                    if (StrUtils.isNull(wtIssueList)) continue;
                    for (WtIssue wtIssue : wtIssueList) {
                        WtIssue wtIssueOld = new WtIssue();
                        wtIssueOld.where().addEq(WtIssue.ISSUE_UUID, (Object)wtIssue.getIssueUuid()).model();
                        this.dao.delete((AbsModel)wtIssueOld);
                        this.tagsService.saveQueryTagsRelationReturn(wtIssue.getIssueUuid(), "issue_uuid", "wt_issue", wtIssue.getTags());
                        this.insertWtIssue(wtIssue);
                        AddTagsRelationParam addTagsRelationParam = new AddTagsRelationParam();
                        for (QueryTagsRelationReturn tag : wtIssue.getTags()) {
                            ScpzMaterialTagsRelation scpzMaterialTagsRelationTemp = new ScpzMaterialTagsRelation();
                            scpzMaterialTagsRelationTemp.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)tag.getRelationFk());
                            scpzMaterialTagsRelationTemp.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)tag.getRelationField());
                            scpzMaterialTagsRelationTemp.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)tag.getRelationTab());
                            scpzMaterialTagsRelationTemp.where().addEq(ScpzMaterialTagsRelation.TAG_BELONGS, (Object)tag.getTagBelongs());
                            scpzMaterialTagsRelationTemp.where().addEq(ScpzMaterialTagsRelation.TAG_ID, (Object)tag.getTagId());
                            List scpzMaterialTagsRelationCheck = this.dao.findAll((AbsModel)scpzMaterialTagsRelationTemp);
                            if (scpzMaterialTagsRelationCheck.size() > 0) continue;
                            ScpzTags scpzTags1 = new ScpzTags();
                            scpzTags1.where().addEq(ScpzTags.TAG_ID, (Object)tag.getTagId());
                            List all = this.dao.findAll((AbsModel)scpzTags1);
                            if (ObjectUtils.isEmpty((Object)all)) {
                                ScpzTags scpzTags = new ScpzTags();
                                scpzTags.setTagId(tag.getTagId());
                                scpzTags.setTagName(tag.getTagName());
                                scpzTags.setTagCategories(tag.getTagCategories());
                                this.dao.save((AbsModel)scpzTags);
                            }
                            ScpzMaterialTagsRelation scpzMaterialTagsRelation = new ScpzMaterialTagsRelation();
                            String uUid = UUID.uuid();
                            scpzMaterialTagsRelation.setTagId(tag.getTagId());
                            scpzMaterialTagsRelation.setRelationFk(tag.getRelationFk());
                            scpzMaterialTagsRelation.setRelationUuid(uUid);
                            scpzMaterialTagsRelation.setRelationTab(tag.getRelationTab());
                            scpzMaterialTagsRelation.setRelationField(tag.getRelationField());
                            scpzMaterialTagsRelation.setTagBelongs(tag.getTagBelongs());
                            this.dao.save((AbsModel)scpzMaterialTagsRelation);
                        }
                    }
                }
                catch (Throwable ch) {
                    throwable = ch;
                    throw ch;
                }
                finally {
                    if (reader2 == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader2).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    ((Reader)reader2).close();
                }
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
                e.printStackTrace();
                msg.setFailMsg("\u6d41\u7a0b\u5bfc\u5165\u5931\u8d25");
                return msg.msg();
            }
        }
        ArrayList<File> fileList1 = new ArrayList<File>();
        this.getAllFiles(importDir, fileList1, "fileList.txt");
        for (File jsonFile : fileList1) {
            try {
                InputStreamReader reader3 = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
                Throwable ch = null;
                try {
                    int ch2 = 0;
                    StringBuilder sb3 = new StringBuilder();
                    while ((ch2 = ((Reader)reader3).read()) != -1) {
                        sb3.append((char)ch2);
                    }
                    txtStr2 = sb3.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u7d20\u6750\u6570\u636e\u4e3a" + (String)txtStr2));
                    MaterialDataList scglMaterials = (MaterialDataList)JsonUtils.json2Class((String)txtStr2, MaterialDataList.class);
                    if (CollectionUtils.isNotEmpty(scglMaterials.getScpzTags())) {
                        List tagIds = scglMaterials.getScpzTags().stream().map(ScpzTags::getTagId).collect(Collectors.toList());
                        this.dao.delete(ScpzTags.n().where().addIn(ScpzTags.TAG_ID, tagIds).model());
                        this.dao.save(scglMaterials.getScpzTags());
                    }
                    List authorizationIds = scglMaterials.getScglAuthorizeds().stream().map(ScglAuthorized::getAuthorizationId).collect(Collectors.toList());
                    this.dao.delete(ScglAuthorized.n().where().addIn(ScglAuthorized.AUTHORIZATION_ID, authorizationIds).model());
                    this.dao.save(scglMaterials.getScglAuthorizeds());
                    List materialIds = scglMaterials.getScglMaterials().stream().map(ScglMaterial::getMaterialId).collect(Collectors.toList());
                    this.dao.delete(ScglMaterial.n().where().addIn(ScglMaterial.MATERIAL_ID, materialIds).model());
                    this.dao.save(scglMaterials.getScglMaterials());
                    List relationUuids = scglMaterials.getScpzMaterialTagsRelations().stream().map(ScpzMaterialTagsRelation::getRelationUuid).collect(Collectors.toList());
                    this.dao.delete(ScpzMaterialTagsRelation.n().where().addIn(ScpzMaterialTagsRelation.RELATION_UUID, relationUuids).model());
                    this.dao.save(scglMaterials.getScpzMaterialTagsRelations());
                    if (!CollectionUtils.isNotEmpty(scglMaterials.getScpzReferences())) continue;
                    List referencedIds = scglMaterials.getScpzReferences().stream().map(ScpzReference::getReferencedId).collect(Collectors.toList());
                    this.dao.delete(ScpzReference.n().where().addIn(ScpzReference.REFERENCED_ID, referencedIds).model());
                    this.dao.save(scglMaterials.getScpzReferences());
                }
                catch (Throwable ch2) {
                    ch = ch2;
                    throw ch2;
                }
                finally {
                    if (reader3 == null) continue;
                    if (ch != null) {
                        try {
                            ((Reader)reader3).close();
                        }
                        catch (Throwable ch2) {
                            ch.addSuppressed(ch2);
                        }
                        continue;
                    }
                    ((Reader)reader3).close();
                }
            }
            catch (Exception e) {
                Ulog.debug((Object)e);
            }
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        this.getAllFiles(importDir, arrayList, ".jpg");
        this.getAllFiles(importDir, arrayList, ".png");
        this.getAllFiles(importDir, arrayList, ".gif");
        this.getAllFiles(importDir, arrayList, ".jpeg");
        this.getAllFiles(importDir, arrayList, ".mp4");
        this.getAllFiles(importDir, arrayList, ".pdf");
        ArrayList<File> fileList2 = new ArrayList<File>();
        ArrayList<File> fileList3 = new ArrayList<File>();
        this.getFileByName(importDir, fileList2, "component.txt");
        this.getFileByName(importDir, fileList3, "embedded.txt");
        for (File jsonFile : fileList2) {
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
                txtStr2 = null;
                try {
                    int ch = 0;
                    sb = new StringBuilder();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    txtStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u57cb\u70b9\u4e3a" + txtStr));
                    List component = JsonUtils.json2List((String)txtStr, Component.class);
                    this.dao.delete(Component.n().where().addIn(Component.COMPONENT_ID, component.stream().map(Component::getComponentId).collect(Collectors.toList())).model());
                    this.dao.save(component);
                }
                catch (Throwable ch) {
                    txtStr2 = ch;
                    throw ch;
                }
                finally {
                    if (reader == null) continue;
                    if (txtStr2 != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable ch) {
                            ((Throwable)txtStr2).addSuppressed(ch);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Ulog.debug((Object)e);
            }
        }
        for (File jsonFile : fileList3) {
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
                txtStr2 = null;
                try {
                    int ch = 0;
                    sb = new StringBuilder();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    txtStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u57cb\u70b9\u4e3a" + txtStr));
                    List embeddeds = JsonUtils.json2List((String)txtStr, FmEmbedded.class);
                    this.dao.delete(FmEmbedded.n().where().addIn(FmEmbedded.SERNO, embeddeds.stream().map(AbsModel::getSerno).collect(Collectors.toList())).model());
                    this.dao.save(embeddeds);
                }
                catch (Throwable ch) {
                    txtStr2 = ch;
                    throw ch;
                }
                finally {
                    if (reader == null) continue;
                    if (txtStr2 != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable ch) {
                            ((Throwable)txtStr2).addSuppressed(ch);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Ulog.debug((Object)e);
            }
        }
        try {
            for (File pic : arrayList) {
                String path = pic.getPath();
                String[] str = new String[]{};
                String obsSplitPath = this.obsConfig.getObsSplitPath();
                if (path.contains("page/")) {
                    str = path.split("page/");
                } else if (path.contains(obsSplitPath)) {
                    str = path.split(obsSplitPath);
                }
                String filePath = str[str.length - 1];
                filePath = filePath.replaceAll("/" + pic.getName(), "");
                this.sysDataService.uploadFileById(pic, filePath, pic.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.debug((Object)e);
            Ulog.info((String)("\u7d20\u6750\u6587\u4ef6\u5bfc\u5165\u5f02\u5e38--->" + e.getMessage()));
        }
        FilesUtil.delFile(pathName);
        String taskName = joiner.toString();
        task.setFuncModule("FLOW");
        task.setTaskType("IMP");
        task.setTaskName(taskName);
        task.setTaskState("FINISH");
        task.setFinishDate(new Date());
        this.dao.save((AbsModel)task);
        msg.setSuccessMsg("\u6d41\u7a0b\u5bfc\u5165\u6210\u529f");
        return msg.msg();
    }

    @Override
    public ReturnMsg uploadFlowNew(MultipartFile zipFile) {
        SipProductSyncTask task = new SipProductSyncTask();
        task.setCrtDate(new Date());
        String pathName = this.templateConfig.getUploadFormCollectPath() + "/upload/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = this.unzipFile(zipFile, pathName);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
            return msg.msg();
        }
        File importDir = new File(pathName);
        ArrayList<File> fileList = new ArrayList<File>();
        this.getAllFiles(importDir, fileList, ".json");
        Ulog.info((String)("\u83b7\u53d6\u9700\u8981\u8bfb\u53d6\u7684\u6587\u4ef6" + JsonUtils.toJson(fileList)));
        StringJoiner joiner = new StringJoiner(",");
        for (File file : fileList) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
                Throwable throwable = null;
                try {
                    int ch = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch = ((Reader)inputStreamReader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    String jsonStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u6d41\u7a0b\u6570\u636e\u4e3a" + jsonStr));
                    NodeAndTemplateParam flow = new NodeAndTemplateParam(jsonStr);
                    joiner.add(flow.getFlow().getFlowName());
                    flow.updateFlow();
                    flow.uploadTags();
                    flow.uploadTemplate();
                    flow.uploadRouters();
                    flow.uploadNodes();
                    flow.uploadTemplateLists();
                    flow.uploadWtIssue();
                    flow.saveFlowRelation();
                }
                catch (Throwable ch) {
                    Throwable throwable2 = ch;
                    throw ch;
                }
                finally {
                    if (inputStreamReader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (Throwable ch) {
                            throwable.addSuppressed(ch);
                        }
                        continue;
                    }
                    ((Reader)inputStreamReader).close();
                }
            }
            catch (Exception exception) {
                Ulog.error((Throwable)exception);
                exception.printStackTrace();
                msg.setFailMsg("\u6d41\u7a0b\u5bfc\u5165\u5931\u8d25");
                return msg.msg();
            }
        }
        ArrayList<File> fileList1 = new ArrayList<File>();
        this.getAllFiles(importDir, fileList1, "fileList.txt");
        for (File file : fileList1) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
                Throwable ch = null;
                try {
                    int ch2 = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch2 = ((Reader)inputStreamReader).read()) != -1) {
                        sb.append((char)ch2);
                    }
                    String txtStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u7d20\u6750\u6570\u636e\u4e3a" + txtStr));
                    MaterialParam materialParam = new MaterialParam(txtStr);
                    materialParam.updateMaterial();
                }
                catch (Throwable ch2) {
                    ch = ch2;
                    throw ch2;
                }
                finally {
                    if (inputStreamReader == null) continue;
                    if (ch != null) {
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (Throwable ch2) {
                            ch.addSuppressed(ch2);
                        }
                        continue;
                    }
                    ((Reader)inputStreamReader).close();
                }
            }
            catch (Exception exception) {
                Ulog.debug((Object)exception);
            }
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        this.getFileByName(importDir, arrayList, "component.txt");
        for (File file : arrayList) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
                Throwable ch2 = null;
                try {
                    int ch = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    String txtStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u57cb\u70b9\u4e3a" + txtStr));
                    ComponentParam componentParam = new ComponentParam(txtStr);
                    componentParam.updateComponent();
                }
                catch (Throwable ch) {
                    ch2 = ch;
                    throw ch;
                }
                finally {
                    if (reader == null) continue;
                    if (ch2 != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable ch) {
                            ch2.addSuppressed(ch);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Ulog.debug((Object)e);
            }
        }
        ArrayList<File> arrayList2 = new ArrayList<File>();
        this.getFileByName(importDir, arrayList2, "embedded.txt");
        for (File jsonFile : arrayList2) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
                Throwable ch = null;
                try {
                    int ch3 = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch3 = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch3);
                    }
                    String txtStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u57cb\u70b9\u4e3a" + txtStr));
                    EmbeddedParam embeddeds = new EmbeddedParam(txtStr);
                    embeddeds.updateEmbedded();
                }
                catch (Throwable ch3) {
                    ch = ch3;
                    throw ch3;
                }
                finally {
                    if (reader == null) continue;
                    if (ch != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable ch3) {
                            ch.addSuppressed(ch3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Ulog.debug((Object)e);
            }
        }
        ArrayList<File> arrayList3 = new ArrayList<File>();
        this.getAllFiles(importDir, arrayList3, ".jpg");
        this.getAllFiles(importDir, arrayList3, ".png");
        this.getAllFiles(importDir, arrayList3, ".gif");
        this.getAllFiles(importDir, arrayList3, ".jpeg");
        this.getAllFiles(importDir, arrayList3, ".mp4");
        this.getAllFiles(importDir, arrayList3, ".pdf");
        try {
            for (File pic : arrayList3) {
                String path = pic.getPath();
                String[] str = new String[]{};
                String obsSplitPath = this.obsConfig.getObsSplitPath();
                if (path.contains("page/")) {
                    str = path.split("page/");
                } else if (path.contains(obsSplitPath)) {
                    str = path.split(obsSplitPath);
                }
                String filePath = str[str.length - 1];
                filePath = filePath.replaceAll("/" + pic.getName(), "");
                this.sysDataService.uploadFileById(pic, filePath, pic.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.debug((Object)e);
            Ulog.info((String)("\u7d20\u6750\u6587\u4ef6\u5bfc\u5165\u5f02\u5e38--->" + e.getMessage()));
        }
        FilesUtil.delFile(pathName);
        String taskName = joiner.toString();
        task.setFuncModule("FLOW");
        task.setTaskType("IMP");
        task.setTaskName(taskName);
        task.setTaskState("FINISH");
        task.setFinishDate(new Date());
        this.dao.save((AbsModel)task);
        msg.setSuccessMsg("\u6d41\u7a0b\u5bfc\u5165\u6210\u529f");
        return msg.msg();
    }

    public ReturnMsg insertWtIssue(WtIssue wtIssue) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)wtIssue.getIssueName())) {
            msg.setFailMsg("\u95ee\u9898\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)wtIssue.getAnser())) {
            msg.setFailMsg("\u95ee\u9898\u7b54\u6848\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)wtIssue.getDisplayOrder())) {
            msg.setFailMsg("\u95ee\u9898\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        WtIssue issue01 = new WtIssue();
        issue01.where().addIsNotNull(WtIssue.DISPLAY_ORDER);
        issue01.groupBy().max(WtIssue.DISPLAY_ORDER);
        WtIssue maxIssue = (WtIssue)this.dao.findOne((AbsModel)issue01);
        int maxDisplayOrder = StrUtils.isNull((Object)maxIssue.getOtherProperty("max_display_order")) || maxIssue.getOtherProperty("max_display_order").equals("") ? 0 : Integer.parseInt(maxIssue.getOtherProperty("max_display_order").toString());
        int finalDisplayOrder = wtIssue.getDisplayOrder();
        WtIssue issue02 = new WtIssue();
        issue02.setDisplayOrder(maxDisplayOrder + 1);
        issue02.setIssueUuid(wtIssue.getIssueUuid());
        issue02.setIssueName(wtIssue.getIssueName());
        issue02.setAnser(wtIssue.getAnser());
        this.dao.save((AbsModel)issue02);
        issue02.setDisplayOrder(finalDisplayOrder);
        this.wtIssueServiceImpl.updateDisplayorder(issue02);
        msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        WtIssue wtIssue03 = new WtIssue();
        wtIssue03.where().addEq(WtIssue.ISSUE_UUID, (Object)wtIssue.getIssueUuid());
        WtIssue issue04 = (WtIssue)this.dao.findOne((AbsModel)wtIssue03);
        msg.setDataTable(new Object[]{issue04});
        return msg.msg();
    }

    @Override
    public ReturnMsg copyFmFlow(FmFlowCopyVo fmFlowCopyVo) {
        String flowUuid = fmFlowCopyVo.getFlowUuid();
        Return msg = new Return();
        if (StrUtils.isNull((Object)flowUuid)) {
            msg.setFailMsg("\u6d41\u7a0buuid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        FmFlow flow = (FmFlow)this.dao.findOne(FmFlow.n().where().addEq(FmFlow.FLOW_UUID, (Object)flowUuid).model());
        if (flow == null) {
            msg.setFailMsg("\u8be5\u6d41\u7a0b\u4e0d\u5b58\u5728\uff01");
            return msg.msg();
        }
        FmFlow flowCheck = new FmFlow();
        flowCheck.where().addEq(FmFlow.COLL_ID, (Object)fmFlowCopyVo.getNewCollId());
        flowCheck.where().addEq(FmFlow.FLOW_NAME, (Object)fmFlowCopyVo.getNewFlowName());
        List fmFlowDb = this.dao.findAll((AbsModel)flowCheck);
        if (CollectionUtils.isNotEmpty((Collection)fmFlowDb)) {
            msg.setFailMsg("\u540c\u4e00\u6a21\u5757\u4e0b\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            return msg.msg();
        }
        HashMap<String, String> templateIds = new HashMap<String, String>();
        HashMap<String, String> nodeNo = new HashMap<String, String>();
        HashMap<String, String> flowId = new HashMap<String, String>();
        String flUuid = UUID.uuid();
        flowId.put(flowUuid, flUuid);
        ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)flowUuid);
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)"flow_uuid");
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)"fm_flow");
        List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation1);
        scpzMaterialTagsRelationList.stream().forEach(s -> {
            String uuid1 = UUID.uuid();
            s.setRelationUuid(uuid1);
            s.setRelationFk(flUuid);
            s.setCrtDate(new Date());
            s.setMdfDate(new Date());
        });
        this.dao.save(scpzMaterialTagsRelationList);
        List fmNodeList = this.dao.findAll(FmNode.n().where().addEq(FmNode.FLOW_UUID, (Object)flowUuid).model());
        for (Object fmNode : fmNodeList) {
            String uUidFmNode = UUID.uuid();
            String uUidTem = UUID.uuid();
            if (!(StrUtils.isNull((Object)((FmNode)((Object)fmNode)).getRelateFk()) || StrUtils.isNull((Object)((FmNode)((Object)fmNode)).getRelateTab()) || StrUtils.isNull((Object)((FmNode)((Object)fmNode)).getRelateField()) || ((FmNode)((Object)fmNode)).getNodeType().equals("child_flow"))) {
                String templateId = ((FmNode)((Object)fmNode)).getRelateFk();
                FmTemplateVo fmTemplateVo = new FmTemplateVo();
                fmTemplateVo.setTemplateId(templateId);
                fmTemplateVo.setTemplateIdNew(uUidTem);
                fmTemplateVo.setCollId(fmFlowCopyVo.getNewCollId());
                this.formTemplateService.copyFormTemplate(fmTemplateVo);
                templateIds.put(templateId, uUidTem);
                ((FmNode)((Object)fmNode)).setRelateFk(uUidTem);
            }
            FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
            fkRulesReqParam.setRelateField("node_no");
            fkRulesReqParam.setRelateTab("fm_node");
            fkRulesReqParam.setRelateFk(((FmNode)((Object)fmNode)).getNodeNo());
            List saveRuleUsedParams = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
            if (CollectionUtils.isNotEmpty((Collection)saveRuleUsedParams)) {
                for (SaveRuleUsedParam saveRuleUsedParam : saveRuleUsedParams) {
                    saveRuleUsedParam.setRelateFk(uUidFmNode);
                    this.saveRuleUsed(saveRuleUsedParam);
                }
            }
            nodeNo.put(((FmNode)((Object)fmNode)).getNodeNo(), uUidFmNode);
            ((FmNode)((Object)fmNode)).setFlowUuid(flUuid);
            ((FmNode)((Object)fmNode)).setNodeNo(uUidFmNode);
            String name2 = ((FmNode)((Object)fmNode)).getNodeName().substring(0, ((FmNode)((Object)fmNode)).getNodeName().lastIndexOf("copy") + 1);
            if (StrUtils.isNull((Object)name2) || name2.equals("")) {
                name2 = ((FmNode)((Object)fmNode)).getNodeName() + "copy";
            }
            name2 = name2 + System.currentTimeMillis();
            ((FmNode)((Object)fmNode)).setNodeName(name2);
            fmNode.setCrtDate(new Date());
            fmNode.setMdfDate(new Date());
            this.dao.save((AbsModel)fmNode);
        }
        List fmRouterList = this.dao.findAll(FmRouter.n().where().addEq(FmRouter.FLOW_UUID, (Object)flowUuid).model());
        for (FmRouter fmRouter : fmRouterList) {
            String node = fmRouter.getNodeNo();
            String descNode = fmRouter.getDestNode();
            String uUidFmRouter = UUID.uuid();
            FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
            fkRulesReqParam.setRelateField("router_uuid");
            fkRulesReqParam.setRelateTab("fm_router");
            fkRulesReqParam.setRelateFk(fmRouter.getRouterUuid());
            List saveRuleUsedParams = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
            if (CollectionUtils.isNotEmpty((Collection)saveRuleUsedParams)) {
                for (SaveRuleUsedParam saveRuleUsedParam : saveRuleUsedParams) {
                    saveRuleUsedParam.setRelateFk(uUidFmRouter);
                    this.saveRuleUsed(saveRuleUsedParam);
                }
            }
            for (String id : nodeNo.keySet()) {
                if (fmRouter.getNodeNo().equals(id)) {
                    node = (String)nodeNo.get(id);
                }
                if (!fmRouter.getDestNode().equals(id)) continue;
                descNode = (String)nodeNo.get(id);
            }
            fmRouter.setFlowUuid(flUuid);
            fmRouter.setRouterUuid(uUidFmRouter);
            if (!StrUtils.isNull((Object)fmRouter.getRouterName()) && !fmRouter.getRouterName().equals("")) {
                String name3 = fmRouter.getRouterName().substring(0, fmRouter.getRouterName().lastIndexOf("copy") + 1);
                if (StrUtils.isNull((Object)name3) || name3.equals("")) {
                    name3 = fmRouter.getRouterName() + "copy";
                }
                name3 = name3 + System.currentTimeMillis();
                fmRouter.setRouterName(name3);
            }
            fmRouter.setNodeNo(node);
            fmRouter.setDestNode(descNode);
            fmRouter.setCrtDate(new Date());
            fmRouter.setMdfDate(new Date());
            this.dao.save((AbsModel)fmRouter);
        }
        flow.setFlowUuid(flUuid);
        if (!StrUtils.isNull((Object)fmFlowCopyVo.getNewCollId())) {
            flow.setCollId(fmFlowCopyVo.getNewCollId());
        }
        if (!StrUtils.isNull((Object)fmFlowCopyVo.getNewFlowName())) {
            flow.setFlowName(fmFlowCopyVo.getNewFlowName());
        } else {
            flow.setFlowName(flow.getFlowName() + "copy" + System.currentTimeMillis());
        }
        List fmFlowRelation = this.dao.findAll(FmFlowRelation.n().where().addEq(FmFlowRelation.FLOW_UUID, (Object)flowUuid).model());
        fmFlowRelation.forEach(o -> {
            o.setCrtDate(new Date());
            o.setMdfDate(new Date());
            o.setFlowUuid(flUuid);
        });
        flow.setCrtDate(new Date());
        flow.setMdfDate(new Date());
        this.dao.save((AbsModel)flow);
        this.dao.save(fmFlowRelation);
        msg.setSuccessMsg("\u6d41\u7a0b\u590d\u5236\u6210\u529f");
        return msg.msg();
    }

    public ReturnMsg saveRuleUsed(SaveRuleUsedParam saveRuleUsedParam) {
        Return msg = new Return();
        String newRuleId = UUID.shortUUID();
        if (StrUtils.isNull((Object)saveRuleUsedParam.getRelateFk())) {
            msg.setFailMsg("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        this.saveRules(saveRuleUsedParam, newRuleId);
        return msg.setSuccessMsg(new Message("2010005", "\u4fdd\u5b58\u6210\u529f")).msg();
    }

    private ReturnMsg saveRules(SaveRuleUsedParam saveRuleUsedParam, String newRuleId) {
        List consts;
        Return r = new Return();
        if (saveRuleUsedParam == null) {
            r.setFailMsg("\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return r.msg();
        }
        DsnRules ruleNew = new DsnRules();
        BeanUtils.copyProperties((Object)saveRuleUsedParam, (Object)ruleNew);
        if (StrUtils.isNull((Object)ruleNew.getRuleInfo())) {
            r.setFailMsg("[\u89c4\u5219\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a!");
            return r.msg();
        }
        ruleNew.setRuleId(newRuleId);
        ruleNew.setRuleTemplateId(saveRuleUsedParam.getRuleTemplateId());
        ruleNew.setSerno((String)null);
        ruleNew.setCrtDate(new Date());
        ruleNew.setMdfDate(new Date());
        this.dao.save((AbsModel)ruleNew);
        String ruleTemplateId = saveRuleUsedParam.getRuleTemplateId();
        this.updateUseNumber(ruleTemplateId);
        if (CollectionUtils.isNotEmpty((Collection)saveRuleUsedParam.getParams())) {
            consts = saveRuleUsedParam.getParams();
            for (DsnRulesParam dsnRulesParam : consts) {
                dsnRulesParam.setSerno((String)null);
                dsnRulesParam.setRuleId(newRuleId);
                dsnRulesParam.setCrtDate(new Date());
                dsnRulesParam.setMdfDate(new Date());
            }
            this.dao.save(consts);
        }
        if (CollectionUtils.isNotEmpty((Collection)saveRuleUsedParam.getConsts())) {
            consts = saveRuleUsedParam.getConsts();
            for (DsnRulesConst dsnRulesConst : consts) {
                dsnRulesConst.setSerno((String)null);
                dsnRulesConst.setRuleId(newRuleId);
                dsnRulesConst.setCrtDate(new Date());
                dsnRulesConst.setMdfDate(new Date());
            }
            this.dao.save(consts);
        }
        return r.msg();
    }

    public void updateUseNumber(String ruleId) {
        DsnRulesTemplate dsnRulesTemplate = (DsnRulesTemplate)this.dao.findOne(DsnRulesTemplate.n().where().addEq(DsnRulesTemplate.RULE_ID, (Object)ruleId).model());
        if (dsnRulesTemplate != null) {
            dsnRulesTemplate.setUseNumber(Integer.valueOf(StrUtils.isNull((Object)dsnRulesTemplate.getUseNumber()) ? 1 : dsnRulesTemplate.getUseNumber() + 1));
            dsnRulesTemplate.where().addEq(DsnRulesTemplate.RULE_ID, (Object)ruleId);
            this.dao.update((AbsModel)dsnRulesTemplate);
        }
    }

    private void copyTemplate(String uUidNodeTem, String templateId) {
        FmTemplate fmTemplate = new FmTemplate();
        FmTemplate fmTemplateDb = (FmTemplate)this.dao.findOne(FmTemplate.n().where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId).model());
        BeanUtils.copyProperties((Object)((Object)fmTemplateDb), (Object)((Object)fmTemplate));
        String templateName = fmTemplate.getTemplateName();
        String templateNameNew = templateName + "_" + uUidNodeTem + "\u526f\u672c";
        fmTemplate.setState("OFF");
        fmTemplate.setTemplateName(templateNameNew);
        Ulog.info((String)(templateName + "--\u590d\u5236\u8868\u5355\u6a21\u677f\u5230--" + templateNameNew));
        fmTemplate.setTemplateId(uUidNodeTem);
        Ulog.info((String)(templateId + "\u590d\u5236\u8868\u5355\u6a21\u677f\u5230" + uUidNodeTem));
        String serno = fmTemplate.getSerno();
        String sernoNew = UUID.snowId() + "";
        fmTemplate.setSerno(sernoNew);
        Ulog.info((String)(serno + "\u590d\u5236\u8868\u5355\u6a21\u677f\u5230" + sernoNew));
        String templateJson = fmTemplate.getTemplateJson();
        fmTemplate.setTemplateJson(templateJson.replaceAll(templateId, uUidNodeTem).replaceAll(serno, sernoNew).replaceAll(templateName, templateNameNew));
        String templateCode = fmTemplate.getTemplateCode();
        String templateCodeNew = fmTemplate.getTemplateCode();
        if (!StrUtils.isNull((Object)templateCode)) {
            templateCodeNew = templateCode.substring(0, templateCode.lastIndexOf("_") + 1) + UUIDUtils.shortUUID(uUidNodeTem);
        }
        fmTemplate.setTemplateCode(templateCodeNew);
        this.dao.save((AbsModel)fmTemplate);
        ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)templateId);
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)"template_id");
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)"fm_template");
        List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation1);
        scpzMaterialTagsRelationList.stream().forEach(o -> {
            String uUid = UUID.uuid();
            o.setRelationUuid(uUid);
            o.setRelationFk(uUidNodeTem);
        });
        this.dao.save(scpzMaterialTagsRelationList);
        this.copyFormAttr(templateId, fmTemplate);
        FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
        fkRulesReqParam.setRelateField("template_id");
        fkRulesReqParam.setRelateTab("fm_template");
        fkRulesReqParam.setRelateFk(templateId);
        List saveRuleUsedParams = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
        if (CollectionUtils.isNotEmpty((Collection)saveRuleUsedParams)) {
            for (SaveRuleUsedParam saveRuleUsedParam : saveRuleUsedParams) {
                saveRuleUsedParam.setRelateFk(uUidNodeTem);
                saveRuleUsedParam.setRuleId(null);
                this.ruleUsedService.saveRuleUsed(saveRuleUsedParam);
            }
        }
        if (CollectionUtils.isNotEmpty(fmTemplate.getAttrList())) {
            Ulog.info((String)(templateId + "\u590d\u5236\u8868\u5355\u6a21\u677f\u5230" + uUidNodeTem + "\u5f00\u59cb\u521b\u5efa\u52a8\u6001\u8868"));
            Map<String, String> typeMap = this.fmAttributesTypeService.getAttrMap();
            this.dynamicFormService.createDBTable(fmTemplate.getAttrList(), typeMap, fmTemplate);
        }
    }

    public void copyFormAttr(String templateId, FmTemplate fmTemplate) {
        String templateIdNew = fmTemplate.getTemplateId();
        List<FmTemplateAttributes> fmTemplateAttrAll = new ArrayList();
        FmTemplateAttributes fmTemplateAttributes = new FmTemplateAttributes();
        fmTemplateAttributes.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).addEq(FmTemplateAttributes.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        fmTemplateAttributes.setOrderBy(FmTemplateAttributes.DISPLAY_ORDER.asc());
        fmTemplateAttrAll = this.dao.findAll((AbsModel)fmTemplateAttributes);
        if (CollectionUtils.isNotEmpty(fmTemplateAttrAll)) {
            HashMap<String, String> attrIdNewMap = new HashMap<String, String>();
            fmTemplateAttrAll.forEach(a -> attrIdNewMap.put(a.getAttrId(), UUID.uuid()));
            Ulog.info((String)(templateId + "\u590d\u5236\u8868\u5355\u6a21\u677f\u5230" + templateIdNew + "\u5f00\u59cb\u5c5e\u6027\u590d\u5236"));
            for (FmTemplateAttributes attr : fmTemplateAttrAll) {
                String attrId = attr.getAttrId();
                String newAttrId = (String)attrIdNewMap.get(attrId);
                String attrSernoNew = UUID.snowId() + "";
                String attrJson = attr.getAttrJson();
                String attrJsonNew = this.getNewAttrJson(attrJson, attrIdNewMap, templateId, templateIdNew);
                attr.setAttrJson(attrJsonNew);
                attr.setAttrId(newAttrId);
                attr.setSerno(attrSernoNew);
                attr.setTemplateId(templateIdNew);
                String upAttr = attr.getUpAttr();
                if (!"0".equals(upAttr)) {
                    attr.setUpAttr((String)attrIdNewMap.get(upAttr));
                }
                if ("richText".equals(attr.getComponentType()) || "wangeditorText".equals(attr.getComponentType())) {
                    FmTemplateText fmTemplateText;
                    String editorContent = attr.getEditorContent();
                    List fmTemplateTextList = new ArrayList();
                    if (StrUtils.isNull((Object)editorContent)) {
                        fmTemplateText = new FmTemplateText();
                        fmTemplateText.where().addEq(FmTemplateText.ATTR_ID, (Object)attrId).addEq(FmTemplateText.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
                        fmTemplateTextList = this.dao.findAll((AbsModel)fmTemplateText);
                        if (CollectionUtils.isNotEmpty(fmTemplateTextList)) {
                            for (FmTemplateText text : fmTemplateTextList) {
                                text.setSerno(null);
                                text.setAttrId(newAttrId);
                            }
                            this.dao.save(fmTemplateTextList);
                        }
                    } else {
                        fmTemplateText = new FmTemplateText();
                        fmTemplateText.setTextContent(editorContent);
                        fmTemplateText.setAttrId(newAttrId);
                        this.dao.save((AbsModel)fmTemplateText);
                    }
                }
                FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
                fkRulesReqParam.setRelateField("attr_id");
                fkRulesReqParam.setRelateTab("fm_template_attributes");
                fkRulesReqParam.setRelateFk(attrId);
                List saveRuleUsedParams = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
                if (!CollectionUtils.isNotEmpty((Collection)saveRuleUsedParams)) continue;
                for (SaveRuleUsedParam saveRuleUsedParam : saveRuleUsedParams) {
                    saveRuleUsedParam.setRelateFk(newAttrId);
                    saveRuleUsedParam.setRuleId(null);
                    this.ruleUsedService.saveRuleUsed(saveRuleUsedParam);
                }
            }
            fmTemplate.setAttrList(fmTemplateAttrAll);
            this.dao.save(fmTemplateAttrAll);
        }
    }

    private Return unzipFile(MultipartFile file, String path) {
        String fileName = file.getOriginalFilename();
        long fileSize = file.getSize();
        Return msg = this.checkFile(fileName, fileSize);
        try {
            File destFile = new File(path);
            if (!destFile.exists()) {
                destFile.mkdirs();
            }
            FileUtils.unzip((InputStream)file.getInputStream(), (String)path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return msg;
    }

    private Return checkFile(String fileName, long fileSize) {
        String suffix;
        Return msg = new Return();
        if (fileName.indexOf(".") < 0) {
            msg.setFailMsg(new Message("6030004", "\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6"));
        }
        if (ALLOW_SUFFIX.indexOf(suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) == -1) {
            msg.setFailMsg(new Message("6030004", "\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6"));
        }
        if (fileSize <= 0L) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u5fc5\u987b\u5927\u4e8e0KB"));
        }
        return msg;
    }

    private String getNewAttrJson(String attrJson, Map<String, String> attrIdNewMap, String templateId, String templateIdNew) {
        String returnJson = attrJson.replaceAll(templateId, templateIdNew);
        for (Map.Entry<String, String> entry : attrIdNewMap.entrySet()) {
            returnJson = returnJson.replaceAll(entry.getKey(), entry.getValue());
        }
        return returnJson;
    }

    public void getAllFiles(File dir, List<File> file) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getAllFiles(files[i], file);
                continue;
            }
            String name = files[i].getName();
            if (name.endsWith(".json")) {
                File file1 = files[i];
                file.add(file1);
            }
            Ulog.info((Object)files[i]);
        }
    }

    public void getFileByName(File dir, List<File> file, String fileName) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getFileByName(files[i], file, fileName);
                continue;
            }
            String name = files[i].getName();
            if (name.equals(fileName)) {
                File file1 = files[i];
                file.add(file1);
            }
            Ulog.info((Object)files[i]);
        }
    }

    public void getAllFiles(File dir, List<File> file, String fileType) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getAllFiles(files[i], file, fileType);
                continue;
            }
            String name = files[i].getName();
            if (name.endsWith(fileType)) {
                File file1 = files[i];
                file.add(file1);
            }
            Ulog.info((Object)files[i]);
        }
    }

    @Override
    public ReturnMsg addTagsRelation(AddTagsRelationParam add) {
        Return msg = new Return();
        if (add == null) {
            msg.setFailMsg("\u6570\u636e\u4f20\u8f93\u4e3a\u7a7a!");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)add.getUuid())) {
            msg.setFailMsg("uuid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)add.getUuid());
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)add.getRelationField());
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)add.getRelationTab());
        List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation1);
        if (!scpzMaterialTagsRelationList.isEmpty() && scpzMaterialTagsRelationList.size() > 0) {
            this.dao.delete(ScpzMaterialTagsRelation.n().where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)add.getUuid()).addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)add.getRelationField()).addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)add.getRelationTab()).model());
        }
        for (String tagsId : add.getTagsId()) {
            if (StrUtils.isNull((Object)tagsId)) {
                msg.setFailMsg("\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return msg.msg();
            }
            ScpzMaterialTagsRelation scpzMaterialTagsRelation = new ScpzMaterialTagsRelation();
            ScpzTags scpzTags = new ScpzTags();
            scpzTags.where().addEq(ScpzTags.TAG_ID, (Object)tagsId);
            List scpzTagsList = this.dao.findAll((AbsModel)scpzTags);
            if (scpzTagsList.isEmpty() || scpzTagsList.size() == 0) {
                msg.setFailMsg("\u6807\u7b7eid:" + tagsId + "\u4e0d\u5b58\u5728");
                return msg.msg();
            }
            String uUid = UUID.uuid();
            scpzMaterialTagsRelation.setRelationFk(add.getUuid());
            scpzMaterialTagsRelation.setTagId(tagsId);
            scpzMaterialTagsRelation.setRelationUuid(uUid);
            scpzMaterialTagsRelation.setRelationTab(add.getRelationTab());
            scpzMaterialTagsRelation.setRelationField(add.getRelationField());
            scpzMaterialTagsRelation.setTagBelongs(add.getTagBelongs());
            this.dao.save((AbsModel)scpzMaterialTagsRelation);
        }
        msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteTagsRelation(AddTagsRelationParam add) {
        Return msg = new Return();
        if (add == null) {
            msg.setFailMsg("\u6570\u636e\u4f20\u8f93\u4e3a\u7a7a!");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)add.getUuid())) {
            msg.setFailMsg("uuid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)add.getUuid());
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)add.getRelationField());
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)add.getRelationTab());
        List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation1);
        if (!scpzMaterialTagsRelationList.isEmpty() && scpzMaterialTagsRelationList.size() > 0) {
            this.dao.delete(ScpzMaterialTagsRelation.n().where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)add.getUuid()).addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)add.getRelationField()).addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)add.getRelationTab()).model());
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryProductFmFlowList(QueryFmFlowParam queryFmFlowParam) {
        int i;
        Return msg = new Return();
        StringBuilder sql = new StringBuilder();
        ArrayList<String> sqlParam = new ArrayList<String>();
        sql.append("select ff.flow_uuid ,ff.flow_name ,ff.flow_no  from fm_flow ff\nleft join fm_collection fc on ff.coll_id = fc.coll_id \nleft join scpz_material_tags_relation sm \non ff.flow_uuid  = sm.relation_fk and sm.relation_tab = ? and sm.relation_field = ? \n left join scpz_tags st on st.tag_id = sm.tag_id where ff.is_master = ? and ");
        sqlParam.add("fm_flow");
        sqlParam.add("flow_uuid");
        sqlParam.add("Y");
        List<String> tagIds = queryFmFlowParam.getTagIds();
        List<String> channelNoList = queryFmFlowParam.getChannelNoList();
        if (tagIds.isEmpty() || tagIds.isEmpty()) {
            msg.setFailMsg(new Message("6080001", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        if (tagIds.size() == 1) {
            sql.append(" st.tag_name like ? ");
            sqlParam.add(tagIds.get(0));
        } else {
            sql.append(" ( st.tag_name like ? ");
            sqlParam.add(tagIds.get(0));
            for (i = 1; i < tagIds.size(); ++i) {
                sql.append(" or st.tag_name like ?");
                sqlParam.add(tagIds.get(i));
            }
            sql.append(" ) ");
        }
        sql.append(" and fc.channel_no  in ( ");
        for (i = 0; i < channelNoList.size(); ++i) {
            if (i == channelNoList.size() - 1) {
                sql.append(" ?  ");
            } else {
                sql.append(" ?,  ");
            }
            sqlParam.add(channelNoList.get(i));
        }
        sql.append(")");
        if (!StrUtils.isNull((Object)queryFmFlowParam.getFlowName())) {
            sql.append(" and ff.flow_name like ? ");
            sqlParam.add("%" + queryFmFlowParam.getFlowName() + "%");
        }
        if (CollectionUtils.isNotEmpty(queryFmFlowParam.getDeliveryPlatformList())) {
            queryFmFlowParam.getDeliveryPlatformList().forEach(p -> {
                sql.append(" and ff.delivery_platform like ? ");
                sqlParam.add("%" + p + "%");
            });
        }
        sql.append(" group by ff.flow_uuid,ff.coll_id ");
        sql.append(" order by ff.mdf_date  desc ");
        List mapList = this.dao.findAll(sql.toString(), Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(sqlParam)});
        msg.setDataList(mapList);
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addTagsRelationsList(AddTagsRelationParam add) {
        Return msg = new Return();
        if (add.getUuidList() == null) {
            msg.setFailMsg("uuid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        for (String materialId : add.getUuidList()) {
            add.setUuid(materialId);
            this.addTagsRelationList(add);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg addTagsRelationList(AddTagsRelationParam add) {
        Return msg = new Return();
        List<ScpzTags> scpzTagsList = add.getScpzTagsList();
        if (add == null) {
            msg.setFailMsg("\u6570\u636e\u4f20\u8f93\u4e3a\u7a7a!");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)add.getUuid())) {
            msg.setFailMsg("uuid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)add.getTagBelongs())) {
            msg.setFailMsg("\u6807\u7b7e\u5173\u8054\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)add.getRelationTab())) {
            msg.setFailMsg("\u5173\u8054\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)add.getRelationField())) {
            msg.setFailMsg("\u5173\u8054\u8868\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (add.getUuidList() == null) {
            ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
            scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)add.getUuid());
            scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)add.getRelationField());
            scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)add.getRelationTab());
            scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.TAG_BELONGS, (Object)add.getTagBelongs());
            List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation1);
            if (!scpzMaterialTagsRelationList.isEmpty() && scpzMaterialTagsRelationList.size() > 0) {
                this.dao.delete(ScpzMaterialTagsRelation.n().where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)add.getUuid()).addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)add.getRelationField()).addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)add.getRelationTab()).addEq(ScpzMaterialTagsRelation.TAG_BELONGS, (Object)add.getTagBelongs()).model());
            }
        }
        for (ScpzTags scpzTags : scpzTagsList) {
            String uUid;
            ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
            scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)add.getUuid());
            scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)add.getRelationField());
            scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)add.getRelationTab());
            scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.TAG_BELONGS, (Object)add.getTagBelongs());
            scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.TAG_ID, (Object)scpzTags.getTagId());
            List scpzMaterialTagsRelationCheck = this.dao.findAll((AbsModel)scpzMaterialTagsRelation1);
            if (scpzMaterialTagsRelationCheck.size() > 0) continue;
            if (StrUtils.isNull((Object)scpzTags.getTagName())) {
                msg.setFailMsg("\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return msg.msg();
            }
            if (scpzTags.getTagName().length() > 32) {
                msg.setFailMsg("\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u8d8532\u5b57\u7b26\uff01");
                return msg.msg();
            }
            if (StrUtils.isNull((Object)scpzTags.getTagCategories())) {
                scpzTags.setTagCategories("\u81ea\u5b9a\u4e49\u6807\u7b7e");
            }
            ScpzMaterialTagsRelation scpzMaterialTagsRelation = new ScpzMaterialTagsRelation();
            ScpzTags scpzTags1 = new ScpzTags();
            scpzTags1.where().addEq(ScpzTags.TAG_NAME, (Object)scpzTags.getTagName());
            List all = this.dao.findAll((AbsModel)scpzTags1);
            if (ObjectUtils.isEmpty((Object)all)) {
                uUid = UUID.shortUUID();
                scpzTags.setTagId(uUid);
                this.dao.save((AbsModel)scpzTags);
                scpzMaterialTagsRelation.setTagId(scpzTags.getTagId());
            } else {
                scpzMaterialTagsRelation.setTagId(scpzTags.getTagId());
            }
            uUid = UUID.uuid();
            scpzMaterialTagsRelation.setRelationFk(add.getUuid());
            scpzMaterialTagsRelation.setRelationUuid(uUid);
            scpzMaterialTagsRelation.setRelationTab(add.getRelationTab());
            scpzMaterialTagsRelation.setRelationField(add.getRelationField());
            scpzMaterialTagsRelation.setTagBelongs(add.getTagBelongs());
            this.dao.save((AbsModel)scpzMaterialTagsRelation);
        }
        msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryAllChildFlow(QueryChildFlowParam queryChildFlowParam) {
        Return msg = new Return();
        FmFlow fmFlow = (FmFlow)this.dao.findOne(FmFlow.n().where().addEq(FmFlow.FLOW_UUID, (Object)queryChildFlowParam.getFlowUuid()).model());
        String[] delivery_platform = fmFlow.getDeliveryPlatform().split(",");
        String sql = "select * from fm_flow where is_enable = ? and is_master = ? and coll_id = ? ";
        ArrayList<String> param = new ArrayList<String>();
        param.add("Y");
        param.add("N");
        param.add(fmFlow.getCollId());
        if (!StrUtils.isNull((Object)queryChildFlowParam.getChildFlowUuid())) {
            sql = sql + " and flow_uuid = ?";
            sql = sql + " \uff03NOTCHECK";
            param.add(queryChildFlowParam.getChildFlowUuid());
            List list = this.dao.findAll(sql, Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(param)});
            msg.setDataList(list);
            return msg.msg();
        }
        if (!StrUtils.isNull((Object)queryChildFlowParam.getChildFlowName())) {
            sql = sql + " and flow_name like ? ";
            param.add("%" + queryChildFlowParam.getChildFlowName() + "%");
        }
        sql = sql + "and (";
        for (String s : delivery_platform) {
            sql = sql + "delivery_platform like ? or ";
            param.add("%" + s + "%");
        }
        sql = sql.substring(0, sql.length() - 3) + ")";
        sql = sql + " \uff03NOTCHECK";
        List list = this.dao.findAll(sql, Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(param)});
        msg.setDataList(list);
        return msg.msg();
    }

    @Override
    public ReturnMsg updateFlowState(UpdateStateParam updateStateParam) {
        Return msg = new Return();
        if (updateStateParam.getIsMaster().equals("N")) {
            List fmFlowRelations = this.dao.findAll(FmFlowRelation.n().where().addEq(FmFlowRelation.CHILD_FLOW_UUID, (Object)updateStateParam.getFlowUuid()).model());
            if (CollectionUtils.isNotEmpty((Collection)fmFlowRelations)) {
                List strings = fmFlowRelations.stream().map(FmFlowRelation::getFlowUuid).collect(Collectors.toList());
                List fmFlows = this.dao.findAll(FmFlow.n().where().addIn(FmFlow.FLOW_UUID, strings).model());
                List strings1 = fmFlows.stream().map(FmFlow::getFlowName).collect(Collectors.toList());
                String s = strings1.stream().distinct().collect(Collectors.joining(","));
                msg.setFailMsg("\u5f53\u524d\u6d41\u7a0b\u5df2\u5173\u8054\u6d41\u7a0b\u3010" + s + "\u3011\uff0c\u4e0d\u53ef\u3010\u505c\u7528\u3011");
                return msg.msg();
            }
            FmFlow fmFlow = new FmFlow();
            fmFlow.setIsEnable(updateStateParam.getIsEnable());
            fmFlow.where().addEq(FmFlow.FLOW_UUID, (Object)updateStateParam.getFlowUuid());
            this.dao.update((AbsModel)fmFlow);
            msg.setSuccessMsg("\u66f4\u6539\u72b6\u6001\u6210\u529f");
            return msg.msg();
        }
        List fmProductFlows = this.dao.findAll(FmProductFlow.n().where().addEq(FmProductFlow.FLOW_UUID, (Object)updateStateParam.getFlowUuid()).model());
        if (CollectionUtils.isNotEmpty((Collection)fmProductFlows)) {
            List strings = fmProductFlows.stream().map(FmProductFlow::getSaleName).collect(Collectors.toList());
            String s = strings.stream().distinct().collect(Collectors.joining(","));
            msg.setFailMsg("\u5f53\u524d\u6d41\u7a0b\u5df2\u5173\u8054\u4ea7\u54c1\u3010" + s + "\u3011\uff0c\u4e0d\u53ef\u3010\u505c\u7528\u3011");
            return msg.msg();
        }
        FmFlow fmFlow = new FmFlow();
        fmFlow.setIsEnable(updateStateParam.getIsEnable());
        fmFlow.where().addEq(FmFlow.FLOW_UUID, (Object)updateStateParam.getFlowUuid());
        this.dao.update((AbsModel)fmFlow);
        msg.setSuccessMsg("\u66f4\u6539\u72b6\u6001\u6210\u529f");
        return msg.msg();
    }

    @Override
    public ReturnMsg checkChildFlow(String childFlowUuid, String flowUuid) {
        Return msg = new Return();
        FmFlow fmFlow = (FmFlow)this.dao.findOne(FmFlow.n().where().addEq(FmFlow.FLOW_UUID, (Object)flowUuid).model());
        if (fmFlow.getIsMaster().equals("Y")) {
            msg.setSuccessMsg("\u53ef\u6dfb\u52a0");
            return msg.msg();
        }
        if (flowUuid.equals(childFlowUuid)) {
            msg.setFailMsg("\u540c\u4e00\u5b50\u6d41\u7a0b\u4e0d\u53ef\u5728\u540c\u4e00\u7ebf\u8def\u4e0b\u88ab\u91cd\u590d\u5173\u8054");
            return msg.msg();
        }
        String sql = "select * from fm_flow_relation start with flow_uuid = ? connect by prior child_flow_uuid = flow_uuid \uff03NOTCHECK";
        ArrayList<String> param = new ArrayList<String>();
        param.add(childFlowUuid);
        List list = this.dao.findAll(sql, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(param)});
        if (CollectionUtils.isNotEmpty((Collection)list) && list.stream().filter(a -> a.get("flow_uuid").equals(flowUuid) || a.get("child_flow_uuid").equals(flowUuid)).collect(Collectors.toList()).size() > 0) {
            msg.setFailMsg("\u540c\u4e00\u5b50\u6d41\u7a0b\u4e0d\u53ef\u5728\u540c\u4e00\u7ebf\u8def\u4e0b\u88ab\u91cd\u590d\u5173\u8054");
            return msg.msg();
        }
        msg.setSuccessMsg("\u53ef\u6dfb\u52a0");
        return msg.msg();
    }
}

