/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.flow.service.impl;

import com.newtouch.base.config.TemplateConfig;
import com.newtouch.base.enums.CompareEnum;
import com.newtouch.base.model.FmCollection;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.model.FmTemplateAttributes;
import com.newtouch.base.param.SaveRuleUsedParam;
import com.newtouch.base.utils.FilesUtil;
import com.newtouch.base.utils.TreeComparator;
import com.newtouch.flow.model.FmFlow;
import com.newtouch.flow.model.FmNode;
import com.newtouch.flow.model.FmRouter;
import com.newtouch.flow.service.IFmCompareService;
import com.newtouch.flow.uploadParam.NodeAndTemplateParam;
import com.newtouch.flow.vo.TreeNode;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.utils.ModelFieldCache;
import com.uniapis.utils.ClassUtils;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FmCompareServiceImpl
implements IFmCompareService {
    @Autowired
    private TemplateConfig templateConfig;

    @Override
    public ReturnMsg compare(String compareType, MultipartFile newFile, MultipartFile originFile) {
        Return aReturn = new Return();
        LocalDateTime startTime = LocalDateTime.now();
        NodeAndTemplateParam newJson = this.getFileJson(newFile);
        NodeAndTemplateParam originJson = this.getFileJson(originFile);
        LocalDateTime endTime1 = LocalDateTime.now();
        Duration duration = Duration.between(startTime, endTime1);
        Ulog.info((String)("\u4ece\u6587\u4ef6\u4e2d\u63d0\u53d6json\u6267\u884c\u65f6\u95f4: " + duration.toMillis() + " \u6beb\u79d2"));
        TreeNode originTree = null;
        TreeNode newTree = null;
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Callable<TreeNode> task1 = () -> this.buildTree(originJson);
        Callable<TreeNode> task2 = () -> this.buildTree(newJson);
        Future<TreeNode> future1 = executor.submit(task1);
        Future<TreeNode> future2 = executor.submit(task2);
        try {
            originTree = future1.get();
            newTree = future2.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            throw new BusinessException("\u6784\u5efa\u6811\u5f62\u7ed3\u6784\u5931\u8d25");
        }
        finally {
            executor.shutdown();
        }
        LocalDateTime endTime2 = LocalDateTime.now();
        duration = Duration.between(endTime1, endTime2);
        Ulog.info((String)("\u6784\u5efa\u6811\u5f62\u7ed3\u6784\u6267\u884c\u65f6\u95f4: " + duration.toMillis() + " \u6beb\u79d2"));
        ArrayList<Map<String, Object>> diffData = new ArrayList<Map<String, Object>>();
        TreeNode diffTree = TreeComparator.buildDiffTree(originTree, newTree, diffData);
        LocalDateTime endTime3 = LocalDateTime.now();
        duration = Duration.between(endTime2, endTime3);
        Ulog.info((String)("\u6bd4\u8f83\u5dee\u5f02\u6267\u884c\u65f6\u95f4: " + duration.toMillis() + " \u6beb\u79d2"));
        aReturn.getDataTable().put("diffTree", diffTree);
        aReturn.getDataTable().put("diffData", diffData);
        return aReturn.msg();
    }

    private TreeNode buildTree(NodeAndTemplateParam originJson) {
        FmCollection fmCollection = originJson.getFlow().getCollection();
        TreeNode rootNode = new TreeNode(fmCollection.getCollId(), fmCollection.getCollName());
        FmFlow flow = originJson.getFlow();
        FmFlow copyFlow = new FmFlow();
        List list = ModelFieldCache.getInstance().getFieldMapper(((Object)((Object)copyFlow)).getClass());
        for (com.uniapis.repository.core.Field aField : list) {
            Iterator<FmFlow> value = ClassUtils.getProperty((Object)((Object)flow), (String)aField.property());
            ClassUtils.setProperty((Object)((Object)copyFlow), (String)aField.property(), (Object)value);
        }
        copyFlow.setScpzMaterialTagsRelationList(flow.getScpzMaterialTagsRelationList());
        TreeNode flowAttrNode = new TreeNode(copyFlow.getFlowUuid(), JsonUtils.toJson((Object)((Object)copyFlow)), CompareEnum.Tag.FM_FLOW.getDesc(), CompareEnum.Tag.FM_FLOW.getType(), null);
        rootNode.getChildren().add(flowAttrNode.setDisplayOrder(rootNode.getChildren().size()));
        if (CollectionUtils.isNotEmpty(originJson.getFlow().getChildFmFlows())) {
            TreeNode childFlowNode = new TreeNode("\u5b50\u6d41\u7a0b", "\u5b50\u6d41\u7a0b");
            for (FmFlow fmFlow : originJson.getFlow().getChildFmFlows()) {
                TreeNode singleChildFlowNode = new TreeNode(fmFlow.getFlowUuid(), fmFlow.getFlowName());
                singleChildFlowNode.getChildren().add(new TreeNode(fmFlow.getFlowNo(), JsonUtils.toJson((Object)((Object)fmFlow)), CompareEnum.Tag.FM_FLOW.getDesc(), CompareEnum.Tag.FM_FLOW.getType(), null));
                childFlowNode.getChildren().add(singleChildFlowNode);
            }
            rootNode.getChildren().add(childFlowNode.setDisplayOrder(rootNode.getChildren().size()));
        }
        TreeNode rootTemplateNode = this.buildTemplateTree(originJson);
        rootNode.getChildren().add(rootTemplateNode.setDisplayOrder(rootNode.getChildren().size()));
        TreeNode rootFlowNode = this.buildFlowNodeTree(originJson);
        rootNode.getChildren().add(rootFlowNode.setDisplayOrder(rootNode.getChildren().size()));
        return rootNode;
    }

    private TreeNode buildFlowNodeTree(NodeAndTemplateParam originJson) {
        TreeNode rootFlowNode = new TreeNode("\u6d41\u7a0b\u8282\u70b9", "\u6d41\u7a0b\u8282\u70b9");
        List<FmNode> fmNodeList = originJson.getFlow().getFmNodeList();
        List<FmRouter> fmRouterList = originJson.getFlow().getFmRouterList();
        for (FmNode fmNode : fmNodeList) {
            TreeNode singleFlowNode = new TreeNode(fmNode.getNodeNo(), fmNode.getNodeName());
            Map nodeInfoMap = JsonUtils.json2Map((String)fmNode.getNodeInfo());
            singleFlowNode.getChildren().add(new TreeNode(fmNode.getNodeNo(), JsonUtils.toJson((Object)nodeInfoMap), CompareEnum.Tag.FM_NODE.getDesc(), CompareEnum.Tag.FM_NODE.getType(), null));
            List<SaveRuleUsedParam> rules = fmNode.getRules();
            if (CollectionUtils.isNotEmpty(rules)) {
                TreeNode ruleNode = this.getRuleNode(rules, fmNode.getNodeNo());
                singleFlowNode.getChildren().add(ruleNode);
            }
            List routerCollect = fmRouterList.stream().filter(p -> p.getNodeNo().equals(fmNode.getNodeNo())).sorted((o1, o2) -> (Integer)o1.getOtherProperty("rn", Integer.class) - (Integer)o2.getOtherProperty("rn", Integer.class)).collect(Collectors.toList());
            TreeNode rootEdgeNode = new TreeNode(fmNode.getNodeNo() + "_router", "\u8fde\u63a5\u7ebf");
            for (FmRouter rmRouter : routerCollect) {
                String routerName = rmRouter.getRouterName();
                if (StrUtils.isNull((Object)routerName)) {
                    String destNodeNo = rmRouter.getDestNode();
                    FmNode destNode = fmNodeList.stream().filter(p -> p.getNodeNo().equals(destNodeNo)).findFirst().get();
                    routerName = fmNode.getNodeName() + "->" + destNode.getNodeName();
                }
                TreeNode edgeNode = new TreeNode(rmRouter.getRouterUuid(), routerName);
                Map routerInfoMap = JsonUtils.json2Map((String)rmRouter.getRouterInfo());
                edgeNode.getChildren().add(new TreeNode(rmRouter.getRouterUuid(), JsonUtils.toJson((Object)routerInfoMap), CompareEnum.Tag.FM_ROUTER.getDesc(), CompareEnum.Tag.FM_ROUTER.getType(), null));
                List<SaveRuleUsedParam> routerRules = rmRouter.getRules();
                if (CollectionUtils.isNotEmpty(routerRules)) {
                    TreeNode ruleNode = this.getRuleNode(routerRules, rmRouter.getRouterUuid());
                    edgeNode.getChildren().add(ruleNode);
                }
                rootEdgeNode.getChildren().add(edgeNode);
            }
            singleFlowNode.getChildren().add(rootEdgeNode);
            rootFlowNode.getChildren().add(singleFlowNode);
        }
        return rootFlowNode;
    }

    private TreeNode buildTemplateTree(NodeAndTemplateParam newJson) {
        TreeNode rootTemplateNode = new TreeNode("\u9875\u9762", "\u9875\u9762");
        for (FmTemplate template : newJson.getFlow().getFmTemplateList()) {
            TreeNode singleTemplateNode = new TreeNode(template.getTemplateId(), template.getTemplateName());
            if (CollectionUtils.isNotEmpty(template.getRules())) {
                TreeNode ruleNode = this.getRuleNode(template.getRules(), template.getTemplateId());
                singleTemplateNode.getChildren().add(ruleNode.setDisplayOrder(singleTemplateNode.getChildren().size() + 1));
            }
            if (CollectionUtils.isEmpty(template.getAttrList())) {
                rootTemplateNode.getChildren().add(singleTemplateNode.setDisplayOrder(rootTemplateNode.getChildren().size()));
                continue;
            }
            TreeNode parentAttrNode = new TreeNode(template.getTemplateId() + "_attr", "\u7ec4\u4ef6");
            List attributes = template.getAttrList().stream().filter(p -> "0".equals(p.getUpAttr())).collect(Collectors.toList());
            for (FmTemplateAttributes attribute : attributes) {
                TreeNode attrNode = this.recursiveAttrNode(attribute, template.getAttrList());
                parentAttrNode.getChildren().add(attrNode.setDisplayOrder(parentAttrNode.getChildren().size()));
            }
            singleTemplateNode.getChildren().add(parentAttrNode.setDisplayOrder(singleTemplateNode.getChildren().size()));
            rootTemplateNode.getChildren().add(singleTemplateNode.setDisplayOrder(rootTemplateNode.getChildren().size()));
        }
        return rootTemplateNode;
    }

    public TreeNode recursiveAttrNode(FmTemplateAttributes currentAttr, List<FmTemplateAttributes> attributes) {
        TreeNode currentNode = this.getAttrNode(currentAttr);
        List collect = attributes.stream().filter(p -> currentAttr.getAttrId().equals(p.getUpAttr())).sorted((o1, o2) -> o1.getDisplayOrder() - o2.getDisplayOrder()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return currentNode;
        }
        for (FmTemplateAttributes attr : collect) {
            TreeNode childNode = this.recursiveAttrNode(attr, attributes);
            currentNode.getChildren().add(childNode);
        }
        return currentNode;
    }

    private TreeNode getAttrNode(FmTemplateAttributes attribute) {
        TreeNode treeNode = new TreeNode(attribute.getAttrId(), attribute.getAttrName());
        Map map = JsonUtils.json2Map((String)attribute.getAttrJson());
        map.remove("columns");
        map.put("display_order", attribute.getDisplayOrder());
        TreeNode featureNode = new TreeNode(attribute.getAttrId(), JsonUtils.toJson((Object)map), CompareEnum.Tag.FM_TEMPLATE_ATTRIBUTES.getDesc(), CompareEnum.Tag.FM_TEMPLATE_ATTRIBUTES.getType(), null);
        treeNode.getChildren().add(featureNode.setDisplayOrder(treeNode.getChildren().size()));
        List<SaveRuleUsedParam> rules = attribute.getRules();
        if (CollectionUtils.isEmpty(rules)) {
            return treeNode;
        }
        TreeNode ruleNode = this.getRuleNode(rules, attribute.getAttrId());
        treeNode.getChildren().add(ruleNode.setDisplayOrder(treeNode.getChildren().size()));
        return treeNode;
    }

    private TreeNode getRuleNode(List<SaveRuleUsedParam> rules, String parentUuid) {
        TreeNode ruleNode = new TreeNode(parentUuid + "_rule", "\u89c4\u5219");
        for (SaveRuleUsedParam param : rules) {
            TreeNode singleRuleNode = new TreeNode(param.getRuleId(), param.getRuleName());
            SaveRuleUsedParam copyParam = new SaveRuleUsedParam();
            this.copyObject(param, copyParam);
            singleRuleNode.getChildren().add(new TreeNode(copyParam.getRuleId(), JsonUtils.toJson((Object)copyParam), CompareEnum.Tag.DSN_RULES.getDesc(), CompareEnum.Tag.DSN_RULES.getType(), null).setDisplayOrder(singleRuleNode.getChildren().size()));
            ruleNode.getChildren().add(singleRuleNode.setDisplayOrder(ruleNode.getChildren().size()));
        }
        return ruleNode;
    }

    private void copyObject(Object originObj, Object copyObj) {
        List list = ModelFieldCache.getInstance().getFieldMapper(copyObj.getClass());
        for (com.uniapis.repository.core.Field aField : list) {
            Object value = ClassUtils.getProperty((Object)originObj, (String)aField.property());
            ClassUtils.setProperty((Object)copyObj, (String)aField.property(), (Object)value);
        }
    }

    public static void setFieldValue(Object object, String fieldName, Object fieldValue) {
        Field field = null;
        try {
            field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, fieldValue);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NodeAndTemplateParam getFileObject(String filePath) {
        File jsonFile = new File(filePath);
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");){
            NodeAndTemplateParam newJson;
            int ch = 0;
            StringBuilder sb = new StringBuilder();
            while ((ch = ((Reader)reader).read()) != -1) {
                sb.append((char)ch);
            }
            String jsonStr = sb.toString();
            NodeAndTemplateParam nodeAndTemplateParam = newJson = new NodeAndTemplateParam(jsonStr);
            return nodeAndTemplateParam;
        }
        catch (Exception e) {
            Ulog.error((Throwable)e);
            Ulog.info((String)("\u5546\u54c1\u7ba1\u7406\u5bfc\u5165\u5931\u8d25-->" + e.getMessage()));
            e.printStackTrace();
            throw new BusinessException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NodeAndTemplateParam getFileJson(MultipartFile file) {
        NodeAndTemplateParam flow = null;
        String pathName = this.templateConfig.getUploadFormCollectPath() + "/upload/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = FilesUtil.unzipFile(file, pathName);
        if (!msg.isSuccessflag()) {
            throw new BusinessException(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
        }
        File importDir = new File(pathName);
        ArrayList<File> jsonList = new ArrayList<File>();
        ArrayList<File> fileList = new ArrayList<File>();
        FilesUtil.getAllFiles(importDir, jsonList, fileList);
        Iterator iterator = jsonList.iterator();
        if (!iterator.hasNext()) {
            FilesUtil.delFile(pathName);
            return flow;
        }
        File jsonFile = (File)iterator.next();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");){
            int ch = 0;
            StringBuilder sb = new StringBuilder();
            while ((ch = ((Reader)reader).read()) != -1) {
                sb.append((char)ch);
            }
            String jsonStr = sb.toString();
            NodeAndTemplateParam nodeAndTemplateParam = flow = new NodeAndTemplateParam(jsonStr);
            return nodeAndTemplateParam;
        }
        catch (Exception e) {
            Ulog.error((Throwable)e);
            Ulog.info((String)("\u5546\u54c1\u7ba1\u7406\u5bfc\u5165\u5931\u8d25-->" + e.getMessage()));
            e.printStackTrace();
            throw new BusinessException(e.getMessage());
        }
    }
}

