/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.duty.controller;

import com.newtouch.duty.service.IRiskDutyService;
import com.newtouch.duty.vo.IRiskDutyReqVo;
import com.newtouch.nms.sip.model.SipRiskDutyRelation;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/riskDuty"})
public class RiskDutyController {
    @Autowired
    private IRiskDutyService iRiskDutyService;

    @PostMapping(value={"/addRiskDuty.do"})
    public String addRiskDuty(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        SipRiskDutyRelation sipRiskDutyRelation = (SipRiskDutyRelation)JsonUtils.map2Class((Map)param, SipRiskDutyRelation.class);
        ReturnMsg msg = this.iRiskDutyService.addRiskDuty(sipRiskDutyRelation);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/queryRiskDuty.do"})
    public String queryRiskDuty(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        IRiskDutyReqVo iRiskDutyReqVo = (IRiskDutyReqVo)JsonUtils.map2Class((Map)param, IRiskDutyReqVo.class);
        ReturnMsg msg = this.iRiskDutyService.queryRiskDuty(iRiskDutyReqVo);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/updateRiskDuty.do"})
    public String updateRiskDuty(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        SipRiskDutyRelation sipRiskDutyRelation = (SipRiskDutyRelation)JsonUtils.map2Class((Map)param, SipRiskDutyRelation.class);
        ReturnMsg msg = this.iRiskDutyService.updateRiskDuty(sipRiskDutyRelation);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/deleteRiskDuty.do"})
    public String deleteRiskDuty(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        String sernoStr = (String)param.get("sernos");
        if (StrUtils.isNull((Object)sernoStr)) {
            throw new BusinessException("\u5165\u53c2sernoStr\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        ReturnMsg msg = this.iRiskDutyService.deleteRiskDuty(sernoStr);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/queryProductList.do"})
    public String queryProductList(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        ReturnMsg msg = this.iRiskDutyService.queryProductList(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/queryRiskList.do"})
    public String queryRiskList(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        String productNo = (String)param.get("product_no");
        ReturnMsg msg = this.iRiskDutyService.queryRiskList(productNo);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/uploadRiskDuty.do"})
    public String uploadRiskDuty(MultipartFile zipFile) {
        ReturnMsg returnMsg = this.iRiskDutyService.uploadRiskDuty(zipFile);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @PostMapping(value={"/exportRiskDutyJson.do"})
    public String exportRiskDutyJson(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String sernosLists = map.get("sernos");
        ReturnMsg msg = this.iRiskDutyService.exportRiskDutyJson(sernosLists, response);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

