/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.enums.RelateEnum;
import com.newtouch.base.model.FmCollection;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.newtouch.base.vo.export.FmNodeInfo;
import com.newtouch.base.vo.export.FmRouterInfo;
import com.newtouch.base.vo.export.FormInfo;
import com.newtouch.base.vo.export.MaterialInfo;
import com.newtouch.base.vo.export.SmtrInfo;
import com.newtouch.base.vo.export.WtIssueInfo;
import com.newtouch.flow.model.FmFlow;
import com.newtouch.flow.model.FmNode;
import com.newtouch.flow.model.FmRouter;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class FlowInfo {
    @JsonProperty(value="fmFlow")
    private FmFlow fmFlow;
    @JsonProperty(value="fmCollection")
    private FmCollection fmCollection;
    @JsonProperty(value="fmRouterList")
    private List<FmRouterInfo> fmRouterList;
    @JsonProperty(value="fmNodeList")
    private List<FmNodeInfo> fmNodeList;
    @JsonProperty(value="smtrList")
    private List<SmtrInfo> smtrList;
    @JsonProperty(value="formInfoList")
    private List<FormInfo> formInfoList;
    @JsonProperty(value="wtIssueList")
    private List<WtIssueInfo> wtIssueList;
    @JsonProperty(value="materialList")
    private List<MaterialInfo> materialList;

    public FlowInfo load(String flowUuid) {
        ExportQueryUtils query = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        this.fmFlow = query.queryFmFlow(flowUuid);
        this.fmCollection = query.queryFmCollection(this.fmFlow.getCollId());
        this.fmRouterList = new ArrayList<FmRouterInfo>();
        List<FmRouter> routerList = query.queryFmRouterList(flowUuid);
        if (CollectionUtils.isNotEmpty(routerList)) {
            for (FmRouter fr : routerList) {
                Iterator fri = new FmRouterInfo();
                ((FmRouterInfo)((Object)fri)).setFmRouter(fr);
                ((FmRouterInfo)((Object)fri)).load(fr.getRouterUuid());
                this.fmRouterList.add((FmRouterInfo)((Object)fri));
            }
        }
        this.fmNodeList = new ArrayList<FmNodeInfo>();
        List<FmNode> nodeList = query.queryFmNodeList(flowUuid);
        HashMap<String, String> formIdMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(nodeList)) {
            for (FmNode fn : nodeList) {
                FmNodeInfo fni = new FmNodeInfo();
                fni.setFmNode(fn);
                if (!StrUtils.isNull((Object)fn.getRelateFk())) {
                    formIdMap.put(fn.getRelateFk(), "");
                }
                fni.load(fn.getNodeNo());
                this.fmNodeList.add(fni);
            }
        }
        this.formInfoList = new ArrayList<FormInfo>();
        for (Map.Entry entry : formIdMap.entrySet()) {
            String key = (String)entry.getKey();
            FormInfo formInfo = new FormInfo();
            formInfo.load(key);
            this.formInfoList.add(formInfo);
        }
        this.smtrList = new ArrayList<SmtrInfo>();
        List<ScpzMaterialTagsRelation> scpzMaterialTagsRelations = query.querySmtr(flowUuid, RelateEnum.flow.getRelateField(), RelateEnum.flow.getRelateTab());
        if (CollectionUtils.isNotEmpty(scpzMaterialTagsRelations)) {
            for (ScpzMaterialTagsRelation smtr : scpzMaterialTagsRelations) {
                SmtrInfo si = new SmtrInfo();
                si.setSmtr(smtr);
                si.load(smtr.getTagId());
                this.smtrList.add(si);
            }
        }
        return this;
    }

    public void merge(FlowInfo formInfo) {
        this.fmFlow = EqualsUtils.merge(this.fmFlow, formInfo.getFmFlow());
        this.fmCollection = EqualsUtils.merge(this.fmCollection, formInfo.getFmCollection());
        this.fmRouterList = EqualsUtils.merge(this.fmRouterList, formInfo.getFmRouterList(), FmRouterInfo.class);
        this.fmNodeList = EqualsUtils.merge(this.fmNodeList, formInfo.getFmNodeList(), FmNodeInfo.class);
        this.smtrList = EqualsUtils.merge(this.smtrList, formInfo.getSmtrList(), SmtrInfo.class);
        this.formInfoList = EqualsUtils.merge(this.formInfoList, formInfo.getFormInfoList(), FormInfo.class);
    }

    public void save() {
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        if (this.fmFlow != null) {
            update.update(this.fmFlow);
        }
        if (this.fmCollection != null) {
            update.update(this.fmCollection);
        }
        if (this.fmRouterList != null) {
            this.fmRouterList.forEach(m -> m.save());
        }
        if (this.fmNodeList != null) {
            this.fmNodeList.forEach(m -> m.save());
        }
        if (this.smtrList != null) {
            this.smtrList.forEach(m -> m.save());
        }
        if (this.formInfoList != null) {
            this.formInfoList.forEach(m -> m.save("N"));
        }
    }

    public FmFlow getFmFlow() {
        return this.fmFlow;
    }

    public FmCollection getFmCollection() {
        return this.fmCollection;
    }

    public List<FmRouterInfo> getFmRouterList() {
        return this.fmRouterList;
    }

    public List<FmNodeInfo> getFmNodeList() {
        return this.fmNodeList;
    }

    public List<SmtrInfo> getSmtrList() {
        return this.smtrList;
    }

    public List<FormInfo> getFormInfoList() {
        return this.formInfoList;
    }

    public List<WtIssueInfo> getWtIssueList() {
        return this.wtIssueList;
    }

    public List<MaterialInfo> getMaterialList() {
        return this.materialList;
    }

    @JsonProperty(value="fmFlow")
    public void setFmFlow(FmFlow fmFlow) {
        this.fmFlow = fmFlow;
    }

    @JsonProperty(value="fmCollection")
    public void setFmCollection(FmCollection fmCollection) {
        this.fmCollection = fmCollection;
    }

    @JsonProperty(value="fmRouterList")
    public void setFmRouterList(List<FmRouterInfo> fmRouterList) {
        this.fmRouterList = fmRouterList;
    }

    @JsonProperty(value="fmNodeList")
    public void setFmNodeList(List<FmNodeInfo> fmNodeList) {
        this.fmNodeList = fmNodeList;
    }

    @JsonProperty(value="smtrList")
    public void setSmtrList(List<SmtrInfo> smtrList) {
        this.smtrList = smtrList;
    }

    @JsonProperty(value="formInfoList")
    public void setFormInfoList(List<FormInfo> formInfoList) {
        this.formInfoList = formInfoList;
    }

    @JsonProperty(value="wtIssueList")
    public void setWtIssueList(List<WtIssueInfo> wtIssueList) {
        this.wtIssueList = wtIssueList;
    }

    @JsonProperty(value="materialList")
    public void setMaterialList(List<MaterialInfo> materialList) {
        this.materialList = materialList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowInfo)) {
            return false;
        }
        FlowInfo other = (FlowInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FmFlow this$fmFlow = this.getFmFlow();
        FmFlow other$fmFlow = other.getFmFlow();
        if (this$fmFlow == null ? other$fmFlow != null : !((Object)((Object)this$fmFlow)).equals((Object)other$fmFlow)) {
            return false;
        }
        FmCollection this$fmCollection = this.getFmCollection();
        FmCollection other$fmCollection = other.getFmCollection();
        if (this$fmCollection == null ? other$fmCollection != null : !((Object)((Object)this$fmCollection)).equals((Object)other$fmCollection)) {
            return false;
        }
        List<FmRouterInfo> this$fmRouterList = this.getFmRouterList();
        List<FmRouterInfo> other$fmRouterList = other.getFmRouterList();
        if (this$fmRouterList == null ? other$fmRouterList != null : !((Object)this$fmRouterList).equals(other$fmRouterList)) {
            return false;
        }
        List<FmNodeInfo> this$fmNodeList = this.getFmNodeList();
        List<FmNodeInfo> other$fmNodeList = other.getFmNodeList();
        if (this$fmNodeList == null ? other$fmNodeList != null : !((Object)this$fmNodeList).equals(other$fmNodeList)) {
            return false;
        }
        List<SmtrInfo> this$smtrList = this.getSmtrList();
        List<SmtrInfo> other$smtrList = other.getSmtrList();
        if (this$smtrList == null ? other$smtrList != null : !((Object)this$smtrList).equals(other$smtrList)) {
            return false;
        }
        List<FormInfo> this$formInfoList = this.getFormInfoList();
        List<FormInfo> other$formInfoList = other.getFormInfoList();
        if (this$formInfoList == null ? other$formInfoList != null : !((Object)this$formInfoList).equals(other$formInfoList)) {
            return false;
        }
        List<WtIssueInfo> this$wtIssueList = this.getWtIssueList();
        List<WtIssueInfo> other$wtIssueList = other.getWtIssueList();
        if (this$wtIssueList == null ? other$wtIssueList != null : !((Object)this$wtIssueList).equals(other$wtIssueList)) {
            return false;
        }
        List<MaterialInfo> this$materialList = this.getMaterialList();
        List<MaterialInfo> other$materialList = other.getMaterialList();
        return !(this$materialList == null ? other$materialList != null : !((Object)this$materialList).equals(other$materialList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FmFlow $fmFlow = this.getFmFlow();
        result = result * 59 + ($fmFlow == null ? 43 : ((Object)((Object)$fmFlow)).hashCode());
        FmCollection $fmCollection = this.getFmCollection();
        result = result * 59 + ($fmCollection == null ? 43 : ((Object)((Object)$fmCollection)).hashCode());
        List<FmRouterInfo> $fmRouterList = this.getFmRouterList();
        result = result * 59 + ($fmRouterList == null ? 43 : ((Object)$fmRouterList).hashCode());
        List<FmNodeInfo> $fmNodeList = this.getFmNodeList();
        result = result * 59 + ($fmNodeList == null ? 43 : ((Object)$fmNodeList).hashCode());
        List<SmtrInfo> $smtrList = this.getSmtrList();
        result = result * 59 + ($smtrList == null ? 43 : ((Object)$smtrList).hashCode());
        List<FormInfo> $formInfoList = this.getFormInfoList();
        result = result * 59 + ($formInfoList == null ? 43 : ((Object)$formInfoList).hashCode());
        List<WtIssueInfo> $wtIssueList = this.getWtIssueList();
        result = result * 59 + ($wtIssueList == null ? 43 : ((Object)$wtIssueList).hashCode());
        List<MaterialInfo> $materialList = this.getMaterialList();
        result = result * 59 + ($materialList == null ? 43 : ((Object)$materialList).hashCode());
        return result;
    }

    public String toString() {
        return "FlowInfo(fmFlow=" + (Object)((Object)this.getFmFlow()) + ", fmCollection=" + (Object)((Object)this.getFmCollection()) + ", fmRouterList=" + this.getFmRouterList() + ", fmNodeList=" + this.getFmNodeList() + ", smtrList=" + this.getSmtrList() + ", formInfoList=" + this.getFormInfoList() + ", wtIssueList=" + this.getWtIssueList() + ", materialList=" + this.getMaterialList() + ")";
    }
}

