/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.config;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.uniapis.logger.Ulog;
import java.io.Serializable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="obs")
public class ObsConfig
implements Serializable {
    private static final long serialVersionUID = -6012325496138899160L;
    private String endpoint;
    private String bucketName;
    private String accessKey;
    private String secretKey;
    private String endpointUrl;
    private String obsPath;
    private String obsSplitPath;

    public ObsClient getInstance() {
        Ulog.info((String)("ak:" + this.accessKey + "-sk:" + this.secretKey + "-endpoint:" + this.endpoint));
        return new ObsClient(this.accessKey, this.secretKey, this.endpoint);
    }

    public void destroy(ObsClient obsClient) {
        try {
            obsClient.close();
        }
        catch (ObsException e) {
            Ulog.error((String)("obs\u6267\u884c\u5931\u8d25" + e.getMessage()));
        }
        catch (Exception e) {
            Ulog.error((String)("\u6267\u884c\u5931\u8d25" + e.getMessage()));
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public String getObsPath() {
        return this.obsPath;
    }

    public String getObsSplitPath() {
        return this.obsSplitPath;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public void setObsPath(String obsPath) {
        this.obsPath = obsPath;
    }

    public void setObsSplitPath(String obsSplitPath) {
        this.obsSplitPath = obsSplitPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObsConfig)) {
            return false;
        }
        ObsConfig other = (ObsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$endpointUrl = this.getEndpointUrl();
        String other$endpointUrl = other.getEndpointUrl();
        if (this$endpointUrl == null ? other$endpointUrl != null : !this$endpointUrl.equals(other$endpointUrl)) {
            return false;
        }
        String this$obsPath = this.getObsPath();
        String other$obsPath = other.getObsPath();
        if (this$obsPath == null ? other$obsPath != null : !this$obsPath.equals(other$obsPath)) {
            return false;
        }
        String this$obsSplitPath = this.getObsSplitPath();
        String other$obsSplitPath = other.getObsSplitPath();
        return !(this$obsSplitPath == null ? other$obsSplitPath != null : !this$obsSplitPath.equals(other$obsSplitPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObsConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $endpointUrl = this.getEndpointUrl();
        result = result * 59 + ($endpointUrl == null ? 43 : $endpointUrl.hashCode());
        String $obsPath = this.getObsPath();
        result = result * 59 + ($obsPath == null ? 43 : $obsPath.hashCode());
        String $obsSplitPath = this.getObsSplitPath();
        result = result * 59 + ($obsSplitPath == null ? 43 : $obsSplitPath.hashCode());
        return result;
    }

    public String toString() {
        return "ObsConfig(endpoint=" + this.getEndpoint() + ", bucketName=" + this.getBucketName() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", endpointUrl=" + this.getEndpointUrl() + ", obsPath=" + this.getObsPath() + ", obsSplitPath=" + this.getObsSplitPath() + ")";
    }
}

