/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.model.QsnPaperTemplate;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.newtouch.base.vo.export.FormInfo;
import com.newtouch.base.vo.export.QsnInfo;
import com.newtouch.inform.model.QsnTitleRelation;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class QsnPaperTemplateInfo
implements Comparable {
    @JsonProperty(value="qsnPaperTemplate")
    private QsnPaperTemplate qsnPaperTemplate;
    @JsonProperty(value="formInfo")
    private FormInfo formInfo;
    @JsonProperty(value="qsnInfoList")
    private List<QsnInfo> qsnInfoList;

    public QsnPaperTemplateInfo load(QsnPaperTemplate qpt, String paperType) {
        List<QsnTitleRelation> qsnTitleRelations;
        ExportQueryUtils query = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        this.formInfo = new FormInfo();
        this.formInfo.load(qpt.getTemplateId());
        this.qsnInfoList = new ArrayList<QsnInfo>();
        if (("inform".equals(paperType) || "qsn".equals(paperType)) && CollectionUtils.isNotEmpty(qsnTitleRelations = query.queryQsnTitleRelationList(qpt.getPaperUuid()))) {
            for (QsnTitleRelation qtr : qsnTitleRelations) {
                QsnInfo qsnInfo = new QsnInfo();
                qsnInfo.setQsnTitleRelation(qtr);
                qsnInfo.load(qtr.getQsnUuid(), "0");
                this.qsnInfoList.add(qsnInfo);
            }
        }
        return this;
    }

    public void merge(QsnPaperTemplateInfo qsnPaperTemplateInfo) {
        this.qsnPaperTemplate = EqualsUtils.merge(this.qsnPaperTemplate, qsnPaperTemplateInfo.getQsnPaperTemplate());
        this.formInfo = EqualsUtils.merge(this.formInfo, qsnPaperTemplateInfo.getFormInfo(), FormInfo.class);
        this.qsnInfoList = EqualsUtils.merge(this.qsnInfoList, qsnPaperTemplateInfo.getQsnInfoList(), QsnInfo.class);
    }

    public int compareTo(@NotNull Object o) {
        UpdateUtils.UpdateFlag flag = (UpdateUtils.UpdateFlag)((Object)this.qsnPaperTemplate.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
        if (flag == UpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == UpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == UpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }

    public void save() {
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        if (this.qsnPaperTemplate != null) {
            update.update(this.qsnPaperTemplate);
        }
        if (this.formInfo != null) {
            this.formInfo.save("Y");
        }
        if (this.qsnInfoList != null) {
            this.qsnInfoList.forEach(m -> m.save());
        }
    }

    public QsnPaperTemplate getQsnPaperTemplate() {
        return this.qsnPaperTemplate;
    }

    public FormInfo getFormInfo() {
        return this.formInfo;
    }

    public List<QsnInfo> getQsnInfoList() {
        return this.qsnInfoList;
    }

    @JsonProperty(value="qsnPaperTemplate")
    public void setQsnPaperTemplate(QsnPaperTemplate qsnPaperTemplate) {
        this.qsnPaperTemplate = qsnPaperTemplate;
    }

    @JsonProperty(value="formInfo")
    public void setFormInfo(FormInfo formInfo) {
        this.formInfo = formInfo;
    }

    @JsonProperty(value="qsnInfoList")
    public void setQsnInfoList(List<QsnInfo> qsnInfoList) {
        this.qsnInfoList = qsnInfoList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QsnPaperTemplateInfo)) {
            return false;
        }
        QsnPaperTemplateInfo other = (QsnPaperTemplateInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QsnPaperTemplate this$qsnPaperTemplate = this.getQsnPaperTemplate();
        QsnPaperTemplate other$qsnPaperTemplate = other.getQsnPaperTemplate();
        if (this$qsnPaperTemplate == null ? other$qsnPaperTemplate != null : !((Object)((Object)this$qsnPaperTemplate)).equals((Object)other$qsnPaperTemplate)) {
            return false;
        }
        FormInfo this$formInfo = this.getFormInfo();
        FormInfo other$formInfo = other.getFormInfo();
        if (this$formInfo == null ? other$formInfo != null : !((Object)this$formInfo).equals(other$formInfo)) {
            return false;
        }
        List<QsnInfo> this$qsnInfoList = this.getQsnInfoList();
        List<QsnInfo> other$qsnInfoList = other.getQsnInfoList();
        return !(this$qsnInfoList == null ? other$qsnInfoList != null : !((Object)this$qsnInfoList).equals(other$qsnInfoList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QsnPaperTemplateInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QsnPaperTemplate $qsnPaperTemplate = this.getQsnPaperTemplate();
        result = result * 59 + ($qsnPaperTemplate == null ? 43 : ((Object)((Object)$qsnPaperTemplate)).hashCode());
        FormInfo $formInfo = this.getFormInfo();
        result = result * 59 + ($formInfo == null ? 43 : ((Object)$formInfo).hashCode());
        List<QsnInfo> $qsnInfoList = this.getQsnInfoList();
        result = result * 59 + ($qsnInfoList == null ? 43 : ((Object)$qsnInfoList).hashCode());
        return result;
    }

    public String toString() {
        return "QsnPaperTemplateInfo(qsnPaperTemplate=" + (Object)((Object)this.getQsnPaperTemplate()) + ", formInfo=" + this.getFormInfo() + ", qsnInfoList=" + this.getQsnInfoList() + ")";
    }
}

