/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.operation.service.impl;

import com.newtouch.flow.model.FmProductFlow;
import com.newtouch.flow.model.FmProductFlowLink;
import com.newtouch.nms.sip.model.SysEnumConf;
import com.newtouch.operation.enums.OperationEnum;
import com.newtouch.operation.model.RmsOpRecord;
import com.newtouch.operation.service.OperationService;
import com.newtouch.operation.vo.OpRecordVo;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.context.pojo.User;
import com.uniapis.logger.Ulog;
import com.uniapis.model.sys.SysEnum;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.rms.model.RmsUser;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperationServiceImpl
implements OperationService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public void save() {
        RmsOpRecord record1 = new RmsOpRecord();
        record1.setOpResult("\u8981\u56de\u6eda");
        this.dao.save((AbsModel)record1);
        throw new BusinessException("123");
    }

    @Override
    public void saveRmsOpRecord(RmsOpRecord record, String opResult) {
        RmsOpRecord selectRecord = new RmsOpRecord();
        selectRecord.where().addEq(RmsOpRecord.OP_ID, (Object)record.getOpId());
        RmsOpRecord dbRecord = (RmsOpRecord)this.dao.findOne((AbsModel)selectRecord);
        if (dbRecord != null) {
            if ("fail".equals(opResult) || StrUtils.isNull((Object)dbRecord.getOpResult())) {
                record.setOpResult(opResult);
            }
            record.where().addEq(RmsOpRecord.OP_ID, (Object)record.getOpId());
            this.dao.update((AbsModel)record);
        } else {
            record.setOpResult(opResult);
            this.dao.save((AbsModel)record);
        }
    }

    @Override
    public ReturnMsg getOpRecords(OpRecordVo record) {
        Return aReturn = new Return();
        RmsOpRecord rmsOpRecord = new RmsOpRecord();
        rmsOpRecord.where().addEq(RmsOpRecord.DATA_FLAG, (Object)"1");
        if (!StrUtils.isNull((Object)record.getOpTimeStart()) && !StrUtils.isNull((Object)record.getOpTimeEnd())) {
            rmsOpRecord.where().addBetween(RmsOpRecord.OP_TIME, record.getOpTimeStart(), record.getOpTimeEnd());
        }
        if (!StrUtils.isNull((Object)record.getOpUser())) {
            rmsOpRecord.where().addLike(RmsOpRecord.OP_USER, (Object)record.getOpUser());
        }
        if (!StrUtils.isNull((Object)record.getOpMenu())) {
            rmsOpRecord.where().addEq(RmsOpRecord.OP_MENU, (Object)record.getOpMenu());
        }
        if (!StrUtils.isNull((Object)record.getOpTrack())) {
            rmsOpRecord.where().addLike(RmsOpRecord.OP_TRACK, (Object)record.getOpTrack());
        }
        if (!StrUtils.isNull((Object)record.getOpInterface())) {
            rmsOpRecord.where().addLike(RmsOpRecord.OP_INTERFACE, (Object)record.getOpInterface());
        }
        if (!StrUtils.isNull((Object)record.getOpResult())) {
            rmsOpRecord.where().addLike(RmsOpRecord.OP_RESULT, (Object)record.getOpResult());
        }
        if (!StrUtils.isNull((Object)record.getOpIp())) {
            rmsOpRecord.where().addLike(RmsOpRecord.OP_IP, (Object)record.getOpIp());
        }
        if (!StrUtils.isNull((Object)record.getOpReqJson())) {
            rmsOpRecord.where().addLike(RmsOpRecord.OP_REQ_JSON, (Object)record.getOpReqJson());
        }
        List all = this.dao.findAll((AbsModel)rmsOpRecord, Boolean.valueOf(true));
        aReturn.setDataList(all, RmsOpRecord.class);
        return aReturn.msg();
    }

    @Override
    public RmsUser getRmsUser(String opUser) {
        RmsUser rmsUser = (RmsUser)this.dao.findOne(RmsUser.n().where().addEq(RmsUser.PK_UUID, (Object)opUser).model());
        return rmsUser;
    }

    @Override
    public RmsOpRecord assembleRmsOpRecord(HttpServletRequest httpServletRequest, String bodyString) throws UnsupportedEncodingException, UnknownHostException {
        RmsOpRecord record = new RmsOpRecord();
        String opId = UUID.uuid();
        record.setOpId(opId);
        httpServletRequest.setAttribute("op_id", (Object)opId);
        record.setOpTime(new Date());
        User user = ThreadLocalContext.get().getUser();
        String opUser = user.getPkUuid();
        String opMenuce = httpServletRequest.getHeader("op_menu");
        String opTrackce = httpServletRequest.getHeader("op_track");
        String opMenu = "";
        String opTrack = "";
        if (!StrUtils.isNull((Object)opMenuce)) {
            opMenu = URLDecoder.decode(httpServletRequest.getHeader("op_menu"), "UTF-8");
            record.setOpMenu(opMenu);
        }
        if (!StrUtils.isNull((Object)opTrackce)) {
            opTrack = URLDecoder.decode(httpServletRequest.getHeader("op_track"), "UTF-8");
            Ulog.info((String)("opTrack===>" + opTrack));
            record.setOpTrack(opTrack);
            if (opTrack.contains("-")) {
                String[] split = opTrack.split("-");
                int length = split.length;
                if (length >= 2) {
                    record.setOpFunc(split[1]);
                }
                if (length >= 3) {
                    record.setOpBtn(split[2]);
                }
                if (length >= 4) {
                    record.setOpBtnC(split[3]);
                }
            }
        }
        String pathInfo = httpServletRequest.getRequestURI();
        record.setOpInterface(pathInfo);
        InetAddress addr = InetAddress.getLocalHost();
        String hostAddress = addr.getHostAddress();
        record.setOpIp(hostAddress);
        Ulog.info((String)("bodyString===>" + bodyString));
        record.setOpReqJson(bodyString);
        RmsUser rmsUser = this.getRmsUser(opUser);
        String opUserName = rmsUser.getUserName();
        record.setOpUser(opUserName);
        return record;
    }

    @Override
    public ReturnMsg getOpRecordList(OpRecordVo record) {
        Return aReturn = new Return();
        RmsOpRecord rmsOpRecord = new RmsOpRecord();
        rmsOpRecord.where().addEq(RmsOpRecord.DATA_FLAG, (Object)"1");
        rmsOpRecord.where().addEq(RmsOpRecord.OP_RESULT, (Object)OperationEnum.OpResultEnum.upsuccess.getType());
        if (!StrUtils.isNull((Object)record.getOpTimeStart()) && !StrUtils.isNull((Object)record.getOpTimeEnd())) {
            rmsOpRecord.where().addBetween(RmsOpRecord.OP_TIME, record.getOpTimeStart(), record.getOpTimeEnd());
        }
        if (!StrUtils.isNull((Object)record.getOpUser())) {
            rmsOpRecord.where().addLike(RmsOpRecord.OP_USER, (Object)record.getOpUser());
        }
        if (!StrUtils.isNull((Object)record.getOpJson())) {
            rmsOpRecord.where().addLike(RmsOpRecord.OP_JSON, (Object)record.getOpJson());
        }
        rmsOpRecord.setOrderBy(RmsOpRecord.OP_TIME.desc());
        List all = this.dao.findAll((AbsModel)rmsOpRecord, Boolean.valueOf(true));
        aReturn.setDataList(all, RmsOpRecord.class);
        return aReturn.msg();
    }

    @Override
    public String getLinkOpJson(String opJson, String uuid, FmProductFlow flowDB, FmProductFlowLink flowLinkSave) {
        String deliveryPlatform = flowDB.getDeliveryPlatform();
        SysEnum dysEnum = (SysEnum)this.dao.findOne(SysEnum.n().where().addEq(SysEnum.ENUM_TYPE, (Object)"delivery_platform").addEq(SysEnum.ENUM_CODE, (Object)deliveryPlatform).model());
        if (dysEnum != null) {
            deliveryPlatform = dysEnum.getEnumName();
        }
        String orderingPlatform = flowLinkSave.getOrderingPlatform();
        SysEnum oysEnum = (SysEnum)this.dao.findOne(SysEnum.n().where().addEq(SysEnum.ENUM_TYPE, (Object)deliveryPlatform).addEq(SysEnum.ENUM_CODE, (Object)orderingPlatform).model());
        if (oysEnum != null) {
            orderingPlatform = oysEnum.getEnumName();
        }
        String saleName = flowDB.getSaleName();
        String channelNo = flowDB.getChannelNo();
        SysEnumConf sysEnumConf = (SysEnumConf)this.dao.findOne(SysEnumConf.n().where().addEq(SysEnumConf.UP_ENUM, (Object)"channel_type").addEq(SysEnumConf.ENUM_CODE, (Object)channelNo).model());
        if (sysEnumConf != null) {
            channelNo = sysEnumConf.getEnumName();
        }
        String resourceCode = StrUtils.isNull((Object)flowLinkSave.getResourceCode()) ? "" : flowLinkSave.getResourceCode();
        String recordAgent = StrUtils.isNull((Object)flowLinkSave.getRecordAgent()) ? "" : flowLinkSave.getRecordAgent();
        String resourceName = StrUtils.isNull((Object)flowLinkSave.getResourceName()) ? "" : flowLinkSave.getResourceName();
        String formJson = StrUtils.isNull((Object)flowLinkSave.getFormJson()) ? "" : flowLinkSave.getFormJson();
        String uuidName = saleName + channelNo + deliveryPlatform + resourceCode + "\u7684\u94fe\u63a5";
        if (OperationEnum.OpJsonEnum.addOrEditLink.getType().equals(opJson)) {
            opJson = String.format(opJson, uuid, uuidName, deliveryPlatform, orderingPlatform, recordAgent, OperationEnum.AllowUnloginEnum.getDescByCode(flowLinkSave.getAllowUnlogin()), resourceCode, resourceName, OperationEnum.StateEnum.getDescByCode(flowLinkSave.getState()), formJson);
        }
        if (OperationEnum.OpJsonEnum.delLink.getType().equals(opJson) || OperationEnum.OpJsonEnum.addFlowCache.getType().equals(opJson)) {
            opJson = String.format(opJson, uuid, uuidName);
        }
        return opJson;
    }
}

