/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.inform.service.impl;

import cn.hutool.core.util.StrUtil;
import com.newtouch.base.enums.BaseEnum;
import com.newtouch.inform.model.QsnQuestions;
import com.newtouch.inform.model.QsnTitleRelation;
import com.newtouch.inform.param.QsnQuestionsParam;
import com.newtouch.inform.param.QsnTitleRelationParam;
import com.newtouch.inform.param.QtrSaveParam;
import com.newtouch.inform.param.QtrSortParam;
import com.newtouch.inform.param.RemoveQtrParam;
import com.newtouch.inform.service.QsnTitleRelationService;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QsnTitleRelationServiceImpl
implements QsnTitleRelationService {
    @Autowired
    AbsModelRepository dao;

    @Override
    public ReturnMsg queryList(QsnTitleRelationParam qtrp) {
        Return msg = new Return();
        String paperUuid = qtrp.getPaperUuid();
        if (StrUtil.isBlank((CharSequence)paperUuid)) {
            msg.setFailMsg(new Message("0000000", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        stringBuilder.append("select qtr.serno,qtr.relation_uuid,qtr.child_uuid,qtr.qsn_uuid,qtr.paper_uuid,qtr.display_order, ");
        stringBuilder.append("qq.core_question_uuid,qq.representation_id,qq.qsn_title,qq.qsn_type,qq.up_question_id, ");
        stringBuilder.append("qq.question_seq,qq.is_show_number,qq.qsn_class,qq.qsn_option_title ");
        stringBuilder.append("from qsn_title_relation qtr left join qsn_questions qq on ");
        stringBuilder.append("qtr.qsn_uuid = qq.qsn_uuid ");
        stringBuilder.append("where qtr.paper_uuid = ? and qq.up_question_id = ?");
        list.add(paperUuid);
        list.add("0");
        if (!StrUtil.isBlank((CharSequence)qtrp.getQsnType())) {
            stringBuilder.append("and qq.qsn_type = ? ");
            list.add(qtrp.getQsnType());
        }
        if (!StrUtil.isBlank((CharSequence)qtrp.getRepresentationId())) {
            stringBuilder.append("and qq.representation_id = ? ");
            list.add(qtrp.getRepresentationId());
        }
        if (!StrUtil.isBlank((CharSequence)qtrp.getQsnTitle())) {
            stringBuilder.append("and qq.qsn_title like ? ");
            list.add("%" + qtrp.getQsnTitle() + "%");
        }
        stringBuilder.append("order by qq.qsn_class,qtr.display_order ");
        List returnList = new ArrayList();
        returnList = "Y".equals(qtrp.getIsAllFlag()) ? this.dao.findAll(stringBuilder.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(list)}) : this.dao.findAll(stringBuilder.toString(), Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(list)});
        ArrayList<Map> queryList = new ArrayList<Map>();
        if (CollectionUtils.isNotEmpty(returnList)) {
            for (Map map : returnList) {
                String childUuid;
                String qsnUuid = map.get("qsn_uuid").toString();
                String string = childUuid = map.get("child_uuid") == null ? "" : map.get("child_uuid").toString();
                if (!StrUtils.isNull((Object)childUuid)) {
                    QsnQuestions qq = new QsnQuestions();
                    qq.where().addEq(QsnQuestions.UP_QUESTION_ID, (Object)qsnUuid);
                    qq.where().addIn(QsnQuestions.QSN_UUID, Arrays.asList(childUuid.split(",")));
                    qq.setOrderBy(QsnQuestions.DISPLAY_ORDER.asc());
                    List childList = this.dao.findAll((AbsModel)qq);
                    map.put("childList", childList);
                }
                queryList.add(map);
            }
        }
        msg.getDataTable().put("queryList", queryList);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addQsnTitleRelation(QtrSaveParam qtrSaveParam) {
        Return msg = new Return();
        String paperUuid = qtrSaveParam.getPaperUuid();
        if (StrUtil.isBlank((CharSequence)paperUuid) || CollectionUtils.isEmpty(qtrSaveParam.getQsnList())) {
            msg.setFailMsg(new Message("0000000", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        QsnTitleRelation oldQtr = new QsnTitleRelation();
        oldQtr.where().addEq(QsnTitleRelation.PAPER_UUID, (Object)paperUuid);
        List oldQtrList = this.dao.findAll((AbsModel)oldQtr);
        if (CollectionUtils.isEmpty((Collection)oldQtrList)) {
            int order = 0;
            List<QsnTitleRelation> qsnList = qtrSaveParam.getQsnList();
            for (QsnTitleRelation qsnTitleRelation : qsnList) {
                qsnTitleRelation.setRelationUuid(UUID.uuid());
                qsnTitleRelation.setPaperUuid(paperUuid);
                qsnTitleRelation.setDisplayOrder(order);
                ++order;
            }
            this.dao.save(qsnList);
        } else {
            QsnTitleRelation qtrOrder = new QsnTitleRelation();
            qtrOrder.where().addEq(QsnTitleRelation.PAPER_UUID, (Object)paperUuid);
            qtrOrder.groupBy().max(QsnTitleRelation.DISPLAY_ORDER);
            QsnTitleRelation qtr = (QsnTitleRelation)this.dao.findOne((AbsModel)qtrOrder);
            String maxDisplayOrder = qtr.getOtherProperty("max_display_order") == null ? "" : qtr.getOtherProperty("max_display_order").toString();
            int order = StrUtil.isBlank((CharSequence)maxDisplayOrder) ? 0 : Integer.parseInt(maxDisplayOrder) + 1;
            List<QsnTitleRelation> qsnList = qtrSaveParam.getQsnList();
            for (QsnTitleRelation qsnTitleRelation : qsnList) {
                boolean orderAdd = true;
                for (QsnTitleRelation oQtr : oldQtrList) {
                    if (!qsnTitleRelation.getQsnUuid().equals(oQtr.getQsnUuid())) continue;
                    String relationUuid = oQtr.getRelationUuid();
                    qsnTitleRelation.setRelationUuid(relationUuid);
                    qsnTitleRelation.setPaperUuid(paperUuid);
                    qsnTitleRelation.setDisplayOrder(oQtr.getDisplayOrder());
                    orderAdd = false;
                    String childUuid = qsnTitleRelation.getChildUuid();
                    String oldChildUuid = oQtr.getChildUuid();
                    if (!StrUtils.isNull((Object)oldChildUuid)) {
                        qsnTitleRelation.setChildUuid(oldChildUuid + "," + childUuid);
                    }
                    qsnTitleRelation.where().addEq(QsnTitleRelation.RELATION_UUID, (Object)relationUuid);
                    this.dao.update((AbsModel)qsnTitleRelation);
                    break;
                }
                if (!orderAdd) continue;
                qsnTitleRelation.setRelationUuid(UUID.uuid());
                qsnTitleRelation.setPaperUuid(paperUuid);
                qsnTitleRelation.setDisplayOrder(order);
                ++order;
                this.dao.save((AbsModel)qsnTitleRelation);
            }
        }
        msg.setSuccessMsg(new Message("2010005", "\u4fdd\u5b58\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg removeQsnTitleRelation(RemoveQtrParam rqtr) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)rqtr.getRelationUuid())) {
            msg.setFailMsg(new Message("0000000", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        String operateFlag = rqtr.getOperateFlag();
        String relationUuid = rqtr.getRelationUuid();
        QsnTitleRelation qtr = new QsnTitleRelation();
        qtr.where().addEq(QsnTitleRelation.RELATION_UUID, (Object)relationUuid);
        if ("del".equals(operateFlag)) {
            this.dao.delete((AbsModel)qtr);
        }
        if ("update".equals(operateFlag)) {
            qtr.setChildUuid(StrUtils.isNull((Object)rqtr.getChildUuid()) ? "" : rqtr.getChildUuid());
            this.dao.update((AbsModel)qtr);
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg sortQsnTitleRelation(QtrSortParam qsp) {
        Return msg = new Return();
        if (!qsp.getQsnClass().equals(qsp.getNewQsnClass())) {
            msg.setFailMsg(new Message("4010002", "\u4e0d\u540c\u5206\u7ec4\u7c7b\u578b\uff0c\u4e0d\u80fd\u8c03\u6574\u987a\u5e8f\u3002"));
            return msg.msg();
        }
        QsnTitleRelation qsnTitleRelation = new QsnTitleRelation();
        qsnTitleRelation.setDisplayOrder(qsp.getNewDisplayOrder());
        qsnTitleRelation.where().addEq(QsnTitleRelation.RELATION_UUID, (Object)qsp.getRelationUuid());
        this.dao.update((AbsModel)qsnTitleRelation);
        qsnTitleRelation.setDisplayOrder(qsp.getDisplayOrder());
        qsnTitleRelation.where().addEq(QsnTitleRelation.RELATION_UUID, (Object)qsp.getNewRelationUuid());
        this.dao.update((AbsModel)qsnTitleRelation);
        msg.setSuccessMsg(new Message("2010006", "\u8c03\u6574\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryAllQsn(QsnQuestionsParam qsnQuestions) {
        Return msg = new Return();
        QsnQuestions queryQsnQuestions = new QsnQuestions();
        if (!StrUtils.isNull((Object)qsnQuestions.getRepresentationId())) {
            queryQsnQuestions.where().addEq(QsnQuestions.REPRESENTATION_ID, (Object)qsnQuestions.getRepresentationId());
        }
        if (!StrUtils.isNull((Object)qsnQuestions.getQsnType())) {
            queryQsnQuestions.where().addEq(QsnQuestions.QSN_TYPE, (Object)qsnQuestions.getQsnType());
        }
        if (!StrUtils.isNull((Object)qsnQuestions.getQsnTitle())) {
            queryQsnQuestions.where().addLike(QsnQuestions.QSN_TITLE, (Object)qsnQuestions.getQsnTitle());
        }
        if (!StrUtils.isNull((Object)qsnQuestions.getQsnClass())) {
            queryQsnQuestions.where().addEq(QsnQuestions.QSN_CLASS, (Object)qsnQuestions.getQsnClass());
        }
        if (!StrUtils.isNull((Object)qsnQuestions.getQsnBelong())) {
            queryQsnQuestions.where().addEq(QsnQuestions.QSN_BELONG, (Object)qsnQuestions.getQsnBelong());
        }
        queryQsnQuestions.where().addEq(QsnQuestions.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        queryQsnQuestions.where().addEq(QsnQuestions.UP_QUESTION_ID, (Object)"0");
        queryQsnQuestions.setOrderBy(QsnQuestions.QSN_CLASS.asc());
        queryQsnQuestions.setOrderBy(QsnQuestions.DISPLAY_ORDER.asc());
        List qsnQuestionsList = this.dao.findAll((AbsModel)queryQsnQuestions, Boolean.valueOf(true));
        if (CollectionUtils.isNotEmpty((Collection)qsnQuestionsList)) {
            for (QsnQuestions qq : qsnQuestionsList) {
                String qsnUuid = qq.getQsnUuid();
                QsnTitleRelation qtr = new QsnTitleRelation();
                if (!StrUtils.isNull((Object)qsnQuestions.getPaperUuid())) {
                    String paperUuid = qsnQuestions.getPaperUuid();
                    qtr.where().addEq(QsnTitleRelation.PAPER_UUID, (Object)paperUuid);
                    qtr.where().addEq(QsnTitleRelation.QSN_UUID, (Object)qsnUuid);
                    qtr = (QsnTitleRelation)this.dao.findOne((AbsModel)qtr);
                    if (!StrUtils.isNull((Object)((Object)qtr))) {
                        qq.setIsSelect("Y");
                    } else {
                        qq.setIsSelect("N");
                    }
                }
                QsnQuestions queryQq = new QsnQuestions();
                queryQq.where().addEq(QsnQuestions.UP_QUESTION_ID, (Object)qsnUuid);
                queryQq.setOrderBy(QsnQuestions.DISPLAY_ORDER.asc());
                List childList = this.dao.findAll((AbsModel)queryQq);
                if (CollectionUtils.isNotEmpty((Collection)childList) && !StrUtils.isNull((Object)((Object)qtr)) && !StrUtils.isNull((Object)qtr.getQsnUuid())) {
                    for (QsnQuestions cqq : childList) {
                        if (!StrUtils.isNull((Object)qtr.getChildUuid()) && qtr.getChildUuid().contains(cqq.getQsnUuid())) {
                            cqq.setIsSelect("Y");
                            continue;
                        }
                        cqq.setIsSelect("N");
                    }
                }
                qq.setChildList(childList);
            }
        }
        msg.setDataList(qsnQuestionsList, QsnQuestions.class);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public List<QsnTitleRelation> getQsnTitleRelationsOrderBy(String paperUuid) {
        String sql = " select\n\t * \nfrom\n\tqsn_title_relation b\njoin qsn_questions qq on\n\tb.qsn_uuid = qq.qsn_uuid\nwhere\n\tb.paper_uuid = ? \norder by qq.qsn_class asc ,b.display_order asc ";
        ArrayList<String> sqlParam2 = new ArrayList<String>();
        sqlParam2.add(paperUuid);
        return this.dao.findAll(sql, QsnTitleRelation.class, new AbsModelRepository.Args[]{this.dao.args(sqlParam2)});
    }
}

