/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.duty.service.impl;

import com.newtouch.base.config.ObsConfig;
import com.newtouch.base.config.TemplateConfig;
import com.newtouch.base.utils.FilesUtil;
import com.newtouch.base.utils.hwobs.HWYObsSDKUtis;
import com.newtouch.duty.service.IRiskDutyService;
import com.newtouch.duty.vo.ExportRiskDutyVo;
import com.newtouch.duty.vo.IRiskDutyReqVo;
import com.newtouch.nms.sip.model.SipProductSyncTask;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipRiskDutyRelation;
import com.uniapis.logger.Env;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class IRiskDutyServiceImpl
implements IRiskDutyService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    private TemplateConfig templateConfig;
    @Autowired
    private ObsConfig obsConfig;
    @Autowired
    private HWYObsSDKUtis hwyObsSDKUtis;
    private static final String ALLOW_SUFFIX = ".zip";

    @Override
    public ReturnMsg addRiskDuty(SipRiskDutyRelation sipRiskDutyRelation) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)sipRiskDutyRelation.getRiskCode())) {
            throw new BusinessException("\u5165\u53c2\u9669\u79cd\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StrUtils.isNull((Object)sipRiskDutyRelation.getProductNo())) {
            throw new BusinessException("\u5165\u53c2\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StrUtils.isNull((Object)sipRiskDutyRelation.getDutyCode())) {
            throw new BusinessException("\u5165\u53c2\u8d23\u4efb\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StrUtils.isNull((Object)sipRiskDutyRelation.getDutyItem())) {
            throw new BusinessException("\u5165\u53c2\u8d23\u4efb\u9879\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StrUtils.isNull((Object)sipRiskDutyRelation.getDutyItemText())) {
            throw new BusinessException("\u5165\u53c2\u8d23\u4efb\u9879\u6587\u672c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        SipRiskDutyRelation sipRiskDutyRelation1 = new SipRiskDutyRelation();
        sipRiskDutyRelation1.where().addEq(SipRiskDutyRelation.PRODUCT_NO, (Object)sipRiskDutyRelation.getProductNo());
        sipRiskDutyRelation1.where().addEq(SipRiskDutyRelation.RISK_CODE, (Object)sipRiskDutyRelation.getRiskCode());
        sipRiskDutyRelation1.where().addEq(SipRiskDutyRelation.DUTY_CODE, (Object)sipRiskDutyRelation.getDutyCode());
        sipRiskDutyRelation1.where().addEq(SipRiskDutyRelation.DATA_FLAG, (Object)"1");
        SipRiskDutyRelation sipRiskDutyRelationOne = (SipRiskDutyRelation)this.dao.findOne((AbsModel)sipRiskDutyRelation1);
        this.dao.save((AbsModel)sipRiskDutyRelation);
        msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRiskDuty(IRiskDutyReqVo iRiskDutyReqVo) {
        Return msg = new Return();
        SipRiskDutyRelation sipRiskDutyRelation1 = new SipRiskDutyRelation();
        sipRiskDutyRelation1.where().addEq(SipRiskDutyRelation.DATA_FLAG, (Object)"1");
        sipRiskDutyRelation1.setOrderBy(new Sort.Order[]{SipRiskDutyRelation.MDF_DATE.desc()});
        List sipRiskDutyRelationList = this.dao.findAll((AbsModel)sipRiskDutyRelation1, Boolean.valueOf(true));
        ArrayList<String> param = new ArrayList<String>();
        StringBuilder baseSql = new StringBuilder();
        baseSql.append("select * from  (select srdr.serno, srdr.risk_code, sr.risk_name, srdr.product_no, sp.product_name, srdr.duty_code, (select distinct se.enum_name from sys_enum se where se.enum_code = srdr.duty_code and se.enum_code = srdr.product_no ) enum_name, srdr.duty_item, srdr.duty_item_text, srdr.duty_content, srdr.duty_content_text, srdr.duty_sketch, srdr.duty_sketch_text, srdr.duty_details, srdr.duty_details_text, srdr.optional_duty_describe, srdr.optional_duty_describe_text, srdr.is_optional, srdr.optional_duty_url, srdr.is_safeguard_liability, srdr.is_push_underwrite, srdr.crt_date, srdr.mdf_date from sip_risk_duty_relation srdr  left join sip_risks sr on sr.risk_no = srdr.risk_code left join sip_products sp on sp.product_no = srdr.product_no where srdr.data_flag = ? ");
        param.add("1");
        if (!StrUtils.isNull((Object)iRiskDutyReqVo.getProductName())) {
            baseSql.append("and sp.product_name like ? ");
            param.add("%" + iRiskDutyReqVo.getProductName() + "%");
        }
        if (!StrUtils.isNull((Object)iRiskDutyReqVo.getRiskName())) {
            baseSql.append("and sr.risk_name like ? ");
            param.add("%" + iRiskDutyReqVo.getRiskName() + "%");
        }
        if (!StrUtils.isNull((Object)iRiskDutyReqVo.getProductNo())) {
            baseSql.append("and srdr.product_no = ? ");
            param.add(iRiskDutyReqVo.getProductNo());
        }
        if (!StrUtils.isNull((Object)iRiskDutyReqVo.getRiskCode())) {
            baseSql.append("and srdr.risk_code = ? ");
            param.add(iRiskDutyReqVo.getRiskCode());
        }
        if (!StrUtils.isNull((Object)iRiskDutyReqVo.getDutyCode())) {
            baseSql.append("and srdr.duty_code = ? ");
            param.add(iRiskDutyReqVo.getDutyCode());
        }
        if (!StrUtils.isNull((Object)iRiskDutyReqVo.getDutyName())) {
            baseSql.append("and enum_name like ? ");
            param.add("%" + iRiskDutyReqVo.getDutyName() + "%");
        }
        if (!StrUtils.isNull((Object)iRiskDutyReqVo.getDutyItem())) {
            baseSql.append("and srdr.duty_item like ? ");
            param.add("%" + iRiskDutyReqVo.getDutyItem() + "%");
        }
        baseSql.append(" )  order by mdf_date desc");
        List personRespVoList = this.dao.findAll(baseSql.toString(), Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(param)});
        msg.setDataList(personRespVoList);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg updateRiskDuty(SipRiskDutyRelation sipRiskDutyRelation) {
        Return msg = new Return();
        sipRiskDutyRelation.where().addEq(SipRiskDutyRelation.SERNO, (Object)sipRiskDutyRelation.getSerno());
        this.dao.update((AbsModel)sipRiskDutyRelation);
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteRiskDuty(String sernoStr) {
        String[] array = sernoStr.split(",");
        Return msg = new Return();
        for (String serno : array) {
            SipRiskDutyRelation sipRiskDutyRelation = new SipRiskDutyRelation();
            sipRiskDutyRelation.where().addEq(SipRiskDutyRelation.SERNO, (Object)serno);
            this.dao.delete((AbsModel)sipRiskDutyRelation);
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryProductList(Map<String, Object> param) {
        Return msg = new Return();
        SipProducts sipProducts = new SipProducts();
        sipProducts.where().addEq(SipProducts.DATA_FLAG, (Object)"1");
        sipProducts.where().addEq(SipProducts.STATE, (Object)"S");
        sipProducts.setOrderBy(new Sort.Order[]{SipProducts.MDF_DATE.desc()});
        List sipProductsList = this.dao.findAll((AbsModel)sipProducts, Boolean.valueOf(false));
        List mainRiskList = new ArrayList();
        Date date = new Date();
        ArrayList<String> list = new ArrayList<String>();
        String dataStr = DateUtils.date2String((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        StringBuilder sql = new StringBuilder("select  sp.product_uuid, sp.product_no,  sp.product_name,  product_label from sip_products sp where sp.data_flag = ? and sp.product_uuid in (select  c.product_uuid from  (  select  product_uuid,   delivery_platform  from   sip_products_channel spc where   spc.data_flag = ? ");
        list.add("1");
        list.add("1");
        sql.append(" and spc.start_date <= ?  and spc.end_date >= ?  group by  spc.product_uuid,  spc.delivery_platform) c  group by  c.product_uuid  )");
        list.add(dataStr);
        list.add(dataStr);
        sql.append(" order by sp.mdf_date desc");
        mainRiskList = this.dao.findAll(sql.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(list)});
        msg.setDataList(mainRiskList);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRiskList(String productNo) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)productNo)) {
            throw new BusinessException("\u5165\u53c2productNo\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        ArrayList<String> param = new ArrayList<String>();
        StringBuilder baseSql = new StringBuilder();
        baseSql.append("select sr.risk_no,sr.risk_name from sip_products sp left join sip_product_risks spr on sp.product_uuid = spr.product_uuid left join sip_risks sr on spr.risk_uuid = sr.risk_uuid where sp.product_no = ? and sr.data_flag = ? ");
        param.add(productNo);
        param.add("1");
        baseSql.append("union select sr1.risk_no, sr1.risk_name from sip_risks sr1 where sr1.risk_uuid in  (SELECT distinct srr.risk_uuid FROM sip_risk_relation srr WHERE srr.main_risk in (select sr.risk_uuid from sip_products sp left join sip_product_risks spr on sp.product_uuid = spr.product_uuid left join sip_risks sr on spr.risk_uuid = sr.risk_uuid where sp.product_no = ? and sr.data_flag = ?)) and sr1.data_flag = ? ");
        param.add(productNo);
        param.add("1");
        param.add("1");
        baseSql.append("union select sr2.risk_no,sr2.risk_name from sip_risks sr2 where sr2.risk_uuid in (SELECT distinct srr.risk_uuid FROM sip_risk_relation srr WHERE srr.main_risk in (select distinct sr1.risk_uuid from sip_risks sr1 where sr1.risk_uuid in (SELECT distinct srr.risk_uuid FROM sip_risk_relation srr WHERE srr.main_risk in (select sr.risk_uuid from sip_products sp left join sip_product_risks spr on sp.product_uuid = spr.product_uuid left join sip_risks sr on spr.risk_uuid = sr.risk_uuid where sp.product_no = ? and sr.data_flag = ?)) and sr1.is_main_risk = ? and sr1.data_flag = ?)) and sr2.data_flag = ?");
        param.add(productNo);
        param.add("1");
        param.add("A");
        param.add("1");
        param.add("1");
        List riskList = this.dao.findAll(baseSql.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(param)});
        msg.setDataList(riskList);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg uploadRiskDuty(MultipartFile zipFile) {
        SipProductSyncTask task = new SipProductSyncTask();
        task.setCrtDate(new Date());
        String pathName = this.templateConfig.getUploadFormCollectPath() + "/upload/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = this.unzipFile(zipFile, pathName);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
            return msg.msg();
        }
        File importDir = new File(pathName);
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<File> jsonList = new ArrayList<File>();
        this.getAllFiles(importDir, jsonList, fileList);
        StringJoiner joiner = new StringJoiner(",");
        Ulog.info((String)("\u83b7\u53d6\u9700\u8981\u8bfb\u53d6\u7684json\u6587\u4ef6---" + JsonUtils.toJson(jsonList)));
        Ulog.info((String)("\u83b7\u53d6\u9700\u8981\u8bfb\u53d6\u7684\u5176\u4ed6\u6587\u4ef6---" + JsonUtils.toJson(fileList)));
        for (File jsonFile : jsonList) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
                Throwable throwable = null;
                try {
                    int ch = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    String txtStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u7684\u9669\u79cd\u8d23\u4efb\u5173\u7cfb\u4e3a" + txtStr));
                    joiner.add(jsonFile.getName());
                    List sipRiskDutyRelation = JsonUtils.json2List((String)txtStr, SipRiskDutyRelation.class);
                    this.dao.delete(SipRiskDutyRelation.n().where().addIn(SipRiskDutyRelation.SERNO, sipRiskDutyRelation.stream().map(AbsModel::getSerno).collect(Collectors.toList())).model());
                    this.dao.save(sipRiskDutyRelation);
                }
                catch (Throwable ch) {
                    throwable = ch;
                    throw ch;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable ch) {
                            throwable.addSuppressed(ch);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Ulog.debug((Object)e);
                Ulog.info((String)("\u9669\u79cd\u8d23\u4efb\u5173\u7cfb\u6587\u4ef6\u5bfc\u5165\u5f02\u5e38--->" + e.getMessage()));
                msg.setFailMsg("\u9669\u79cd\u8d23\u4efb\u5173\u7cfb\u6587\u4ef6\u5bfc\u5165\u5f02\u5e38--->" + e.getMessage());
                return msg.msg();
            }
        }
        try {
            for (File file : fileList) {
                String path = file.getPath();
                String obsSplitPath = this.obsConfig.getObsSplitPath();
                String[] str = path.split(obsSplitPath);
                String filePath = str[str.length - 1];
                String nasPath = Env.env().baseDir() + filePath;
                FileInputStream inputStream = new FileInputStream(file);
                File nasFile = new File(nasPath);
                org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)nasFile);
                String string = this.obsConfig.getObsPath() + filePath;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.error((Throwable)e);
            e.printStackTrace();
            msg.setFailMsg("\u9669\u79cd\u8d23\u4efb\u5173\u7cfb\u6587\u4ef6\u5bfc\u5165\u5931\u8d25");
            return msg.msg();
        }
        FilesUtil.delFile(pathName);
        String taskName = joiner.toString();
        task.setFuncModule("SIPRISKDUTYRELATION");
        task.setTaskType("IMP");
        task.setTaskName("SipRiskDutyRelation");
        task.setTaskState("FINISH");
        task.setFinishDate(new Date());
        this.dao.save((AbsModel)task);
        msg.setSuccessMsg("\u9669\u79cd\u8d23\u4efb\u5173\u7cfb\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
        return msg.msg();
    }

    private Return unzipFile(MultipartFile file, String path) {
        String fileName = file.getOriginalFilename();
        long fileSize = file.getSize();
        Return msg = this.checkFile(fileName, fileSize);
        try {
            File destFile = new File(path);
            if (!destFile.exists()) {
                destFile.mkdirs();
            }
            FileUtils.unzip((InputStream)file.getInputStream(), (String)path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return msg;
    }

    private Return checkFile(String fileName, long fileSize) {
        String suffix;
        Return msg = new Return();
        if (fileName.indexOf(".") < 0) {
            msg.setFailMsg(new Message("6030004", "\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6"));
        }
        if (ALLOW_SUFFIX.indexOf(suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) == -1) {
            msg.setFailMsg(new Message("6030004", "\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6"));
        }
        if (fileSize <= 0L) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u5fc5\u987b\u5927\u4e8e0KB"));
        }
        return msg;
    }

    public void getAllFiles(File dir, List<File> jsonList, List<File> fileList) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getAllFiles(files[i], jsonList, fileList);
                continue;
            }
            String name = files[i].getName();
            if (name.endsWith(".json")) {
                File file1 = files[i];
                jsonList.add(file1);
            }
            if ((name.endsWith(".jpg") || name.endsWith(".png") || name.endsWith(".jpeg") || name.endsWith(".gif")) && !name.startsWith("~")) {
                File file2 = files[i];
                fileList.add(file2);
            }
            Ulog.info((Object)files[i]);
        }
    }

    @Override
    public ReturnMsg exportRiskDutyJson(String sernosList, HttpServletResponse response) {
        Return msg = new Return();
        SipProductSyncTask task = new SipProductSyncTask();
        task.setFuncModule("FLOW");
        task.setIsZipDel("1");
        task.setTaskType("EXP");
        task.setCrtDate(new Date());
        StringJoiner joiner = new StringJoiner(",");
        String zipFile = "";
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String baseAddress = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
        String[] sernosList1 = sernosList.split(",");
        ArrayList riskDutyList = new ArrayList();
        ArrayList exportDataVos = new ArrayList();
        ExportRiskDutyVo exportRiskDutyVo = new ExportRiskDutyVo();
        HashSet<String> set = new HashSet<String>(Arrays.asList(sernosList1));
        String[] sernoList = set.toArray(set.toArray(new String[0]));
        if (!sernosList.isEmpty()) {
            for (String serno : sernoList) {
                SipRiskDutyRelation sipRiskDutyRelationip = new SipRiskDutyRelation();
                sipRiskDutyRelationip.where().addEq(SipRiskDutyRelation.SERNO, (Object)serno);
                List riskDuty = this.dao.findAll((AbsModel)sipRiskDutyRelationip);
                if (riskDuty == null) continue;
                riskDutyList.addAll(riskDuty);
            }
        } else {
            SipRiskDutyRelation sipRiskDutyRelation = new SipRiskDutyRelation();
            sipRiskDutyRelation.where().addEq(SipRiskDutyRelation.DATA_FLAG, (Object)"1");
            List riskDuty = this.dao.findAll((AbsModel)sipRiskDutyRelation);
            riskDutyList.addAll(riskDuty);
        }
        exportRiskDutyVo.setJson(JsonUtils.toJson(riskDutyList));
        exportRiskDutyVo.setName("SipRiskDutyRelation");
        try {
            FilesUtil.createFile(baseAddress + "/" + exportRiskDutyVo.getName() + "/" + exportRiskDutyVo.getName() + ".json");
            FilesUtil.writeToFile(baseAddress + "/" + exportRiskDutyVo.getName() + "/" + exportRiskDutyVo.getName() + ".json", exportRiskDutyVo.getJson(), false);
            for (SipRiskDutyRelation sipRiskDutyRelation : riskDutyList) {
                String optionalDutyUrl = sipRiskDutyRelation.getOptionalDutyUrl();
                try {
                    InputStream inStream = this.hwyObsSDKUtis.getObject(optionalDutyUrl);
                    String filePath = baseAddress + "/" + exportRiskDutyVo.getName() + "/" + "fileList" + "/" + optionalDutyUrl;
                    File file = new File(filePath);
                    if (!file.getParentFile().exists() || !file.isDirectory()) {
                        file.getParentFile().mkdirs();
                    }
                    BufferedInputStream in = null;
                    BufferedOutputStream out = null;
                    in = new BufferedInputStream(inStream);
                    out = new BufferedOutputStream(new FileOutputStream(filePath));
                    int len = -1;
                    byte[] b = new byte[1024];
                    while ((len = in.read(b)) != -1) {
                        out.write(b, 0, len);
                    }
                    in.close();
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            zipFile = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + ALLOW_SUFFIX;
            Ulog.info((String)("baseAddress----" + baseAddress));
            Ulog.info((String)("zipFile----" + zipFile));
            String zip = FileUtils.zip((String)baseAddress, (String)zipFile, (String[])new String[]{".txt", ".json", ".xlsx", ".png", ".jpg", "jpeg", "gif", "mp4", "pdf"});
            Ulog.info((String)("zip----" + zip));
            File file = new File(zipFile);
            FileInputStream inputStream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            inputStream.read(data);
            inputStream.close();
            response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.addHeader("Content-Length", "" + file.length());
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + ALLOW_SUFFIX, "UTF-8"));
            ServletOutputStream stream = response.getOutputStream();
            stream.write(data);
            stream.flush();
            stream.close();
            FilesUtil.delFile(baseAddress);
            String taskName = joiner.toString();
            task.setTaskName(taskName);
            task.setTaskState("FINISH");
            task.setFinishDate(new Date());
            task.setZipPath(zipFile);
            this.dao.save((AbsModel)task);
        }
        catch (Exception e) {
            e.printStackTrace();
            String taskName = joiner.toString();
            task.setTaskName(taskName);
            task.setTaskState("FAIL");
            task.setErrorInfo(e.getMessage());
            task.setFinishDate(new Date());
            this.dao.save((AbsModel)task);
        }
        return null;
    }
}

