/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.enums.RelateEnum;
import com.newtouch.base.model.DsnRules;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.newtouch.base.vo.export.ExportRuleInfo;
import com.newtouch.flow.model.FmNode;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class FmNodeInfo
implements Comparable {
    @JsonProperty(value="fmNode")
    private FmNode fmNode;
    @JsonProperty(value="ruleInfos")
    private List<ExportRuleInfo> ruleInfos;

    public FmNodeInfo load(String nodeNo) {
        ExportQueryUtils query = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        this.ruleInfos = new ArrayList<ExportRuleInfo>();
        List<DsnRules> dsnRulesList = query.queryDsnRulesList(nodeNo, RelateEnum.node.getRelateField(), RelateEnum.node.getRelateTab());
        if (CollectionUtils.isNotEmpty(dsnRulesList)) {
            for (DsnRules dr : dsnRulesList) {
                ExportRuleInfo eri = new ExportRuleInfo();
                eri.load(dr);
                this.ruleInfos.add(eri);
            }
        }
        return this;
    }

    public void merge(FmNodeInfo fmNodeInfo) {
        this.fmNode = EqualsUtils.merge(this.fmNode, fmNodeInfo.getFmNode());
        this.ruleInfos = EqualsUtils.merge(this.ruleInfos, fmNodeInfo.getRuleInfos(), ExportRuleInfo.class);
    }

    public void save() {
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        if (this.fmNode != null) {
            update.update(this.fmNode);
        }
        if (this.ruleInfos != null) {
            this.ruleInfos.forEach(m -> m.save("Y"));
        }
    }

    public int compareTo(@NotNull Object o) {
        UpdateUtils.UpdateFlag flag = (UpdateUtils.UpdateFlag)((Object)this.fmNode.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
        if (flag == UpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == UpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == UpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }

    public FmNode getFmNode() {
        return this.fmNode;
    }

    public List<ExportRuleInfo> getRuleInfos() {
        return this.ruleInfos;
    }

    @JsonProperty(value="fmNode")
    public void setFmNode(FmNode fmNode) {
        this.fmNode = fmNode;
    }

    @JsonProperty(value="ruleInfos")
    public void setRuleInfos(List<ExportRuleInfo> ruleInfos) {
        this.ruleInfos = ruleInfos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FmNodeInfo)) {
            return false;
        }
        FmNodeInfo other = (FmNodeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FmNode this$fmNode = this.getFmNode();
        FmNode other$fmNode = other.getFmNode();
        if (this$fmNode == null ? other$fmNode != null : !((Object)((Object)this$fmNode)).equals((Object)other$fmNode)) {
            return false;
        }
        List<ExportRuleInfo> this$ruleInfos = this.getRuleInfos();
        List<ExportRuleInfo> other$ruleInfos = other.getRuleInfos();
        return !(this$ruleInfos == null ? other$ruleInfos != null : !((Object)this$ruleInfos).equals(other$ruleInfos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FmNodeInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FmNode $fmNode = this.getFmNode();
        result = result * 59 + ($fmNode == null ? 43 : ((Object)((Object)$fmNode)).hashCode());
        List<ExportRuleInfo> $ruleInfos = this.getRuleInfos();
        result = result * 59 + ($ruleInfos == null ? 43 : ((Object)$ruleInfos).hashCode());
        return result;
    }

    public String toString() {
        return "FmNodeInfo(fmNode=" + (Object)((Object)this.getFmNode()) + ", ruleInfos=" + this.getRuleInfos() + ")";
    }
}

