/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.utils.obs;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.newtouch.base.config.SyAccountConfig;
import com.newtouch.base.utils.obs.HCPClients;
import com.uniapis.logger.Ulog;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ObjectStorageDownLoadUtil {
    @Autowired
    private SyAccountConfig syAccountConfig;
    @Autowired
    private HCPClients HCPClients;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getObjectByte(String key) {
        byte[] data = null;
        InputStream in = this.getObject(key);
        if (null != in) {
            try {
                data = IOUtils.toByteArray((InputStream)in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        return data;
    }

    public InputStream getObject(String key) {
        S3Object s3Object = null;
        AmazonS3 hs3Client = this.HCPClients.getS3Client("SY");
        try {
            s3Object = hs3Client.getObject(this.syAccountConfig.getNamespace(), key);
        }
        catch (AmazonServiceException e) {
            if ("The specified key does not exist.".equals(e.getErrorMessage())) {
                Ulog.info((String)("\u6749\u5ca9" + this.syAccountConfig.getNamespace() + "\u6876,\u672a\u67e5\u627e\u5230[" + key + "]\u5bf9\u5e94\u6587\u4ef6"));
                return null;
            }
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (SdkClientException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        S3ObjectInputStream in = s3Object.getObjectContent();
        return in;
    }

    public InputStream getObjectRL(String key) {
        S3Object s3Object = null;
        AmazonS3 hs3Client = this.HCPClients.getS3Client("RL");
        try {
            s3Object = hs3Client.getObject(this.syAccountConfig.getRlNamespace(), key);
        }
        catch (AmazonServiceException e) {
            if ("The specified key does not exist.".equals(e.getErrorMessage())) {
                Ulog.info((String)("\u65e5\u7acb" + this.syAccountConfig.getRlNamespace() + "\u6876,\u672a\u67e5\u627e\u5230[" + key + "]\u5bf9\u5e94\u6587\u4ef6"));
                return null;
            }
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (SdkClientException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        S3ObjectInputStream in = s3Object.getObjectContent();
        return in;
    }
}

