/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.utils;

import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;

public class JasyptUtil {
    private static final String PBEWITHMD5ANDDES = "PBEWithMD5AndDES";
    private static final String PBEWITHHMACSHA512ANDAES_256 = "PBEWITHHMACSHA512ANDAES_256";

    public static String encryptWithMD5(String text, String crack) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        EnvironmentStringPBEConfig config = new EnvironmentStringPBEConfig();
        config.setAlgorithm(PBEWITHMD5ANDDES);
        config.setPassword(crack);
        encryptor.setConfig((PBEConfig)config);
        return encryptor.encrypt(text);
    }

    public static String decryptWithMD5(String text, String crack) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        EnvironmentStringPBEConfig config = new EnvironmentStringPBEConfig();
        config.setAlgorithm(PBEWITHMD5ANDDES);
        config.setPassword(crack);
        encryptor.setConfig((PBEConfig)config);
        return encryptor.decrypt(text);
    }

    public static String encryptWithSHA512(String text, String crack) {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(crack);
        config.setAlgorithm(PBEWITHHMACSHA512ANDAES_256);
        config.setKeyObtentionIterations("1000");
        config.setPoolSize("1");
        config.setProviderName("SunJCE");
        config.setSaltGeneratorClassName("org.jasypt.salt.RandomSaltGenerator");
        config.setStringOutputType("base64");
        encryptor.setConfig((PBEConfig)config);
        return encryptor.encrypt(text);
    }

    public static String decryptWithSHA512(String text, String crack) {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(crack);
        config.setAlgorithm(PBEWITHHMACSHA512ANDAES_256);
        config.setKeyObtentionIterations("1000");
        config.setPoolSize("1");
        config.setProviderName("SunJCE");
        config.setSaltGeneratorClassName("org.jasypt.salt.RandomSaltGenerator");
        config.setStringOutputType("base64");
        encryptor.setConfig((PBEConfig)config);
        return encryptor.decrypt(text);
    }

    public static void main(String[] args) throws Exception {
        String text = "yinliu@123";
        String crack = "Test";
        String encrypt = JasyptUtil.encryptWithMD5(text, crack);
        System.out.println("+ \u539f\u5bc6\u7801\u4e3a\uff1a" + text);
        System.out.println("+ \u52a0\u5bc6\u540e\u7684\u5bc6\u7801\u4e3a\uff1a" + encrypt);
        System.out.println("++++++++++++++++++++++++++++++");
        String text1 = encrypt;
        String decryptWithMD5 = JasyptUtil.decryptWithMD5(text1, crack);
        System.out.println("+ \u89e3\u5bc6\u540e\u7684\u5bc6\u7801\u4e3a\uff1a" + decryptWithMD5);
    }
}

