/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.transformer.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ReadContext;
import com.newtouch.base.config.TemplateConfig;
import com.newtouch.base.model.JkDataInfo;
import com.newtouch.base.model.JkMappingRule;
import com.newtouch.base.transformer.service.TransformerService;
import com.newtouch.base.transformer.util.TreeBuilder;
import com.newtouch.base.utils.FilesUtil;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransformerServiceImpl
implements TransformerService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private TemplateConfig templateConfig;

    @Override
    public String transToTarget() throws IOException {
        String path = "D:\\ideawork\\gitlab\\nms\\nms-page-conf\\src\\main\\java\\com\\newtouch\\base\\transformer\\jsonFile\\areaSimple.json";
        String inputJson = FileUtils.readFileToString((File)new File(path), (String)"utf-8");
        DocumentContext context = JsonPath.parse((String)inputJson);
        JkDataInfo data = JkDataInfo.n();
        data.setJkUuid("123");
        data.where().addEq(JkDataInfo.JK_UUID, (Object)data.getJkUuid());
        List nodes = this.dao.findAll((AbsModel)data);
        for (JkDataInfo node : nodes) {
            JkMappingRule mappingRule = JkMappingRule.n();
            mappingRule.setTargetDataUuid(node.getDataUuid());
            mappingRule.where().addEq(JkMappingRule.TARGET_DATA_UUID, (Object)node.getDataUuid());
            JkMappingRule rule = (JkMappingRule)this.dao.findOne((AbsModel)mappingRule);
            node.setJkMappingRule(rule);
        }
        String json = new TreeBuilder().buildTreeWithValue(nodes, (ReadContext)context);
        return json;
    }

    @Override
    public ReturnMsg importTreeStruct(Map<String, Object> requestMap) {
        if (StrUtils.isNull((Object)requestMap.get("jk_uuid"))) {
            throw new BusinessException("[\u63a5\u53e3uuid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)requestMap.get("data_type"))) {
            throw new BusinessException("[\u6570\u636e\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)requestMap.get("json_body"))) {
            throw new BusinessException("[\u62a5\u6587\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)requestMap.get("data_class"))) {
            throw new BusinessException("[\u6570\u636e\u5206\u7c7b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Return aReturn = new Return();
        String json = StrUtils.trimStr((Object)requestMap.get("json_body"));
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        ArrayList<JkDataInfo> list = new ArrayList<JkDataInfo>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("up_node", "");
        map.put("display_order", "1");
        map.put("node_seq", "");
        JkDataInfo n = JkDataInfo.n();
        n.setJkUuid(StrUtils.trimStr((Object)requestMap.get("jk_uuid")));
        n.setDataType(StrUtils.trimStr((Object)requestMap.get("data_type")));
        n.setDataClass(StrUtils.trimStr((Object)requestMap.get("data_class")));
        this.analysisJson(jsonObject, list, n, map);
        n.where().addEq(JkDataInfo.JK_UUID, (Object)n.getJkUuid()).addEq(JkDataInfo.DATA_TYPE, (Object)n.getDataType()).addEq(JkDataInfo.DATA_CLASS, (Object)n.getDataClass());
        List all = this.dao.findAll((AbsModel)n);
        ArrayList dataUuidList = new ArrayList();
        all.forEach(p -> dataUuidList.add(p.getDataUuid()));
        if (dataUuidList.size() > 0) {
            JkMappingRule rule = JkMappingRule.n();
            rule.where().addIn(JkMappingRule.TARGET_DATA_UUID, dataUuidList.toArray(new String[0]));
            this.dao.delete((AbsModel)rule);
        }
        n.where().addEq(JkDataInfo.JK_UUID, (Object)n.getJkUuid()).addEq(JkDataInfo.DATA_TYPE, (Object)n.getDataType());
        this.dao.delete((AbsModel)n);
        this.dao.save(list);
        return aReturn.msg();
    }

    @Override
    public void exportTreeStruct(Map<String, Object> requestMap, HttpServletResponse response) {
        if (StrUtils.isNull((Object)requestMap.get("jk_uuid"))) {
            throw new BusinessException("[\u63a5\u53e3uuid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)requestMap.get("data_type"))) {
            throw new BusinessException("[\u6570\u636e\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)requestMap.get("data_class"))) {
            throw new BusinessException("[\u6570\u636e\u5206\u7c7b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JkDataInfo n = JkDataInfo.n();
        n.where().addEq(JkDataInfo.JK_UUID, (Object)StrUtils.trimStr((Object)requestMap.get("jk_uuid"))).addEq(JkDataInfo.DATA_TYPE, (Object)StrUtils.trimStr((Object)requestMap.get("data_type"))).addEq(JkDataInfo.DATA_CLASS, (Object)StrUtils.trimStr((Object)requestMap.get("data_class")));
        List nodes = this.dao.findAll((AbsModel)n);
        if (CollectionUtil.isEmpty((Collection)nodes)) {
            throw new BusinessException(new Message("9999999", "\u5bfc\u51fa\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        String json = new TreeBuilder().buildTree(nodes);
        Ulog.info((String)json);
        try {
            String currentTimeMillis = String.valueOf(System.currentTimeMillis());
            String baseAddress = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
            String fileName = baseAddress + "/" + StrUtils.trimStr((Object)requestMap.get("jk_uuid")).concat("_").concat(StrUtils.trimStr((Object)requestMap.get("data_type"))) + ".json";
            FilesUtil.writeToFile(fileName, json, false);
            File file = new File(fileName);
            FileInputStream inputStream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            inputStream.read(data);
            inputStream.close();
            response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.addHeader("Content-Length", "" + file.length());
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + ".json", "UTF-8"));
            ServletOutputStream stream = response.getOutputStream();
            stream.write(data);
            stream.flush();
            stream.close();
            FilesUtil.delFile(baseAddress);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException(e.getMessage());
        }
    }

    @Override
    public ReturnMsg getTreeStruct(JkDataInfo data) {
        if (StrUtils.isNull((Object)data.getJkUuid())) {
            throw new BusinessException("[\u63a5\u53e3uuid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)data.getDataType())) {
            throw new BusinessException("[\u6570\u636e\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)data.getDataClass())) {
            throw new BusinessException("[\u6570\u636e\u5206\u7c7b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Return aReturn = new Return();
        StringBuilder builder = new StringBuilder("select * from jk_data_info\nleft join jk_mapping_rule\n");
        if ("SOURCE".equals(StrUtils.trimStr((Object)data.getDataType()))) {
            builder.append("on jk_data_info.data_uuid = jk_mapping_rule.source_data_uuid ");
        } else {
            builder.append("on jk_data_info.data_uuid = jk_mapping_rule.target_data_uuid ");
        }
        builder.append("where jk_data_info.jk_uuid = ? and data_type = ? and data_class = ?");
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(data.getJkUuid());
        list.args().add(data.getDataType());
        list.args().add(data.getDataClass());
        if (!StrUtils.isNull((Object)data.getUpNode())) {
            builder.append(" and up_node = ? ");
            list.args().add(data.getUpNode());
        } else {
            builder.append(" and up_node is null ");
        }
        List all = this.dao.findAll(builder.toString(), new AbsModelRepository.Args[]{list});
        all.forEach(p -> {
            List childNodes = this.dao.findAll(JkDataInfo.n().where().addEq(JkDataInfo.UP_NODE, p.get("data_uuid")).model());
            if (CollectionUtils.isEmpty((Collection)childNodes)) {
                p.put("is_leaf_children", "1");
            } else {
                p.put("is_leaf_children", "0");
            }
            if (!StrUtils.isNull(p.get("mapping_uuid"))) {
                if ("SOURCE".equals(StrUtils.trimStr((Object)data.getDataType()))) {
                    p.put("source_node_no", p.get("node_no"));
                    JkDataInfo dataInfo = (JkDataInfo)this.dao.findOne(JkDataInfo.n().where().addEq(JkDataInfo.DATA_UUID, p.get("target_data_uuid")).model());
                    p.put("target_node_no", dataInfo.getNodeNo());
                } else {
                    p.put("target_node_no", p.get("node_no"));
                    JkDataInfo dataInfo = (JkDataInfo)this.dao.findOne(JkDataInfo.n().where().addEq(JkDataInfo.DATA_UUID, p.get("source_data_uuid")).model());
                    p.put("source_node_no", dataInfo.getNodeNo());
                }
            }
        });
        aReturn.setDataList(all);
        return aReturn.msg();
    }

    @Override
    public ReturnMsg linkNodes(Map<String, Object> requestMap) {
        if (StrUtils.isNull((Object)requestMap.get("source_data_uuid"))) {
            throw new BusinessException("[\u6e90\u8282\u70b9uuid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)requestMap.get("source_node_seq"))) {
            throw new BusinessException("[\u6e90\u8282\u70b9\u8282\u70b9\u5e8f\u5217]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)requestMap.get("target_data_uuid"))) {
            throw new BusinessException("[\u76ee\u6807\u8282\u70b9uuid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)requestMap.get("jk_uuid"))) {
            throw new BusinessException("[\u63a5\u53e3uuid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Return aReturn = new Return();
        JkMappingRule rule = JkMappingRule.n();
        rule.setMappingUuid(UUID.uuid()).setSourceDataUuid(StrUtils.trimStr((Object)requestMap.get("source_data_uuid"))).setTargetDataUuid(StrUtils.trimStr((Object)requestMap.get("target_data_uuid"))).setMappingRule(StrUtils.trimStr((Object)requestMap.get("source_node_seq"))).setJkUuid(StrUtils.trimStr((Object)requestMap.get("jk_uuid")));
        this.dao.save((AbsModel)rule);
        return aReturn.msg();
    }

    @Override
    public ReturnMsg cancelLink(JkDataInfo dataInfo) {
        if (StrUtils.isNull((Object)dataInfo.getDataUuid())) {
            throw new BusinessException("[\u8282\u70b9uuid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)dataInfo.getDataType())) {
            throw new BusinessException("[\u6570\u636e\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Return aReturn = new Return();
        JkMappingRule rule = JkMappingRule.n();
        if ("SOURCE".equals(dataInfo.getDataType())) {
            rule.where().addEq(JkMappingRule.SOURCE_DATA_UUID, (Object)dataInfo.getDataUuid());
        } else {
            rule.where().addEq(JkMappingRule.TARGET_DATA_UUID, (Object)dataInfo.getDataUuid());
        }
        this.dao.delete((AbsModel)rule);
        return aReturn.msg();
    }

    @Override
    public ReturnMsg checkDeleteTransformerData(String jkUuid, String dataType, String dataClass) {
        JkDataInfo dataInfo = new JkDataInfo();
        dataInfo.where().addEq(JkDataInfo.JK_UUID, (Object)jkUuid);
        dataInfo.where().addEq(JkDataInfo.DATA_TYPE, (Object)dataType);
        dataInfo.where().addEq(JkDataInfo.DATA_CLASS, (Object)dataClass);
        JkDataInfo jkDataInfoResult = (JkDataInfo)this.dao.findOne((AbsModel)dataInfo);
        JkMappingRule mappingRule = new JkMappingRule();
        if ("source".equals(dataClass)) {
            mappingRule.where().addEq(JkMappingRule.SOURCE_DATA_UUID, (Object)jkDataInfoResult.getDataUuid());
        } else if ("target".equals(dataClass)) {
            mappingRule.where().addEq(JkMappingRule.TARGET_DATA_UUID, (Object)jkDataInfoResult.getDataUuid());
        } else {
            throw new BusinessException("\u5165\u53c2dataClass\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        JkMappingRule result = (JkMappingRule)this.dao.findOne((AbsModel)mappingRule);
        if (result != null && StrUtils.isNull((Object)result.getSerno())) {
            throw new BusinessException("\u5b58\u5728\u5df2\u5173\u8054\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u5220\u9664");
        }
        Return aReturn = new Return();
        return aReturn.msg();
    }

    @Override
    public ReturnMsg deleteTransformerData(String jkUuid, String dataType, String dataClass) {
        JkDataInfo jkDataInfo = new JkDataInfo();
        jkDataInfo.where().addEq(JkDataInfo.JK_UUID, (Object)jkUuid);
        jkDataInfo.where().addEq(JkDataInfo.DATA_TYPE, (Object)dataType);
        jkDataInfo.where().addEq(JkDataInfo.DATA_CLASS, (Object)dataClass);
        List jkDataInfoList = this.dao.findAll((AbsModel)jkDataInfo);
        for (JkDataInfo jkDataInfoResult : jkDataInfoList) {
            JkMappingRule jkMappingRule = new JkMappingRule();
            if ("source".equals(dataClass)) {
                jkMappingRule.where().addEq(JkMappingRule.SOURCE_DATA_UUID, (Object)jkDataInfoResult.getDataUuid());
            } else if ("target".equals(dataClass)) {
                jkMappingRule.where().addEq(JkMappingRule.TARGET_DATA_UUID, (Object)jkDataInfoResult.getDataUuid());
            } else {
                throw new BusinessException("\u5165\u53c2dataClass\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            this.dao.delete((AbsModel)jkMappingRule);
        }
        JkDataInfo jkDataInfo2 = new JkDataInfo();
        jkDataInfo2.where().addEq(JkDataInfo.JK_UUID, (Object)jkUuid);
        jkDataInfo2.where().addEq(JkDataInfo.DATA_TYPE, (Object)dataType);
        jkDataInfo2.where().addEq(JkDataInfo.DATA_CLASS, (Object)dataClass);
        this.dao.delete((AbsModel)jkDataInfo2);
        Return aReturn = new Return();
        return aReturn.msg();
    }

    public void analysisJson(Object objJson, List<JkDataInfo> resList, JkDataInfo dataInfo, Map<String, String> map) {
        if (objJson instanceof JSONArray) {
            JkDataInfo jkDataInfo = new JkDataInfo();
            jkDataInfo.setJkUuid(dataInfo.getJkUuid());
            jkDataInfo.setDataType(dataInfo.getDataType());
            jkDataInfo.setDataClass(dataInfo.getDataClass());
            jkDataInfo.setDataUuid(UUID.shortUUID());
            jkDataInfo.setNodeNo(map.get("node_no"));
            jkDataInfo.setNodeType("List");
            jkDataInfo.setNodeSeq(StrUtils.isNull((Object)map.get("node_seq")) ? "$" : map.get("node_seq"));
            jkDataInfo.setDisplayOrder(map.get("display_order"));
            jkDataInfo.setUpNode(map.get("up_node"));
            resList.add(jkDataInfo);
            map.put("up_node", jkDataInfo.getDataUuid());
            map.put("node_seq", jkDataInfo.getNodeSeq().concat("[#i#]"));
            JSONArray objArray = (JSONArray)objJson;
            if (objArray.size() > 0) {
                map.put("display_order", "1");
                map.put("up_node_type", "List");
                this.analysisJson(objArray.get(0), resList, dataInfo, map);
            }
        } else if (objJson instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)objJson;
            JkDataInfo jkDataInfo = new JkDataInfo();
            if ("List".equals(map.get("up_node_type")) || StrUtils.isNull((Object)map.get("up_node_type"))) {
                jkDataInfo.setJkUuid(dataInfo.getJkUuid());
                jkDataInfo.setDataType(dataInfo.getDataType());
                jkDataInfo.setDataClass(dataInfo.getDataClass());
                jkDataInfo.setDataUuid(UUID.shortUUID());
                jkDataInfo.setNodeNo("");
                jkDataInfo.setNodeType("Map");
                jkDataInfo.setNodeSeq(StrUtils.isNull((Object)map.get("node_seq")) ? "$" : map.get("node_seq"));
                jkDataInfo.setDisplayOrder(map.get("display_order"));
                jkDataInfo.setUpNode(map.get("up_node"));
                resList.add(jkDataInfo);
            } else {
                jkDataInfo.setDataUuid(map.get("up_node"));
                jkDataInfo.setNodeSeq(StrUtils.isNull((Object)map.get("node_seq")) ? "$" : map.get("node_seq"));
            }
            int i = 1;
            for (String key : jsonObject.keySet()) {
                JkDataInfo targetData;
                Object object = jsonObject.get((Object)key);
                map.put("node_no", key);
                map.put("node_seq", jkDataInfo.getNodeSeq().concat(".").concat(key));
                map.put("up_node", jkDataInfo.getDataUuid());
                if (object instanceof JSONArray) {
                    JSONArray objArray = (JSONArray)object;
                    map.put("display_order", String.valueOf(i));
                    this.analysisJson(objArray, resList, dataInfo, map);
                } else if (object instanceof JSONObject) {
                    targetData = new JkDataInfo();
                    targetData.setJkUuid(dataInfo.getJkUuid());
                    targetData.setDataType(dataInfo.getDataType());
                    targetData.setDataClass(dataInfo.getDataClass());
                    targetData.setDataUuid(UUID.shortUUID());
                    targetData.setNodeNo(key);
                    targetData.setNodeSeq(map.get("node_seq"));
                    targetData.setDisplayOrder(String.valueOf(i));
                    targetData.setUpNode(jkDataInfo.getDataUuid());
                    targetData.setNodeType("Map");
                    resList.add(targetData);
                    map.put("up_node", targetData.getDataUuid());
                    map.put("display_order", String.valueOf(i));
                    map.put("up_node_type", "Map");
                    this.analysisJson((JSONObject)object, resList, dataInfo, map);
                } else {
                    targetData = new JkDataInfo();
                    targetData.setJkUuid(dataInfo.getJkUuid());
                    targetData.setDataType(dataInfo.getDataType());
                    targetData.setDataClass(dataInfo.getDataClass());
                    targetData.setDataUuid(UUID.shortUUID());
                    targetData.setNodeNo(key);
                    targetData.setNodeSeq(map.get("node_seq"));
                    targetData.setDisplayOrder(String.valueOf(i));
                    targetData.setUpNode(jkDataInfo.getDataUuid());
                    if (object instanceof Integer) {
                        targetData.setNodeType("Integer");
                    } else {
                        targetData.setNodeType("String");
                    }
                    resList.add(targetData);
                    map.put("up_node", targetData.getDataUuid());
                    map.put("display_order", String.valueOf(i));
                }
                ++i;
            }
        }
    }

    @Override
    public ReturnMsg eitNode(JkDataInfo jkDataInfo) {
        if (StrUtils.isNull((Object)jkDataInfo.getDataUuid())) {
            return this.addNode(jkDataInfo);
        }
        return this.updateNode(jkDataInfo);
    }

    @Override
    public ReturnMsg addNode(JkDataInfo jkDataInfo) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)jkDataInfo.getJkUuid())) {
            throw new BusinessException("\u63a5\u53e3Uuid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtils.isNull((Object)jkDataInfo.getNodeNo())) {
            throw new BusinessException("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtils.isNull((Object)jkDataInfo.getNodeName())) {
            throw new BusinessException("\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtils.isNull((Object)jkDataInfo.getNodeSeq())) {
            throw new BusinessException("\u8282\u70b9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtils.isNull((Object)jkDataInfo.getNodeType())) {
            throw new BusinessException("\u8282\u70b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtils.isNull((Object)jkDataInfo.getDataType())) {
            throw new BusinessException("\u8282\u70b9\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JkDataInfo jkDataInfo1 = new JkDataInfo();
        jkDataInfo1.where().addEq(JkDataInfo.JK_UUID, (Object)jkDataInfo.getJkUuid());
        jkDataInfo1.where().addEq(JkDataInfo.NODE_NO, (Object)jkDataInfo.getNodeNo());
        List jkDataInfos = this.dao.findAll((AbsModel)jkDataInfo1);
        if (!jkDataInfos.isEmpty()) {
            throw new BusinessException("\u8be5\u8282\u70b9\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        jkDataInfo.setDataUuid(UUID.shortUUID());
        this.dao.save((AbsModel)jkDataInfo);
        msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg updateNode(JkDataInfo jkDataInfo) {
        Return msg = new Return();
        jkDataInfo.where().addEq(JkDataInfo.DATA_UUID, (Object)jkDataInfo.getDataUuid());
        this.dao.update((AbsModel)jkDataInfo);
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg delNode(ArrayList<String> dataUuids) {
        Return msg = new Return();
        JkDataInfo jkDataInfo = new JkDataInfo();
        jkDataInfo.where().addIn(JkDataInfo.DATA_UUID, dataUuids);
        List jkDataInfos = this.dao.findAll((AbsModel)jkDataInfo);
        for (JkDataInfo dataInfo : jkDataInfos) {
            JkDataInfo childNode = new JkDataInfo();
            childNode.where().addEq(JkDataInfo.JK_UUID, (Object)dataInfo.getJkUuid());
            childNode.where().addLike(JkDataInfo.NODE_SEQ, (Object)dataInfo.getNodeNo());
            this.dao.delete((AbsModel)childNode);
        }
        JkMappingRule jkMappingRule = new JkMappingRule();
        jkMappingRule.where().addIn(JkMappingRule.SOURCE_DATA_UUID, dataUuids).addIn(JkMappingRule.TARGET_DATA_UUID, dataUuids);
        this.dao.delete((AbsModel)jkMappingRule);
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryByDataUUid(String dataUuid) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)dataUuid)) {
            throw new BusinessException("dataUuid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JkDataInfo jkDataInfo = new JkDataInfo();
        jkDataInfo.where().addEq(JkDataInfo.DATA_UUID, (Object)dataUuid);
        JkDataInfo one = (JkDataInfo)this.dao.findOne((AbsModel)jkDataInfo);
        msg.setDataTable(new Object[]{one});
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }
}

