/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.material.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.newtouch.base.config.ObsConfig;
import com.newtouch.base.config.TemplateConfig;
import com.newtouch.base.service.SyncService;
import com.newtouch.base.service.SysDataService;
import com.newtouch.base.utils.FilesUtil;
import com.newtouch.base.utils.hwobs.HWYObsSDKUtis;
import com.newtouch.base.vo.ExportDataVo;
import com.newtouch.material.model.ScglAuthorized;
import com.newtouch.material.model.ScglMaterial;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.newtouch.material.model.ScpzTags;
import com.newtouch.material.param.AddMaterialsParam;
import com.newtouch.material.param.DeleteMaterialsParam;
import com.newtouch.material.param.QueryMaterialsParam;
import com.newtouch.material.param.SaveScpzTagsMaterialRelationparam;
import com.newtouch.material.param.SaveScpzTagsMaterialparam;
import com.newtouch.material.service.IAuthorizedService;
import com.newtouch.material.service.IMaterialManagerService;
import com.newtouch.material.vo.MaterialVo;
import com.newtouch.nms.sip.model.SipProductSyncTask;
import com.newtouch.tags.service.ITagsService;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MaterialManagerServiceImpl
implements IMaterialManagerService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    private TemplateConfig templateConfig;
    @Autowired
    private HWYObsSDKUtis hwyObsSDKUtis;
    @Autowired
    private ObsConfig obsConfig;
    @Value(value="${template.uploadFileType}")
    private String FILE_TYPE;
    @Autowired
    private SyncService syncService;
    @Autowired
    private ITagsService tagsService;
    @Autowired
    private IAuthorizedService authorizedService;
    @Autowired
    private SysDataService sysDataService;
    private static final List<String> FILE_TYPE_LIST = new ArrayList<String>(Arrays.asList("GIF", "JPG", "JPEG", "PNG", "MP4", "PDF", "HTML", "gif", "jpg", "jpeg", "png", "mp4", "pdf", "html"));
    private static final long FILE_MAX_SIZE = 0xA00000L;
    private static final String relate_tab = "scgl_material";
    private static final String relate_field = "material_id";
    StringJoiner joiner = new StringJoiner(",");
    private static final String MATERIAL_EXPORT_NAME = "material_export";
    private static final String FILE_LIST_DIR = "fileList";

    @Override
    public ReturnMsg queryMaterial(QueryMaterialsParam queryMaterialsParam) {
        Return msg = new Return();
        StringBuilder sql = new StringBuilder();
        ArrayList<String> sqlParam = new ArrayList<String>();
        sql.append("select sm.material_id,        sm.material_name,        sm.file_resolution,        sm.file_size,        sm.file_format,        sm.is_share,        sm.is_authorized,        sm.file_name,        sm.reference_count,        sa.authorization_id,        sa.expiration_date,        sm.file_path,        sm.material_source,        sa.certificate_file_name  from scgl_material sm   left join scgl_authorized sa     on sm.material_id = sa.material_id  where sm.data_flag = ? ");
        sqlParam.add("1");
        if (!StrUtils.isNull((Object)queryMaterialsParam.getMaterialName())) {
            sql.append("and sm.material_name like ? ");
            sqlParam.add("%" + queryMaterialsParam.getMaterialName() + "%");
        }
        if (!StrUtils.isNull((Object)queryMaterialsParam.getMaterialFileType())) {
            if (queryMaterialsParam.getMaterialFileType().equals("pic")) {
                sql.append("and sm.material_file_type in (?,?,?,?) ");
                sqlParam.add("gif");
                sqlParam.add("jpg");
                sqlParam.add("png");
                sqlParam.add("jpeg");
            } else {
                sql.append("and sm.material_file_type = ? ");
                sqlParam.add(queryMaterialsParam.getMaterialFileType());
            }
        }
        if (!StrUtils.isNull((Object)queryMaterialsParam.getUseSce())) {
            sql.append("and sm.use_sce = ? ");
            sqlParam.add(queryMaterialsParam.getUseSce());
        }
        if (!StrUtils.isNull((Object)queryMaterialsParam.getIsAuthorize())) {
            sql.append("and sm.is_authorized = ?");
            sqlParam.add(queryMaterialsParam.getIsAuthorize());
        }
        if (!StrUtils.isNull((Object)queryMaterialsParam.getIsExpire())) {
            if (queryMaterialsParam.getIsExpire().equals("1")) {
                sql.append("and sa.expiration_date < now()");
            }
            if (queryMaterialsParam.getIsExpire().equals("0")) {
                sql.append("and sa.expiration_date >= now()");
            }
        }
        sql.append("order by sm.crt_date desc");
        List mapList = this.dao.findAll(sql.toString(), Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(sqlParam)});
        mapList.stream().forEach(o -> {
            String tagSql = "select st.tag_id,st.tag_name   from scpz_material_tags_relation smtr, scpz_tags st  where smtr.tag_id = st.tag_id    and smtr.relation_fk = ?    and smtr.relation_tab = ? ";
            ArrayList<String> tagSqlParam = new ArrayList<String>();
            tagSqlParam.add((String)o.get(relate_field));
            tagSqlParam.add(relate_tab);
            List tagList = this.dao.findAll(tagSql, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(tagSqlParam)});
            if (tagList.size() > 0) {
                o.put("tags", tagList);
            }
        });
        msg.setDataList(mapList);
        return msg.msg();
    }

    @Override
    public ReturnMsg updateMaterialName(String materialId, String materialName) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)materialId)) {
            return msg.setFailMsg("\u7d20\u6750id\u4e0d\u80fd\u4e3a\u7a7a").msg();
        }
        if (StrUtils.isNull((Object)materialName)) {
            return msg.setFailMsg("\u7d20\u6750\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a").msg();
        }
        this.dao.update(ScglMaterial.n().setMaterialName(materialName).where().addEq(ScglMaterial.MATERIAL_ID, (Object)materialId).model());
        return msg.setSuccessMsg("\u4fee\u6539\u6210\u529f").msg();
    }

    @Override
    public ReturnMsg deleteMaterials(DeleteMaterialsParam deleteMaterialsParam) {
        Return msg = new Return();
        if (ObjectUtil.isEmpty(deleteMaterialsParam.getMaterialIds())) {
            return msg.setFailMsg("\u7d20\u6750id\u4e0d\u80fd\u4e3a\u7a7a").msg();
        }
        ScglMaterial scglMaterial = new ScglMaterial();
        scglMaterial.setDataFlag("0");
        scglMaterial.where().addIn(ScglMaterial.MATERIAL_ID, deleteMaterialsParam.getMaterialIds());
        this.dao.update((AbsModel)scglMaterial);
        return msg.setSuccessMsg("\u5220\u9664\u6210\u529f").msg();
    }

    @Override
    public ReturnMsg addMaterial(AddMaterialsParam addMaterialsParam) throws IOException {
        Return msg = new Return();
        if (StrUtils.isNull((Object)addMaterialsParam.getMaterialKey()) || StrUtils.isNull((Object)addMaterialsParam.getMaterialUrl())) {
            return msg.setFailMsg("\u4e0a\u4f20\u7d20\u6750\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a").msg();
        }
        if (StrUtils.isNull((Object)addMaterialsParam.getMaterialName())) {
            return msg.setFailMsg("\u7d20\u6750\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a").msg();
        }
        if (StrUtils.isNull((Object)addMaterialsParam.getExpirationDate())) {
            return msg.setFailMsg("\u7d20\u6750\u5230\u671f\u65e5\u4e0d\u80fd\u4e3a\u7a7a").msg();
        }
        List scglMaterials = this.dao.findAll(ScglMaterial.n().where().addEq(ScglMaterial.MATERIAL_NAME, (Object)addMaterialsParam.getMaterialName()).addEq(ScglMaterial.DATA_FLAG, (Object)"1").model());
        if (scglMaterials.size() > 0) {
            return msg.setFailMsg("\u7d20\u6750\u540d\u79f0\u4e0d\u80fd\u91cd\u590d").msg();
        }
        InputStream inStream = this.hwyObsSDKUtis.getObject(addMaterialsParam.getMaterialKey());
        long fileSize = this.getFileSize(inStream);
        String fileType = this.splitFileType(addMaterialsParam.getMaterialUrl());
        List<String> FILE_TYPE_LIST = Arrays.asList(this.FILE_TYPE.split(","));
        Optional<String> any = FILE_TYPE_LIST.stream().filter(x -> StringUtils.equals((CharSequence)x, (CharSequence)fileType)).findAny();
        if (!any.isPresent()) {
            msg.setFailMsg("\u4e0a\u4f20\u7684\u7d20\u6750\u7c7b\u578b\u4e0d\u662fGIF,JPG,JPEG,PNG,mp4,pdf,html\u683c\u5f0f");
            return msg.msg();
        }
        ScglMaterial scglMaterial = new ScglMaterial();
        BeanUtils.copyProperties((Object)((Object)addMaterialsParam), (Object)((Object)scglMaterial));
        scglMaterial.setIsAuthorized("0");
        if (!StrUtils.isNull((Object)addMaterialsParam.getAuthorizedUrl())) {
            String fileAuthorizationTyoe = this.splitFileType(addMaterialsParam.getAuthorizedUrl());
            if (!StringUtils.equals((CharSequence)fileAuthorizationTyoe, (CharSequence)"PDF") && !StringUtils.equals((CharSequence)fileAuthorizationTyoe, (CharSequence)"pdf")) {
                msg.setFailMsg("\u4e0a\u4f20\u7684\u6388\u6743\u8bc1\u4e66\u7c7b\u578b\u4e0d\u662fpdf\u683c\u5f0f");
                return msg.msg();
            }
            scglMaterial.setIsAuthorized("1");
        }
        String materialId = UUID.shortUUID();
        scglMaterial.setFileFormat(fileType);
        scglMaterial.setFileName(addMaterialsParam.getMaterialKey());
        scglMaterial.setUseSce(addMaterialsParam.getUseSce());
        scglMaterial.setFileSize(this.getFileSize(fileSize));
        scglMaterial.setMaterialId(materialId);
        scglMaterial.setFilePath(addMaterialsParam.getMaterialUrl());
        scglMaterial.setMaterialFileType(fileType);
        this.dao.save((AbsModel)scglMaterial);
        ScglAuthorized scglAuthorized = new ScglAuthorized();
        scglAuthorized.setMaterialId(materialId);
        scglAuthorized.setCertificateFileName(addMaterialsParam.getAuthorizedKey());
        if (!StrUtils.isNull((Object)addMaterialsParam.getAuthorizedKey())) {
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            scglAuthorized.setAuthorizationDate(ts);
        }
        scglAuthorized.setAuthorizationId(UUID.shortUUID());
        scglAuthorized.setExpirationDate(addMaterialsParam.getExpirationDate());
        scglAuthorized.setCertificateFilePath(addMaterialsParam.getAuthorizedUrl());
        this.dao.save((AbsModel)scglAuthorized);
        msg.setSuccessMsg("\u65b0\u589e\u6210\u529f");
        msg.setDataTable(new Object[]{scglMaterial});
        return msg.msg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadFile(byte[] bytes, String type, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        String filePath = this.templateConfig.getUploadFormCollectPath() + "/upload/" + type + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/";
        File f = new File(filePath);
        if (!f.getParentFile().exists() || !f.isDirectory()) {
            f.getParentFile().mkdirs();
        }
        try {
            File dir = new File(filePath);
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(filePath + "/" + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return filePath + fileName;
    }

    private String getFileSize(long size) {
        String fileSize = "";
        if (size > 0x40000000L) {
            fileSize = size / 0x40000000L + "GB";
        }
        if (size > 0x100000L) {
            fileSize = size / 0x100000L + "MB";
        }
        if (size > 1024L) {
            fileSize = size / 1024L + "KB";
        }
        return fileSize;
    }

    private String splitFileType(String s) {
        String[] split = s.split("\\.");
        return split[split.length - 1];
    }

    @Override
    public ReturnMsg insertScpzTags(String tagName, String tagCategories) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)tagName)) {
            msg.setFailMsg("\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (tagName.getBytes(Charset.forName("UTF-8")).length >= 32) {
            msg.setFailMsg("\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u8d8532\u5b57\u7b26\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)tagCategories)) {
            tagCategories = "\u81ea\u5b9a\u4e49\u6807\u7b7e";
        }
        ScpzTags scpzTags = new ScpzTags();
        scpzTags.where().addEq(ScpzTags.TAG_NAME, (Object)tagName);
        List all = this.dao.findAll((AbsModel)scpzTags);
        if (!ObjectUtils.isEmpty((Object)all)) {
            msg.setFailMsg("\u6807\u7b7e\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u5f55\u5165");
            return msg.msg();
        }
        ScpzTags scpzTags1 = new ScpzTags();
        String uUid = UUID.shortUUID();
        scpzTags1.setTagId(uUid);
        scpzTags1.setTagName(tagName);
        scpzTags1.setTagCategories(tagCategories);
        this.dao.save((AbsModel)scpzTags1);
        msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryScpzTags(String tagName) {
        Return msg = new Return();
        ScpzTags scpzTags = new ScpzTags();
        scpzTags.where().setCheckWhere(false);
        if (!StrUtils.isNull((Object)tagName)) {
            scpzTags.where().addLike(ScpzTags.TAG_NAME, (Object)tagName);
        }
        scpzTags.setOrderBy(ScpzTags.CRT_DATE.desc());
        List scpzTagsList = this.dao.findAll((AbsModel)scpzTags);
        msg.setDataList(scpzTagsList, ScpzTags.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg saveScpzTagsMaterialVo(SaveScpzTagsMaterialparam saveScpzTagsMaterialparam) {
        Return msg = new Return();
        if (saveScpzTagsMaterialparam == null) {
            msg.setFailMsg("\u6570\u636e\u4f20\u8f93\u4e3a\u7a7a!");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)saveScpzTagsMaterialparam.getTagBelongs())) {
            msg.setFailMsg("\u6807\u7b7e\u5f52\u5c5e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        for (String materialId : saveScpzTagsMaterialparam.getMaterialId()) {
            if (StrUtils.isNull((Object)materialId)) {
                msg.setFailMsg("\u7d20\u6750ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return msg.msg();
            }
            ScglMaterial scglMaterial = new ScglMaterial();
            scglMaterial.where().addEq(ScglMaterial.MATERIAL_ID, (Object)materialId);
            ScglMaterial scglMaterial1 = (ScglMaterial)this.dao.findOne((AbsModel)scglMaterial);
            if (ObjectUtils.isEmpty((Object)((Object)scglMaterial1))) {
                msg.setFailMsg("\u7d20\u6750id:" + materialId + "\u4e0d\u5b58\u5728");
                return msg.msg();
            }
            for (String tagsId : saveScpzTagsMaterialparam.getTagsId()) {
                if (StrUtils.isNull((Object)tagsId)) {
                    msg.setFailMsg("\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    return msg.msg();
                }
                ScpzMaterialTagsRelation scpzMaterialTagsRelation = new ScpzMaterialTagsRelation();
                ScpzTags scpzTags = new ScpzTags();
                scpzTags.where().addEq(ScpzTags.TAG_ID, (Object)tagsId);
                List scpzTagsList = this.dao.findAll((AbsModel)scpzTags);
                if (scpzTagsList.isEmpty() || scpzTagsList.size() == 0) {
                    msg.setFailMsg("\u6807\u7b7eid:" + tagsId + "\u4e0d\u5b58\u5728");
                    return msg.msg();
                }
                scpzMaterialTagsRelation.where().addEq(ScpzMaterialTagsRelation.TAG_ID, (Object)tagsId);
                scpzMaterialTagsRelation.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)materialId);
                scpzMaterialTagsRelation.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)relate_field);
                scpzMaterialTagsRelation.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)relate_tab);
                List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation);
                if (!scpzMaterialTagsRelationList.isEmpty() && scpzMaterialTagsRelationList.size() > 0) continue;
                String uUid = UUID.shortUUID();
                scpzMaterialTagsRelation.setRelationFk(materialId);
                scpzMaterialTagsRelation.setTagId(tagsId);
                scpzMaterialTagsRelation.setRelationUuid(uUid);
                scpzMaterialTagsRelation.setRelationTab(relate_tab);
                scpzMaterialTagsRelation.setRelationField(relate_field);
                scpzMaterialTagsRelation.setTagBelongs(saveScpzTagsMaterialparam.getTagBelongs());
                this.dao.save((AbsModel)scpzMaterialTagsRelation);
            }
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg saveScpzMaterialTagsRelation(SaveScpzTagsMaterialRelationparam save) {
        Return msg = new Return();
        if (save == null) {
            msg.setFailMsg("\u6570\u636e\u4f20\u8f93\u4e3a\u7a7a!");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)save.getMaterialId())) {
            msg.setFailMsg("\u7d20\u6750id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        ScglMaterial scglMaterial = new ScglMaterial();
        scglMaterial.where().addEq(ScglMaterial.MATERIAL_ID, (Object)save.getMaterialId());
        ScglMaterial scglMaterial1 = (ScglMaterial)this.dao.findOne((AbsModel)scglMaterial);
        if (ObjectUtils.isEmpty((Object)((Object)scglMaterial1))) {
            msg.setFailMsg("\u7d20\u6750id:" + save.getMaterialId() + "\u4e0d\u5b58\u5728");
            return msg.msg();
        }
        ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)save.getMaterialId());
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)relate_field);
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)relate_tab);
        List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation1);
        if (!scpzMaterialTagsRelationList.isEmpty() && scpzMaterialTagsRelationList.size() > 0) {
            this.dao.delete(ScpzMaterialTagsRelation.n().where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)save.getMaterialId()).addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)relate_field).addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)relate_tab).model());
        }
        for (String tagsId : save.getTagsId()) {
            if (StrUtils.isNull((Object)tagsId)) {
                msg.setFailMsg("\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return msg.msg();
            }
            ScpzMaterialTagsRelation scpzMaterialTagsRelation = new ScpzMaterialTagsRelation();
            ScpzTags scpzTags = new ScpzTags();
            scpzTags.where().addEq(ScpzTags.TAG_ID, (Object)tagsId);
            List scpzTagsList = this.dao.findAll((AbsModel)scpzTags);
            if (scpzTagsList.isEmpty() || scpzTagsList.size() == 0) {
                msg.setFailMsg("\u6807\u7b7eid:" + tagsId + "\u4e0d\u5b58\u5728");
                return msg.msg();
            }
            String uUid = UUID.shortUUID();
            scpzMaterialTagsRelation.setRelationFk(save.getMaterialId());
            scpzMaterialTagsRelation.setTagId(tagsId);
            scpzMaterialTagsRelation.setRelationUuid(uUid);
            scpzMaterialTagsRelation.setRelationTab(relate_tab);
            scpzMaterialTagsRelation.setRelationField(relate_field);
            scpzMaterialTagsRelation.setTagBelongs(save.getTagBelongs());
            this.dao.save((AbsModel)scpzMaterialTagsRelation);
        }
        return msg.msg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnMsg downloadMaterial(HttpServletRequest request, HttpServletResponse response, String filePath) throws IOException {
        Return msg = new Return();
        filePath = "D:\\1111.gif";
        File file = new File(filePath);
        if (StrUtils.isNull((Object)filePath)) {
            msg.setFailMsg("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (file.getName().contains("\r") || file.getName().contains("\n")) {
            msg.setFailMsg("\u6587\u4ef6\u540d\u542b\u6709\u975e\u6cd5\u5b57\u7b26\uff01");
        }
        response.setContentType("multipart/form-data");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + file.getName());
        ServletOutputStream out = response.getOutputStream();
        FileInputStream fileInput = new FileInputStream(file);
        try {
            int b;
            out = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((b = fileInput.read(buffer)) != -1) {
                out.write(buffer, 0, b);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            fileInput.close();
            out.flush();
            out.close();
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg exportNew(List<String> materialUuidList, HttpServletResponse response) {
        try {
            this.validateMaterialUuidList(materialUuidList);
            SipProductSyncTask task = this.createSyncTask();
            String basePath = this.generateBasePath();
            String baseAddress = basePath + "/";
            List<ScglMaterial> materialList = this.fetchMaterials(materialUuidList);
            if (CollectionUtils.isNotEmpty(materialList)) {
                this.saveData(baseAddress, materialList);
                this.compressAndSend(basePath, response);
                this.dao.save((AbsModel)task);
            }
        }
        catch (Exception e) {
            this.handleExportException(e);
        }
        return null;
    }

    private void validateMaterialUuidList(List<String> materialUuidList) {
        if (CollectionUtils.isEmpty(materialUuidList)) {
            Ulog.info((String)"\u4f20\u5165id\u4e3a\u7a7a");
            throw new BusinessException("\u4f20\u5165id\u4e3a\u7a7a");
        }
    }

    private SipProductSyncTask createSyncTask() {
        SipProductSyncTask task = new SipProductSyncTask();
        task.setFuncModule("TSCGLMATERIAL");
        task.setTaskType("EXP");
        task.setCrtDate(new Date());
        return task;
    }

    private String generateBasePath() {
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String basePath = this.templateConfig.getUploadFormCollectPath() + "/export/material/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis;
        return basePath;
    }

    private List<ScglMaterial> fetchMaterials(List<String> materialUuidList) {
        ScglMaterial material = new ScglMaterial();
        material.where().addIn(ScglMaterial.MATERIAL_ID, materialUuidList);
        return this.dao.findAll((AbsModel)material);
    }

    private void saveData(String baseAddress, List<ScglMaterial> materialList) {
        ArrayList<MaterialVo> materialVoList = new ArrayList<MaterialVo>();
        String destinationDir = baseAddress + "/" + MATERIAL_EXPORT_NAME + "/" + FILE_LIST_DIR;
        ArrayList<String> fileNameList = new ArrayList<String>();
        for (ScglMaterial m : materialList) {
            this.joiner.add(m.getFileName());
            MaterialVo materialVo = new MaterialVo();
            BeanUtils.copyProperties((Object)((Object)m), (Object)((Object)materialVo));
            materialVo.setMaterialTagsRelationList(this.tagsService.findScpzMaterialTagsRelationList(m.getMaterialId(), relate_field, relate_tab));
            materialVo.setScglAuthorized(this.authorizedService.queryAuthorizedByMaterialId(m.getMaterialId()));
            fileNameList.add(materialVo.getFileName());
            fileNameList.add(materialVo.getScglAuthorized().getCertificateFileName());
            materialVoList.add(materialVo);
        }
        this.downloadFiles(destinationDir, fileNameList.toArray(new String[0]));
        ExportDataVo exportDataVo = new ExportDataVo();
        exportDataVo.setName(MATERIAL_EXPORT_NAME);
        exportDataVo.setJson(JsonUtils.toJson(materialVoList));
        FilesUtil.createFile(baseAddress + "/" + exportDataVo.getName() + "/" + exportDataVo.getName() + ".json");
        FilesUtil.writeToFile(baseAddress + "/" + exportDataVo.getName() + "/" + exportDataVo.getName() + ".json", exportDataVo.getJson(), false);
    }

    private void handleExportException(Exception e) {
        String taskName = this.joiner.toString().substring(0, Math.min(this.joiner.toString().length() - 1, 10));
        SipProductSyncTask task = this.createSyncTask();
        task.setTaskName(taskName);
        task.setTaskState("FAIL");
        task.setErrorInfo(e.getMessage());
        task.setFinishDate(new Date());
        this.syncService.saveSyncTask(task, ThreadLocalContext.get().getUser());
        Ulog.error((String)("Export failed: {" + e.getMessage() + "}"));
        throw new BusinessException("\u5bfc\u51fa\u5931\u8d25");
    }

    public void compressAndSend(String basePath, HttpServletResponse response) {
        try {
            String zipFile = basePath + ".zip";
            Ulog.info((String)("baseAddress----" + basePath));
            Ulog.info((String)("zipFile----" + zipFile));
            String zip = FileUtils.zip((String)basePath, (String)zipFile, (String[])new String[]{".txt", ".json", ".xlsx", ".png", ".jpg", "jpeg", "gif", "mp4", "pdf", "html"});
            Ulog.info((String)("zip----" + zip));
            File file = new File(zipFile);
            if (!file.exists()) {
                throw new FileNotFoundException("\u538b\u7f29\u6587\u4ef6\u4e0d\u5b58\u5728: " + zipFile);
            }
            FileInputStream inputStream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            inputStream.read(data);
            inputStream.close();
            response.setHeader("content-type", "application/octet-stream;charset=UTF-8");
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.addHeader("Content-Length", "" + file.length());
            response.setHeader("Content-Disposition", "attachment;filename=" + this.encodeFileName(System.currentTimeMillis() + ".zip"));
            ServletOutputStream stream = response.getOutputStream();
            stream.write(data);
            stream.flush();
            stream.close();
            FilesUtil.delFile(basePath);
        }
        catch (FileNotFoundException e) {
            Ulog.error((String)("\u6587\u4ef6\u672a\u627e\u5230: " + e.getMessage()));
        }
        catch (IOException e) {
            Ulog.error((String)("IO\u5f02\u5e38: " + e.getMessage()));
        }
        catch (Exception e) {
            Ulog.error((String)("\u672a\u77e5\u5f02\u5e38: " + e.getMessage()));
        }
    }

    private String encodeFileName(String filename) {
        try {
            return URLEncoder.encode(filename, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return filename;
        }
    }

    public void downloadFiles(String destinationDir, String[] fileNames) {
        if (fileNames == null || fileNames.length == 0) {
            Ulog.warn((String)"No file names provided.");
            return;
        }
        for (String fileName : fileNames) {
            if (fileName == null || fileName.trim().isEmpty()) {
                Ulog.warn((String)"Skipping empty or null file name.");
                continue;
            }
            String filePath = destinationDir + "/" + fileName;
            File file = new File(filePath);
            if (!file.getParentFile().exists() || !file.isDirectory()) {
                file.getParentFile().mkdirs();
            }
            try (InputStream inStream = this.hwyObsSDKUtis.getObject(fileName);
                 BufferedInputStream in = new BufferedInputStream(inStream);
                 BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filePath));){
                int len;
                byte[] b = new byte[1024];
                while ((len = in.read(b)) != -1) {
                    out.write(b, 0, len);
                }
            }
            catch (Exception e) {
                Ulog.error((String)("Error downloading file: " + fileName));
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnMsg uploadJson(MultipartFile zipFile) {
        SipProductSyncTask task = new SipProductSyncTask();
        task.setCrtDate(new Date());
        String pathName = this.templateConfig.getUploadFormCollectPath() + "/upload/material/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = FilesUtil.unzipFile(zipFile, pathName);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
            return msg.msg();
        }
        File importDir = new File(pathName);
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<File> jsonList = new ArrayList<File>();
        FilesUtil.getAllFiles(importDir, jsonList, fileList);
        Ulog.info((String)("\u83b7\u53d6\u9700\u8981\u8bfb\u53d6\u7684\u6587\u4ef6" + JsonUtils.toJson(jsonList)));
        StringJoiner joiner = new StringJoiner(",");
        for (File jsonFile : jsonList) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
                Throwable throwable = null;
                try {
                    int ch = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    String jsonStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u7d20\u6750\u6570\u636e\u4e3a" + jsonStr));
                    List MaterialVoList = JSONObject.parseArray((String)jsonStr, MaterialVo.class);
                    for (MaterialVo materialVo : MaterialVoList) {
                        String materialId = materialVo.getMaterialId();
                        joiner.add(materialVo.getMaterialName());
                        int cCount = this.dao.delete(ScglMaterial.n().where().addEq(ScglMaterial.MATERIAL_ID, (Object)materialId).model());
                        int caCount = this.dao.delete(ScpzMaterialTagsRelation.n().where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)relate_tab).addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)relate_field).addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)materialId).model());
                        ScglMaterial material = new ScglMaterial();
                        BeanUtils.copyProperties((Object)((Object)materialVo), (Object)((Object)material));
                        this.dao.save((AbsModel)material);
                        if (CollectionUtils.isNotEmpty(materialVo.getMaterialTagsRelationList())) {
                            this.tagsService.saveScpzMaterialTagsRelationList(materialId, relate_field, relate_tab, materialVo.getMaterialTagsRelationList());
                        }
                        if (!ObjectUtil.isNotEmpty((Object)((Object)materialVo.getScglAuthorized()))) continue;
                        this.authorizedService.deleteAuthorizedByMaterialId(materialVo.getMaterialId());
                        this.authorizedService.saveMaterialId(materialVo.getScglAuthorized());
                    }
                }
                catch (Throwable ch) {
                    throwable = ch;
                    throw ch;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable ch) {
                            throwable.addSuppressed(ch);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
                e.printStackTrace();
                String taskName = joiner.toString().substring(0, Math.min(joiner.toString().length() - 1, 10));
                task.setIsZipDel("0");
                task.setTaskName(taskName);
                task.setTaskState("FAIL");
                task.setErrorInfo(e.getMessage());
                task.setFinishDate(new Date());
                this.syncService.saveSyncTask(task, ThreadLocalContext.get().getUser());
                msg.setFailMsg(new Message("6050005", "\u5bfc\u5165\u5931\u8d25"));
                return msg.msg();
            }
        }
        try {
            for (File pic : fileList) {
                String path = pic.getPath();
                String[] str = new String[]{};
                String obsSplitPath = this.obsConfig.getObsSplitPath();
                if ((path = path.replace("\\", "/")).contains("page/")) {
                    str = path.split("page/");
                } else if (path.contains(obsSplitPath)) {
                    str = path.split(obsSplitPath);
                }
                String filePath = str[str.length - 1];
                filePath = filePath.replaceAll("/" + pic.getName(), "");
                this.sysDataService.uploadFileById(pic, filePath, pic.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.debug((Object)e);
            Ulog.info((String)("\u7d20\u6750\u6587\u4ef6\u5bfc\u5165\u5f02\u5e38--->" + e.getMessage()));
            String taskName = joiner.toString().substring(0, Math.min(joiner.toString().length() - 1, 10));
            task.setIsZipDel("0");
            task.setTaskName(taskName);
            task.setTaskState("FAIL");
            task.setErrorInfo(e.getMessage());
            task.setFinishDate(new Date());
            this.syncService.saveSyncTask(task, ThreadLocalContext.get().getUser());
        }
        finally {
            FilesUtil.delFile(pathName);
        }
        String taskName = joiner.toString().substring(0, Math.min(joiner.toString().length() - 1, 10));
        task.setFuncModule("TSCGLMATERIAL");
        task.setTaskType("IMP");
        task.setTaskName(taskName);
        task.setTaskState("FINISH");
        task.setFinishDate(new Date());
        this.dao.save((AbsModel)task);
        msg.setSuccessMsg(new Message("6050004", "\u5bfc\u5165\u6210\u529f"));
        return msg.msg();
    }

    private long getFileSize(InputStream inputStream) {
        int fileSize = 0;
        try {
            int bytesRead;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            byte[] data = byteArrayOutputStream.toByteArray();
            fileSize = data.length;
            System.out.println("File size: " + fileSize + " bytes");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileSize;
    }
}

