/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.utils;

import com.newtouch.base.model.QsnPaper;
import com.newtouch.base.param.FkRulesReqParam;
import com.newtouch.base.param.SaveRuleUsedParam;
import com.newtouch.base.service.FormTemplateService;
import com.newtouch.base.service.RuleUsedService;
import com.newtouch.inform.model.QsnCoreQuestions;
import com.newtouch.inform.model.QsnQuestionBlanks;
import com.newtouch.inform.model.QsnQuestionOptions;
import com.newtouch.inform.model.QsnQuestions;
import com.newtouch.inform.model.QsnTitleRelation;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.stereotype.Component;

@Component
@CacheConfig(cacheNames={"queryUtils"})
public class QueryUtils {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    FormTemplateService formTemplateService;
    @Autowired
    RuleUsedService ruleUsedService;

    public QsnPaper queryPaper(String paperUuid) {
        QsnPaper qsnPaper = new QsnPaper();
        qsnPaper.where().addEq(QsnPaper.PAPER_UUID, (Object)paperUuid);
        qsnPaper = (QsnPaper)this.dao.findOne((AbsModel)qsnPaper);
        if (StrUtils.isNull((Object)((Object)qsnPaper))) {
            return null;
        }
        return qsnPaper;
    }

    public QsnTitleRelation queryQsnTitleRelation(String paperUuid) {
        QsnTitleRelation qsnTitleRelation = new QsnTitleRelation();
        qsnTitleRelation.where().addEq(QsnTitleRelation.PAPER_UUID, (Object)paperUuid);
        qsnTitleRelation = (QsnTitleRelation)this.dao.findOne((AbsModel)qsnTitleRelation);
        if (StrUtils.isNull((Object)((Object)qsnTitleRelation))) {
            return null;
        }
        return qsnTitleRelation;
    }

    public QsnQuestions queryQsnQuestions(String qsnUuid) {
        QsnQuestions qsnQuestions = new QsnQuestions();
        qsnQuestions.where().addEq(QsnQuestions.QSN_UUID, (Object)qsnUuid);
        qsnQuestions = (QsnQuestions)this.dao.findOne((AbsModel)qsnQuestions);
        if (StrUtils.isNull((Object)((Object)qsnQuestions))) {
            return null;
        }
        return qsnQuestions;
    }

    public List<QsnQuestions> queryChildQsnQuestions(String qsnUuid) {
        QsnQuestions qsnQuestions = new QsnQuestions();
        qsnQuestions.where().addEq(QsnQuestions.UP_QUESTION_ID, (Object)qsnUuid);
        qsnQuestions.setOrderBy(QsnQuestions.DISPLAY_ORDER.asc());
        return this.dao.findAll((AbsModel)qsnQuestions);
    }

    public List<QsnQuestions> queryChildQsnQuestions222(String qsnUuid, String childUuid) {
        if (StrUtils.isNull((Object)childUuid)) {
            return new ArrayList<QsnQuestions>();
        }
        String[] split = childUuid.split(",");
        QsnQuestions qsnQuestions = new QsnQuestions();
        qsnQuestions.where().addEq(QsnQuestions.UP_QUESTION_ID, (Object)qsnUuid);
        qsnQuestions.where().addIn(QsnQuestions.QSN_UUID, split);
        qsnQuestions.setOrderBy(QsnQuestions.DISPLAY_ORDER.asc());
        return this.dao.findAll((AbsModel)qsnQuestions);
    }

    public QsnCoreQuestions queryQsnCoreQuestions(String coreQuestionUuid) {
        QsnCoreQuestions qsnCoreQuestions = new QsnCoreQuestions();
        qsnCoreQuestions.where().addEq(QsnCoreQuestions.CORE_QUESTION_UUID, (Object)coreQuestionUuid);
        qsnCoreQuestions = (QsnCoreQuestions)this.dao.findOne((AbsModel)qsnCoreQuestions);
        if (StrUtils.isNull((Object)((Object)qsnCoreQuestions))) {
            return null;
        }
        return qsnCoreQuestions;
    }

    public List<QsnQuestionBlanks> queryQsnQuestionBlanks(String qsnUuid) {
        QsnQuestionBlanks qsnQuestionBlanks = new QsnQuestionBlanks();
        qsnQuestionBlanks.where().addEq(QsnQuestionBlanks.QUESTION_UUID, (Object)qsnUuid);
        List qsnQuestionBlanksList = this.dao.findAll((AbsModel)qsnQuestionBlanks);
        if (CollectionUtils.isEmpty((Collection)qsnQuestionBlanksList)) {
            return new ArrayList<QsnQuestionBlanks>();
        }
        return qsnQuestionBlanksList;
    }

    public List<QsnQuestionBlanks> queryQsnQuestionBlanks(String relateField, String relateTab, String relateFk) {
        QsnQuestionBlanks qsnQuestionBlanks = new QsnQuestionBlanks();
        qsnQuestionBlanks.where().addEq(QsnQuestionBlanks.RELATE_FK, (Object)relateFk);
        qsnQuestionBlanks.where().addEq(QsnQuestionBlanks.RELATE_FIELD, (Object)relateField);
        qsnQuestionBlanks.where().addEq(QsnQuestionBlanks.RELATE_TAB, (Object)relateTab);
        List qsnQuestionBlanksList = this.dao.findAll((AbsModel)qsnQuestionBlanks);
        if (CollectionUtils.isEmpty((Collection)qsnQuestionBlanksList)) {
            return new ArrayList<QsnQuestionBlanks>();
        }
        return qsnQuestionBlanksList;
    }

    public List<QsnQuestionOptions> queryQsnQuestionOptions(String relateField, String relateTab, String relateFk) {
        QsnQuestionOptions qsnQuestionOptions = new QsnQuestionOptions();
        qsnQuestionOptions.where().addEq(QsnQuestionOptions.RELATE_FK, (Object)relateFk);
        qsnQuestionOptions.where().addEq(QsnQuestionOptions.RELATE_FIELD, (Object)relateField);
        qsnQuestionOptions.where().addEq(QsnQuestionOptions.RELATE_TAB, (Object)relateTab);
        List qsnQuestionOptionsList = this.dao.findAll((AbsModel)qsnQuestionOptions);
        if (CollectionUtils.isEmpty((Collection)qsnQuestionOptionsList)) {
            return new ArrayList<QsnQuestionOptions>();
        }
        return qsnQuestionOptionsList;
    }

    public List<SaveRuleUsedParam> queryRuleInfo(String relateField, String relateTab, String relateFk) {
        FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
        fkRulesReqParam.setRelateField(relateField);
        fkRulesReqParam.setRelateTab(relateTab);
        fkRulesReqParam.setRelateFk(relateFk);
        List rules = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
        if (CollectionUtils.isEmpty((Collection)rules)) {
            return new ArrayList<SaveRuleUsedParam>();
        }
        return rules;
    }
}

