/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.newtouch.base.component.SqlBaseComponent;
import com.newtouch.base.config.TemplateConfig;
import com.newtouch.base.enums.BaseEnum;
import com.newtouch.base.enums.PageBaseEnum;
import com.newtouch.base.model.FmAllAttributes;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.model.FmTemplateAttributes;
import com.newtouch.base.model.FmTemplateText;
import com.newtouch.base.param.FkRulesReqParam;
import com.newtouch.base.param.SaveRuleUsedParam;
import com.newtouch.base.service.DynamicFormService;
import com.newtouch.base.service.RuleUsedService;
import com.newtouch.base.vo.FmJsonReqParam;
import com.uniapis.cache.CacheManager;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.SqlMapper;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Service;

@Service
public class DynamicFormServiceImpl
implements DynamicFormService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    TemplateConfig templateConfig;
    @Autowired
    SqlBaseComponent sqlBaseComponent;
    @Autowired
    RuleUsedService ruleUsedService;

    @Override
    public List<FmTemplateAttributes> getAttrListJson(FmJsonReqParam formJsonReqParam) {
        String templateId = formJsonReqParam.getTemplateId();
        FmTemplateAttributes fmTemplateAttributes = new FmTemplateAttributes();
        fmTemplateAttributes.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).addEq(FmTemplateAttributes.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        fmTemplateAttributes.setOrderBy(FmTemplateAttributes.DISPLAY_ORDER.asc());
        List fmTemplateAttrAll = this.dao.findAll((AbsModel)fmTemplateAttributes);
        if (CollectionUtils.isEmpty((Collection)fmTemplateAttrAll)) {
            return null;
        }
        for (FmTemplateAttributes attr : fmTemplateAttrAll) {
            String attrId = attr.getAttrId();
            if ("richText".equals(attr.getComponentType())) {
                FmTemplateText fmTemplateText = new FmTemplateText();
                fmTemplateText.where().addEq(FmTemplateText.ATTR_ID, (Object)attrId).addEq(FmTemplateText.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
                FmTemplateText fmTemplateTexDb = (FmTemplateText)this.dao.findOne((AbsModel)fmTemplateText);
                attr.setEditorContent(JsonUtils.toJson((Object)((Object)fmTemplateTexDb)));
            }
            FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
            fkRulesReqParam.setRelateField("attr_id");
            fkRulesReqParam.setRelateTab("fm_template_attributes");
            fkRulesReqParam.setRelateFk(attrId);
            List saveRuleUsedParamsList = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
            if (!CollectionUtils.isNotEmpty((Collection)saveRuleUsedParamsList)) continue;
            attr.setRules(saveRuleUsedParamsList);
        }
        return fmTemplateAttrAll;
    }

    @Override
    public void recursionAttr(JSONArray content, List<FmTemplateAttributes> dataList, Map<String, String> typeMap, String templateId, String parentId, Map<String, String> attrCodeMap) {
        if (CollectionUtils.isEmpty((Collection)content)) {
            return;
        }
        for (int i = 0; i < content.size(); ++i) {
            JSONArray configs;
            JSONObject jsonObject = content.getJSONObject(i);
            String componentType = jsonObject.getString(PageBaseEnum.JsonContentEnum.COMPONENT_TYPE.getType());
            String attrId = jsonObject.getString(PageBaseEnum.JsonContentEnum.ATTR_ID.getType());
            this.wrapperAttr(jsonObject, dataList, typeMap, i, templateId, parentId, attrCodeMap);
            if (!this.templateConfig.getFormLayoutList().contains(componentType) || StringUtils.isBlank((CharSequence)jsonObject.getString(PageBaseEnum.JsonContentEnum.COLUMNS.getType())) || !CollectionUtils.isNotEmpty((Collection)(configs = jsonObject.getJSONArray(PageBaseEnum.JsonContentEnum.COLUMNS.getType()))) || !this.templateConfig.getFormLayoutList().contains(componentType)) continue;
            for (int j = 0; j < configs.size(); ++j) {
                if (!CollectionUtils.isNotEmpty((Collection)configs.getJSONObject(j).getJSONArray("list"))) continue;
                JSONArray columnsArray = configs.getJSONObject(j).getJSONArray("list");
                this.recursionAttr(columnsArray, dataList, typeMap, templateId, attrId, attrCodeMap);
            }
        }
    }

    @Override
    public ReturnMsg updateFormTemplate(FmTemplate fmTemplate, FmTemplate fmTemplateDb, List<FmTemplateAttributes> dataList, Map<String, String> typeMap) {
        Ulog.info((String)("\u9700\u8981\u4fee\u6539\u7684\u8868\u7ed3\u6784\u7684\u5b57\u6bb5\u4fe1\u606f\u4e3a:" + JsonUtils.toJson(dataList)));
        Return msg = new Return();
        String tableMd5 = fmTemplateDb.getTemplateMd5();
        JSONObject json = fmTemplate.getJson();
        String formMd5 = DigestUtils.md5Hex((String)JSON.toJSONString((Object)json));
        if (Objects.equals(tableMd5, formMd5)) {
            msg.setSuccessMsg(new Message("6020002", "\u5185\u5bb9\u76f8\u540c\u65e0\u9700\u4fee\u6539"));
            return msg.msg();
        }
        String templateId = fmTemplate.getTemplateId();
        String isCreateTableDb = fmTemplateDb.getIsCreateTable();
        String isCreateTable = fmTemplate.getIsCreateTable();
        Ulog.info((String)(templateId + "\u539f\u8868\u5355\u6a21\u677f\u521b\u5efa\u52a8\u6001\u8868\u6807\u8bc6-->" + isCreateTableDb + "--\u6539\u540e\u7684\u8868\u5355\u6a21\u677f\u521b\u5efa\u52a8\u6001\u8868\u6807\u8bc6\u4e3a-->" + isCreateTable));
        ArrayList<FmTemplateAttributes> dataListNew = new ArrayList<FmTemplateAttributes>(dataList);
        if (Objects.equals("Y", isCreateTable)) {
            Ulog.info((String)(templateId + "\u539f\u8868\u5355\u6a21\u677fcode\u4e3a-->" + fmTemplateDb.getTemplateCode() + "--\u6539\u540e\u7684\u8868\u5355\u6a21\u677fcode\u4e3a-->" + fmTemplate.getTemplateCode()));
            FmTemplateAttributes fmTemplateAttributes = new FmTemplateAttributes();
            fmTemplateAttributes.select(FmTemplateAttributes.ATTR_MD5, FmTemplateAttributes.ATTR_ID, FmTemplateAttributes.ATTR_CODE, FmTemplateAttributes.COMPONENT_TYPE).where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).addEq(FmTemplateAttributes.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
            List attrAll = this.dao.findAll((AbsModel)fmTemplateAttributes);
            this.updateAttr(fmTemplate, fmTemplateDb, dataListNew, attrAll, typeMap);
        }
        this.updateAttrDirect(templateId, dataList);
        fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        fmTemplate.setTemplateMd5(formMd5);
        json.remove((Object)PageBaseEnum.JsonContentEnum.CONTENT.getType());
        fmTemplate.setTemplateJson(JsonUtils.toJson((Object)json));
        this.dao.update((AbsModel)fmTemplate);
        CacheManager.remove((String)("template_" + templateId));
        CacheManager.remove((String)("template_limit" + templateId));
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg createFormTemplate(FmTemplate fmTemplate, FmTemplate fmTemplateDb, List<FmTemplateAttributes> allOldAttr, Map<String, String> typeMap) {
        Return msg = new Return();
        List<FmTemplateAttributes> attrList = fmTemplate.getAttrList();
        if (!StrUtils.isNull(attrList)) {
            this.saveTemplateAttributes(attrList);
        }
        if (Objects.equals("Y", fmTemplate.getIsCreateTable())) {
            this.updateAttr(fmTemplate, fmTemplateDb, attrList, allOldAttr, typeMap);
        }
        Ulog.info((String)("\u8868\u5355\u6a21\u677ffmTemplate:" + (Object)((Object)fmTemplate)));
        if (fmTemplate.getJson() != null) {
            String formMd5 = DigestUtils.md5Hex((String)JSON.toJSONString((Object)fmTemplate.getJson()));
            JSONObject json = fmTemplate.getJson();
            json.remove((Object)PageBaseEnum.JsonContentEnum.CONTENT.getType());
            fmTemplate.setTemplateJson(JsonUtils.toJson((Object)json));
            fmTemplate.setTemplateMd5(formMd5);
        }
        this.dao.save((AbsModel)fmTemplate);
        if (CollectionUtils.isNotEmpty(fmTemplate.getRules())) {
            List<SaveRuleUsedParam> rules = fmTemplate.getRules();
            for (SaveRuleUsedParam saveRuleUsedParam : rules) {
                this.ruleUsedService.saveRuleUsed(saveRuleUsedParam);
            }
        }
        String templateId = fmTemplate.getTemplateId();
        CacheManager.remove((String)("template_" + templateId));
        CacheManager.remove((String)("template_limit" + templateId));
        msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public void createDBTable(List<FmTemplateAttributes> fmTemplateAttributesList, Map<String, String> typeMap, FmTemplate fmTemplate) {
        String templateCode = fmTemplate.getTemplateCode();
        Ulog.info((String)("\u5f00\u59cb\u8fdb\u884c\u52a8\u6001\u8868\u521b\u5efa\u8868\u540d\u4e3a--->" + templateCode));
        List<Object> indexStatus = new ArrayList();
        if (!StrUtils.isNull((Object)fmTemplate.getIndexColumn())) {
            indexStatus = fmTemplateAttributesList.stream().filter(a -> fmTemplate.getIndexColumn().contains(a.getAttrId())).collect(Collectors.toList());
        }
        fmTemplateAttributesList = this.sqlBaseComponent.removeExtraAttr(fmTemplateAttributesList);
        ArrayList<String> commentSql = new ArrayList<String>();
        ArrayList<String> indexSql = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ").append(templateCode).append("(");
        sql.append("serno VARCHAR(64) NOT NULL ,");
        commentSql.add("comment on column " + templateCode + ".serno is '\u5e8f\u5217\u53f7'");
        sql.append("instance_id VARCHAR(64) NOT NULL DEFAULT '1' ,");
        commentSql.add("comment on column " + templateCode + ".instance_id is '\u5b9e\u4f8bID'");
        for (FmTemplateAttributes fmTemplateAttributes : fmTemplateAttributesList) {
            String attrCode = fmTemplateAttributes.getAttrCode();
            sql.append(" ").append(attrCode).append(" ");
            sql.append(typeMap.get(fmTemplateAttributes.getComponentType()));
            if (Objects.nonNull(fmTemplateAttributes.getAttrLength())) {
                sql.append("(").append(fmTemplateAttributes.getAttrLength()).append(")");
            }
            if ("true".equals(fmTemplateAttributes.getNotNull())) {
                sql.append(" NOT NULL ");
            } else {
                sql.append(" NULL ");
            }
            if (StringUtils.isNotBlank((CharSequence)fmTemplateAttributes.getDefValue()) && !Objects.equals(typeMap.get(fmTemplateAttributes.getComponentType()), "TEXT")) {
                sql.append(" DEFAULT '").append(fmTemplateAttributes.getDefValue()).append("'");
            }
            sql.append(",");
            commentSql.add("comment on column " + templateCode + "." + attrCode + " is '" + fmTemplateAttributes.getAttrName() + "'");
        }
        sql.append("crt_date DATE DEFAULT CURRENT_TIMESTAMP ,").append("mdf_date DATE  NULL ,").append("crt_user VARCHAR(32) NULL ,").append("mdf_user VARCHAR(32) NULL ,").append("data_flag VARCHAR(4) NULL ,");
        indexSql.add("create index idx_" + templateCode + "_mdf_date on " + templateCode + " (mdf_date)");
        commentSql.add("comment on column " + templateCode + ".crt_date is '\u521b\u5efa\u65f6\u95f4'");
        commentSql.add("comment on column " + templateCode + ".mdf_date is '\u4fee\u6539\u65f6\u95f4'");
        commentSql.add("comment on column " + templateCode + ".crt_user is '\u521b\u5efa\u4eba'");
        commentSql.add("comment on column " + templateCode + ".mdf_user is '\u66f4\u65b0\u4eba'");
        commentSql.add("comment on column " + templateCode + ".data_flag is '\u6570\u636e\u72b6\u6001'");
        for (FmTemplateAttributes fmTemplateAttributes : indexStatus) {
            indexSql.add("create index idx_" + templateCode + "_" + fmTemplateAttributes.getAttrCode() + " on " + templateCode + " (" + fmTemplateAttributes.getAttrCode() + ")");
        }
        indexSql.add("create index idx_" + templateCode + "_user_instance on " + templateCode + " (crt_user,instance_id)");
        sql.append("constraint ").append(templateCode).append("_serno_pk primary key (serno))");
        String dropsql = "select DISTINCT TABLE_NAME  from information_schema.COLUMNS c where TABLE_NAME  = ? ";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(templateCode.toLowerCase());
        List all = this.dao.findAll(dropsql + " \uff03NOTCHECK", Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(arrayList)});
        if (CollectionUtils.isNotEmpty((Collection)all)) {
            this.dao.getJdbcTemplate().execute("DROP TABLE " + templateCode);
            Ulog.info((String)("\u52a8\u6001\u8868" + templateCode + "\u5220\u9664\u8868"));
        }
        try {
            JdbcTemplate jdbcTemplate = this.dao.getJdbcTemplate();
            jdbcTemplate.execute(sql.toString());
            this.dao.getJdbcTemplate().batchUpdate(indexSql.toArray(new String[0]));
            this.dao.getJdbcTemplate().batchUpdate(commentSql.toArray(new String[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.info((String)("\u52a8\u6001\u8868" + templateCode + "\u521b\u5efa\u5931\u8d25-->" + e.getMessage()));
            Connection connection = DataSourceUtils.getConnection((DataSource)this.dao.getJdbcTemplate().getDataSource());
            try {
                connection.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private ReturnMsg wrapperAttr(JSONObject jsonObject, List<FmTemplateAttributes> dataList, Map<String, String> typeMap, int order, String templateId, String parentId, Map<String, String> attrCodeMap) {
        Return msg = new Return();
        FmTemplateAttributes attributes = (FmTemplateAttributes)((Object)jsonObject.toJavaObject(FmTemplateAttributes.class));
        Integer attrLength = attributes.getAttrLength();
        String attrCode = attributes.getAttrCode();
        String attrName = attributes.getAttrName();
        attrCodeMap.put(attrCode, attrName);
        String attrId = attributes.getAttrId();
        String componentType = attributes.getComponentType();
        if (StrUtils.isNull((Object)attrId)) {
            return null;
        }
        if (attrLength != null && attrLength != 0) {
            attributes.setAttrLength(attrLength);
        } else {
            if ("VARCHAR".equals(typeMap.get(componentType))) {
                attributes.setAttrLength(128);
            }
            if ("textarea".equals(componentType)) {
                attributes.setAttrLength(1024);
            }
        }
        attributes.setDataFlag(BaseEnum.DataFlag.USABLE.getType());
        attributes.setDisplayOrder(order);
        attributes.setUpAttr(parentId);
        jsonObject.remove((Object)"tags");
        jsonObject.remove((Object)"qsnQuestionsInfo");
        String attrJson = jsonObject.toJSONString();
        attributes.setAttrJson(attrJson);
        attributes.setTemplateId(templateId);
        attributes.setIsColumn(this.templateConfig.getFromExcludeColumn().contains(componentType) ? "N" : "Y");
        attributes.setAttrMd5(DigestUtils.md5Hex((String)attrJson));
        dataList.add(attributes);
        return null;
    }

    private void updateAttr(FmTemplate fmTemplate, FmTemplate fmTemplateDb, List<FmTemplateAttributes> dataList, List<FmTemplateAttributes> allOldAttr, Map<String, String> typeMap) {
        String indexColumnDb;
        Ulog.info((String)"\u5f00\u59cb\u66f4\u65b0\u5c5e\u6027\u4e14\u4fee\u6539\u5176\u52a8\u6001\u8868\u4fe1\u606f");
        String templateCode = fmTemplate.getTemplateCode();
        String sql = "select DISTINCT TABLE_NAME  from information_schema.COLUMNS c where TABLE_NAME  = ? ";
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(templateCode.toLowerCase());
        List all = this.dao.findAll(sql + " \uff03NOTCHECK", Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(sqlList)});
        if (CollectionUtils.isEmpty((Collection)all)) {
            this.createDBTable(dataList, typeMap, fmTemplate);
            return;
        }
        ArrayList valueList = new ArrayList();
        SqlMapper sqlMapper = new SqlMapper();
        sqlMapper.setSql("SELECT * FROM " + templateCode);
        valueList.addAll(this.dao.findAll(sqlMapper.getSql() + " \uff03NOTCHECK", Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(sqlMapper.getValue())}));
        if (CollectionUtils.isEmpty(valueList)) {
            this.createDBTable(dataList, typeMap, fmTemplate);
            return;
        }
        Map<Object, Object> attrCodeMap = new HashMap();
        if (CollectionUtils.isNotEmpty(allOldAttr)) {
            attrCodeMap = allOldAttr.stream().collect(Collectors.toMap(FmTemplateAttributes::getAttrId, FmTemplateAttributes::getAttrCode));
        }
        ArrayList<FmTemplateAttributes> addAttrList = new ArrayList<FmTemplateAttributes>();
        ArrayList<FmTemplateAttributes> updateAttrList = new ArrayList<FmTemplateAttributes>();
        ArrayList<FmTemplateAttributes> updateAttrCodeList = new ArrayList<FmTemplateAttributes>();
        ArrayList<FmTemplateAttributes> addAttrIndexList = new ArrayList<FmTemplateAttributes>();
        ArrayList<FmTemplateAttributes> delAttrIndexList = new ArrayList();
        String indexColumn = fmTemplate.getIndexColumn() == null ? "" : fmTemplate.getIndexColumn();
        Set dbSet = ((Map)valueList.get(0)).keySet();
        dbSet.removeAll(Arrays.asList("serno", "instance_id", "crt_date", "mdf_date", "crt_user", "mdf_user", "data_flag", "patch_memo", "rn"));
        for (FmTemplateAttributes attr : dataList) {
            String attrCode = attr.getAttrCode();
            String attrId = attr.getAttrId();
            String oldAttrCode = (String)attrCodeMap.get(attrId);
            attr.setOldAttrCode(oldAttrCode);
            if (StrUtils.isNull((Object)oldAttrCode)) {
                addAttrList.add(attr);
            } else if (attrCode.equals(oldAttrCode)) {
                if (!dbSet.contains(attrCode)) {
                    addAttrList.add(attr);
                } else {
                    updateAttrList.add(attr);
                }
            } else if (!dbSet.contains(oldAttrCode)) {
                addAttrList.add(attr);
            } else {
                updateAttrCodeList.add(attr);
            }
            if (!indexColumn.contains(attrId)) continue;
            addAttrIndexList.add(attr);
        }
        Ulog.info((String)("\u9700\u8981\u65b0\u589e\u7684\u5b57\u6bb5:" + JsonUtils.toJson(addAttrList)));
        Ulog.info((String)("\u9700\u8981\u4fee\u6539\u7684\u5b57\u6bb5:" + JsonUtils.toJson(updateAttrList)));
        Ulog.info((String)("\u9700\u8981\u4fee\u6539\u7684\u5b57\u6bb5\u4e14\u4fee\u6539\u5b57\u6bb5\u540d\u7684:" + JsonUtils.toJson(updateAttrCodeList)));
        Ulog.info((String)("\u9700\u8981\u589e\u52a0\u7d22\u5f15\u7684:" + JsonUtils.toJson(updateAttrCodeList)));
        if (CollectionUtils.isNotEmpty(addAttrList)) {
            this.updateDBTable(addAttrList, PageBaseEnum.OptType.ADD.getType(), templateCode, typeMap);
        }
        if (CollectionUtils.isNotEmpty(updateAttrList)) {
            this.updateDBTable(updateAttrList, PageBaseEnum.OptType.MODIFY.getType(), templateCode, typeMap);
        }
        if (CollectionUtils.isNotEmpty(updateAttrCodeList)) {
            this.updateDBTable(updateAttrCodeList, PageBaseEnum.OptType.CHANGE.getType(), templateCode, typeMap);
        }
        String string = indexColumnDb = fmTemplateDb != null ? fmTemplateDb.getIndexColumn() : "";
        if (!StrUtils.isNull((Object)indexColumnDb)) {
            delAttrIndexList = allOldAttr.stream().filter(o -> indexColumnDb.contains(o.getAttrId())).collect(Collectors.toList());
            Ulog.info((String)("\u9700\u8981\u5220\u9664\u7d22\u5f15\u7684\u5b57\u6bb5:" + JsonUtils.toJson(delAttrIndexList)));
            if (CollectionUtils.isNotEmpty(delAttrIndexList)) {
                this.updateDBTable(delAttrIndexList, PageBaseEnum.OptType.DEL_INDEX.getType(), templateCode, typeMap);
            }
        }
        if (!StrUtils.isNull((Object)indexColumn) && CollectionUtils.isNotEmpty(addAttrIndexList)) {
            Ulog.info((String)("\u9700\u8981\u589e\u52a0\u7d22\u5f15\u7684\u5b57\u6bb5:" + JsonUtils.toJson(addAttrIndexList)));
            this.updateDBTable(addAttrIndexList, PageBaseEnum.OptType.ADD_INDEX.getType(), templateCode, typeMap);
        }
        Ulog.info((String)"\u7ed3\u675f\u66f4\u65b0\u5c5e\u6027\u4e14\u4fee\u6539\u5176\u52a8\u6001\u8868\u4fe1\u606f");
    }

    private void updateDBTable(List<FmTemplateAttributes> attrList, String optType, String templateCode, Map<String, String> typeMap) {
        try {
            Ulog.info((String)"\u5c5e\u6027\u4fee\u6539\u8fdb\u884c\u52a8\u6001\u8868\u66f4\u65b0");
            attrList = this.sqlBaseComponent.removeExtraAttr(attrList);
            Ulog.info((String)("\u66f4\u6539\u524d\u6700\u7ec8\u8fc7\u6ee4\u540e\u6570\u636e:" + JsonUtils.toJson(attrList)));
            if (CollectionUtils.isEmpty(attrList)) {
                return;
            }
            List<Object> sqlList = new ArrayList();
            if (Objects.equals(optType, PageBaseEnum.OptType.ADD_INDEX.getType())) {
                Ulog.info((String)"\u52a8\u6001\u8868\u7d22\u5f15\u589e\u52a0");
                sqlList = this.sqlBaseComponent.addIndex(attrList, templateCode);
            }
            if (Objects.equals(optType, PageBaseEnum.OptType.DEL_INDEX.getType())) {
                Ulog.info((String)"\u52a8\u6001\u8868\u7d22\u5f15\u5220\u9664");
                sqlList = this.sqlBaseComponent.delIndex(attrList, templateCode);
            }
            if (Objects.equals(optType, PageBaseEnum.OptType.DELETE.getType())) {
                Ulog.info((String)"\u52a8\u6001\u8868\u5b57\u6bb5\u5220\u9664");
                sqlList = this.sqlBaseComponent.dropAttr(attrList, templateCode);
            }
            if (Objects.equals(optType, PageBaseEnum.OptType.CHANGE.getType()) || Objects.equals(optType, PageBaseEnum.OptType.ADD.getType()) || Objects.equals(optType, PageBaseEnum.OptType.MODIFY.getType())) {
                sqlList = this.sqlBaseComponent.modifyAttr(attrList, optType, templateCode, typeMap);
                Ulog.info((String)"\u52a8\u6001\u8868\u5b57\u6bb5\u4fee\u6539");
            }
            if (CollectionUtils.isNotEmpty(sqlList)) {
                this.dao.getJdbcTemplate().batchUpdate(sqlList.toArray(new String[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.info((String)"\u52a8\u6001\u8868\u4fee\u6539\u5931\u8d25");
            Connection connection = DataSourceUtils.getConnection((DataSource)this.dao.getJdbcTemplate().getDataSource());
            try {
                connection.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void updateAttrDirect(String templateId, List<FmTemplateAttributes> dataList) {
        FmTemplateAttributes attr = new FmTemplateAttributes();
        attr.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId);
        this.dao.delete((AbsModel)attr);
        this.saveTemplateAttributes(dataList);
    }

    private void updateTemplateAttributes(List<FmTemplateAttributes> updateAttrList, String templateId) {
        ArrayList<FmTemplateText> textSaveList = new ArrayList<FmTemplateText>();
        ArrayList<String> attrStrList = new ArrayList<String>();
        for (FmTemplateAttributes updateAttr : updateAttrList) {
            String attrId = updateAttr.getAttrId();
            updateAttr.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).addEq(FmTemplateAttributes.ATTR_ID, (Object)attrId);
            FmAllAttributes fmAllAttributes = new FmAllAttributes();
            BeanUtils.copyProperties((Object)((Object)updateAttr), (Object)((Object)fmAllAttributes));
            fmAllAttributes.where().addEq(FmAllAttributes.ATTR_CODE, (Object)updateAttr.getAttrCode()).addEq(FmAllAttributes.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
            List all = this.dao.findAll((AbsModel)fmAllAttributes);
            if (CollectionUtils.isNotEmpty((Collection)all)) {
                fmAllAttributes.where().addEq(FmAllAttributes.ATTR_CODE, (Object)updateAttr.getAttrCode()).addEq(FmAllAttributes.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
                this.dao.update((AbsModel)fmAllAttributes);
            } else {
                this.dao.save((AbsModel)fmAllAttributes);
            }
            if (!StrUtils.isNull((Object)updateAttr.getOldAttrCode())) {
                fmAllAttributes.where().addEq(FmAllAttributes.ATTR_CODE, (Object)updateAttr.getOldAttrCode());
                this.dao.delete((AbsModel)fmAllAttributes);
            }
            this.dao.update((AbsModel)updateAttr);
            String editorContent = updateAttr.getEditorContent();
            String componentType = updateAttr.getComponentType();
            if (!"richText".equals(componentType) && !"wangeditorText".equals(componentType)) continue;
            attrStrList.add(attrId);
            if (StrUtils.isNull((Object)editorContent)) continue;
            FmTemplateText fmTemplateText = new FmTemplateText();
            fmTemplateText.setAttrId(attrId);
            fmTemplateText.setTextContent(editorContent);
            textSaveList.add(fmTemplateText);
        }
        if (CollectionUtils.isNotEmpty(attrStrList)) {
            int textCount = this.dao.delete(FmTemplateText.n().where().addIn(FmTemplateText.ATTR_ID, attrStrList).model());
            Ulog.info((String)("\u66f4\u65b0\u6a21\u677f\u5c5e\u6027\u5220\u9664\u5bcc\u6587\u672c\u4fe1\u606f\u6210\u529f" + textCount));
        }
        if (CollectionUtils.isNotEmpty(textSaveList)) {
            Ulog.info((String)("\u66f4\u65b0\u6a21\u677f\u5c5e\u6027\u9700\u8981\u4fdd\u5b58\u7684\u5bcc\u6587\u672c\u4fe1\u606f\u4e3a:" + JsonUtils.toJson(textSaveList)));
            this.dao.save(textSaveList);
        }
    }

    private void saveTemplateAttributes(List<FmTemplateAttributes> dataList) {
        ArrayList<FmTemplateText> textSaveList = new ArrayList<FmTemplateText>();
        ArrayList<String> attrStrList = new ArrayList<String>();
        String pkUuid = ThreadLocalContext.get().getUser().getPkUuid();
        ArrayList<String> insertList = new ArrayList<String>();
        List<String> addList = Arrays.asList("template_id", "attr_id", "attr_code", "attr_name", "component_type", "attr_length", "not_null", "is_component", "c_attr_id", "exclude_ids", "is_encrypt", "attr_int", "attr_precision", "ths_rs", "data_fmt", "blank_value", "is_column", "attr_json", "up_attr", "attr_md5", "attr_desc", "display_order", "prompt_text", "def_value", "level_code", "level_name");
        for (FmTemplateAttributes attr : dataList) {
            String attrId = attr.getAttrId();
            String editorContent = attr.getEditorContent();
            String componentType = attr.getComponentType();
            if ("richText".equals(componentType) || "wangeditorText".equals(componentType)) {
                attrStrList.add(attrId);
                if (!StrUtils.isNull((Object)editorContent)) {
                    FmTemplateText fmTemplateText = new FmTemplateText();
                    fmTemplateText.setAttrId(attrId);
                    fmTemplateText.setTextContent(editorContent);
                    textSaveList.add(fmTemplateText);
                }
            }
            if (CollectionUtils.isNotEmpty(attr.getRules())) {
                List<SaveRuleUsedParam> rules = attr.getRules();
                for (SaveRuleUsedParam saveRuleUsedParam : rules) {
                    this.ruleUsedService.saveRuleUsed(saveRuleUsedParam);
                }
            }
            String timestamp = DateUtils.date2String((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            StringBuilder sql = new StringBuilder("INSERT INTO fm_template_attributes (serno, crt_user, mdf_user, data_flag, crt_date, mdf_date");
            StringBuilder value = new StringBuilder(" VALUES('" + UUID.snowId() + "', '" + pkUuid + "', '" + pkUuid + "', '1', '" + timestamp + "', '" + timestamp + "'");
            Map attrMap = JsonUtils.json2Map((String)JsonUtils.toJson((Object)((Object)attr)));
            for (Map.Entry entry : attrMap.entrySet()) {
                String key = (String)entry.getKey();
                if (!addList.contains(key)) continue;
                sql.append(", " + key);
                if (StrUtils.isNull(entry.getValue())) {
                    value.append(", null ");
                    continue;
                }
                value.append(", '" + entry.getValue() + "'");
            }
            insertList.add(sql.append(") ").append((CharSequence)value).append(")").toString());
        }
        if (CollectionUtils.isNotEmpty(insertList)) {
            long start = System.currentTimeMillis();
            Ulog.info((String)("\u4fdd\u5b58\u5c5e\u6027:" + JsonUtils.toJson(insertList)));
            this.dao.getJdbcTemplate().batchUpdate(insertList.toArray(new String[0]));
            long end = System.currentTimeMillis();
            double time = (double)(end - start) / 1000.0;
            Ulog.info((String)("\u4fdd\u5b58\u5c5e\u6027\u8017\u65f6:" + time + "s"));
        }
        if (CollectionUtils.isNotEmpty(attrStrList)) {
            int textCount = this.dao.delete(FmTemplateText.n().where().addIn(FmTemplateText.ATTR_ID, attrStrList).model());
            Ulog.info((String)("\u5220\u9664\u5bcc\u6587\u672c\u4fe1\u606f\u6210\u529f" + textCount));
        }
        if (CollectionUtils.isNotEmpty(textSaveList)) {
            Ulog.info((String)("\u9700\u8981\u4fdd\u5b58\u7684\u5bcc\u6587\u672c\u4fe1\u606f\u4e3a:" + JsonUtils.toJson(textSaveList)));
            this.dao.save(textSaveList);
        }
    }
}

