/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.enums.RelateEnum;
import com.newtouch.base.model.DsnRules;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.newtouch.base.vo.export.ExportRuleInfo;
import com.newtouch.base.vo.export.QsnQuestionBlanksInfo;
import com.newtouch.inform.model.QsnQuestionBlanks;
import com.newtouch.inform.model.QsnQuestionOptions;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class QsnQuestionOptionsInfo
implements Comparable {
    @JsonProperty(value="qsnQuestionOption")
    private QsnQuestionOptions qsnQuestionOption;
    @JsonProperty(value="qsnQuestionBlanksInfos")
    private List<QsnQuestionBlanksInfo> qsnQuestionBlanksInfos;
    @JsonProperty(value="ruleInfos")
    private List<ExportRuleInfo> ruleInfos;

    public QsnQuestionOptionsInfo load(String optionsUuid) {
        List<DsnRules> dsnRulesList;
        ExportQueryUtils query = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        this.ruleInfos = new ArrayList<ExportRuleInfo>();
        List<QsnQuestionBlanks> qsnQuestionBlanksList = query.queryQsnQuestionBlanks("option_uuid", "qsn_question_options", optionsUuid);
        this.qsnQuestionBlanksInfos = new ArrayList<QsnQuestionBlanksInfo>();
        if (CollectionUtils.isNotEmpty(qsnQuestionBlanksList)) {
            for (QsnQuestionBlanks qqb : qsnQuestionBlanksList) {
                QsnQuestionBlanksInfo qqbi = new QsnQuestionBlanksInfo();
                qqbi.setQsnQuestionBlank(qqb);
                qqbi.load(qqb.getBlankUuid());
                this.qsnQuestionBlanksInfos.add(qqbi);
            }
        }
        if (CollectionUtils.isNotEmpty(dsnRulesList = query.queryDsnRulesList(optionsUuid, RelateEnum.option.getRelateField(), RelateEnum.option.getRelateTab()))) {
            for (DsnRules dr : dsnRulesList) {
                ExportRuleInfo eri = new ExportRuleInfo();
                eri.load(dr);
                this.ruleInfos.add(eri);
            }
        }
        return this;
    }

    public void merge(QsnQuestionOptionsInfo qqoi) {
        this.qsnQuestionOption = EqualsUtils.merge(this.qsnQuestionOption, qqoi.getQsnQuestionOption());
        this.qsnQuestionBlanksInfos = EqualsUtils.merge(this.qsnQuestionBlanksInfos, qqoi.getQsnQuestionBlanksInfos(), QsnQuestionBlanksInfo.class);
        this.ruleInfos = EqualsUtils.merge(this.ruleInfos, qqoi.getRuleInfos(), ExportRuleInfo.class);
    }

    public void save() {
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        UpdateUtils.UpdateFlag updateFlag = UpdateUtils.UpdateFlag.U;
        if (this.qsnQuestionOption != null && ((updateFlag = (UpdateUtils.UpdateFlag)((Object)this.qsnQuestionOption.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class))) == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I)) {
            update.save(this.qsnQuestionOption);
            String optionUuid = this.qsnQuestionOption.getOptionUuid();
            QsnQuestionBlanks qsnQuestionBlanks = new QsnQuestionBlanks();
            qsnQuestionBlanks.setRelateFk(optionUuid);
            qsnQuestionBlanks.setRelateField(RelateEnum.option.getRelateField());
            qsnQuestionBlanks.setRelateTab(RelateEnum.option.getRelateTab());
            update.del(qsnQuestionBlanks);
            DsnRules dsnRules = new DsnRules();
            dsnRules.setRelateFk(optionUuid);
            dsnRules.setRelateField(RelateEnum.option.getRelateField());
            dsnRules.setRelateTab(RelateEnum.option.getRelateTab());
            update.del((AbsModel)dsnRules);
        }
        if (this.qsnQuestionBlanksInfos != null) {
            this.qsnQuestionBlanksInfos.forEach(m -> m.save());
        }
        if (this.ruleInfos != null) {
            this.ruleInfos.forEach(m -> m.save("N"));
        }
    }

    public int compareTo(@NotNull Object o) {
        UpdateUtils.UpdateFlag flag = (UpdateUtils.UpdateFlag)((Object)this.qsnQuestionOption.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
        if (flag == UpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == UpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == UpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }

    public QsnQuestionOptions getQsnQuestionOption() {
        return this.qsnQuestionOption;
    }

    public List<QsnQuestionBlanksInfo> getQsnQuestionBlanksInfos() {
        return this.qsnQuestionBlanksInfos;
    }

    public List<ExportRuleInfo> getRuleInfos() {
        return this.ruleInfos;
    }

    @JsonProperty(value="qsnQuestionOption")
    public void setQsnQuestionOption(QsnQuestionOptions qsnQuestionOption) {
        this.qsnQuestionOption = qsnQuestionOption;
    }

    @JsonProperty(value="qsnQuestionBlanksInfos")
    public void setQsnQuestionBlanksInfos(List<QsnQuestionBlanksInfo> qsnQuestionBlanksInfos) {
        this.qsnQuestionBlanksInfos = qsnQuestionBlanksInfos;
    }

    @JsonProperty(value="ruleInfos")
    public void setRuleInfos(List<ExportRuleInfo> ruleInfos) {
        this.ruleInfos = ruleInfos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QsnQuestionOptionsInfo)) {
            return false;
        }
        QsnQuestionOptionsInfo other = (QsnQuestionOptionsInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QsnQuestionOptions this$qsnQuestionOption = this.getQsnQuestionOption();
        QsnQuestionOptions other$qsnQuestionOption = other.getQsnQuestionOption();
        if (this$qsnQuestionOption == null ? other$qsnQuestionOption != null : !((Object)((Object)this$qsnQuestionOption)).equals((Object)other$qsnQuestionOption)) {
            return false;
        }
        List<QsnQuestionBlanksInfo> this$qsnQuestionBlanksInfos = this.getQsnQuestionBlanksInfos();
        List<QsnQuestionBlanksInfo> other$qsnQuestionBlanksInfos = other.getQsnQuestionBlanksInfos();
        if (this$qsnQuestionBlanksInfos == null ? other$qsnQuestionBlanksInfos != null : !((Object)this$qsnQuestionBlanksInfos).equals(other$qsnQuestionBlanksInfos)) {
            return false;
        }
        List<ExportRuleInfo> this$ruleInfos = this.getRuleInfos();
        List<ExportRuleInfo> other$ruleInfos = other.getRuleInfos();
        return !(this$ruleInfos == null ? other$ruleInfos != null : !((Object)this$ruleInfos).equals(other$ruleInfos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QsnQuestionOptionsInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QsnQuestionOptions $qsnQuestionOption = this.getQsnQuestionOption();
        result = result * 59 + ($qsnQuestionOption == null ? 43 : ((Object)((Object)$qsnQuestionOption)).hashCode());
        List<QsnQuestionBlanksInfo> $qsnQuestionBlanksInfos = this.getQsnQuestionBlanksInfos();
        result = result * 59 + ($qsnQuestionBlanksInfos == null ? 43 : ((Object)$qsnQuestionBlanksInfos).hashCode());
        List<ExportRuleInfo> $ruleInfos = this.getRuleInfos();
        result = result * 59 + ($ruleInfos == null ? 43 : ((Object)$ruleInfos).hashCode());
        return result;
    }

    public String toString() {
        return "QsnQuestionOptionsInfo(qsnQuestionOption=" + (Object)((Object)this.getQsnQuestionOption()) + ", qsnQuestionBlanksInfos=" + this.getQsnQuestionBlanksInfos() + ", ruleInfos=" + this.getRuleInfos() + ")";
    }
}

