/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.enums.RelateEnum;
import com.newtouch.base.model.Component;
import com.newtouch.base.model.ComponentAttribute;
import com.newtouch.base.model.FmAttributesType;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.newtouch.base.vo.export.SmtrInfo;
import com.newtouch.flow.model.FmEmbedded;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class ComponentInfo
implements Comparable {
    @JsonProperty(value="component")
    private Component component;
    @JsonProperty(value="caList")
    private List<ComponentAttribute> caList;
    @JsonProperty(value="fmAttributesType")
    private FmAttributesType fmAttributesType;
    @JsonProperty(value="smtrList")
    private List<SmtrInfo> smtrList;
    @JsonProperty(value="embeddedList")
    private List<FmEmbedded> embeddedList;

    public ComponentInfo load(String componentType, String templateType) {
        ExportQueryUtils query = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        this.component = query.queryComponent(componentType, templateType);
        if (this.component == null) {
            return this;
        }
        String componentId = this.component.getComponentId();
        this.caList = query.queryCaList(componentId);
        this.fmAttributesType = query.queryFmAttributesType(componentType);
        this.smtrList = new ArrayList<SmtrInfo>();
        List<ScpzMaterialTagsRelation> scpzMaterialTagsRelations = query.querySmtr(componentId, RelateEnum.component.getRelateField(), RelateEnum.component.getRelateTab());
        if (CollectionUtils.isNotEmpty(scpzMaterialTagsRelations)) {
            for (ScpzMaterialTagsRelation smtr : scpzMaterialTagsRelations) {
                SmtrInfo si = new SmtrInfo();
                si.setSmtr(smtr);
                si.load(smtr.getTagId());
                this.smtrList.add(si);
            }
        }
        this.embeddedList = new ArrayList<FmEmbedded>();
        if (!StrUtils.isNull((Object)this.component.getEmbeddedJson())) {
            List list = JsonUtils.json2List((String)this.component.getEmbeddedJson());
            list.forEach(l -> {
                FmEmbedded fmEmbedded = new FmEmbedded();
                fmEmbedded.setEmbeddedElementCn((String)l.get("embedded_element_cn"));
                fmEmbedded.setEmbeddedElementEn((String)l.get("embedded_element_en"));
                fmEmbedded.setDeliveryPlatform((String)l.get("delivery_platform"));
                List<FmEmbedded> fmEmbeddedList = query.queryFmEmbeddedList(fmEmbedded);
                this.embeddedList.addAll(fmEmbeddedList);
            });
        }
        return this;
    }

    public void merge(ComponentInfo componentInfo) {
        this.component = EqualsUtils.merge(this.component, componentInfo.getComponent());
        this.caList = EqualsUtils.merge(this.caList, componentInfo.getCaList());
        this.fmAttributesType = EqualsUtils.merge(this.fmAttributesType, componentInfo.getFmAttributesType());
        this.smtrList = EqualsUtils.merge(this.smtrList, componentInfo.getSmtrList(), SmtrInfo.class);
        this.embeddedList = EqualsUtils.merge(this.embeddedList, componentInfo.getEmbeddedList());
    }

    public void save() {
        UpdateUtils.UpdateFlag flag;
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        UpdateUtils.UpdateFlag updateFlag = UpdateUtils.UpdateFlag.D;
        if (this.component != null && ((updateFlag = (UpdateUtils.UpdateFlag)((Object)this.component.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class))) == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I)) {
            update.update(this.component);
            ComponentAttribute ca = new ComponentAttribute();
            String componentId = this.component.getComponentId();
            ca.setComponentId(componentId);
            update.del(ca);
            FmAttributesType fmAttributesType = new FmAttributesType();
            String componentType = this.component.getComponentType();
            fmAttributesType.setComponentType(componentType);
            update.del(fmAttributesType);
        }
        if (updateFlag == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I) {
            this.caList.forEach(m -> update.save((AbsModel)m));
        }
        if (this.fmAttributesType != null && ((flag = (UpdateUtils.UpdateFlag)((Object)this.fmAttributesType.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class))) == UpdateUtils.UpdateFlag.U || flag == UpdateUtils.UpdateFlag.I)) {
            update.save(this.fmAttributesType);
        }
        if (this.smtrList != null) {
            this.smtrList.forEach(m -> m.save());
        }
        if ((updateFlag == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I) && this.embeddedList != null) {
            this.embeddedList.forEach(m -> update.update((AbsModel)m));
        }
    }

    public int compareTo(@NotNull Object o) {
        UpdateUtils.UpdateFlag flag = (UpdateUtils.UpdateFlag)((Object)this.component.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
        if (flag == UpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == UpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == UpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }

    public Component getComponent() {
        return this.component;
    }

    public List<ComponentAttribute> getCaList() {
        return this.caList;
    }

    public FmAttributesType getFmAttributesType() {
        return this.fmAttributesType;
    }

    public List<SmtrInfo> getSmtrList() {
        return this.smtrList;
    }

    public List<FmEmbedded> getEmbeddedList() {
        return this.embeddedList;
    }

    @JsonProperty(value="component")
    public void setComponent(Component component) {
        this.component = component;
    }

    @JsonProperty(value="caList")
    public void setCaList(List<ComponentAttribute> caList) {
        this.caList = caList;
    }

    @JsonProperty(value="fmAttributesType")
    public void setFmAttributesType(FmAttributesType fmAttributesType) {
        this.fmAttributesType = fmAttributesType;
    }

    @JsonProperty(value="smtrList")
    public void setSmtrList(List<SmtrInfo> smtrList) {
        this.smtrList = smtrList;
    }

    @JsonProperty(value="embeddedList")
    public void setEmbeddedList(List<FmEmbedded> embeddedList) {
        this.embeddedList = embeddedList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentInfo)) {
            return false;
        }
        ComponentInfo other = (ComponentInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Component this$component = this.getComponent();
        Component other$component = other.getComponent();
        if (this$component == null ? other$component != null : !((Object)((Object)this$component)).equals((Object)other$component)) {
            return false;
        }
        List<ComponentAttribute> this$caList = this.getCaList();
        List<ComponentAttribute> other$caList = other.getCaList();
        if (this$caList == null ? other$caList != null : !((Object)this$caList).equals(other$caList)) {
            return false;
        }
        FmAttributesType this$fmAttributesType = this.getFmAttributesType();
        FmAttributesType other$fmAttributesType = other.getFmAttributesType();
        if (this$fmAttributesType == null ? other$fmAttributesType != null : !((Object)((Object)this$fmAttributesType)).equals((Object)other$fmAttributesType)) {
            return false;
        }
        List<SmtrInfo> this$smtrList = this.getSmtrList();
        List<SmtrInfo> other$smtrList = other.getSmtrList();
        if (this$smtrList == null ? other$smtrList != null : !((Object)this$smtrList).equals(other$smtrList)) {
            return false;
        }
        List<FmEmbedded> this$embeddedList = this.getEmbeddedList();
        List<FmEmbedded> other$embeddedList = other.getEmbeddedList();
        return !(this$embeddedList == null ? other$embeddedList != null : !((Object)this$embeddedList).equals(other$embeddedList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComponentInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Component $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : ((Object)((Object)$component)).hashCode());
        List<ComponentAttribute> $caList = this.getCaList();
        result = result * 59 + ($caList == null ? 43 : ((Object)$caList).hashCode());
        FmAttributesType $fmAttributesType = this.getFmAttributesType();
        result = result * 59 + ($fmAttributesType == null ? 43 : ((Object)((Object)$fmAttributesType)).hashCode());
        List<SmtrInfo> $smtrList = this.getSmtrList();
        result = result * 59 + ($smtrList == null ? 43 : ((Object)$smtrList).hashCode());
        List<FmEmbedded> $embeddedList = this.getEmbeddedList();
        result = result * 59 + ($embeddedList == null ? 43 : ((Object)$embeddedList).hashCode());
        return result;
    }

    public String toString() {
        return "ComponentInfo(component=" + (Object)((Object)this.getComponent()) + ", caList=" + this.getCaList() + ", fmAttributesType=" + (Object)((Object)this.getFmAttributesType()) + ", smtrList=" + this.getSmtrList() + ", embeddedList=" + this.getEmbeddedList() + ")";
    }
}

