/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.utils.hwobs;

import com.newtouch.base.config.ObsConfig;
import com.newtouch.base.enums.BaseEnum;
import com.newtouch.base.utils.hwobs.DateUtils;
import com.newtouch.base.utils.hwobs.Signature;
import com.uniapis.logger.Ulog;
import com.uniapis.utils.StrUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HWYObsAPIUtis {
    @Autowired
    private ObsConfig obsConfig;

    public static void main(String[] str) {
        HWYObsAPIUtis hwyObsAPIUtis = new HWYObsAPIUtis();
        String uri = "http://10.57.228.253";
        String bucketName = "sx-cpzx-obs01";
        String objectPath = "/page/tctip.5fc4d9a.png";
        String filePath = "C:\\Users\\14740\\Desktop\\tctip.5fc4d9a.png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listAllMyBuckets() {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String requesttime = DateUtils.formatDate(System.currentTimeMillis());
        HttpGet httpGet = new HttpGet(this.obsConfig.getEndpoint());
        httpGet.addHeader("Date", requesttime);
        String contentMD5 = "";
        String contentType = "";
        String canonicalizedHeaders = "";
        String canonicalizedResource = "/";
        String canonicalString = "GET\n" + contentMD5 + "\n" + contentType + "\n" + requesttime + "\n" + canonicalizedHeaders + canonicalizedResource;
        Ulog.info((String)("StringToSign:[" + canonicalString + "]"));
        String signature = null;
        try {
            String inputLine;
            signature = Signature.signWithHmacSha1(this.obsConfig.getSecretKey(), canonicalString);
            httpGet.addHeader("Authorization", "OBS " + this.obsConfig.getAccessKey() + ":" + signature);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            Ulog.info((String)"Request Message:");
            Ulog.info((Object)httpGet.getRequestLine());
            for (Header header : httpGet.getAllHeaders()) {
                Ulog.info((String)(header.getName() + ":" + header.getValue()));
            }
            Ulog.info((String)"Response Message:");
            Ulog.info((Object)httpResponse.getStatusLine());
            for (Header header : httpResponse.getAllHeaders()) {
                Ulog.info((String)(header.getName() + ":" + header.getValue()));
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = reader.readLine()) != null) {
                response.append(inputLine);
            }
            reader.close();
            Ulog.info((String)response.toString());
            String string = response.toString();
            return string;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putObjectToBucket(String objectPath, String filePath, String xObsAcl) {
        FileInputStream inputStream = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse httpResponse = null;
        String requestTime = DateUtils.formatDate(System.currentTimeMillis());
        String uri = this.obsConfig.getEndpoint() + "/" + objectPath;
        Ulog.info((String)("obs\u4e0a\u4f20uri--->" + uri));
        HttpPut httpPut = new HttpPut(uri);
        httpPut.addHeader("Date", requestTime);
        String bucketName = this.obsConfig.getBucketName();
        String host = bucketName + "." + this.obsConfig.getEndpointUrl();
        Ulog.info((String)("obs\u4e0a\u4f20host--->" + host));
        httpPut.addHeader("Host", host);
        if (!StrUtils.isNull((Object)xObsAcl)) {
            httpPut.addHeader("x-obs-acl", xObsAcl);
        }
        String contentMD5 = "";
        String suffix = objectPath.substring(objectPath.lastIndexOf(".") + 1);
        String contentType = "";
        if (BaseEnum.FILE_TYPE_LIST.contains(suffix)) {
            contentType = "text/plain";
            httpPut.addHeader("content-type", "text/plain");
        }
        String canonicalizedHeaders = "";
        String canonicalizedResource = "/" + bucketName + "/" + objectPath;
        String canonicalString = "";
        canonicalString = !StrUtils.isNull((Object)xObsAcl) ? "PUT\n" + contentMD5 + "\n" + contentType + "\n" + requestTime + "\nx-obs-acl:" + xObsAcl + "\n" + canonicalizedHeaders + canonicalizedResource : "PUT\n" + contentMD5 + "\n" + contentType + "\n" + requestTime + "\n" + canonicalizedHeaders + canonicalizedResource;
        Ulog.info((String)("obs\u4e0a\u4f20StringToSign:[" + canonicalString + "]"));
        String signature = null;
        try {
            String string;
            String inputLine;
            signature = Signature.signWithHmacSha1(this.obsConfig.getSecretKey(), canonicalString);
            inputStream = new FileInputStream(filePath);
            InputStreamEntity entity = new InputStreamEntity((InputStream)inputStream);
            httpPut.setEntity((HttpEntity)entity);
            httpPut.addHeader("Authorization", "OBS " + this.obsConfig.getAccessKey() + ":" + signature);
            httpResponse = httpClient.execute((HttpUriRequest)httpPut);
            Ulog.info((String)("Request Message:" + httpPut.getRequestLine()));
            for (Header header : httpPut.getAllHeaders()) {
                Ulog.info((String)(header.getName() + ":" + header.getValue()));
            }
            StatusLine statusLine = httpResponse.getStatusLine();
            Ulog.info((String)("Response Message:" + statusLine));
            int statusCode = statusLine.getStatusCode();
            for (Header header : httpResponse.getAllHeaders()) {
                Ulog.info((String)(header.getName() + ":" + header.getValue()));
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = reader.readLine()) != null) {
                response.append(inputLine);
            }
            reader.close();
            Ulog.info((String)response.toString());
            if (statusCode != 200) {
                string = null;
                return string;
            }
            string = "http://" + host + "/" + objectPath;
            return string;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getObject(String objectPath) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse httpResponse = null;
        String requestTime = DateUtils.formatDate(System.currentTimeMillis());
        String uri = this.obsConfig.getEndpoint() + "/" + objectPath;
        Ulog.info((String)("obs\u4e0b\u8f7duri--->" + uri));
        HttpGet httpGet = new HttpGet(uri);
        httpGet.addHeader("Date", requestTime);
        String host = this.obsConfig.getBucketName() + "." + this.obsConfig.getEndpointUrl();
        Ulog.info((String)("obs\u4e0b\u8f7dhost--->" + host));
        httpGet.addHeader("Host", host);
        String contentMD5 = "";
        String contentType = "";
        String canonicalizedHeaders = "";
        String canonicalizedResource = "/" + this.obsConfig.getBucketName() + "/" + objectPath;
        String canonicalString = "GET\n" + contentMD5 + "\n" + contentType + "\n" + requestTime + "\n" + canonicalizedHeaders + canonicalizedResource;
        Ulog.info((String)("obs\u4e0b\u8f7dStringToSign:[" + canonicalString + "]"));
        String signature = null;
        try {
            signature = Signature.signWithHmacSha1(this.obsConfig.getSecretKey(), canonicalString);
            httpGet.addHeader("Authorization", "OBS " + this.obsConfig.getAccessKey() + ":" + signature);
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            Ulog.info((String)("Request Message:" + httpGet.getRequestLine()));
            for (Header header : httpGet.getAllHeaders()) {
                Ulog.info((String)(header.getName() + ":" + header.getValue()));
            }
            StatusLine statusLine = httpResponse.getStatusLine();
            Ulog.info((String)("Response Message:" + statusLine));
            int statusCode = statusLine.getStatusCode();
            if (statusCode != 200) {
                return null;
            }
            Header[] headerArray = httpResponse.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    InputStream content = httpResponse.getEntity().getContent();
                    return content;
                }
                Header header = headerArray[n2];
                Ulog.info((String)(header.getName() + ":" + header.getValue()));
                ++n2;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

