/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.newtouch.base.component.SqlBaseComponent;
import com.newtouch.base.config.ObsConfig;
import com.newtouch.base.config.TemplateConfig;
import com.newtouch.base.enums.BaseEnum;
import com.newtouch.base.enums.PageBaseEnum;
import com.newtouch.base.model.Component;
import com.newtouch.base.model.ComponentAttribute;
import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConfig;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.base.model.DsnRulesParam;
import com.newtouch.base.model.FmAllAttributes;
import com.newtouch.base.model.FmCollection;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.model.FmTemplateAttributes;
import com.newtouch.base.model.FmTemplateText;
import com.newtouch.base.param.FkRulesReqParam;
import com.newtouch.base.param.SaveRuleUsedParam;
import com.newtouch.base.service.DynamicFormService;
import com.newtouch.base.service.FmAttributesTypeService;
import com.newtouch.base.service.FormTemplateService;
import com.newtouch.base.service.RuleUsedService;
import com.newtouch.base.service.SysDataService;
import com.newtouch.base.utils.FilesUtil;
import com.newtouch.base.utils.PinYin4JUtils;
import com.newtouch.base.utils.UUIDUtils;
import com.newtouch.base.utils.hwobs.HWYObsSDKUtis;
import com.newtouch.base.vo.AttrVo;
import com.newtouch.base.vo.AttributeMultiVo;
import com.newtouch.base.vo.AttributeVo;
import com.newtouch.base.vo.ComponentJsonVo;
import com.newtouch.base.vo.ComponentVo;
import com.newtouch.base.vo.ExportDataVo;
import com.newtouch.base.vo.FmAttrVo;
import com.newtouch.base.vo.FmCollectionRespVo;
import com.newtouch.base.vo.FmJsonAndValueVo;
import com.newtouch.base.vo.FmJsonReqParam;
import com.newtouch.base.vo.FmTemplateSaveVo;
import com.newtouch.base.vo.FmTemplateVo;
import com.newtouch.base.vo.RichTextVo;
import com.newtouch.flow.model.FmNode;
import com.newtouch.flow.param.MaterialDataList;
import com.newtouch.flow.param.QueryTagsRelationParam;
import com.newtouch.flow.param.QueryTagsRelationReturn;
import com.newtouch.flow.service.IFmFlowService;
import com.newtouch.inform.model.QsnQuestions;
import com.newtouch.inform.param.PackageQsnParam;
import com.newtouch.inform.param.QsnQuestionsInfo;
import com.newtouch.issue.service.IWtIssueService;
import com.newtouch.material.model.ScglAuthorized;
import com.newtouch.material.model.ScglMaterial;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.newtouch.material.model.ScpzReference;
import com.newtouch.material.model.ScpzTags;
import com.newtouch.nms.sip.model.SipProductSyncTask;
import com.newtouch.tags.service.ITagsService;
import com.uniapis.cache.CacheManager;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.SqlMapper;
import com.uniapis.repository.core.utils.SqlUtils;
import com.uniapis.rms.model.RmsMenu;
import com.uniapis.rms.param.RmsLimitVo;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.HttpUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import com.uniapis.web.utils.RequestUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FormTemplateServiceImpl
implements FormTemplateService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    FmAttributesTypeService fmAttributesTypeService;
    @Autowired
    DynamicFormService dynamicFormService;
    @Autowired
    TemplateConfig templateConfig;
    @Autowired
    SqlBaseComponent sqlBaseComponent;
    @Autowired
    RuleUsedService ruleUsedService;
    @Lazy
    @Autowired
    IFmFlowService iFmFlowService;
    @Autowired
    private IWtIssueService iWtIssueService;
    @Autowired
    private ITagsService tagsService;
    @Autowired
    private HWYObsSDKUtis hwyObsSDKUtis;
    @Autowired
    private ObsConfig obsConfig;
    @Autowired
    private SysDataService sysDataService;

    @Override
    public ReturnMsg queryCollectionForm(String collId) {
        Return msg = new Return();
        FmTemplate fmTemplate = new FmTemplate();
        fmTemplate.where().addEq(FmTemplate.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        fmTemplate.where().addEq(FmTemplate.COLL_ID, (Object)collId);
        fmTemplate.setOrderBy(FmTemplate.CRT_DATE.desc());
        List fmTemplates = this.dao.findAll((AbsModel)fmTemplate);
        msg.getDataTable().put("templateList", fmTemplates);
        return msg.msg();
    }

    @Override
    public ReturnMsg getOldAttrList() {
        Return msg = new Return();
        FmAllAttributes fmAllAttributes = new FmAllAttributes();
        fmAllAttributes.where().addEq(FmTemplate.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        fmAllAttributes.setOrderBy(FmTemplate.CRT_DATE.desc());
        List fmAllAttributesList = this.dao.findAll((AbsModel)fmAllAttributes);
        msg.getDataTable().put("oldAttrList", fmAllAttributesList);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg initAddOrUpdate(FmTemplateSaveVo fmTemplateSaveVo) {
        List all;
        Ulog.info((String)("\u65b0\u589e\u6216\u7f16\u8f91\u9875\u9762\u540d\u79f0\u57fa\u7840\u4fe1\u606f\u53c2\u6570\u4e3a:" + JsonUtils.toJson((Object)fmTemplateSaveVo)));
        Return msg = new Return();
        String templateId = fmTemplateSaveVo.getTemplateId();
        String collId = fmTemplateSaveVo.getCollId();
        if (StrUtils.isNull((Object)fmTemplateSaveVo.getDeliveryPlatform())) {
            msg.setFailMsg("\u9500\u552e\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (fmTemplateSaveVo.getTemplateName().getBytes(Charset.forName("UTF-8")).length > 256) {
            msg.setFailMsg("\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u8d85256\u5b57\u7b26\uff01");
            return msg.msg();
        }
        FmTemplate fmTemplateCheck = new FmTemplate();
        fmTemplateCheck.where().addEq(FmTemplate.TEMPLATE_NAME, (Object)fmTemplateSaveVo.getTemplateName());
        fmTemplateCheck.where().addEq(FmTemplate.COLL_ID, (Object)fmTemplateSaveVo.getCollId());
        fmTemplateCheck.where().addNotEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        fmTemplateCheck.where().addEq(FmTemplate.TEMPLATE_BELONGS, (Object)fmTemplateSaveVo.getTemplateBelongs());
        String templateType = fmTemplateSaveVo.getTemplateType();
        if (("inform".equals(templateType) || "qsn".equals(templateType)) && "form".equals(fmTemplateSaveVo.getTemplateBelongs())) {
            fmTemplateCheck.where().addEq(FmTemplate.USE_SCENE, (Object)fmTemplateSaveVo.getUseScene());
        }
        if (CollectionUtils.isNotEmpty((Collection)(all = this.dao.findAll((AbsModel)fmTemplateCheck)))) {
            msg.setFailMsg(new Message("6020005", "\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u91cd\u590d"));
            return msg.msg();
        }
        FmTemplate fmTemplateDb = new FmTemplate();
        fmTemplateDb.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        fmTemplateDb = (FmTemplate)this.dao.findOne((AbsModel)fmTemplateDb);
        if (fmTemplateDb != null && Objects.equals("ON", fmTemplateDb.getState())) {
            msg.setFailMsg(new Message("6020004", "\u9875\u9762\u72b6\u6001\u5904\u4e8e\u4f7f\u7528\u72b6\u6001\uff0c\u4e0d\u53ef\u8fdb\u884c\u4fee\u6539/\u5220\u9664"));
            return msg.msg();
        }
        FmTemplate fmTemplateMax = new FmTemplate();
        fmTemplateMax.where().addEq(DsnRulesConfig.DATA_FLAG, (Object)"1");
        if (!StrUtils.isNull((Object)collId)) {
            fmTemplateMax.where().addEq(FmTemplate.COLL_ID, (Object)collId);
        }
        if (!StrUtils.isNull((Object)fmTemplateSaveVo.getTemplateBelongs())) {
            fmTemplateMax.where().addEq(FmTemplate.TEMPLATE_BELONGS, (Object)fmTemplateSaveVo.getTemplateBelongs());
        }
        fmTemplateMax.groupBy().max(DsnRulesConfig.DISPLAY_ORDER);
        fmTemplateMax = (FmTemplate)this.dao.findOne((AbsModel)fmTemplateMax);
        FmTemplate fmTemplate = new FmTemplate();
        String order = fmTemplateMax.getOtherProperty("max_display_order").toString();
        if (StrUtils.isNull((Object)order)) {
            fmTemplate.setDisplayOrder(1);
        } else {
            fmTemplate.setDisplayOrder(Integer.parseInt(order) + 1);
        }
        if (ObjectUtil.isNotEmpty(fmTemplateSaveVo.getEmbeddeds())) {
            fmTemplateSaveVo.setEmbeddedJson(JsonUtils.toJson(fmTemplateSaveVo.getEmbeddeds()));
        }
        if (fmTemplateDb == null) {
            fmTemplateSaveVo.setIsEdit(fmTemplateSaveVo.getIsEdit());
            fmTemplateSaveVo.setBgColor("#fff");
            fmTemplateSaveVo.setBgImg("");
            fmTemplateSaveVo.setFontColor("#333");
            fmTemplateSaveVo.setFontFamily("SimSun");
            fmTemplateSaveVo.setFontSize("14");
            fmTemplateSaveVo.setFormPadding("20");
            fmTemplateSaveVo.setIndexColumn("");
            fmTemplateSaveVo.setIsCreateTable("");
            fmTemplateSaveVo.setLabelColor("#333");
            fmTemplateSaveVo.setLabelWidth("100");
            fmTemplateSaveVo.setState("OFF");
            fmTemplateSaveVo.setTemplateJson("{\"theme\": \"\u84dd\u8272\",\"language\": \"zh\"}");
            fmTemplateSaveVo.setDisplayOrder(fmTemplate.getDisplayOrder());
            BeanUtils.copyProperties((Object)fmTemplateSaveVo, (Object)((Object)fmTemplate));
            fmTemplate.setIsEdit(fmTemplateSaveVo.getIsEdit());
            fmTemplate.setTemplateJson(JsonUtils.toJson((Object)fmTemplateSaveVo));
            this.dao.save((AbsModel)fmTemplate);
            msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        } else {
            String templateName = fmTemplateSaveVo.getTemplateName();
            String collIdDb = fmTemplateDb.getCollId();
            String templateJson = fmTemplateDb.getTemplateJson();
            Map oldJson = JsonUtils.json2Map((String)templateJson);
            fmTemplateDb.setTemplateName(templateName);
            oldJson.put("template_name", templateName);
            fmTemplateDb.setCollId(collId);
            oldJson.put("coll_id", collId);
            fmTemplateDb.setIsEdit(fmTemplateSaveVo.getIsEdit());
            oldJson.put("is_edit", fmTemplateSaveVo.getIsEdit());
            fmTemplateDb.setUseScene(fmTemplateSaveVo.getUseScene());
            oldJson.put("use_Scene", fmTemplateSaveVo.getUseScene());
            if (!StrUtils.isNull((Object)fmTemplateSaveVo.getDeliveryPlatform())) {
                fmTemplateDb.setDeliveryPlatform(fmTemplateSaveVo.getDeliveryPlatform());
                oldJson.put("delivery_platform", fmTemplateSaveVo.getDeliveryPlatform());
            }
            if (!StrUtils.isNull((Object)templateType)) {
                fmTemplateDb.setTemplateType(templateType);
                oldJson.put("template_type", templateType);
            }
            if (StrUtils.isNull((Object)collIdDb) || !collIdDb.equals(collId)) {
                Integer displayOrder = fmTemplate.getDisplayOrder();
                fmTemplateDb.setDisplayOrder(displayOrder);
                oldJson.put("display_order", displayOrder);
            }
            String embeddedJson = fmTemplateSaveVo.getEmbeddedJson();
            fmTemplateDb.setEmbeddedJson(embeddedJson);
            oldJson.put("embeddeds", fmTemplateSaveVo.getEmbeddeds());
            String templateCode = fmTemplateSaveVo.getTemplateCode();
            if (!StrUtils.isNull((Object)templateCode)) {
                String shortId = "_" + UUIDUtils.shortUUID(templateId);
                String startStr = "z_";
                templateCode = templateCode.replaceFirst(startStr, "").replace(shortId, "");
                fmTemplateDb.setTemplateCode(templateCode);
                oldJson.put("template_code", templateCode);
            }
            fmTemplateDb.setTemplateJson(JsonUtils.toJson((Object)oldJson));
            fmTemplateDb.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
            this.dao.update((AbsModel)fmTemplateDb);
            CacheManager.remove((String)("template_" + templateId));
            CacheManager.remove((String)("template_limit" + templateId));
            msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg createFormTemplate(FmTemplate fmTemplate) {
        Ulog.info((String)("\u521b\u5efa\u8868\u5355\u7684\u53c2\u6570\u4e3a:" + JsonUtils.toJson((Object)((Object)fmTemplate))));
        Return msg = new Return();
        String templateId = fmTemplate.getTemplateId();
        FmTemplate fmTemplateCheck = new FmTemplate();
        fmTemplateCheck.where().addEq(FmTemplate.TEMPLATE_NAME, (Object)fmTemplate.getTemplateName());
        fmTemplateCheck.where().addEq(FmTemplate.COLL_ID, (Object)fmTemplate.getCollId());
        fmTemplateCheck.where().addNotEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        fmTemplateCheck.where().addEq(FmTemplate.USE_SCENE, (Object)fmTemplate.getUseScene());
        List all = this.dao.findAll((AbsModel)fmTemplateCheck);
        if (CollectionUtils.isNotEmpty((Collection)all)) {
            msg.setFailMsg(new Message("6020005", "\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u91cd\u590d"));
            return msg.msg();
        }
        FmTemplate fmTemplateDb = (FmTemplate)this.dao.findOne(FmTemplate.n().where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId).model());
        if (fmTemplateDb != null && Objects.equals("ON", fmTemplateDb.getState())) {
            msg.setFailMsg(new Message("6020004", "\u9875\u9762\u72b6\u6001\u5904\u4e8e\u4f7f\u7528\u72b6\u6001\uff0c\u4e0d\u53ef\u8fdb\u884c\u4fee\u6539/\u5220\u9664"));
            return msg.msg();
        }
        String templateCode = fmTemplate.getTemplateCode();
        if (StrUtils.isNull((Object)templateCode)) {
            fmTemplate.setTemplateCode("z_" + UUIDUtils.shortUUID(templateId));
        } else {
            if (!templateCode.matches("[a-zA-Z0-9]+")) {
                msg.setFailMsg(new Message("6020009", "\u9875\u9762\u7f16\u7801\u683c\u5f0f\u9519\u8bef"));
                return msg.msg();
            }
            fmTemplate.setTemplateCode("z_" + templateCode + "_" + UUIDUtils.shortUUID(templateId));
        }
        Map<String, String> typeMap = this.fmAttributesTypeService.getAttrMap();
        ArrayList<FmTemplateAttributes> dataList = new ArrayList<FmTemplateAttributes>();
        if (Objects.isNull(fmTemplate.getJson())) {
            msg.setFailMsg(new Message("6020001", "json\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        JSONObject json = fmTemplate.getJson();
        Ulog.info((String)("\u524d\u7aef\u4f20\u5165\u6a21\u677f\u8868\u7684json\u4fe1\u606f\u4e3a:" + json));
        HashMap<String, String> attrCodeMap = new HashMap<String, String>();
        this.dynamicFormService.recursionAttr(json.getJSONArray(PageBaseEnum.JsonContentEnum.CONTENT.getType()), dataList, typeMap, templateId, "0", attrCodeMap);
        fmTemplate.setAttrList(dataList);
        if (Objects.nonNull((Object)fmTemplateDb)) {
            return this.dynamicFormService.updateFormTemplate(fmTemplate, fmTemplateDb, dataList, typeMap);
        }
        return this.dynamicFormService.createFormTemplate(fmTemplate, fmTemplateDb, null, typeMap);
    }

    @Override
    public ReturnMsg queryTemplateList(FmTemplateVo fmTemplateVo) {
        int i;
        Return msg = new Return();
        QueryTagsRelationParam tag = new QueryTagsRelationParam();
        tag.setRelationTab("fm_template");
        tag.setRelationField("template_id");
        tag.setTagBelongs(fmTemplateVo.getTagBelongs());
        tag.setTagsId(fmTemplateVo.getTagIds());
        ReturnMsg msgTag = this.iWtIssueService.queryTagsRelation(tag);
        List tagsList = msgTag.getDataList(QueryTagsRelationReturn.class);
        List idList = null;
        Map<Object, Object> listMaps = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)tagsList)) {
            idList = tagsList.stream().map(QueryTagsRelationReturn::getRelationFk).collect(Collectors.toList());
            listMaps = tagsList.stream().collect(Collectors.groupingBy(QueryTagsRelationReturn::getRelationFk));
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        stringBuilder.append("select t.template_id template_id,t.template_code template_code,t.template_name template_name,t.use_scene use_scene,t.delivery_platform delivery_platform,t.embedded_json embedded_json,");
        stringBuilder.append("t.template_type template_type,t.crt_user crt_user,t.crt_date crt_date,t.state state,t.is_edit , ");
        stringBuilder.append("c.coll_id coll_id,c.coll_name coll_name, c.render_method render_method ");
        stringBuilder.append("from fm_template t left join fm_collection c on t.coll_id = c.coll_id where t.data_flag  = ? ");
        stringBuilder.append("and t.template_id not in (select distinct template_id from fm_node_template) ");
        list.add("1");
        if (Objects.equals(fmTemplateVo.getTemplateBelongs(), "form") && StrUtils.isNull((Object)fmTemplateVo.getCollId())) {
            msg.setFailMsg("\u6a21\u5757id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        List tagIdsList = idList;
        List<String> tagIds = fmTemplateVo.getTagIds();
        if (CollectionUtils.isNotEmpty(tagIds)) {
            if (CollectionUtils.isEmpty(tagIdsList)) {
                List templateListnull = null;
                msg.setDataList(templateListnull);
                msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
                return msg.msg();
            }
            stringBuilder.append(" and t.template_id  in ( ");
            for (int i2 = 0; i2 < tagIdsList.size(); ++i2) {
                if (i2 == tagIdsList.size() - 1) {
                    stringBuilder.append(" ?  ");
                } else {
                    stringBuilder.append(" ?,  ");
                }
                list.add((String)tagIdsList.get(i2));
            }
            stringBuilder.append(")");
        }
        if (!StrUtils.isNull((Object)fmTemplateVo.getDeliveryPlatform())) {
            String deliveryPlatformList = fmTemplateVo.getDeliveryPlatform();
            String[] platformList = deliveryPlatformList.split(",");
            List<String> platformIdList = Arrays.asList(platformList);
            stringBuilder.append(" and ( ");
            for (i = 0; i < platformIdList.size(); ++i) {
                if (i == platformIdList.size() - 1) {
                    stringBuilder.append(" t.delivery_platform like ? ");
                    list.add("%" + platformIdList.get(i) + "%");
                    continue;
                }
                stringBuilder.append(" t.delivery_platform like ?  or ");
                list.add("%" + platformIdList.get(i) + "%");
            }
            stringBuilder.append(")");
        }
        if (!StrUtils.isNull((Object)fmTemplateVo.getTemplateType())) {
            stringBuilder.append("and t.template_type = ? ");
            list.add(fmTemplateVo.getTemplateType());
        }
        if (!StrUtils.isNull((Object)fmTemplateVo.getCollId())) {
            stringBuilder.append("and t.coll_id = ? ");
            list.add(fmTemplateVo.getCollId());
        }
        if (!StrUtils.isNull((Object)fmTemplateVo.getTemplateId())) {
            stringBuilder.append("and t.template_id = ? ");
            list.add(fmTemplateVo.getTemplateId());
        }
        if (!StrUtils.isNull((Object)fmTemplateVo.getUseScene())) {
            String useSceneList = fmTemplateVo.getUseScene();
            String[] useList = useSceneList.split(",");
            List<String> useSceneIdList = Arrays.asList(useList);
            stringBuilder.append(" and t.use_scene  in ( ");
            for (i = 0; i < useSceneIdList.size(); ++i) {
                if (i == useSceneIdList.size() - 1) {
                    stringBuilder.append(" ?  ");
                } else {
                    stringBuilder.append(" ?,  ");
                }
                list.add(useSceneIdList.get(i));
            }
            stringBuilder.append(")");
        }
        if (!StrUtils.isNull((Object)fmTemplateVo.getIsEdit())) {
            stringBuilder.append("and t.is_edit  = ?  ");
            list.add(fmTemplateVo.getIsEdit());
        }
        if (!StrUtils.isNull((Object)fmTemplateVo.getTemplateName())) {
            stringBuilder.append("and t.template_name like ? ");
            list.add("%" + fmTemplateVo.getTemplateName() + "%");
        }
        if (!StrUtils.isNull((Object)fmTemplateVo.getTemplateBelongs())) {
            stringBuilder.append("and t.template_belongs = ?   ");
            list.add(fmTemplateVo.getTemplateBelongs());
        }
        if (StringUtils.isNotBlank((CharSequence)fmTemplateVo.getCrtDateEnd()) && StringUtils.isNotBlank((CharSequence)fmTemplateVo.getCrtDateStart())) {
            stringBuilder.append("and g.crt_date between '" + fmTemplateVo.getCrtDateStart() + "'  and  '" + fmTemplateVo.getCrtDateEnd() + "' ");
        }
        stringBuilder.append("order by t.crt_date desc,");
        stringBuilder.append("t.template_id desc");
        List templateList = "Y".equals(fmTemplateVo.getAllFlag()) ? this.dao.findAll(stringBuilder.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(list)}) : this.dao.findAll(stringBuilder.toString(), Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(list)});
        Map<Object, Object> finalListMaps = listMaps;
        templateList.stream().forEach(o -> {
            if (CollectionUtils.isNotEmpty((Collection)((Collection)finalListMaps.get(o.get("template_id"))))) {
                o.put("tags", finalListMaps.get(o.get("template_id")));
            }
            if (ObjectUtil.isNotEmpty(o.get("embedded_json"))) {
                o.put("embeddeds", JsonUtils.json2List((String)((String)o.get("embedded_json"))));
            }
        });
        msg.getDataTable().put("templateList", templateList);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteFormTemplate(FmTemplateVo fmTemplateVo) {
        Return msg = new Return();
        List<FmTemplateVo.FmTemplateIdVo> idList = fmTemplateVo.getIdList();
        List templateIds = idList.stream().map(FmTemplateVo.FmTemplateIdVo::getTemplateId).collect(Collectors.toList());
        FmNode fmNode = new FmNode();
        fmNode.where().addIn(FmNode.RELATE_FK, templateIds);
        List fmNodeDb = this.dao.findAll((AbsModel)fmNode);
        if (CollectionUtils.isNotEmpty((Collection)fmNodeDb)) {
            msg.setFailMsg(new Message("6020010", "\u5df2\u7ecf\u5173\u8054\u6d41\u7a0b\u7684\u9875\u9762\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01"));
            return msg.msg();
        }
        for (FmTemplateVo.FmTemplateIdVo idVo : idList) {
            FmTemplate fmTemplate = new FmTemplate();
            if (!StrUtils.isNull((Object)idVo.getCollId())) {
                fmTemplate.where().addEq(FmTemplate.COLL_ID, (Object)idVo.getCollId());
            }
            fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)idVo.getTemplateId());
            FmTemplate fmTemplateDb = (FmTemplate)this.dao.findOne((AbsModel)fmTemplate);
            if (fmTemplateDb != null && Objects.equals("ON", fmTemplateDb.getState())) {
                msg.setFailMsg(new Message("6020004", fmTemplateDb.getTemplateName() + ":" + "\u9875\u9762\u72b6\u6001\u5904\u4e8e\u4f7f\u7528\u72b6\u6001\uff0c\u4e0d\u53ef\u8fdb\u884c\u4fee\u6539/\u5220\u9664"));
                return msg.msg();
            }
            if (!StrUtils.isNull((Object)idVo.getCollId())) {
                fmTemplate.where().addEq(FmTemplate.COLL_ID, (Object)idVo.getCollId());
            }
            fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)idVo.getTemplateId());
            this.dao.delete((AbsModel)fmTemplate);
            FmTemplateAttributes fmTemplateAttributes = new FmTemplateAttributes();
            fmTemplateAttributes.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)fmTemplate.getTemplateId());
            this.dao.delete((AbsModel)fmTemplateAttributes);
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg getFormJsonByTemplateId(FmJsonReqParam fmJsonReqParam) {
        Return msg = new Return();
        FmTemplate fmTemplate = new FmTemplate();
        String templateId = fmJsonReqParam.getTemplateId();
        fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        FmTemplate fmTemplateDb = (FmTemplate)this.dao.findOne((AbsModel)fmTemplate);
        if (StrUtils.isNull((Object)((Object)fmTemplateDb))) {
            msg.setSuccessMsg(new Message("2010007", "\u67e5\u8be2\u6210\u529f\uff08\u65e0\u6570\u636e\uff09"));
            return msg.msg();
        }
        ArrayList<QueryTagsRelationReturn> tagsList = new ArrayList<QueryTagsRelationReturn>();
        this.setTagsList(templateId, tagsList);
        fmTemplateDb.setTagsList(tagsList);
        String formJson = "";
        String templateType = fmTemplateDb.getTemplateType();
        String templateBelongs = fmTemplateDb.getTemplateBelongs();
        if (("inform".equals(templateType) || "qsn".equals(templateType)) && "form".equals(templateBelongs)) {
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<String> list = new ArrayList<String>();
            stringBuilder.append("select qtr.paper_uuid,qtr.relation_uuid,qtr.child_uuid,qtr.display_order relation_order,qq.* ");
            stringBuilder.append("from qsn_title_relation qtr left join qsn_paper_template qpt ");
            stringBuilder.append("on qtr.paper_uuid = qpt.paper_uuid ");
            stringBuilder.append("left join qsn_questions qq on ");
            stringBuilder.append("qtr.qsn_uuid = qq.qsn_uuid ");
            stringBuilder.append("where qpt.template_id = ? and qq.qsn_uuid is not null ");
            stringBuilder.append("order by qq.qsn_class,qtr.display_order ");
            list.add(templateId);
            List qtrList = this.dao.findAll(stringBuilder.toString(), PackageQsnParam.class, new AbsModelRepository.Args[]{this.dao.args(list)});
            if (CollectionUtils.isEmpty((Collection)qtrList)) {
                msg.setFailMsg(new Message("2010008", "\u8bf7\u7ba1\u7406\u9898\u76ee\u540e\u8fdb\u884c\u9875\u9762\u8bbe\u8ba1"));
                return msg.msg();
            }
            formJson = this.getInformFormJson(fmJsonReqParam, fmTemplateDb, qtrList, "Y", null);
        } else {
            formJson = this.getFormJson(fmJsonReqParam, fmTemplateDb, null);
        }
        msg.getDataTable().put("fromJson", formJson);
        msg.getDataTable().put("tagsList", tagsList);
        String collId = fmTemplateDb.getCollId();
        if (!StrUtils.isNull((Object)collId)) {
            FmCollection fmCollection = new FmCollection();
            fmCollection.where().addEq(FmCollection.COLL_ID, (Object)collId);
            FmCollection fmCollectionDb = (FmCollection)this.dao.findOne((AbsModel)fmCollection);
            msg.getDataTable().put("coll_name", fmCollectionDb.getCollName());
            msg.getDataTable().put("render_method", fmCollectionDb.getRenderMethod());
        }
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    private String getInformFormJson(FmJsonReqParam fmJsonReqParam, FmTemplate fmTemplateDb, List<PackageQsnParam> qtrList, String isSave, FmJsonAndValueVo fmJsonAndValueVo) {
        String templateJson = fmTemplateDb.getTemplateJson();
        String templateId = fmJsonReqParam.getTemplateId();
        String formJson = templateJson;
        FmTemplateAttributes fmAttr = new FmTemplateAttributes();
        fmAttr.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).addEq(FmTemplateAttributes.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        fmAttr.setOrderBy(FmTemplateAttributes.DISPLAY_ORDER.asc());
        List attrAll = this.dao.findAll((AbsModel)fmAttr);
        ArrayList<FmTemplateAttributes> fmAttrList = new ArrayList<FmTemplateAttributes>();
        String templateType = fmTemplateDb.getTemplateType();
        if (CollectionUtils.isEmpty((Collection)attrAll)) {
            for (PackageQsnParam qtr : qtrList) {
                int order = 0;
                String qsnUuid = qtr.getQsnUuid();
                String childUuid = qtr.getChildUuid() == null ? "" : qtr.getChildUuid();
                QsnQuestions qsn = new QsnQuestions();
                BeanUtils.copyProperties((Object)((Object)qtr), (Object)((Object)qsn));
                order = this.packageQsn(fmAttrList, qsnUuid, order, templateId, qsn, isSave, templateType);
                if (StrUtils.isNull((Object)childUuid)) continue;
                QsnQuestions queryChild = new QsnQuestions();
                queryChild.where().addEq(QsnQuestions.UP_QUESTION_ID, (Object)qsnUuid);
                List<String> qsnUuidList = Arrays.asList(childUuid.split(","));
                queryChild.where().addIn(QsnQuestions.QSN_UUID, qsnUuidList);
                queryChild.setOrderBy(QsnQuestions.DISPLAY_ORDER.asc());
                List childQq = this.dao.findAll((AbsModel)queryChild);
                if (!CollectionUtils.isNotEmpty((Collection)childQq)) continue;
                for (QsnQuestions qq : childQq) {
                    order = this.packageQsn(fmAttrList, qq.getQsnUuid(), order, templateId, qq, isSave, templateType);
                }
            }
        } else {
            ArrayList delIdList = new ArrayList();
            ArrayList<FmTemplateAttributes> updateAttrList = new ArrayList<FmTemplateAttributes>();
            for (FmTemplateAttributes oldFta : attrAll) {
                boolean delFlag = true;
                String aQsnUuid = JsonUtils.json2Map((String)oldFta.getAttrJson()).get("qsn_uuid") == null ? "" : JsonUtils.json2Map((String)oldFta.getAttrJson()).get("qsn_uuid").toString();
                block3: for (PackageQsnParam qtr : qtrList) {
                    String qsnUuid = qtr.getQsnUuid();
                    String childUuid = qtr.getChildUuid() == null ? "" : qtr.getChildUuid();
                    List childQq = qtr.getChildQq();
                    if (CollectionUtils.isEmpty(qtr.getChildQq()) && !StrUtils.isNull((Object)childUuid)) {
                        QsnQuestions queryChild = new QsnQuestions();
                        queryChild.where().addEq(QsnQuestions.UP_QUESTION_ID, (Object)qsnUuid);
                        List<String> qsnUuidList = Arrays.asList(childUuid.split(","));
                        queryChild.where().addIn(QsnQuestions.QSN_UUID, qsnUuidList);
                        queryChild.setOrderBy(QsnQuestions.DISPLAY_ORDER.asc());
                        childQq = this.dao.findAll((AbsModel)queryChild);
                        qtr.setChildQq(childQq);
                    }
                    if (aQsnUuid.equals(qsnUuid)) {
                        delFlag = false;
                        oldFta.setQsnUuid(aQsnUuid);
                        updateAttrList.add(oldFta);
                        qtr.setOldAttr(oldFta);
                    }
                    if (!CollectionUtils.isNotEmpty(childQq)) continue;
                    for (QsnQuestions qq : childQq) {
                        String childQsnUuid = qq.getQsnUuid();
                        if (!childQsnUuid.equals(aQsnUuid)) continue;
                        delFlag = false;
                        oldFta.setQsnUuid(aQsnUuid);
                        updateAttrList.add(oldFta);
                        qq.setOldAttr(oldFta);
                        qtr.setChildQq(childQq);
                        break block3;
                    }
                }
                if (!delFlag) continue;
                delIdList.add(oldFta.getAttrId());
            }
            Ulog.info((String)("\u7ec4\u88c5\u597d\u7684qtrnew--->" + JsonUtils.toJson(qtrList)));
            for (PackageQsnParam qtr : qtrList) {
                int order = 0;
                String qsnUuid = qtr.getQsnUuid();
                QsnQuestions qsn = new QsnQuestions();
                BeanUtils.copyProperties((Object)((Object)qtr), (Object)((Object)qsn));
                order = this.packageQsn(fmAttrList, qsnUuid, order, templateId, qsn, isSave, templateType);
                List<QsnQuestions> childQq = qtr.getChildQq();
                if (!CollectionUtils.isNotEmpty(childQq)) continue;
                for (QsnQuestions qq : childQq) {
                    String childQsnUuid = qq.getQsnUuid();
                    order = this.packageQsn(fmAttrList, childQsnUuid, order, templateId, qq, isSave, templateType);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)delIdList) && "Y".equals(isSave)) {
                FmTemplateAttributes delFta = new FmTemplateAttributes();
                delFta.where().addIn(FmTemplateAttributes.ATTR_ID, (List)delIdList);
                this.dao.delete((AbsModel)delFta);
            }
        }
        for (String key : CacheManager.keys((String)("qsn_" + templateType + "_component*"))) {
            Ulog.info((String)("\u6e05\u9664\u7f13\u5b58--->" + key));
            CacheManager.remove((String)key);
        }
        if (!fmAttrList.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner(",");
            ArrayList<FmAttrVo> fmAttrVos = new ArrayList<FmAttrVo>();
            for (FmTemplateAttributes s : fmAttrList) {
                stringJoiner.add(s.getAttrJson());
                FmAttrVo fa = new FmAttrVo();
                fa.setAttrId(s.getAttrId());
                fa.setIsComponent(s.getIsComponent());
                fa.setCAttrId(s.getCAttrId());
                fa.setExcludeIds(s.getExcludeIds());
                fmAttrVos.add(fa);
            }
            fmJsonReqParam.setAttrList(fmAttrVos);
            String json = "{    \"content\": [" + stringJoiner;
            formJson = json + templateJson.replaceFirst("\\{", "],");
        }
        if (Objects.equals("Y", fmTemplateDb.getIsCreateTable()) && fmJsonAndValueVo != null) {
            String formValue = "";
            formValue = "Y".equals(isSave) ? this.getFormValue(fmJsonReqParam, fmAttrList, fmTemplateDb.getTemplateCode()) : this.getFormValue(fmJsonReqParam, attrAll, fmTemplateDb.getTemplateCode());
            if (!StrUtils.isNull((Object)formValue)) {
                fmJsonAndValueVo.setFormValue(formValue);
            }
        }
        return formJson;
    }

    private int packageQsn(List<FmTemplateAttributes> fmAttrList, String qsnUuid, int order, String templateId, QsnQuestions qsnQuestions, String isSave, String templateType) {
        QsnQuestionsInfo qsnQuestionsInfo = new QsnQuestionsInfo();
        FmTemplateAttributes oldFta = qsnQuestions.getOldAttr();
        qsnQuestions.setOldAttr(null);
        qsnQuestionsInfo.setQsnQuestions(qsnQuestions);
        qsnQuestionsInfo.load(qsnUuid, "N");
        String qsnType = qsnQuestionsInfo.getQsnQuestions().getQsnType();
        String cacheKey = "qsn_" + templateType + "_component:" + qsnType;
        Component component = new Component();
        List<Object> caList = new ArrayList();
        if (!StrUtils.isNull((Object)CacheManager.get((String)cacheKey))) {
            ComponentJsonVo componentJsonVo = (ComponentJsonVo)((Object)CacheManager.get((String)cacheKey, ComponentJsonVo.class));
            BeanUtils.copyProperties((Object)((Object)componentJsonVo), (Object)((Object)component));
            caList = componentJsonVo.getAttributeList();
        } else {
            Component componentQuery = new Component();
            componentQuery.where().addEq(Component.COMPONENT_TYPE, (Object)qsnType);
            componentQuery.where().addEq(Component.COMPONENT_CLASS, (Object)templateType);
            componentQuery.where().addEq(Component.DATA_FLAG, (Object)"1");
            component = (Component)this.dao.findOne((AbsModel)componentQuery);
            ComponentAttribute ca = new ComponentAttribute();
            ca.where().addEq(ComponentAttribute.COMPONENT_ID, (Object)component.getComponentId());
            ca.where().addEq(ComponentAttribute.DATA_FLAG, (Object)"1");
            caList = this.dao.findAll((AbsModel)ca);
            ComponentJsonVo componentJsonVo = new ComponentJsonVo();
            BeanUtils.copyProperties((Object)((Object)component), (Object)((Object)componentJsonVo));
            componentJsonVo.setAttributeList(caList);
            CacheManager.put((String)cacheKey, (Object)((Object)componentJsonVo));
        }
        if (StrUtils.isNull((Object)((Object)component))) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7ec4\u4ef6");
        }
        ComponentVo componentVo = new ComponentVo();
        BeanUtils.copyProperties((Object)((Object)component), (Object)componentVo);
        Map attrJsonMap = JsonUtils.json2Map((String)JsonUtils.toJson((Object)componentVo));
        String componentName = component.getComponentName();
        String componentType = component.getComponentType();
        Map oldAttrMap = new HashMap();
        String attrId = "";
        if (StrUtils.isNull((Object)((Object)oldFta))) {
            attrId = UUID.uuid();
        } else {
            attrId = oldFta.getAttrId();
            String attrJson = oldFta.getAttrJson();
            oldAttrMap = JsonUtils.json2Map((String)attrJson);
        }
        ArrayList<AttributeVo> attributeVos = new ArrayList<AttributeVo>();
        if (CollectionUtils.isNotEmpty(caList)) {
            for (ComponentAttribute componentAttribute : caList) {
                String attributeCode = componentAttribute.getAttributeCode();
                attrJsonMap.put(attributeCode, oldAttrMap.get(attributeCode));
                AttributeVo attributeVo = new AttributeVo();
                attributeVo.setKey(attributeCode);
                attributeVo.setLabel(componentAttribute.getAttributeName());
                attributeVo.setType(componentAttribute.getAttributeType());
                attributeVo.setAttribute_classify(componentAttribute.getAttributeClassify());
                attributeVo.setPrivilegeLevel(componentAttribute.getPrivilegeLevel());
                attributeVo.setAttributeDesc(componentAttribute.getAttributeDesc());
                List attributeMultiVos = JSONObject.parseArray((String)componentAttribute.getAttributeMulti(), AttributeMultiVo.class);
                for (AttributeMultiVo vo : attributeMultiVos) {
                    String[] split;
                    String attributeValue = vo.getAttributeValue();
                    if (StrUtils.isNull((Object)attributeValue)) continue;
                    ArrayList<Map<String, Object>> aOptionList = new ArrayList<Map<String, Object>>();
                    for (String item : split = attributeValue.split("\n")) {
                        if (StrUtils.isNull((Object)item)) continue;
                        HashMap<String, String> aOption = new HashMap<String, String>();
                        String[] optionSplit = item.split("#");
                        aOption.put("label", optionSplit[0]);
                        aOption.put("value", optionSplit.length > 1 ? optionSplit[1] : optionSplit[0]);
                        aOptionList.add(aOption);
                    }
                    vo.setOption(aOptionList);
                }
                attributeVo.setElements(attributeMultiVos);
                attributeVos.add(attributeVo);
            }
        }
        attrJsonMap.put("key", attrId);
        attrJsonMap.put("attr_id", attrId);
        attrJsonMap.put("qsn_uuid", qsnUuid);
        attrJsonMap.put("attr_name", componentName);
        attrJsonMap.put("component_type", componentType);
        attrJsonMap.put("label", componentName);
        attrJsonMap.put("type", componentType);
        attrJsonMap.put("options", attributeVos);
        if (StrUtils.isNull((Object)((Object)oldFta))) {
            FmTemplateAttributes fta = new FmTemplateAttributes();
            fta.setTemplateId(templateId);
            fta.setAttrId(attrId);
            String string = PinYin4JUtils.converterToFirstSpell(componentName);
            Random random = new Random();
            int i = 10000000 + random.nextInt(90000000);
            attrJsonMap.put("attr_code", string + i);
            fta.setAttrCode(string + i);
            fta.setAttrName(componentName);
            fta.setDisplayOrder(order);
            fta.setComponentType(componentType);
            fta.setAttrLength(128);
            fta.setIsColumn(this.templateConfig.getFromExcludeColumn().contains(componentType) ? "N" : "Y");
            fta.setAttrJson(JsonUtils.toJson((Object)attrJsonMap));
            fta.setUpAttr("0");
            if ("Y".equals(isSave)) {
                this.dao.save((AbsModel)fta);
            }
            attrJsonMap.put("qsnQuestionsInfo", qsnQuestionsInfo);
            fta.setAttrJson(JsonUtils.toJson((Object)attrJsonMap));
            fmAttrList.add(fta);
        } else {
            attrJsonMap.put("attr_code", oldFta.getAttrCode());
            oldFta.setTemplateId(templateId);
            oldFta.setAttrName(componentName);
            oldFta.setDisplayOrder(order);
            oldFta.setComponentType(componentType);
            oldFta.setIsColumn(this.templateConfig.getFromExcludeColumn().contains(componentType) ? "N" : "Y");
            oldFta.setAttrJson(JsonUtils.toJson((Object)attrJsonMap));
            oldFta.setUpAttr("0");
            oldFta.where().addEq(FmTemplateAttributes.ATTR_ID, (Object)attrId);
            if ("Y".equals(isSave)) {
                this.dao.update((AbsModel)oldFta);
            }
            attrJsonMap.put("qsnQuestionsInfo", qsnQuestionsInfo);
            oldFta.setAttrJson(JsonUtils.toJson((Object)attrJsonMap));
            fmAttrList.add(oldFta);
        }
        return ++order;
    }

    @Override
    public ReturnMsg getFormJsonAndRule(FmJsonReqParam fmJsonReqParam) {
        Return msg = new Return();
        FmTemplate fmTemplate = new FmTemplate();
        FmJsonAndValueVo fmJsonAndValueVo = new FmJsonAndValueVo();
        String templateId = fmJsonReqParam.getTemplateId();
        fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        FmTemplate fmTemplateDb = (FmTemplate)this.dao.findOne((AbsModel)fmTemplate);
        if (StrUtils.isNull((Object)((Object)fmTemplateDb))) {
            msg.setSuccessMsg(new Message("2010007", "\u67e5\u8be2\u6210\u529f\uff08\u65e0\u6570\u636e\uff09"));
            return msg.msg();
        }
        fmJsonReqParam.setIsPackageQsn("N");
        String formJson = this.getFormJsonAndAttr(fmJsonReqParam, fmTemplateDb, fmJsonAndValueVo);
        this.getRule(fmJsonReqParam, fmJsonAndValueVo);
        msg.getDataTable().put("attrRules", fmJsonAndValueVo.getAttrRules());
        msg.getDataTable().put("formRules", fmJsonAndValueVo.getFormRules());
        return msg.msg();
    }

    @Override
    public void setTagsList(String templateId, List<QueryTagsRelationReturn> tagsList) {
        StringBuilder sql2 = new StringBuilder();
        ArrayList<String> sqlParam2 = new ArrayList<String>();
        sql2.append("select\n\tsm.relation_tab ,\n\tsm.relation_field ,\n\tsm.relation_fk ,\n\tsm.tag_belongs ,\n\tst.tag_id ,\n\tst.tag_name ,\n\tst.tag_categories\nfrom\n\tscpz_material_tags_relation sm\nleft join scpz_tags st on\n\tsm.tag_id = st.tag_id\nwhere 1=1  ");
        sql2.append(" and sm.relation_tab = ? ");
        sql2.append(" and sm.relation_field = ? ");
        sql2.append(" and sm.relation_fk  = ? ");
        sqlParam2.add("fm_template");
        sqlParam2.add("template_id");
        sqlParam2.add(templateId);
        List mapList2 = this.dao.findAll(sql2.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(sqlParam2)});
        mapList2.stream().forEach(o -> {
            QueryTagsRelationReturn tagsRelationReturn = new QueryTagsRelationReturn();
            tagsRelationReturn.setRelationTab((String)o.get("relation_tab"));
            tagsRelationReturn.setRelationField((String)o.get("relation_field"));
            tagsRelationReturn.setRelationFk((String)o.get("relation_fk"));
            tagsRelationReturn.setTagBelongs((String)o.get("tag_belongs"));
            tagsRelationReturn.setTagId((String)o.get("tag_id"));
            tagsRelationReturn.setTagName((String)o.get("tag_name"));
            tagsRelationReturn.setTagCategories((String)o.get("tag_categories"));
            tagsList.add(tagsRelationReturn);
        });
    }

    @Override
    public ReturnMsg getFormJsonAndValue(FmJsonReqParam fmJsonReqParam) {
        Return msg = new Return();
        FmJsonAndValueVo fmJsonAndValueVo = new FmJsonAndValueVo();
        String pkUuid = ThreadLocalContext.get().getUser().getPkUuid();
        FmTemplate fmTemplate = new FmTemplate();
        String templateId = fmJsonReqParam.getTemplateId();
        fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        FmTemplate fmTemplateDb = (FmTemplate)this.dao.findOne((AbsModel)fmTemplate);
        if (StrUtils.isNull((Object)((Object)fmTemplateDb))) {
            msg.setFailMsg(new Message("6020011", "\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728"));
            return msg.msg();
        }
        fmJsonAndValueVo.setTemplateId(templateId);
        if (Objects.equals(fmTemplateDb.getTemplateBelongs(), "form") && !StrUtils.isNull((Object)fmTemplateDb.getCollId())) {
            String collId = fmTemplateDb.getCollId();
            String key = "coll_list:" + collId;
            Object object = CacheManager.get((String)key);
            FmCollectionRespVo fmCollectionRespVo = new FmCollectionRespVo();
            if (!StrUtils.isNull((Object)object)) {
                fmCollectionRespVo = (FmCollectionRespVo)JsonUtils.json2Class((String)JsonUtils.toJson((Object)object), FmCollectionRespVo.class);
            } else {
                FmCollection fmCollection = new FmCollection();
                fmCollection.where().addEq(FmTemplate.COLL_ID, (Object)collId);
                FmCollection fmCollectionDb = (FmCollection)this.dao.findOne((AbsModel)fmCollection);
                BeanUtils.copyProperties((Object)((Object)fmCollectionDb), (Object)fmCollectionRespVo);
                CacheManager.put((String)key, (Object)fmCollectionRespVo);
            }
            fmJsonAndValueVo.setFmCollection(fmCollectionRespVo);
        }
        fmJsonReqParam.setPkUuid(pkUuid);
        String authLimit = fmJsonReqParam.getAuthLimit();
        String formJson = this.getFormJsonAndAttr(fmJsonReqParam, fmTemplateDb, fmJsonAndValueVo);
        if (!StrUtils.isNull((Object)authLimit) && Objects.equals(authLimit, "1")) {
            String jsonForLimit = this.getFormJsonForLimit(fmJsonReqParam, fmTemplateDb);
            fmJsonAndValueVo.setFormJson(jsonForLimit);
        } else {
            fmJsonAndValueVo.setFormJson(formJson);
        }
        this.getRule(fmJsonReqParam, fmJsonAndValueVo);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.setDataTable(new Object[]{fmJsonAndValueVo}).msg();
    }

    @Override
    public FmJsonAndValueVo getPaperFormJsonAndValue(FmJsonReqParam fmJsonReqParam) {
        FmJsonAndValueVo fmJsonAndValueVo = new FmJsonAndValueVo();
        String pkUuid = ThreadLocalContext.get().getUser().getPkUuid();
        FmTemplate fmTemplate = new FmTemplate();
        String templateId = fmJsonReqParam.getTemplateId();
        fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        FmTemplate fmTemplateDb = (FmTemplate)this.dao.findOne((AbsModel)fmTemplate);
        fmJsonReqParam.setPkUuid(pkUuid);
        String authLimit = fmJsonReqParam.getAuthLimit();
        String formJson = this.getFormJsonAndAttr(fmJsonReqParam, fmTemplateDb, fmJsonAndValueVo);
        if (!StrUtils.isNull((Object)authLimit) && Objects.equals(authLimit, "1")) {
            String jsonForLimit = this.getFormJsonForLimit(fmJsonReqParam, fmTemplateDb);
            fmJsonAndValueVo.setFormJson(jsonForLimit);
        } else {
            fmJsonAndValueVo.setFormJson(formJson);
        }
        if (CollectionUtils.isNotEmpty(fmJsonReqParam.getAttrList())) {
            this.getRule(fmJsonReqParam, fmJsonAndValueVo);
        }
        return fmJsonAndValueVo;
    }

    @Override
    public List<FmTemplateAttributes> getAttrByTemplateId(String templateId) {
        Return msg = new Return();
        List fmAttrAll = (List)CacheManager.get((String)("fm_attributes_list_all_" + templateId));
        if (CollectionUtils.isEmpty((Collection)fmAttrAll)) {
            FmTemplateAttributes fmAttr = new FmTemplateAttributes();
            fmAttr.select(FmTemplateAttributes.ATTR_ID, FmTemplateAttributes.ATTR_NAME, FmTemplateAttributes.COMPONENT_TYPE).where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).addEq(FmTemplateAttributes.DATA_FLAG, (Object)"1");
            fmAttrAll = this.dao.findAll((AbsModel)fmAttr);
            CacheManager.expire((String)("fm_attributes_list_all_" + templateId), (long)604800L);
        }
        return fmAttrAll;
    }

    @Override
    public ReturnMsg updateState(FmTemplateVo fmTemplateVo) {
        Return msg = new Return();
        FmTemplate fmTemplate = new FmTemplate();
        fmTemplate.setState(fmTemplateVo.getState());
        String templateId = fmTemplateVo.getTemplateId();
        fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        this.dao.update((AbsModel)fmTemplate);
        CacheManager.remove((String)("template_" + templateId));
        CacheManager.remove((String)("template_limit" + templateId));
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg copyFormTemplate(FmTemplateVo fmTemplateVo) {
        Return msg = new Return();
        String templateId = fmTemplateVo.getTemplateId();
        if (StrUtils.isNull((Object)templateId)) {
            msg.setFailMsg(new Message("6020006", "\u9875\u9762id\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        FmTemplate fmTemplate = new FmTemplate();
        fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        FmTemplate fmTemplateDb = (FmTemplate)this.dao.findOne((AbsModel)fmTemplate);
        BeanUtils.copyProperties((Object)((Object)fmTemplateDb), (Object)((Object)fmTemplate));
        String templateName = fmTemplate.getTemplateName();
        String templateNameNew = fmTemplateVo.getTemplateName();
        String templateIdNew = UUID.uuid();
        if (!StrUtils.isNull((Object)fmTemplateVo.getTemplateIdNew())) {
            templateIdNew = fmTemplateVo.getTemplateIdNew();
            templateNameNew = templateName + "_" + templateIdNew;
            fmTemplate.setState("OFF");
        }
        if (StrUtils.isNull((Object)templateNameNew)) {
            templateNameNew = templateName + "\u526f\u672c";
        } else if (!StrUtils.isNull((Object)fmTemplateVo.getCollId())) {
            List fmTemplates = this.dao.findAll(FmTemplate.n().where().addEq(FmTemplate.COLL_ID, (Object)fmTemplateVo.getCollId()).addEq(FmTemplate.TEMPLATE_NAME, (Object)templateNameNew).model());
            if (CollectionUtils.isNotEmpty((Collection)fmTemplates)) {
                msg.setFailMsg(new Message("6020005", "\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u91cd\u590d"));
                return msg.msg();
            }
        } else if (templateName.equals(templateNameNew)) {
            msg.setFailMsg(new Message("6020005", "\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u91cd\u590d"));
            return msg.msg();
        }
        String templateJson = fmTemplate.getTemplateJson();
        String serno = fmTemplate.getSerno();
        String sernoNew = UUID.snowId() + "";
        fmTemplate.setTemplateJson(templateJson.replaceAll(templateId, templateIdNew).replaceAll(serno, sernoNew).replaceAll(templateName, templateNameNew));
        fmTemplate.setCrtDate(new Date());
        if (!StrUtils.isNull((Object)fmTemplateVo.getCollId())) {
            if (!fmTemplateVo.getCollId().equals(fmTemplate.getCollId())) {
                fmTemplate.setTemplateJson(fmTemplate.getTemplateJson().replaceAll(fmTemplate.getCollId(), fmTemplateVo.getCollId()));
            }
            fmTemplate.setCollId(fmTemplateVo.getCollId());
        }
        fmTemplate.setTemplateName(templateNameNew);
        Ulog.info((String)(templateName + "--\u590d\u5236\u8868\u5355\u6a21\u677f\u5230--" + templateNameNew));
        fmTemplate.setTemplateId(templateIdNew);
        Ulog.info((String)(templateId + "\u590d\u5236\u8868\u5355\u6a21\u677f\u5230" + templateIdNew));
        fmTemplate.setSerno(sernoNew);
        Ulog.info((String)(serno + "\u590d\u5236\u8868\u5355\u6a21\u677f\u5230" + sernoNew));
        String templateCode = fmTemplate.getTemplateCode();
        String templateCodeNew = fmTemplate.getTemplateCode();
        if (!StrUtils.isNull((Object)templateCode)) {
            templateCodeNew = templateCode.substring(0, templateCode.lastIndexOf("_") + 1) + UUIDUtils.shortUUID(templateIdNew);
        }
        fmTemplate.setTemplateCode(templateCodeNew);
        this.dao.save((AbsModel)fmTemplate);
        ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)templateId);
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)"template_id");
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)"fm_template");
        List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation1);
        String finalTemplateIdNew = templateIdNew;
        scpzMaterialTagsRelationList.stream().forEach(o -> {
            String uUid = UUID.uuid();
            o.setRelationUuid(uUid);
            o.setRelationFk(finalTemplateIdNew);
            o.setCrtDate(new Date());
            o.setMdfDate(new Date());
        });
        this.dao.save(scpzMaterialTagsRelationList);
        this.copyFormAttr(templateId, fmTemplate);
        FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
        fkRulesReqParam.setRelateField("template_id");
        fkRulesReqParam.setRelateTab("fm_template");
        fkRulesReqParam.setRelateFk(templateId);
        List saveRuleUsedParams = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
        if (CollectionUtils.isNotEmpty((Collection)saveRuleUsedParams)) {
            for (SaveRuleUsedParam saveRuleUsedParam : saveRuleUsedParams) {
                saveRuleUsedParam.setRelateFk(templateIdNew);
                saveRuleUsedParam.setRuleId(null);
                this.ruleUsedService.saveRuleUsed(saveRuleUsedParam);
            }
        }
        if (CollectionUtils.isNotEmpty(fmTemplate.getAttrList()) && "Y".equals(fmTemplate.getIsCreateTable())) {
            Ulog.info((String)(templateId + "\u590d\u5236\u8868\u5355\u6a21\u677f\u5230" + templateIdNew + "\u5f00\u59cb\u521b\u5efa\u52a8\u6001\u8868"));
            Map<String, String> typeMap = this.fmAttributesTypeService.getAttrMap();
            this.dynamicFormService.createDBTable(fmTemplate.getAttrList(), typeMap, fmTemplate);
        }
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg copyAttrRule(List<AttrVo> attrVos) {
        List dsnRulesParams;
        Return msg = new Return();
        List oldAttrIds = attrVos.stream().map(AttrVo::getOldAttrId).collect(Collectors.toList());
        List dsnRules = this.dao.findAll(DsnRules.n().where().addEq(DsnRules.RELATE_TAB, (Object)"fm_template_attributes").addEq(DsnRules.RELATE_FIELD, (Object)"attr_id").addIn(DsnRules.RELATE_FK, oldAttrIds).model());
        List oldRuleIds = dsnRules.stream().map(DsnRules::getRuleId).collect(Collectors.toList());
        if (oldRuleIds.isEmpty()) {
            return msg.msg();
        }
        dsnRules.stream().forEach(o -> attrVos.stream().forEach(attrVo -> {
            if (o.getRelateFk().equals(attrVo.getOldAttrId())) {
                String newRuleId = UUID.uuid();
                attrVo.setOldRuleId(o.getRuleId());
                attrVo.setNewRuleId(newRuleId);
                o.setRelateFk(attrVo.getNewAttrId());
                o.setRuleId(newRuleId);
            }
        }));
        this.dao.save(dsnRules);
        List dsnRulesConsts = this.dao.findAll(DsnRulesConst.n().where().addIn(DsnRulesConst.RULE_ID, oldRuleIds).model());
        if (!dsnRulesConsts.isEmpty()) {
            dsnRulesConsts.stream().forEach(o -> attrVos.stream().forEach(attrVo -> {
                if (o.getRuleId().equals(attrVo.getOldRuleId())) {
                    o.setRuleId(attrVo.getNewRuleId());
                    o.setSerno(null);
                }
            }));
            this.dao.save(dsnRulesConsts);
        }
        if (!(dsnRulesParams = this.dao.findAll(DsnRulesParam.n().where().addIn(DsnRulesParam.RULE_ID, oldRuleIds).model())).isEmpty()) {
            dsnRulesParams.stream().forEach(o -> attrVos.stream().forEach(attrVo -> {
                if (o.getRuleId().equals(attrVo.getOldRuleId())) {
                    o.setRuleId(attrVo.getNewRuleId());
                    o.setSerno(null);
                }
            }));
            this.dao.save(dsnRulesParams);
        }
        return msg.msg();
    }

    @Override
    public void exportFindJson(String[] dataIdList, HttpServletResponse response) {
        SipProductSyncTask task = new SipProductSyncTask();
        task.setFuncModule("FORMTEMPLATE");
        task.setIsZipDel("1");
        task.setTaskType("EXP");
        task.setCrtDate(new Date());
        StringJoiner joiner = new StringJoiner(",");
        String zipFile = "";
        try {
            String currentTimeMillis = String.valueOf(System.currentTimeMillis());
            String basePath = this.templateConfig.getUploadFormCollectPath() + "/export/page/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis;
            String baseAddress = basePath + "/";
            if (dataIdList != null && dataIdList.length > 0) {
                ArrayList<ExportDataVo> exportDataVos = new ArrayList<ExportDataVo>();
                for (String id : dataIdList) {
                    ExportDataVo exportDataVo = new ExportDataVo();
                    FmTemplate fmTemplate = new FmTemplate();
                    fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)id);
                    fmTemplate = (FmTemplate)this.dao.findOne((AbsModel)fmTemplate);
                    joiner.add(fmTemplate.getTemplateName());
                    FmJsonReqParam reqVo = new FmJsonReqParam();
                    reqVo.setTemplateId(id);
                    fmTemplate.setAttrList(this.dynamicFormService.getAttrListJson(reqVo));
                    FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
                    fkRulesReqParam.setRelateField("template_id");
                    fkRulesReqParam.setRelateTab("fm_template");
                    fkRulesReqParam.setRelateFk(id);
                    List saveRuleUsedParamsList = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
                    fmTemplate.setRules(saveRuleUsedParamsList);
                    fmTemplate.setScpzMaterialTagsRelationList(this.tagsService.findScpzMaterialTagsRelationList(id, "template_id", "fm_template"));
                    exportDataVo.setName(fmTemplate.getTemplateName());
                    exportDataVo.setJson(JsonUtils.toJson((Object)((Object)fmTemplate)));
                    exportDataVos.add(exportDataVo);
                    MaterialDataList materialDataList = this.iFmFlowService.getMaterial(JsonUtils.json2Map((String)exportDataVo.getJson()));
                    exportDataVo.setMaterialDataList(materialDataList);
                    exportDataVos.add(exportDataVo);
                }
                for (ExportDataVo data : exportDataVos) {
                    FilesUtil.createFile(baseAddress + data.getName() + ".json");
                    FilesUtil.writeToFile(baseAddress + data.getName() + ".json", data.getJson(), false);
                    if (StrUtils.isNull((Object)data.getMaterialDataList()) || data.getMaterialDataList().getStringSet().isEmpty()) continue;
                    FilesUtil.createFile(baseAddress + "/" + data.getName() + "/fileList.txt");
                    FilesUtil.writeToFile(baseAddress + "/" + data.getName() + "/fileList.txt", JsonUtils.toJson((Object)data.getMaterialDataList()), false);
                    data.getMaterialDataList().getStringSet().stream().forEach(o -> {
                        try {
                            String[] str = new String[]{};
                            String objectPath = o;
                            if (o.contains("/smp/")) {
                                str = o.split("/smp/");
                                objectPath = str[str.length - 1];
                            }
                            if (o.contains("/pscp-service/")) {
                                str = o.split("/pscp-service/");
                                objectPath = str[str.length - 1];
                            }
                            InputStream inStream = this.hwyObsSDKUtis.getObject(objectPath);
                            String filePath = baseAddress + "/" + data.getName() + "/fileList/" + objectPath;
                            File file = new File(filePath);
                            if (!file.getParentFile().exists() || !file.isDirectory()) {
                                file.getParentFile().mkdirs();
                            }
                            BufferedInputStream in = null;
                            BufferedOutputStream out = null;
                            in = new BufferedInputStream(inStream);
                            out = new BufferedOutputStream(new FileOutputStream(filePath));
                            int len = -1;
                            byte[] b = new byte[1024];
                            while ((len = in.read(b)) != -1) {
                                out.write(b, 0, len);
                            }
                            in.close();
                            out.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
                zipFile = basePath + ".zip";
                Ulog.info((String)("baseAddress----" + baseAddress));
                Ulog.info((String)("zipFile----" + zipFile));
                String zip = FileUtils.zip((String)baseAddress, (String)zipFile, (String[])new String[]{".txt", ".json", ".xlsx", ".png", ".jpg", "jpeg", "gif", "mp4", "pdf"});
                Ulog.info((String)("zip----" + zip));
                File file = new File(zipFile);
                FileInputStream inputStream = new FileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                inputStream.read(data);
                inputStream.close();
                response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
                response.setContentType("application/octet-stream;charset=ISO8859-1");
                response.addHeader("Content-Length", "" + file.length());
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + ".zip", "UTF-8"));
                ServletOutputStream stream = response.getOutputStream();
                stream.write(data);
                stream.flush();
                stream.close();
                FilesUtil.delFile(baseAddress);
            }
            String taskName = joiner.toString();
            task.setTaskName(taskName);
            task.setTaskState("FINISH");
            task.setFinishDate(new Date());
            task.setZipPath(zipFile);
            this.dao.save((AbsModel)task);
        }
        catch (Exception e) {
            e.printStackTrace();
            String taskName = joiner.toString();
            task.setTaskName(taskName);
            task.setTaskState("FAIL");
            task.setErrorInfo(e.getMessage());
            task.setFinishDate(new Date());
            this.dao.save((AbsModel)task);
        }
    }

    @Override
    public ReturnMsg uploadJson(MultipartFile zipFile) {
        SipProductSyncTask task = new SipProductSyncTask();
        task.setCrtDate(new Date());
        String pathName = this.templateConfig.getUploadFormCollectPath() + "/upload/page/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = FilesUtil.unzipFile(zipFile, pathName);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
            return msg.msg();
        }
        Map<String, String> typeMap = this.fmAttributesTypeService.getAttrMap();
        if (typeMap == null) {
            msg.setFailMsg(new Message("6030003", "\u6570\u636e\u5e93\u7f3a\u5c11\u9875\u9762\u5bf9\u5e94\u5173\u7cfb"));
            return msg.msg();
        }
        File importDir = new File(pathName);
        ArrayList<File> fileList = new ArrayList<File>();
        FilesUtil.getAllFiles(importDir, fileList);
        Ulog.info((String)("\u83b7\u53d6\u9700\u8981\u8bfb\u53d6\u7684\u6587\u4ef6" + JsonUtils.toJson(fileList)));
        StringJoiner joiner = new StringJoiner(",");
        for (File file : fileList) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
                Throwable throwable = null;
                try {
                    int ch = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch = ((Reader)inputStreamReader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    String jsonStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u9875\u9762/\u4e1a\u52a1\u7ec4\u4ef6\u6570\u636e\u4e3a" + jsonStr));
                    FmTemplate fmTemplate = (FmTemplate)((Object)JsonUtils.json2Class((String)jsonStr, FmTemplate.class));
                    String templateId = fmTemplate.getTemplateId();
                    joiner.add(fmTemplate.getTemplateName());
                    FmTemplate fmTemplateDb = new FmTemplate();
                    fmTemplateDb.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
                    fmTemplateDb = (FmTemplate)this.dao.findOne((AbsModel)fmTemplateDb);
                    if (StrUtils.isNull((Object)((Object)fmTemplateDb))) {
                        fmTemplate.setCrtDate(new Date());
                        fmTemplate.setMdfDate(new Date());
                    } else {
                        fmTemplate.setMdfDate(new Date());
                    }
                    int tableCount = this.dao.delete(FmTemplate.n().where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId).model());
                    this.ruleUsedService.deleteByRelateFks(templateId, "fm_template");
                    FmTemplateAttributes attr = new FmTemplateAttributes();
                    attr.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId);
                    List allOldAttr = this.dao.findAll((AbsModel)attr);
                    if (CollectionUtils.isNotEmpty((Collection)allOldAttr)) {
                        for (FmTemplateAttributes attributes : allOldAttr) {
                            this.ruleUsedService.deleteByRelateFks(attributes.getAttrId(), "fm_template_attributes");
                        }
                    }
                    int columnCount = this.dao.delete(FmTemplateAttributes.n().where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).model());
                    Ulog.info((String)("\u5220\u9664\u6a21\u677f\u548c\u5c5e\u6027\u5173\u7cfb\u6210\u529f--\u6a21\u677f\u9875\u9762:" + tableCount + "--\u6a21\u677f\u9875\u9762\u6240\u5c5e\u5c5e\u6027:" + columnCount));
                    if (CollectionUtils.isNotEmpty(fmTemplate.getScpzMaterialTagsRelationList())) {
                        this.tagsService.saveScpzMaterialTagsRelationList(templateId, "template_id", "fm_template", fmTemplate.getScpzMaterialTagsRelationList());
                    }
                    ReturnMsg returnMsg = this.dynamicFormService.createFormTemplate(fmTemplate, fmTemplateDb, allOldAttr, typeMap);
                    Ulog.info((String)RequestUtils.return2Json((ReturnMsg)returnMsg));
                    if (returnMsg.isSuccessflag()) continue;
                    msg.getDtildMsg().addAll(returnMsg.getMsgList());
                }
                catch (Throwable ch) {
                    throwable = ch;
                    throw ch;
                }
                finally {
                    if (inputStreamReader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (Throwable ch) {
                            throwable.addSuppressed(ch);
                        }
                        continue;
                    }
                    ((Reader)inputStreamReader).close();
                }
            }
            catch (Exception exception) {
                Ulog.error((Throwable)exception);
                exception.printStackTrace();
                msg.setFailMsg(new Message("6050005", "\u5bfc\u5165\u5931\u8d25"));
                return msg.msg();
            }
        }
        ArrayList<File> fileList1 = new ArrayList<File>();
        this.getAllFiles(importDir, fileList1, ".txt");
        for (File file : fileList1) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
                Throwable ch = null;
                try {
                    int ch2 = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch2 = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch2);
                    }
                    String txtStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u7d20\u6750\u6570\u636e\u4e3a" + txtStr));
                    MaterialDataList scglMaterials = (MaterialDataList)JsonUtils.json2Class((String)txtStr, MaterialDataList.class);
                    if (CollectionUtils.isNotEmpty(scglMaterials.getScpzTags())) {
                        List tagIds = scglMaterials.getScpzTags().stream().map(ScpzTags::getTagId).collect(Collectors.toList());
                        this.dao.delete(ScpzTags.n().where().addIn(ScpzTags.TAG_ID, tagIds).model());
                        this.dao.save(scglMaterials.getScpzTags());
                    }
                    List authorizationIds = scglMaterials.getScglAuthorizeds().stream().map(ScglAuthorized::getAuthorizationId).collect(Collectors.toList());
                    this.dao.delete(ScglAuthorized.n().where().addIn(ScglAuthorized.AUTHORIZATION_ID, authorizationIds).model());
                    this.dao.save(scglMaterials.getScglAuthorizeds());
                    List materialIds = scglMaterials.getScglMaterials().stream().map(ScglMaterial::getMaterialId).collect(Collectors.toList());
                    this.dao.delete(ScglMaterial.n().where().addIn(ScglMaterial.MATERIAL_ID, materialIds).model());
                    this.dao.save(scglMaterials.getScglMaterials());
                    List relationUuids = scglMaterials.getScpzMaterialTagsRelations().stream().map(ScpzMaterialTagsRelation::getRelationUuid).collect(Collectors.toList());
                    this.dao.delete(ScpzMaterialTagsRelation.n().where().addIn(ScpzMaterialTagsRelation.RELATION_UUID, relationUuids).model());
                    this.dao.save(scglMaterials.getScpzMaterialTagsRelations());
                    if (!CollectionUtils.isNotEmpty(scglMaterials.getScpzReferences())) continue;
                    List referencedIds = scglMaterials.getScpzReferences().stream().map(ScpzReference::getReferencedId).collect(Collectors.toList());
                    this.dao.delete(ScpzReference.n().where().addIn(ScpzReference.REFERENCED_ID, referencedIds).model());
                    this.dao.save(scglMaterials.getScpzReferences());
                }
                catch (Throwable ch2) {
                    ch = ch2;
                    throw ch2;
                }
                finally {
                    if (reader == null) continue;
                    if (ch != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable ch2) {
                            ch.addSuppressed(ch2);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Ulog.debug((Object)e);
            }
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        this.getAllFiles(importDir, arrayList, ".jpg");
        this.getAllFiles(importDir, arrayList, ".png");
        this.getAllFiles(importDir, arrayList, ".gif");
        this.getAllFiles(importDir, arrayList, ".jpeg");
        this.getAllFiles(importDir, arrayList, ".mp4");
        this.getAllFiles(importDir, arrayList, ".pdf");
        try {
            for (File pic : arrayList) {
                String path = pic.getPath();
                String[] str = new String[]{};
                String obsSplitPath = this.obsConfig.getObsSplitPath();
                if (path.contains("page/")) {
                    str = path.split("page/");
                } else if (path.contains(obsSplitPath)) {
                    str = path.split(obsSplitPath);
                }
                String filePath = str[str.length - 1];
                filePath = filePath.replaceAll("/" + pic.getName(), "");
                this.sysDataService.uploadFileById(pic, filePath, pic.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        FilesUtil.delFile(pathName);
        String string = joiner.toString();
        task.setFuncModule("FORMTEMPLATE");
        task.setTaskType("IMP");
        task.setTaskName(string);
        task.setTaskState("FINISH");
        task.setFinishDate(new Date());
        this.dao.save((AbsModel)task);
        msg.setSuccessMsg(new Message("6050004", "\u5bfc\u5165\u6210\u529f"));
        return msg.msg();
    }

    public void getAllFiles(File dir, List<File> file, String type) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getAllFiles(files[i], file, type);
                continue;
            }
            String name = files[i].getName();
            if (name.endsWith(type)) {
                File file1 = files[i];
                file.add(file1);
            }
            Ulog.info((Object)files[i]);
        }
    }

    public void copyFormAttr(String templateId, FmTemplate fmTemplate) {
        String templateIdNew = fmTemplate.getTemplateId();
        List<FmTemplateAttributes> fmTemplateAttrAll = new ArrayList();
        FmTemplateAttributes fmTemplateAttributes = new FmTemplateAttributes();
        fmTemplateAttributes.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).addEq(FmTemplateAttributes.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        fmTemplateAttributes.setOrderBy(FmTemplateAttributes.DISPLAY_ORDER.asc());
        fmTemplateAttrAll = this.dao.findAll((AbsModel)fmTemplateAttributes);
        if (CollectionUtils.isNotEmpty(fmTemplateAttrAll)) {
            HashMap<String, String> attrIdNewMap = new HashMap<String, String>();
            fmTemplateAttrAll.forEach(a -> attrIdNewMap.put(a.getAttrId(), UUID.uuid()));
            Ulog.info((String)(templateId + "\u590d\u5236\u8868\u5355\u6a21\u677f\u5230" + templateIdNew + "\u5f00\u59cb\u5c5e\u6027\u590d\u5236"));
            String pkUuid = ThreadLocalContext.get().getUser().getPkUuid();
            ArrayList<String> insertList = new ArrayList<String>();
            List<String> addList = Arrays.asList("template_id", "attr_id", "attr_code", "attr_name", "component_type", "attr_length", "not_null", "is_component", "c_attr_id", "exclude_ids", "is_encrypt", "attr_int", "attr_precision", "ths_rs", "data_fmt", "blank_value", "is_column", "attr_json", "up_attr", "attr_md5", "attr_desc", "display_order", "prompt_text", "def_value", "level_code", "level_name");
            for (FmTemplateAttributes attr : fmTemplateAttrAll) {
                String attrId = attr.getAttrId();
                String newAttrId = (String)attrIdNewMap.get(attrId);
                String attrSernoNew = UUID.snowId() + "";
                String attrJson = attr.getAttrJson();
                String attrJsonNew = this.getNewAttrJson(attrJson, attrIdNewMap, templateId, templateIdNew);
                attr.setAttrJson(attrJsonNew);
                attr.setAttrId(newAttrId);
                attr.setSerno(attrSernoNew);
                attr.setTemplateId(templateIdNew);
                String upAttr = attr.getUpAttr();
                if (!"0".equals(upAttr)) {
                    attr.setUpAttr((String)attrIdNewMap.get(upAttr));
                }
                if ("richText".equals(attr.getComponentType()) || "wangeditorText".equals(attr.getComponentType())) {
                    Object fmTemplateText;
                    String editorContent = attr.getEditorContent();
                    List fmTemplateTextList = new ArrayList();
                    if (StrUtils.isNull((Object)editorContent)) {
                        fmTemplateText = new FmTemplateText();
                        ((FmTemplateText)((Object)fmTemplateText)).where().addEq(FmTemplateText.ATTR_ID, (Object)attrId).addEq(FmTemplateText.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
                        fmTemplateTextList = this.dao.findAll((AbsModel)fmTemplateText);
                        if (CollectionUtils.isNotEmpty(fmTemplateTextList)) {
                            for (FmTemplateText text : fmTemplateTextList) {
                                text.setSerno(null);
                                text.setAttrId(newAttrId);
                            }
                            this.dao.save(fmTemplateTextList);
                        }
                    } else {
                        fmTemplateText = new FmTemplateText();
                        ((FmTemplateText)((Object)fmTemplateText)).setTextContent(editorContent);
                        ((FmTemplateText)((Object)fmTemplateText)).setAttrId(newAttrId);
                        this.dao.save((AbsModel)fmTemplateText);
                    }
                }
                FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
                fkRulesReqParam.setRelateField("attr_id");
                fkRulesReqParam.setRelateTab("fm_template_attributes");
                fkRulesReqParam.setRelateFk(attrId);
                List saveRuleUsedParams = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
                if (CollectionUtils.isNotEmpty((Collection)saveRuleUsedParams)) {
                    for (SaveRuleUsedParam saveRuleUsedParam : saveRuleUsedParams) {
                        saveRuleUsedParam.setRelateFk(newAttrId);
                        saveRuleUsedParam.setRuleId(null);
                        this.ruleUsedService.saveRuleUsed(saveRuleUsedParam);
                    }
                }
                String timestamp = DateUtils.date2String((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                StringBuilder sql = new StringBuilder("INSERT INTO fm_template_attributes (serno, crt_user, mdf_user, data_flag, crt_date, mdf_date");
                StringBuilder value = new StringBuilder(" VALUES('" + UUID.snowId() + "', '" + pkUuid + "', '" + pkUuid + "', '1', '" + timestamp + "', '" + timestamp + "'");
                Map attrMap = JsonUtils.json2Map((String)JsonUtils.toJson((Object)((Object)attr)));
                for (Map.Entry entry : attrMap.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!addList.contains(key)) continue;
                    sql.append(", " + key);
                    if (StrUtils.isNull(entry.getValue())) {
                        value.append(", null ");
                        continue;
                    }
                    value.append(", '" + entry.getValue() + "'");
                }
                insertList.add(sql.append(") ").append((CharSequence)value).append(")").toString());
            }
            fmTemplate.setAttrList(fmTemplateAttrAll);
            if (CollectionUtils.isNotEmpty(insertList)) {
                long start = System.currentTimeMillis();
                Ulog.info((String)("\u590d\u5236\u65f6\u4fdd\u5b58\u5c5e\u6027:" + JsonUtils.toJson(insertList)));
                this.dao.getJdbcTemplate().batchUpdate(insertList.toArray(new String[0]));
                long end = System.currentTimeMillis();
                double time = (double)(end - start) / 1000.0;
                Ulog.info((String)("\u590d\u5236\u65f6\u4fdd\u5b58\u5c5e\u6027\u8017\u65f6:" + time + "s"));
            }
        }
    }

    private String getNewAttrJson(String attrJson, Map<String, String> attrIdNewMap, String templateId, String templateIdNew) {
        String returnJson = attrJson.replaceAll(templateId, templateIdNew);
        for (Map.Entry<String, String> entry : attrIdNewMap.entrySet()) {
            returnJson = returnJson.replaceAll(entry.getKey(), entry.getValue());
        }
        return returnJson;
    }

    @Override
    public String getFormJson(FmJsonReqParam fmJsonReqParam, FmTemplate fmTemplateDb, FmJsonAndValueVo fmJsonAndValueVo) {
        String formValue;
        String templateJson;
        String templateId = fmJsonReqParam.getTemplateId();
        String templateKey = "template_" + templateId;
        String formJson = (String)CacheManager.get((String)templateKey);
        if (!StrUtils.isNull((Object)formJson)) {
            return formJson;
        }
        formJson = templateJson = fmTemplateDb.getTemplateJson();
        FmTemplateAttributes fmAttr = new FmTemplateAttributes();
        fmAttr.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).addEq(FmTemplateAttributes.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        fmAttr.setOrderBy(FmTemplateAttributes.DISPLAY_ORDER.asc());
        List attrAll = this.dao.findAll((AbsModel)fmAttr);
        if (CollectionUtils.isEmpty((Collection)attrAll)) {
            return templateJson.replaceFirst("\\{", " {  \"content\": [],");
        }
        List<FmTemplateAttributes> fmAttrList = attrAll.stream().filter(o -> "0".equals(o.getUpAttr())).sorted(Comparator.comparing(FmTemplateAttributes::getDisplayOrder)).collect(Collectors.toList());
        if (!fmAttrList.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner(",");
            fmAttrList.forEach(s -> stringJoiner.add(s.getAttrJson()));
            String json = "{    \"content\": [" + stringJoiner;
            formJson = json + templateJson.replaceFirst("\\{", "],");
        }
        if (Objects.equals("Y", fmTemplateDb.getIsCreateTable()) && fmJsonAndValueVo != null && !StrUtils.isNull((Object)(formValue = this.getFormValue(fmJsonReqParam, attrAll, fmTemplateDb.getTemplateCode())))) {
            fmJsonAndValueVo.setFormValue(formValue);
        }
        CacheManager.put((String)templateKey, (Object)formJson);
        CacheManager.expire((String)templateKey, (long)604800L);
        return formJson;
    }

    private String getFormJsonAndAttr(FmJsonReqParam fmJsonReqParam, FmTemplate fmTemplateDb, FmJsonAndValueVo fmJsonAndValueVo) {
        String templateJson;
        String templateId = fmJsonReqParam.getTemplateId();
        String isPackageQsn = fmJsonReqParam.getIsPackageQsn();
        String formJson = templateJson = fmTemplateDb.getTemplateJson();
        String templateType = fmTemplateDb.getTemplateType();
        String templateBelongs = fmTemplateDb.getTemplateBelongs();
        if (("inform".equals(templateType) || "qsn".equals(templateType)) && "form".equals(templateBelongs) && (StrUtils.isNull((Object)isPackageQsn) || "Y".equals(isPackageQsn))) {
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<String> list = new ArrayList<String>();
            stringBuilder.append("select qtr.paper_uuid,qtr.relation_uuid,qtr.child_uuid,qtr.display_order relation_order,qq.* ");
            stringBuilder.append("from qsn_title_relation qtr left join qsn_paper_template qpt ");
            stringBuilder.append("on qtr.paper_uuid = qpt.paper_uuid ");
            stringBuilder.append("left join qsn_questions qq on ");
            stringBuilder.append("qtr.qsn_uuid = qq.qsn_uuid ");
            stringBuilder.append("where qpt.template_id = ? and qq.qsn_uuid is not null ");
            stringBuilder.append("order by qq.qsn_class,qtr.display_order ");
            list.add(templateId);
            List qtrList = this.dao.findAll(stringBuilder.toString(), PackageQsnParam.class, new AbsModelRepository.Args[]{this.dao.args(list)});
            if (CollectionUtils.isEmpty((Collection)qtrList)) {
                return templateJson.replaceFirst("\\{", " {  \"content\": [],");
            }
            formJson = this.getInformFormJson(fmJsonReqParam, fmTemplateDb, qtrList, "N", fmJsonAndValueVo);
        } else {
            String formValue;
            FmTemplateAttributes fmAttr = new FmTemplateAttributes();
            fmAttr.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).addEq(FmTemplateAttributes.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
            fmAttr.setOrderBy(FmTemplateAttributes.DISPLAY_ORDER.asc());
            List attrAll = this.dao.findAll((AbsModel)fmAttr);
            if (CollectionUtils.isEmpty((Collection)attrAll)) {
                return templateJson.replaceFirst("\\{", " {  \"content\": [],");
            }
            List<Object> fmAttrList = new ArrayList();
            ArrayList<FmAttrVo> fmAttrVos = new ArrayList<FmAttrVo>();
            for (FmTemplateAttributes fta : attrAll) {
                if ("0".equals(fta.getUpAttr())) {
                    fmAttrList.add((Object)fta);
                }
                FmAttrVo fa = new FmAttrVo();
                fa.setAttrId(fta.getAttrId());
                fa.setIsComponent(fta.getIsComponent());
                fa.setCAttrId(fta.getCAttrId());
                fa.setExcludeIds(fta.getExcludeIds());
                fmAttrVos.add(fa);
            }
            fmAttrList = fmAttrList.stream().sorted(Comparator.comparing(FmTemplateAttributes::getDisplayOrder)).collect(Collectors.toList());
            fmJsonReqParam.setAttrList(fmAttrVos);
            if (!fmAttrList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner(",");
                fmAttrList.forEach(s -> stringJoiner.add(s.getAttrJson()));
                String json = "{    \"content\": [" + stringJoiner;
                formJson = json + templateJson.replaceFirst("\\{", "],");
            }
            if (Objects.equals("Y", fmTemplateDb.getIsCreateTable()) && fmJsonAndValueVo != null && !StrUtils.isNull((Object)(formValue = this.getFormValue(fmJsonReqParam, attrAll, fmTemplateDb.getTemplateCode())))) {
                fmJsonAndValueVo.setFormValue(formValue);
            }
        }
        return formJson;
    }

    public String getFormJsonForLimit(FmJsonReqParam fmJsonReqParam, FmTemplate fmTemplateDb) {
        String tableJson;
        String templateId = fmJsonReqParam.getTemplateId();
        String templateKey = "template_limit" + templateId;
        String formJson = (String)CacheManager.get((String)templateKey);
        if (!StrUtils.isNull((Object)formJson)) {
            return formJson;
        }
        formJson = tableJson = fmTemplateDb.getTemplateJson();
        FmTemplateAttributes fmAttr = new FmTemplateAttributes();
        fmAttr.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).addEq(FmTemplateAttributes.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        fmAttr.setOrderBy(FmTemplateAttributes.DISPLAY_ORDER.asc());
        List attrAll = this.dao.findAll((AbsModel)fmAttr);
        if (CollectionUtils.isEmpty((Collection)attrAll)) {
            return tableJson.replaceFirst("\\{", " {  \"content\": [],");
        }
        List fmAttrList = attrAll.stream().filter(o -> "0".equals(o.getUpAttr())).sorted(Comparator.comparing(FmTemplateAttributes::getDisplayOrder)).collect(Collectors.toList());
        ArrayList<String> removeJsonString = new ArrayList<String>();
        HashMap<String, String> tableReplaceOptions = new HashMap<String, String>();
        String result = this.wrapperFormLimit(tableJson, fmJsonReqParam.getPkUuid(), templateId, attrAll, removeJsonString, tableReplaceOptions);
        if (Objects.equals(result, "")) {
            return result;
        }
        if (!fmAttrList.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner(",");
            for (FmTemplateAttributes attr : fmAttrList) {
                String attrJson = attr.getAttrJson();
                if (CollectionUtils.isNotEmpty(removeJsonString)) {
                    for (String string : removeJsonString) {
                        int i = attrJson.indexOf(string);
                        if (i == -1) continue;
                        char split = attrJson.charAt(i - 1);
                        if (split == ',') {
                            attrJson = attrJson.replace("," + string, "");
                            continue;
                        }
                        attrJson = attrJson.replace(string, "");
                    }
                }
                if (Objects.equals(attr.getComponentType(), "table") && MapUtils.isNotEmpty(tableReplaceOptions)) {
                    for (Map.Entry entry : tableReplaceOptions.entrySet()) {
                        attrJson = attrJson.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                    }
                }
                stringJoiner.add(attrJson);
            }
            String json = "{    \"content\": [" + stringJoiner;
            formJson = json + tableJson.replaceFirst("\\{", "],");
        }
        CacheManager.put((String)templateKey, (Object)formJson);
        CacheManager.expire((String)templateKey, (long)604800L);
        return formJson;
    }

    private String wrapperFormLimit(String tableJson, String pkUuid, String templateId, List<FmTemplateAttributes> allAttr, List<String> removeJsonString, Map<String, String> tableReplaceOptions) {
        RmsLimitVo limitVo = (RmsLimitVo)CacheManager.get((String)("USER_LIMIT_" + pkUuid));
        if (Objects.nonNull(limitVo)) {
            Ulog.info((String)("\u7528\u6237-->" + pkUuid + "--\u67e5\u5230\u7684\u6743\u9650\u6570\u636e\u4e3a-->" + JsonUtils.toJson((Object)limitVo)));
            List menuList = JsonUtils.listMap2ListClass((List)((List)limitVo.getResourceLimitMap().get("MENU")), RmsMenu.class);
            Map<String, List<RmsMenu>> groupByMenu = menuList.stream().collect(Collectors.groupingBy(RmsMenu::getUpMenu));
            HashMap rmsMenuMap = new HashMap();
            List menuFormIds = menuList.stream().filter(o -> o.getMenuUrl().contains("templateId=")).map(o -> {
                String menuUrl = o.getMenuUrl();
                String menuFormId = menuUrl.substring(menuUrl.indexOf("templateId=") + 11);
                rmsMenuMap.put(menuFormId, o);
                return menuFormId;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(menuFormIds) || !menuFormIds.contains(templateId)) {
                Ulog.info((String)("\u7528\u6237-->" + pkUuid + "--\u65e0\u6743\u8bbf\u95eetemplateId-->" + templateId));
                return tableJson.replaceFirst("\\{", " {  \"content\": [],");
            }
            RmsMenu rmsMenu = (RmsMenu)rmsMenuMap.get(templateId);
            List<RmsMenu> buttonList = groupByMenu.get(rmsMenu.getMenuId());
            if (CollectionUtils.isNotEmpty(buttonList)) {
                List buttonIds = buttonList.stream().map(RmsMenu::getRouterName).collect(Collectors.toList());
                List buttonAttrs = allAttr.stream().filter(o -> Objects.equals(o.getComponentType(), "button")).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(buttonAttrs) && CollectionUtils.isNotEmpty(buttonIds)) {
                    List stringList = buttonAttrs.stream().filter(o -> !buttonIds.contains(o.getAttrId())).map(FmTemplateAttributes::getAttrJson).collect(Collectors.toList());
                    removeJsonString.addAll(stringList);
                    List<FmTemplateAttributes> tableAttrs = allAttr.stream().filter(o -> Objects.equals(o.getComponentType(), "table")).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(tableAttrs)) {
                        tableAttrs.forEach(o -> {
                            JSONObject jsonObject = JSONObject.parseObject((String)o.getAttrJson());
                            if (StringUtils.isBlank((CharSequence)jsonObject.getString(PageBaseEnum.JsonContentEnum.COLUMNS.getType()))) {
                                return;
                            }
                            JSONArray configs = jsonObject.getJSONArray(PageBaseEnum.JsonContentEnum.COLUMNS.getType());
                            if (CollectionUtils.isEmpty((Collection)configs)) {
                                return;
                            }
                            for (int j = 0; j < configs.size(); ++j) {
                                String routerName = configs.getJSONObject(j).getString("attr_id");
                                if (buttonIds.contains(routerName)) continue;
                                String oldStr = configs.getJSONObject(j).toJSONString();
                                JSONObject obj = configs.getJSONObject(j);
                                obj.put("isShow", (Object)0);
                                String newStr = obj.toJSONString();
                                tableReplaceOptions.put(oldStr, newStr);
                            }
                        });
                    }
                }
            }
        }
        return "";
    }

    public String getFormValue(FmJsonReqParam formJsonReqParam, List<FmTemplateAttributes> attrAll, String formName) {
        String formValue = "";
        String templateId = formJsonReqParam.getTemplateId();
        String pkUuid = formJsonReqParam.getPkUuid();
        String instanceId = formJsonReqParam.getInstanceId();
        if (StrUtils.isNull((Object)instanceId)) {
            return null;
        }
        List<FmTemplateAttributes> attrByTemplateId = this.sqlBaseComponent.removeExtraAttr(attrAll);
        String dropsql = "select DISTINCT TABLE_NAME  from information_schema.COLUMNS c where TABLE_NAME  = ? ";
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(formName.toLowerCase());
        List all = this.dao.findAll(dropsql + " \uff03NOTCHECK", Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(sqlList)});
        if (CollectionUtils.isEmpty((Collection)all)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("select instance_id as instance_id,");
        for (FmTemplateAttributes attr : attrByTemplateId) {
            stringBuilder.append(attr.getAttrCode()).append(",");
        }
        stringBuilder.append("serno as serno from ");
        stringBuilder.append(formName);
        stringBuilder.append(" where crt_user = ? and data_flag = ? and instance_id = ? order by mdf_date desc limit 1 \uff03NOTCHECK");
        String sql = stringBuilder.toString();
        List<HashMap<String, Object>> mapList = new ArrayList();
        try {
            mapList = this.dao.findAll(sql, new AbsModelRepository.Args[]{this.dao.args(new Object[]{pkUuid, BaseEnum.DataFlag.USABLE.getType(), instanceId})});
        }
        catch (Exception e) {
            e.printStackTrace();
            Connection connection = DataSourceUtils.getConnection((DataSource)this.dao.getJdbcTemplate().getDataSource());
            try {
                connection.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            return null;
        }
        if (CollectionUtils.isNotEmpty(mapList)) {
            ((Map)mapList.get(0)).remove("rn");
        }
        ArrayList<RichTextVo> richTextMsgs = new ArrayList<RichTextVo>();
        int num = 0;
        if (CollectionUtils.isNotEmpty(attrAll)) {
            for (int i = 0; i < attrAll.size(); ++i) {
                FmTemplateAttributes fmTemplateAttributes = attrAll.get(i);
                String type = fmTemplateAttributes.getComponentType();
                String attrJson = fmTemplateAttributes.getAttrJson();
                JSONObject jsonObject = JSONObject.parseObject((String)attrJson);
                if ("richText".equals(type)) {
                    RichTextVo richTextVo = new RichTextVo();
                    richTextVo.setColumnName(fmTemplateAttributes.getAttrCode());
                    richTextVo.setInterfaceUrl(jsonObject.getString(PageBaseEnum.JsonContentEnum.INTERFACEURL.getType()));
                    richTextVo.setAttrId(fmTemplateAttributes.getAttrId());
                    richTextMsgs.add(richTextVo);
                    continue;
                }
                if (!this.templateConfig.getFromExcludeColumn().contains(type)) continue;
                ++num;
            }
            if (!richTextMsgs.isEmpty()) {
                if (CollectionUtils.isNotEmpty(mapList)) {
                    for (Map map : mapList) {
                        for (RichTextVo richTextMsg : richTextMsgs) {
                            this.richText(richTextMsg, map);
                        }
                    }
                } else if (richTextMsgs.size() + num == attrAll.size()) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    for (RichTextVo richTextMsg : richTextMsgs) {
                        this.richText(richTextMsg, dataMap);
                    }
                    mapList.add(dataMap);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(mapList)) {
            formValue = JsonUtils.toJson(mapList.get(0));
        }
        return formValue;
    }

    private void richText(RichTextVo richTextMsg, Map<String, Object> dataMap) {
        String columnName = richTextMsg.getColumnName();
        String interfaceUrl = richTextMsg.getInterfaceUrl();
        String attrId = richTextMsg.getAttrId();
        FmTemplateText fmTemplateText = new FmTemplateText();
        fmTemplateText.where().addEq(FmTemplateText.DATA_FLAG, (Object)1).addEq(FmTemplateText.ATTR_ID, (Object)attrId);
        FmTemplateText fmTemplateTextDb = (FmTemplateText)this.dao.findOne((AbsModel)fmTemplateText);
        if (null != fmTemplateTextDb) {
            String content = fmTemplateTextDb.getTextContent();
            if (!StrUtils.isNull((Object)content) && !StrUtils.isNull((Object)interfaceUrl)) {
                String varMsg = HttpUtils.jsonPost((String)interfaceUrl);
                JSONObject varObj = JSONObject.parseObject((String)varMsg);
                Pattern p = Pattern.compile(this.templateConfig.getRichTextReplaceMarkMatch());
                Matcher m = p.matcher(content);
                while (m.find()) {
                    String sub = m.group();
                    String varKey = sub.replace(this.templateConfig.getRichTextReplaceMarkStart(), "").replace(this.templateConfig.getRichTextReplaceMarkEnd(), "");
                    String varValue = varObj.getString(varKey);
                    content = content.replace(sub, varValue);
                }
                dataMap.put(columnName, content);
            } else {
                dataMap.put(columnName, content);
            }
        }
    }

    private void getRule(FmJsonReqParam fmJsonReqParam, FmJsonAndValueVo fmJsonAndValueVo) {
        String templateId = fmJsonReqParam.getTemplateId();
        List<Object> attrList = fmJsonReqParam.getAttrList() == null ? new ArrayList() : fmJsonReqParam.getAttrList();
        ArrayList<Map<String, Object>> attrRules = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> formRules = new ArrayList<Map<String, Object>>();
        FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
        fkRulesReqParam.setRelateField("template_id");
        fkRulesReqParam.setRelateTab("fm_template");
        fkRulesReqParam.setRelateFk(templateId);
        List saveRuleUsedParams = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
        ArrayList<Object> saveRuleUsedParams1 = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty((Collection)saveRuleUsedParams)) {
            for (int i = 0; i < saveRuleUsedParams.size(); ++i) {
                if (((SaveRuleUsedParam)saveRuleUsedParams.get(i)).getRuleUsedType().contains(",")) {
                    String[] s;
                    SaveRuleUsedParam saveRuleUsedParam = (SaveRuleUsedParam)saveRuleUsedParams.get(i);
                    for (String s1 : s = ((SaveRuleUsedParam)saveRuleUsedParams.get(i)).getRuleUsedType().split(",")) {
                        SaveRuleUsedParam save = new SaveRuleUsedParam();
                        BeanUtils.copyProperties((Object)saveRuleUsedParam, (Object)save);
                        save.setRuleUsedType(s1);
                        saveRuleUsedParams1.add(save);
                    }
                    continue;
                }
                saveRuleUsedParams1.add(saveRuleUsedParams.get(i));
            }
            for (SaveRuleUsedParam saveRuleUsedParam : saveRuleUsedParams1) {
                if (CollectionUtils.isNotEmpty((Collection)saveRuleUsedParam.getParams())) {
                    List dsnRulesParamList = saveRuleUsedParam.getParams();
                    for (DsnRulesParam rulesParam : dsnRulesParamList) {
                        String a = StrUtils.trimStr((Object)saveRuleUsedParam.getRuleTemplateId()) + ".###" + rulesParam.getParamCode() + "###";
                        String paramStr = rulesParam.getParamFact().replaceAll("\"", "\\\\\"");
                        saveRuleUsedParam.setRuleInfo(saveRuleUsedParam.getRuleInfo().replace(a, paramStr));
                    }
                }
                HashMap rule = new HashMap();
                rule.put("dsn_rules_const", saveRuleUsedParam.getConsts());
                rule.put("dsn_rules_param", saveRuleUsedParam.getParams());
                saveRuleUsedParam.setConsts(null);
                saveRuleUsedParam.setParams(null);
                rule.put("dsn_rules", saveRuleUsedParam);
                formRules.add(rule);
            }
        }
        if (CollectionUtils.isNotEmpty(attrList)) {
            for (FmAttrVo fmAttrVo : attrList) {
                String attrId = fmAttrVo.getAttrId();
                this.setAttrRule(attrId, null, attrRules, null);
                if (!"Y".equals(fmAttrVo.getIsComponent())) continue;
                this.setAttrRule(fmAttrVo.getCAttrId(), fmAttrVo.getExcludeIds(), attrRules, attrId);
            }
            fmJsonAndValueVo.setAttrRules(attrRules);
        }
        fmJsonAndValueVo.setFormRules(formRules);
    }

    private void setAttrRule(String attrId, String excludeIds, List<Map<String, Object>> attrRules, String rAttrId) {
        FkRulesReqParam attrParam = new FkRulesReqParam();
        attrParam.setRelateField("attr_id");
        attrParam.setRelateTab("fm_template_attributes");
        attrParam.setRelateFk(attrId);
        attrParam.setExcludeIds(excludeIds);
        List attrRuleList = this.ruleUsedService.queryRulesByFk(attrParam);
        if (CollectionUtils.isNotEmpty((Collection)attrRuleList)) {
            attrRuleList = attrRuleList.stream().filter(saveRuleUsedParam -> saveRuleUsedParam.getStatus().equals("1")).collect(Collectors.toList());
        }
        ArrayList<Object> attrRuleList1 = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty((Collection)attrRuleList)) {
            for (int i = 0; i < attrRuleList.size(); ++i) {
                if (((SaveRuleUsedParam)attrRuleList.get(i)).getRuleUsedType().contains(",")) {
                    String[] s;
                    SaveRuleUsedParam saveRuleUsedParam2 = (SaveRuleUsedParam)attrRuleList.get(i);
                    for (String s1 : s = ((SaveRuleUsedParam)attrRuleList.get(i)).getRuleUsedType().split(",")) {
                        SaveRuleUsedParam save = new SaveRuleUsedParam();
                        BeanUtils.copyProperties((Object)saveRuleUsedParam2, (Object)save);
                        save.setRuleUsedType(s1);
                        attrRuleList1.add(save);
                    }
                    continue;
                }
                attrRuleList1.add(attrRuleList.get(i));
            }
            for (SaveRuleUsedParam saveRuleUsedParam3 : attrRuleList1) {
                List dsnRulesParamList = saveRuleUsedParam3.getParams();
                for (DsnRulesParam rulesParam : dsnRulesParamList) {
                    String a = StrUtils.trimStr((Object)saveRuleUsedParam3.getRuleTemplateId()) + ".###" + rulesParam.getParamCode() + "###";
                    String paramStr = rulesParam.getParamFact().replaceAll("\"", "\\\\\"");
                    saveRuleUsedParam3.setRuleInfo(saveRuleUsedParam3.getRuleInfo().replace(a, paramStr));
                }
                HashMap rule = new HashMap();
                rule.put("dsn_rules_const", saveRuleUsedParam3.getConsts());
                rule.put("dsn_rules_param", saveRuleUsedParam3.getParams());
                saveRuleUsedParam3.setConsts(null);
                saveRuleUsedParam3.setParams(null);
                if (!StrUtils.isNull((Object)rAttrId)) {
                    String relateFk = saveRuleUsedParam3.getRelateFk();
                    saveRuleUsedParam3.setRelateFk(rAttrId);
                    saveRuleUsedParam3.setCAttrId(relateFk);
                }
                rule.put("dsn_rules", saveRuleUsedParam3);
                attrRules.add(rule);
            }
        }
    }

    @Override
    public ReturnMsg testBathSave() {
        FmTemplateAttributes fmTemplateAttributes = new FmTemplateAttributes();
        fmTemplateAttributes.where().addEq(FmTemplateAttributes.SERNO, (Object)"293454048932380672");
        fmTemplateAttributes = (FmTemplateAttributes)this.dao.findOne((AbsModel)fmTemplateAttributes);
        ArrayList<FmTemplateAttributes> all = new ArrayList<FmTemplateAttributes>();
        for (int i = 0; i < 40; ++i) {
            FmTemplateAttributes fmTemplateAttributes2 = new FmTemplateAttributes();
            BeanUtils.copyProperties((Object)((Object)fmTemplateAttributes), (Object)((Object)fmTemplateAttributes2));
            fmTemplateAttributes2.setTemplateId("yuan333333333333");
            fmTemplateAttributes2.setAttrId("yuan333333333333" + i);
            all.add(fmTemplateAttributes2);
        }
        Long start = System.currentTimeMillis();
        this.dao.save(all);
        Long end = System.currentTimeMillis();
        System.out.println("\u6027\u80fd\u6d4b\u8bd5-dao.save\u8017\u65f6\uff1a" + (double)(end - start) / 1000.0);
        FmTemplateAttributes fmTemplateAttributes3 = new FmTemplateAttributes();
        fmTemplateAttributes3.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)"yuan333333333333");
        this.dao.delete((AbsModel)fmTemplateAttributes3);
        Long start2 = System.currentTimeMillis();
        this.save(all);
        Long end2 = System.currentTimeMillis();
        System.out.println("\u6027\u80fd\u6d4b\u8bd5-dao.save2\u8017\u65f6\uff1a" + (double)(end2 - start2) / 1000.0);
        FmTemplateAttributes fmTemplateAttributes4 = new FmTemplateAttributes();
        fmTemplateAttributes4.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)"yuan333333333333");
        this.dao.delete((AbsModel)fmTemplateAttributes4);
        throw new BusinessException("22222222");
    }

    @Override
    public ReturnMsg testSubSelect() {
        Return r = new Return();
        String templateId = "0e39dda1ece843d282d400e461578520";
        String templateJson = "{\"font_size\":\"14\",\"display_order\":2,\"template_json\":\"{\\\"theme\\\":\\\"\u84dd\u8272\\\",\\\"language\\\":\\\"zh-cn\\\"}\",\"coll_name\":\"\u52ff\u52a8-\u91d1\u533b\u4fdd\u6295\u4fdd\u6d41\u7a0b\",\"patch_memo\":\"\",\"coll_id\":\"6be0a68b3f8242edab5dda123b303941\",\"bg_img\":\"\",\"template_type\":\"page\",\"state\":\"OFF\",\"form_padding\":\"20\",\"template_md5\":\"6f53a666d41a52d200f528e58a9e6ac0\",\"label_color\":\"rgb(100%, 80%, 50%)\",\"count\":99,\"is_edit\":\"Y\",\"index_column\":\"[]\",\"label_width\":\"100\",\"template_code\":\"txtbxxtx\",\"bg_color\":\"rgb(96%, 96%, 96%)\",\"template_name\":\"\u6295\u4fdd\u4fe1\u606f\u586b\u5199\u9875\u9762_\u52ff\u52a8\u526f\u672c10.24\",\"template_belongs\":\"form\",\"level_name\":\"normal\",\"font_color\":\"rgb(85%, 11%, 26%)\",\"use_scene\":\"mobile\",\"template_id\":\"0e39dda1ece843d282d400e461578520\",\"font_family\":\"SimSun\",\"is_create_table\":\"N\"}";
        FmTemplateAttributes fmAttr = new FmTemplateAttributes();
        fmAttr.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).addEq(FmTemplateAttributes.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        fmAttr.setOrderBy(FmTemplateAttributes.DISPLAY_ORDER.asc());
        List attrAll = this.dao.findAll((AbsModel)fmAttr);
        if (CollectionUtils.isEmpty((Collection)attrAll)) {
            r.getDataTable().put("formJson", templateJson.replaceFirst("\\{", " {  \"content\": [],"));
            return r.msg();
        }
        StringJoiner stringJoiner = new StringJoiner(",");
        for (FmTemplateAttributes fa : attrAll) {
            String attrJson = fa.getAttrJson();
            if (!"0".equals(fa.getUpAttr())) continue;
            JSONObject children = this.findChildren(fa.getAttrId(), JSONObject.parseObject((String)attrJson), attrAll);
            String json = JsonUtils.toJson((Object)children);
            stringJoiner.add(json);
        }
        String json = "{    \"content\": [" + stringJoiner;
        String formJson = json + templateJson.replaceFirst("\\{", "],");
        r.getDataTable().put("formJson", formJson);
        return r.msg();
    }

    private JSONObject findChildren(String attrId, JSONObject attrJsonObject, List<FmTemplateAttributes> attrAll) {
        JSONArray configs = attrJsonObject.getJSONArray(PageBaseEnum.JsonContentEnum.COLUMNS.getType());
        JSONArray configsReturn = new JSONArray();
        if (CollectionUtils.isNotEmpty((Collection)configs)) {
            for (int j = 0; j < configs.size(); ++j) {
                JSONObject jsonObject = configs.getJSONObject(j);
                if (CollectionUtils.isNotEmpty((Collection)jsonObject.getJSONArray("list"))) {
                    JSONArray columnsArrayR = new JSONArray();
                    JSONArray columnsArray = jsonObject.getJSONArray("list");
                    for (int h = 0; h < columnsArray.size(); ++h) {
                        JSONObject jsonObjectH = columnsArray.getJSONObject(h);
                        for (FmTemplateAttributes fta : attrAll) {
                            String ftaAttrJson = fta.getAttrJson();
                            String ftaAttrId = fta.getAttrId();
                            if (!attrId.equals(fta.getUpAttr()) || !jsonObjectH.getString("attr_id").equals(ftaAttrId)) continue;
                            jsonObjectH = JSONObject.parseObject((String)ftaAttrJson);
                            JSONObject children = this.findChildren(ftaAttrId, jsonObjectH, attrAll);
                            columnsArrayR.add((Object)children);
                        }
                    }
                    jsonObject.put("list", (Object)columnsArrayR);
                }
                configsReturn.add((Object)jsonObject);
            }
        }
        attrJsonObject.put(PageBaseEnum.JsonContentEnum.COLUMNS.getType(), (Object)configsReturn);
        return attrJsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbsModel> List<T> save(List<T> models) {
        if (models.isEmpty()) {
            return new ArrayList();
        }
        long start = System.currentTimeMillis();
        Long start3 = System.currentTimeMillis();
        SqlMapper sqlMapper = SqlUtils.getInsertSql((AbsModel)((AbsModel)models.get(0)));
        Long end3 = System.currentTimeMillis();
        System.out.println("\u6027\u80fd\u6d4b\u8bd5-dao.getJdbcTemplate.sqlMapper\u8017\u65f6\uff1a" + (double)(end3 - start3) / 1000.0);
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        Timestamp crtDate = DateUtils.sysTimestamp();
        for (AbsModel model : models) {
            model.where().setDbType(this.dao.getDbType());
            model.setCrtDate((Date)crtDate);
            model.setMdfDate((Date)crtDate);
            model.setCrtUser(ThreadLocalContext.get().getUser().getPkUuid());
            model.setMdfUser(ThreadLocalContext.get().getUser().getPkUuid());
            model.setDataFlag("1");
            if (StrUtils.isNull((Object)model.getSerno())) {
                model.setSerno(UUID.snowId() + "");
            }
            batchArgs.add(((List)SqlUtils.getProperty((AbsModel)model).get("value")).toArray());
        }
        int result = -1;
        try {
            Long start2 = System.currentTimeMillis();
            result = this.dao.getJdbcTemplate().batchUpdate(sqlMapper.getSql(), batchArgs).length;
            Long end2 = System.currentTimeMillis();
            System.out.println("\u6027\u80fd\u6d4b\u8bd5-dao.getJdbcTemplate\u8017\u65f6\uff1a" + (double)(end2 - start2) / 1000.0);
        }
        finally {
            SqlUtils.annalLog((String)(result + ""), (long)start, models, (String)"\u65b0\u589e", () -> ((SqlMapper)sqlMapper).getPrintSql());
        }
        return models;
    }
}

