/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.component;

import com.newtouch.base.config.TemplateConfig;
import com.newtouch.base.enums.BaseEnum;
import com.newtouch.base.enums.PageBaseEnum;
import com.newtouch.base.model.FmTemplateAttributes;
import com.uniapis.cache.CacheManager;
import com.uniapis.logger.Ulog;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SqlBaseComponent {
    @Autowired
    private TemplateConfig templateConfig;
    @Autowired
    AbsModelRepository dao;

    public List<String> modifyAttr(List<FmTemplateAttributes> attrList, String optType, String tableName, Map<String, String> typeMap) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (FmTemplateAttributes t : attrList) {
            StringBuilder sql = new StringBuilder();
            String attrCode = t.getAttrCode();
            if (Objects.equals(optType, PageBaseEnum.OptType.CHANGE.getType())) {
                sql.append("ALTER TABLE ").append(tableName).append(" ").append(optType).append(" ").append(t.getOldAttrCode()).append(" ").append(attrCode).append(" ").append(typeMap.get(t.getComponentType()));
            } else {
                sql.append("ALTER TABLE ").append(tableName).append(" ").append(optType).append(" ").append(attrCode).append(" ").append(typeMap.get(t.getComponentType()));
            }
            if (Objects.nonNull(t.getAttrLength())) {
                sql.append("(").append(t.getAttrLength()).append(")");
            }
            if ("Y".equals(t.getNotNull()) && Objects.equals(optType, PageBaseEnum.OptType.ADD.getType())) {
                sql.append(" NOT NULL ");
            } else {
                sql.append(" NULL ");
            }
            if (!StrUtils.isNull((Object)t.getDefValue())) {
                sql.append(" DEFAULT '").append(t.getDefValue()).append("'");
            }
            sqlList.add(sql.toString());
            sqlList.add("comment on column " + tableName + "." + attrCode + " is '" + t.getAttrName() + "'");
        }
        return sqlList;
    }

    public List<String> dropAttr(List<FmTemplateAttributes> attrList, String tableName) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (FmTemplateAttributes t : attrList) {
            String sql = "ALTER TABLE " + tableName + " drop " + t.getAttrCode();
            sqlList.add(sql);
        }
        return sqlList;
    }

    public List<String> addIndex(List<FmTemplateAttributes> attrList, String tableName) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (FmTemplateAttributes t : attrList) {
            StringBuilder sql = new StringBuilder();
            sql.append("ALTER TABLE ").append(tableName).append(" ADD index idx_").append(tableName).append("_").append(t.getAttrCode());
            sql.append("(").append(t.getAttrCode()).append(")");
            sqlList.add(sql.toString());
        }
        return sqlList;
    }

    public List<String> delIndex(List<FmTemplateAttributes> attrList, String tableName) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (FmTemplateAttributes t : attrList) {
            StringBuilder sql = new StringBuilder();
            sql.append("ALTER TABLE ").append(tableName).append(" DROP index idx_").append(tableName).append("_").append(t.getAttrCode());
            sqlList.add(sql.toString());
        }
        return sqlList;
    }

    public List<FmTemplateAttributes> removeExtraAttr(List<FmTemplateAttributes> attrList) {
        Ulog.info((String)("\u8fc7\u6ee4\u524d\u5217\u4fe1\u606f\uff1a" + JsonUtils.toJson(attrList)));
        Ulog.info((String)("\u9700\u8981\u6392\u9664\u4e0d\u521b\u5efa\u5b57\u6bb5\u7684\u7684\u5217\u8868\uff1a" + this.templateConfig.getFromExcludeColumn()));
        attrList.removeIf(o -> this.templateConfig.getFromExcludeColumn().contains(o.getComponentType()));
        Ulog.info((String)("\u8fc7\u6ee4\u540e\u5217\u4fe1\u606f\uff1a" + JsonUtils.toJson(attrList)));
        attrList = attrList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FmTemplateAttributes>(Comparator.comparing(FmTemplateAttributes::getAttrCode))), ArrayList::new));
        return attrList;
    }

    public Map<String, Object> removeExtraAttr(Map<String, Object> map, String templateId) {
        List<FmTemplateAttributes> FmTemplateAttributess = this.getAttrByTemplateId(templateId);
        if (CollectionUtils.isEmpty(FmTemplateAttributess)) {
            return map;
        }
        List attrNames = FmTemplateAttributess.stream().map(FmTemplateAttributes::getAttrCode).collect(Collectors.toList());
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!attrNames.contains(entry.getKey())) {
                Ulog.info((String)("\u65b0\u589e\u65f6\u5220\u9664\u4e0d\u9700\u8981\u7684\u5217*****" + entry.getKey()));
                continue;
            }
            attrMap.put(entry.getKey(), entry.getValue());
        }
        return attrMap;
    }

    public List<FmTemplateAttributes> getAttrByTemplateId(String templateId) {
        List formColumnAll = (List)CacheManager.get((String)("template_attributes_list_all_" + templateId));
        if (CollectionUtils.isEmpty((Collection)formColumnAll)) {
            FmTemplateAttributes tFormColumn = new FmTemplateAttributes();
            tFormColumn.select(FmTemplateAttributes.ATTR_ID, FmTemplateAttributes.ATTR_CODE, FmTemplateAttributes.COMPONENT_TYPE).where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).addEq(FmTemplateAttributes.IS_COLUMN, (Object)"Y").addEq(FmTemplateAttributes.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
            formColumnAll = this.dao.findAll((AbsModel)tFormColumn);
            CacheManager.put((String)("template_attributes_list_all_" + templateId), (Object)formColumnAll);
            CacheManager.expire((String)("template_attributes_list_all_" + templateId), (long)604800L);
        }
        return formColumnAll;
    }
}

