/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.rms.dic.servers.impl;

import com.uniapis.cache.CacheManager;
import com.uniapis.model.sys.SysEnum;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.Field;
import com.uniapis.rms.dic.servers.IDicService;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IDicServiceImpl
implements IDicService {
    @Autowired
    private AbsModelRepository dao;

    public ReturnMsg addDic(SysEnum sysEnum) {
        SysEnum menus;
        Return msg = new Return();
        sysEnum.setEnumId(UUID.shortUUID());
        if (StrUtils.isNull((Object)sysEnum.getEnumCode())) {
            msg.setFailMsg("\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)sysEnum.getEnumName())) {
            msg.setFailMsg("\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)sysEnum.getUpEnum())) {
            msg.setFailMsg("\u7236\u7ea7\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StrUtils.isNull((Object)(menus = (SysEnum)this.dao.findOne((AbsModel)SysEnum.n((boolean)true).setUpEnum(sysEnum.getUpEnum()).setEnumCode(sysEnum.getEnumCode()))))) {
            msg.setFailMsg("\u540c\u4e00\u7236\u8282\u70b9\u4e0b\uff0c\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)sysEnum.getEnumOrder())) {
            SysEnum anEnum = new SysEnum();
            anEnum.where().addEq(SysEnum.DATA_FLAG, (Object)"1").addEq(SysEnum.ENUM_ID, (Object)sysEnum.getUpEnum());
            anEnum.groupBy().max(SysEnum.ENUM_ORDER);
            anEnum = (SysEnum)this.dao.findOne((AbsModel)anEnum);
            sysEnum.setEnumOrder(Integer.valueOf(null != anEnum.getOtherProperty("max_enum_order") ? (!StrUtils.isNull((Object)anEnum.getOtherProperty("max_enum_order").toString()) ? Integer.parseInt(anEnum.getOtherProperty("max_enum_order").toString()) + 1 : 0) : 0));
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        msg.addReturn(sysEnum.checkValue());
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        CacheManager.removeHash((String)"dicType");
        this.dao.save((AbsModel)sysEnum);
        msg.setDataTable(new Object[]{sysEnum});
        return msg.msg();
    }

    public ReturnMsg delDic(SysEnum menu) {
        Return msg = new Return();
        SysEnum menus = (SysEnum)this.dao.findOne((AbsModel)SysEnum.n((boolean)true).setEnumId(menu.getEnumId()));
        if (StrUtils.isNull((Object)menus)) {
            msg.setFailMsg("\u6570\u636e\u4e0d\u5b58\u5728");
            return msg.msg();
        }
        this.dao.delete(menu.where().addEq(SysEnum.ENUM_ID, (Object)menu.getEnumId()).model());
        CacheManager.removeHash((String)"dicType");
        return msg.msg();
    }

    public ReturnMsg mdfDic(SysEnum menu) {
        Return msg = menu.checkValue();
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        menu.where().addEq(SysEnum.ENUM_ID, (Object)menu.getEnumId());
        this.dao.update((AbsModel)menu);
        CacheManager.removeHash((String)"dicType");
        return msg.msg();
    }

    public ReturnMsg queryDic(SysEnum sysEnum) {
        SysEnum dic = SysEnum.n((boolean)true).setUpEnum("root");
        if (!StrUtils.isNull((Object)sysEnum.getEnumCode())) {
            dic.where().addLike(SysEnum.ENUM_CODE, (Object)sysEnum.getEnumCode());
        }
        if (!StrUtils.isNull((Object)sysEnum.getEnumName())) {
            dic.where().addLike(SysEnum.ENUM_NAME, (Object)sysEnum.getEnumName());
        }
        if (!StrUtils.isNull((Object)sysEnum.getEnumType())) {
            dic.where().addLike(SysEnum.ENUM_TYPE, (Object)sysEnum.getEnumType());
        }
        dic.where().setCheckWhere(false);
        dic.setOrderBy(new Sort.Order[]{SysEnum.ENUM_ORDER.asc()});
        List menus = this.dao.findAll((AbsModel)dic, Boolean.valueOf(true));
        this.getChild(menus);
        Return msg = new Return();
        msg.setDataList(menus, SysEnum.class);
        return msg.msg();
    }

    private void getChild(List<SysEnum> menus) {
        List ids = menus.stream().map(SysEnum::getEnumId).collect(Collectors.toList());
        List child = this.dao.findAll(SysEnum.n().where().setCheckWhere(false).addIn(SysEnum.UP_ENUM, ids).model());
        Map<Object, Object> groupByMenu = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)child)) {
            groupByMenu = child.stream().collect(Collectors.groupingBy(SysEnum::getUpEnum));
        }
        HashMap finalGroupByMenu = groupByMenu;
        menus.forEach(menu -> {
            List sysEnumList;
            menu.putOtherProperty("key", (Object)menu.getEnumId());
            menu.putOtherProperty("title", (Object)menu.getEnumName());
            if (!CollectionUtils.isEmpty((Map)finalGroupByMenu) && !CollectionUtils.isEmpty((Collection)(sysEnumList = (List)finalGroupByMenu.get(menu.getEnumId())))) {
                this.getChild(sysEnumList);
                sysEnumList.sort(Comparator.comparing(SysEnum::getEnumOrder));
                menu.putOtherProperty("children", (Object)sysEnumList);
            }
        });
    }

    public ReturnMsg queryDicNoPage() {
        SysEnum dic = SysEnum.n((boolean)true).setUpEnum("root");
        dic.setOrderBy(new Sort.Order[]{SysEnum.ENUM_ORDER.asc()});
        dic.where().addEq(SysEnum.DATA_FLAG, (Object)"1");
        List menus = this.dao.findAll((AbsModel)dic);
        menus.forEach(menu -> {
            menu.putOtherProperty("key", (Object)menu.getEnumId());
            menu.putOtherProperty("title", (Object)menu.getEnumName());
        });
        Return msg = new Return();
        msg.setDataList(menus, SysEnum.class);
        return msg.msg();
    }

    public ReturnMsg queryDicByCode(String enumCode) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)enumCode)) {
            return msg.msg();
        }
        List list = (List)CacheManager.getHash((String)"dicType", (String)enumCode);
        if (CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<String> args = new ArrayList<String>(Arrays.asList("1", enumCode));
            String sql = "select * from sys_enum e where e.up_enum in (select  m.enum_id from sys_enum m where m.data_flag = ? and m.enum_code = ?) order by e.enum_order ";
            list = this.dao.findAll(sql, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(args)});
            CacheManager.putHash((String)"dicType", (String)enumCode, (Object)list);
        }
        msg.setDataList(list);
        return msg.msg();
    }

    public ReturnMsg delDicList(List<String> ids) {
        Return msg = new Return();
        if (CollectionUtils.isEmpty(ids)) {
            msg.setFailMsg("\u5b57\u5178id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        this.dao.delete(SysEnum.n((boolean)true).where().addIn(SysEnum.ENUM_ID, ids).model());
        CacheManager.remove((String)"dicType");
        return msg.msg();
    }

    public ReturnMsg queryDicList(List<String> codes) {
        Return msg = new Return();
        if (CollectionUtils.isEmpty(codes)) {
            msg.setFailMsg("\u5b57\u5178code\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        List sysEnums = this.dao.findAll((AbsModel)((SysEnum)SysEnum.n((boolean)true).select(new Field[]{SysEnum.ENUM_CODE, SysEnum.ENUM_ID}).where().addEq(SysEnum.DATA_FLAG, (Object)"1").addIn(SysEnum.ENUM_CODE, codes).model()).setOrderBy(new Sort.Order[]{SysEnum.ENUM_ORDER.asc()}));
        HashMap<String, List> m = new HashMap<String, List>();
        for (SysEnum s : sysEnums) {
            m.put(s.getEnumCode(), this.dao.findAll((AbsModel)((SysEnum)SysEnum.n((boolean)true).where().addEq(SysEnum.UP_ENUM, (Object)s.getEnumId()).model()).setOrderBy(new Sort.Order[]{SysEnum.ENUM_ORDER.asc()})));
        }
        msg.setDataTable(m);
        return msg.msg();
    }
}

