/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.services.impl;

import com.newtouch.base.model.DsnRules;
import com.newtouch.nms.sip.design.utils.ListUtil;
import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.DsnStructureRules;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipProductSyncTask;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipProductsChannel;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.product.rate.services.IRateService;
import com.newtouch.nms.sip.product.transfer.domain.product.Product;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.services.IProductTransferAsyncService;
import com.newtouch.nms.sip.product.transfer.services.IProductTransferService;
import com.newtouch.nms.sip.product.transfer.utils.TreeComparator;
import com.newtouch.nms.sip.product.utils.EasyExcelUtil;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.context.pojo.User;
import com.uniapis.logger.Env;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.Field;
import com.uniapis.repository.core.utils.SqlMapper;
import com.uniapis.utils.CodecUtils;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@EnableAsync
@Service
public class ProductTransferServiceImpl
implements IProductTransferService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private IRateService rateService;
    @Autowired
    private IProductTransferAsyncService transferAsyncService;
    private static final String ALLOW_SUFFIX = ".zip";

    @Override
    public ReturnMsg exportProduct(List<Map<String, Object>> products) {
        Return msg = new Return();
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String basePath = Env.env().baseDir() + "product/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
        for (Map<String, Object> prdMap : products) {
            Product p = new Product();
            String prdUuid = (String)prdMap.get("product_uuid");
            p.load(prdUuid);
            ArrayList<String> list = new ArrayList<String>();
            list.add(JsonUtils.toJson((Object)p));
            FileUtils.writeFile((String)(basePath + "/" + prdUuid + ".json"), list);
            this.loadRateExcel(basePath + "/", prdUuid);
            ArrayList<String> publishList = new ArrayList<String>();
            publishList.add(JsonUtils.toJson((Object)this.dao.findAll(SipProductsChannel.n().where().addEq(SipProductsChannel.PRODUCT_UUID, (Object)prdUuid).model())));
            FileUtils.writeFile((String)(basePath + "/" + prdUuid + "_publish.json"), publishList);
        }
        String target = Env.env().baseDir() + "product/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + ALLOW_SUFFIX;
        Ulog.info((String)("basePath----" + basePath));
        Ulog.info((String)("target----" + target));
        String zip = FileUtils.zip((String)basePath, (String)target, (String[])new String[]{".json", ".xlsx"});
        Ulog.info((String)("zip----" + zip));
        msg.getDataTable().put("zipPath", target);
        return msg.msg();
    }

    @Override
    public ReturnMsg querySyncTask(SipProductSyncTask task) {
        Return r = new Return();
        if (!StrUtils.isNull((Object)task.getProductUuid())) {
            task.where().addLike(SipProductSyncTask.PRODUCT_UUID, (Object)task.getProductUuid());
        }
        if (!StrUtils.isNull((Object)task.getTaskType())) {
            task.where().addEq(SipProductSyncTask.TASK_TYPE, (Object)task.getTaskType());
        }
        task.setOrderBy(new Sort.Order[]{SipProductSyncTask.MDF_DATE.desc()});
        r.setDataTable(new Object[]{this.dao.findOne((AbsModel)task)});
        return r.msg();
    }

    public void loadRateExcel(String path, String prdUuid) {
        SipProductRisks sipProductRisks = new SipProductRisks();
        sipProductRisks.select(new Field[]{SipProductRisks.RISK_UUID}).where().addIn(SipProductRisks.PRODUCT_UUID, new String[]{prdUuid});
        List sipProductRisksList = this.dao.findAll((AbsModel)sipProductRisks);
        List mainRiskList = sipProductRisksList.stream().map(r -> r.getRiskUuid()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(mainRiskList)) {
            Ulog.info((String)("\u4ea7\u54c1uuid--" + prdUuid + "\u4e0b\u6ca1\u6709\u4e3b\u9669\u4fe1\u606f"));
            return;
        }
        SipRiskRelation sipRiskRelation = new SipRiskRelation();
        sipRiskRelation.select(new Field[]{SipRiskRelation.RISK_UUID, SipRiskRelation.RELATION_TYPE}).where().addIn(SipRiskRelation.MAIN_RISK, mainRiskList);
        List sipRiskRelationList = this.dao.findAll((AbsModel)sipRiskRelation);
        ArrayList<String> otherRiskList = new ArrayList<String>();
        ArrayList<String> accyRiskList = new ArrayList<String>();
        for (SipRiskRelation srr : sipRiskRelationList) {
            String riskUuid = srr.getRiskUuid();
            if ("ADDED".equals(srr.getRelationType())) {
                accyRiskList.add(riskUuid);
            }
            otherRiskList.add(riskUuid);
        }
        if (CollectionUtils.isNotEmpty(accyRiskList)) {
            SipRiskRelation relation = new SipRiskRelation();
            relation.select(new Field[]{SipRiskRelation.RISK_UUID, SipRiskRelation.RELATION_TYPE}).where().addIn(SipRiskRelation.MAIN_RISK, accyRiskList);
            List accyRiskRelationList = this.dao.findAll((AbsModel)relation);
            if (CollectionUtils.isNotEmpty((Collection)accyRiskRelationList)) {
                otherRiskList.addAll(accyRiskRelationList.stream().map(r -> r.getRiskUuid()).collect(Collectors.toList()));
            }
        }
        ArrayList allRiskList = new ArrayList(mainRiskList);
        allRiskList.addAll(otherRiskList);
        List collect = allRiskList.stream().distinct().collect(Collectors.toList());
        SipRisks sipRisk = new SipRisks();
        sipRisk.select(new Field[]{SipRisks.RISK_NO}).where().addIsNotNull(SipRisks.RISK_NO).addIn(SipRisks.RISK_UUID, collect);
        List sipRisksList = this.dao.findAll((AbsModel)sipRisk);
        if (CollectionUtils.isEmpty(mainRiskList)) {
            Ulog.info((String)("\u4ea7\u54c1uuid--" + prdUuid + "\u4e0b\u6ca1\u6709risk_no\u4e0d\u4e3a\u7a7a\u7684\u9669\u79cd"));
            return;
        }
        List allRiskNoList = sipRisksList.stream().map(r -> r.getRiskNo().toLowerCase()).collect(Collectors.toList());
        DsnDynamicData dsnDynamicData = new DsnDynamicData();
        dsnDynamicData.select(new Field[]{DsnDynamicData.FIELD_5, DsnDynamicData.FIELD_2, DsnDynamicData.RELATE_FK}).where().addIn(DsnDynamicData.FIELD_5, allRiskNoList);
        List dsnDynamicDataList = this.dao.findAll((AbsModel)dsnDynamicData);
        List<String> removeList = Arrays.asList("serno", "crt_date", "mdf_date", "crt_user", "mdf_user", "data_flag", "patch_memo", "rn");
        if (CollectionUtils.isNotEmpty((Collection)dsnDynamicDataList)) {
            for (DsnDynamicData ddd : dsnDynamicDataList) {
                String riskNo = ddd.getField5().toLowerCase();
                String relateFk = ddd.getRelateFk();
                String fileName = "dsn_rate_" + riskNo + "_" + ddd.getField2();
                ArrayList<Map<String, Object>> excelDate = new ArrayList();
                List<Object> excelColumnDate = new ArrayList();
                try {
                    SqlMapper sqlMapper = new SqlMapper();
                    sqlMapper.setSql("select *from " + fileName);
                    excelDate = this.dao.findAll(sqlMapper.getSql() + " \uff03NOTCHECK", new AbsModelRepository.Args[]{this.dao.args(sqlMapper.getValue())});
                    SqlMapper columnSqlMapper = new SqlMapper();
                    columnSqlMapper.setSql("select column_name  from Information_schema.columns where table_Name = ? ");
                    ArrayList<String> fileNameList = new ArrayList<String>();
                    fileNameList.add(fileName);
                    columnSqlMapper.setValue(fileNameList);
                    excelColumnDate = this.dao.findAll(columnSqlMapper.getSql() + " \uff03NOTCHECK", new AbsModelRepository.Args[]{this.dao.args(columnSqlMapper.getValue())});
                    if (CollectionUtils.isNotEmpty(excelColumnDate)) {
                        excelColumnDate = excelColumnDate.stream().distinct().collect(Collectors.toList());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!CollectionUtils.isNotEmpty(excelDate)) continue;
                excelDate.removeAll(removeList);
                ArrayList<String> fieldList = new ArrayList<String>();
                for (Map map : excelColumnDate) {
                    String columnName = map.get("column_name").toString();
                    if (removeList.contains(columnName)) continue;
                    fieldList.add(columnName);
                }
                EasyExcelUtil.writeExcel(null, path + fileName + "-" + prdUuid + "-" + relateFk + ".xlsx", relateFk, fieldList, fieldList, excelDate);
            }
        }
    }

    @Override
    public ReturnMsg importProduct(MultipartFile file, String md5, String taskType) {
        ThreadLocalContext.get().setRqstSource("insure");
        String basePath = Env.env().baseDir() + "product/import/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = this.unzipFile(file, md5, basePath);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg("\u4e0a\u4f20\u5931\u8d25");
            return msg.msg();
        }
        File importDir = new File(basePath);
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<File> rateExcelList = new ArrayList<File>();
        ArrayList<File> publishList = new ArrayList<File>();
        this.getAllFiles(importDir, fileList, rateExcelList, publishList);
        User user = ThreadLocalContext.get().getUser();
        List uuidList = fileList.stream().map(p -> p.getName().substring(0, p.getName().lastIndexOf("."))).collect(Collectors.toList());
        SipProducts product = SipProducts.n();
        product.where().addIn(SipProducts.PRODUCT_UUID, uuidList);
        List sipProductsList = this.dao.findAll((AbsModel)product);
        StringJoiner nameJoiner = new StringJoiner(",");
        StringJoiner uuidJoiner = new StringJoiner(",");
        sipProductsList.forEach(p -> {
            nameJoiner.add(p.getProductName());
            uuidJoiner.add(p.getProductUuid());
        });
        SipProductSyncTask task = new SipProductSyncTask();
        task.setTaskName(nameJoiner.toString());
        task.setProductUuid(uuidJoiner.toString());
        task.setFuncModule("PRODUCT");
        task.setTaskType("IMP");
        task.setTaskState("ING");
        task.setIsZipDel("1");
        String serno = UUID.uuid();
        task.setSerno(serno);
        this.dao.save((AbsModel)task);
        this.transferAsyncService.importProductAsync(fileList, rateExcelList, publishList, user, serno, basePath);
        return msg.msg();
    }

    @Override
    public ReturnMsg compareProduct(MultipartFile newFile) {
        String basePath = Env.env().baseDir() + "product/import/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = this.unzipFile(newFile, null, basePath);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg("\u4e0a\u4f20\u5931\u8d25");
            return msg.msg();
        }
        File importDir = new File(basePath);
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<File> rateExcelList = new ArrayList<File>();
        ArrayList<File> publishList = new ArrayList<File>();
        this.getAllFiles(importDir, fileList, rateExcelList, publishList);
        Return aReturn = new Return();
        for (File file : fileList) {
            String pdrUuid = file.getName().substring(0, file.getName().lastIndexOf("."));
            StringBuffer buffer = new StringBuffer();
            try (FileInputStream inputStream = new FileInputStream(file);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String result = "";
            result = new String(buffer.toString().getBytes(), StandardCharsets.UTF_8);
            Product importProduct = (Product)JsonUtils.json2Class((String)result, Product.class);
            String imports = JsonUtils.toJson((Object)importProduct);
            System.out.println("\u5bfc\u5165\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + imports);
            Product dbProduct = new Product();
            dbProduct.load(pdrUuid);
            String dbPrd = JsonUtils.toJson((Object)dbProduct);
            System.out.println("\u67e5\u8be2\u51fa\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + dbPrd);
            ArrayList<Map<String, Object>> diffData = new ArrayList<Map<String, Object>>();
            TreeNode diffTree = TreeComparator.buildDiffTree(importProduct.fetchTreeNode(), dbProduct.fetchTreeNode(), diffData);
            aReturn.getDataTable().put("diffTree", diffTree);
            aReturn.getDataTable().put("diffData", diffData);
        }
        return aReturn.msg();
    }

    @Override
    public ReturnMsg importPropose(MultipartFile file, String md5) throws Exception {
        String basePath = Env.env().baseDir() + "product/import/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = this.unzipFile(file, md5, basePath);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg("\u4e0a\u4f20\u5931\u8d25");
            return msg.msg();
        }
        File importDir = new File(basePath);
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<File> rateExcelList = new ArrayList<File>();
        ArrayList<File> publishList = new ArrayList<File>();
        this.getAllFiles(importDir, fileList, rateExcelList, publishList);
        for (File aProduct : fileList) {
            String pdrUuid = aProduct.getName().substring(0, aProduct.getName().lastIndexOf("."));
            SipProducts prd = new SipProducts();
            prd.where().addEq(SipProducts.PRODUCT_UUID, (Object)pdrUuid);
            if (StrUtils.isNull((Object)((SipProducts)this.dao.findOne((AbsModel)prd)).getSerno())) {
                throw new BusinessException(new Message("2016027", "\u5206\u516c\u53f8\u4ea7\u54c1\u7b56\u7565\u5220\u9664\u6210\u529f"));
            }
            StringBuffer buffer = new StringBuffer();
            try (FileInputStream inputStream = new FileInputStream(aProduct);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String result = "";
            result = new String(buffer.toString().getBytes(), StandardCharsets.UTF_8);
            Product importProduct = (Product)JsonUtils.json2Class((String)result, Product.class);
            String imports = JsonUtils.toJson((Object)importProduct);
            System.out.println("\u5bfc\u5165\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + imports);
            Product dbProduct = new Product();
            dbProduct.load(pdrUuid);
            String dbPrd = JsonUtils.toJson((Object)dbProduct);
            System.out.println("\u67e5\u8be2\u51fa\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + dbPrd);
            dbProduct.merge(importProduct);
            dbPrd = JsonUtils.toJson((Object)dbProduct);
            System.out.println("merger\u540e\u7684\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + dbPrd);
            dbProduct.save();
        }
        msg.setSuccessMsg("\u4e0a\u4f20\u6210\u529f");
        return msg.msg();
    }

    @Override
    public ReturnMsg transferRule(String delFlag) {
        Return msg = new Return();
        if ("1".equals(delFlag)) {
            this.delTransferRule();
        } else {
            this.addTransferRule();
        }
        msg.setSuccessMsg("\u8f6c\u6362\u6210\u529f");
        return msg.msg();
    }

    private ReturnMsg addTransferRule() {
        Return msg = new Return();
        ArrayList<String> sqlParam = new ArrayList<String>();
        sqlParam.add("1");
        String sql = "select dr.* from dsn_rules dr  where dr.data_flag = ? and dr.rule_id not in (select rule_id from dsn_structure_rules)";
        List dsnRulesList = this.dao.findAll(sql, DsnRules.class, new AbsModelRepository.Args[]{this.dao.args(sqlParam)});
        if (CollectionUtils.isEmpty((Collection)dsnRulesList)) {
            msg.setSuccessMsg("\u6570\u636e\u4e3a\u7a7a");
            return msg.msg();
        }
        List<String> strings = Arrays.asList("init_rule", "value_change_rule", "select_risk_rule", "cancel_risk_rule", "add_prd_rule", "del_prd_rule", "fee_rule", "fee_finish_rule", "next_rule");
        ArrayList<DsnStructureRules> dsnStructureRulesList = new ArrayList<DsnStructureRules>();
        for (DsnRules rules : dsnRulesList) {
            DsnStructureRules dsnStructureRules = new DsnStructureRules();
            String ruleId = rules.getRuleId();
            String relateFk = rules.getRelateFk();
            DsnStructure dsnStructure = new DsnStructure();
            dsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)relateFk);
            DsnStructure dsnStructureDb = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
            if (dsnStructureDb == null || !"rule".equals(dsnStructureDb.getNodeType())) continue;
            String upNode = dsnStructureDb.getUpNode();
            dsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)upNode);
            DsnStructure dsnStructureUp = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
            if (dsnStructureUp == null || !strings.contains(dsnStructureUp.getNodeType())) {
                Ulog.info((String)("ruleId--" + ruleId + "\u4e0a\u7ea7\u4e0d\u6b63\u5e38"));
                continue;
            }
            String nodeType = dsnStructureUp.getNodeType();
            String nodeSeq = dsnStructureUp.getNodeSeq();
            String[] split = nodeSeq.split("\\.");
            String selectRiskUuidNodeRisk = split[split.length - 3];
            String selectRiskUuidNodeAttr = split.length > 5 ? split[split.length - 5] : "";
            String nodeNo = dsnStructureUp.getUpNode();
            DsnStructure detail = new DsnStructure();
            detail.where().addEq(DsnStructure.UP_NODE, (Object)selectRiskUuidNodeRisk);
            detail.where().addEq(DsnStructure.NODE_TYPE, (Object)"n_risk_detail");
            detail = (DsnStructure)this.dao.findOne((AbsModel)detail);
            dsnStructureRules.setRuleBelongs("risk");
            if (detail == null) {
                detail = new DsnStructure();
                detail.where().addEq(DsnStructure.UP_NODE, (Object)selectRiskUuidNodeAttr);
                detail.where().addEq(DsnStructure.NODE_TYPE, (Object)"n_risk_detail");
                detail = (DsnStructure)this.dao.findOne((AbsModel)detail);
                dsnStructureRules.setRuleBelongs("attr");
            }
            DsnRules rulesUpdate = new DsnRules();
            rulesUpdate.setRelateFk(nodeNo);
            rulesUpdate.where().addEq(DsnRules.RULE_ID, (Object)ruleId);
            rulesUpdate.where().addEq(DsnRules.RELATE_FK, (Object)relateFk);
            this.dao.update((AbsModel)rulesUpdate);
            dsnStructureRules.setRiskUuid(detail.getNodeNo());
            dsnStructureRules.setRuleName(dsnStructureDb.getNodeName());
            dsnStructureRules.setEventType(nodeType);
            dsnStructureRules.setNodeNo(nodeNo);
            dsnStructureRules.setRuleId(ruleId);
            dsnStructureRules.setStartDate(rules.getStartDate());
            dsnStructureRules.setEndDate(rules.getEndDate());
            dsnStructureRules.setScheduleOrder(rules.getScheduleOrder());
            dsnStructureRules.setStatus(rules.getStatus());
            dsnStructureRules.setUseScene(rules.getUseScene());
            dsnStructureRules.setOrganId("1000000");
            dsnStructureRules.setChannelNo("ALL");
            dsnStructureRules.setIsQuote("N");
            dsnStructureRules.setEventObject("SELF");
            dsnStructureRulesList.add(dsnStructureRules);
        }
        if (CollectionUtils.isNotEmpty(dsnStructureRulesList)) {
            DsnStructure dsnStructure = new DsnStructure();
            List<String> stringsDel = Arrays.asList("init_rule", "value_change_rule", "select_risk_rule", "cancel_risk_rule", "add_prd_rule", "del_prd_rule", "fee_rule", "fee_finish_rule", "next_rule", "rule");
            dsnStructure.where().addIn(DsnStructure.NODE_TYPE, stringsDel);
            this.dao.delete((AbsModel)dsnStructure);
            this.dao.save(dsnStructureRulesList);
        }
        return null;
    }

    private ReturnMsg delTransferRule() {
        Return msg = new Return();
        DsnRules dsnRules = new DsnRules();
        dsnRules.where().addEq(DsnRules.DATA_FLAG, (Object)"1");
        List dsnRulesList = this.dao.findAll((AbsModel)dsnRules);
        if (CollectionUtils.isEmpty((Collection)dsnRulesList)) {
            msg.setSuccessMsg("\u6570\u636e\u4e3a\u7a7a");
            return msg.msg();
        }
        List<String> strings = Arrays.asList("init_rule", "value_change_rule", "select_risk_rule", "cancel_risk_rule", "add_prd_rule", "del_prd_rule", "fee_rule", "fee_finish_rule", "next_rule");
        ArrayList<DsnStructureRules> dsnStructureRulesList = new ArrayList<DsnStructureRules>();
        for (DsnRules rules : dsnRulesList) {
            String relateFk;
            DsnStructureRules dsnStructureRules = new DsnStructureRules();
            String ruleId = rules.getRuleId();
            String nodeNo = relateFk = rules.getRelateFk();
            DsnStructure dsnStructure = new DsnStructure();
            dsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)relateFk);
            DsnStructure dsnStructureDb = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
            if (dsnStructureDb == null) continue;
            if (!"n_rule".equals(dsnStructureDb.getNodeType())) {
                String upNode = dsnStructureDb.getUpNode();
                dsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)upNode);
                DsnStructure dsnStructureUp = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
                if (dsnStructureUp == null) continue;
                String nodeType = dsnStructureUp.getNodeType();
                String nodeSeq = dsnStructureUp.getNodeSeq();
                String[] split = nodeSeq.split("\\.");
                String selectRiskUuidNodeRisk = split[split.length - 3];
                String selectRiskUuidNodeAttr = split.length > 5 ? split[split.length - 5] : "";
                dsnStructureRules.setEventType(nodeType);
                if (strings.contains(nodeType)) {
                    nodeNo = dsnStructureUp.getUpNode();
                } else {
                    if (!"n_rule".equals(nodeType)) continue;
                    nodeNo = upNode;
                    selectRiskUuidNodeRisk = split[split.length - 2];
                    selectRiskUuidNodeAttr = split.length > 4 ? split[split.length - 4] : "";
                    this.setDsnStructureRules(ruleId, dsnStructureRules);
                }
                DsnStructure detail = new DsnStructure();
                detail.where().addEq(DsnStructure.UP_NODE, (Object)selectRiskUuidNodeRisk);
                detail.where().addEq(DsnStructure.NODE_TYPE, (Object)"n_risk_detail");
                detail = (DsnStructure)this.dao.findOne((AbsModel)detail);
                dsnStructureRules.setRuleBelongs("risk");
                if (detail == null) {
                    detail = new DsnStructure();
                    detail.where().addEq(DsnStructure.UP_NODE, (Object)selectRiskUuidNodeAttr);
                    detail.where().addEq(DsnStructure.NODE_TYPE, (Object)"n_risk_detail");
                    detail = (DsnStructure)this.dao.findOne((AbsModel)detail);
                    dsnStructureRules.setRuleBelongs("attr");
                }
                dsnStructureRules.setRiskUuid(detail.getNodeNo());
                dsnStructureRules.setRuleName(dsnStructureDb.getNodeName());
                DsnRules rulesUpdate = new DsnRules();
                rulesUpdate.setRelateFk(nodeNo);
                rulesUpdate.where().addEq(DsnRules.RULE_ID, (Object)ruleId);
                rulesUpdate.where().addEq(DsnRules.RELATE_FK, (Object)relateFk);
                this.dao.update((AbsModel)rulesUpdate);
            } else {
                this.setDsnStructureRules(ruleId, dsnStructureRules);
            }
            dsnStructureRules.setNodeNo(nodeNo);
            dsnStructureRules.setRuleId(ruleId);
            dsnStructureRules.setStartDate(rules.getStartDate());
            dsnStructureRules.setEndDate(rules.getEndDate());
            dsnStructureRules.setScheduleOrder(rules.getScheduleOrder());
            dsnStructureRules.setStatus(rules.getStatus());
            dsnStructureRules.setUseScene(rules.getUseScene());
            dsnStructureRules.setOrganId("1000000");
            dsnStructureRules.setChannelNo("ALL");
            dsnStructureRules.setIsQuote("N");
            dsnStructureRules.setEventObject("SELF");
            dsnStructureRulesList.add(dsnStructureRules);
        }
        if (CollectionUtils.isNotEmpty(dsnStructureRulesList)) {
            DsnStructureRules delete = new DsnStructureRules();
            delete.where().addEq(DsnStructureRules.DATA_FLAG, (Object)"1");
            this.dao.delete((AbsModel)delete);
            DsnStructure dsnStructure = new DsnStructure();
            List<String> stringsDel = Arrays.asList("init_rule", "value_change_rule", "select_risk_rule", "cancel_risk_rule", "add_prd_rule", "del_prd_rule", "fee_rule", "fee_finish_rule", "next_rule", "rule");
            dsnStructure.where().addIn(DsnStructure.NODE_TYPE, stringsDel);
            this.dao.delete((AbsModel)dsnStructure);
            this.dao.save(dsnStructureRulesList);
        }
        return null;
    }

    private void setDsnStructureRules(String ruleId, DsnStructureRules dsnStructureRules) {
        DsnStructureRules selectStructureRules = new DsnStructureRules();
        selectStructureRules.where().addEq(DsnStructureRules.RULE_ID, (Object)ruleId);
        selectStructureRules = (DsnStructureRules)this.dao.findOne((AbsModel)selectStructureRules);
        if (selectStructureRules != null) {
            dsnStructureRules.setEventType(selectStructureRules.getEventType());
            dsnStructureRules.setRiskUuid(selectStructureRules.getRiskUuid());
            dsnStructureRules.setRuleName(selectStructureRules.getRuleName());
            dsnStructureRules.setRuleBelongs(selectStructureRules.getRuleBelongs());
        }
    }

    public void importData(List<Map<String, Object>> excelData, String tableName) {
        String timestamp = DateUtils.date2String((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        ArrayList insertList = new ArrayList();
        String delSql = "TRUNCATE " + tableName;
        this.dao.getJdbcTemplate().update(delSql);
        excelData.forEach(map -> {
            StringBuilder sql = new StringBuilder("INSERT INTO " + tableName + " (serno, crt_user, mdf_user, data_flag, crt_date, mdf_date");
            StringBuilder value = new StringBuilder(" VALUES('" + UUID.shortUUID() + "', '" + ThreadLocalContext.get().getUser().getPkUuid() + "', '" + ThreadLocalContext.get().getUser().getPkUuid() + "', '1', '" + timestamp + "', '" + timestamp + "'");
            for (Map.Entry entry : map.entrySet()) {
                sql.append(", " + (String)entry.getKey());
                value.append(", '" + entry.getValue() + "'");
            }
            insertList.add(sql.append(") ").append((CharSequence)value).append(")").toString());
        });
        List<List<String>> taskList = ListUtil.splitList(insertList, 1000, String.class);
        Ulog.info((String)("\u6570\u636e\u603b\u91cf\u4e3a===>" + insertList.size() + "  \u5206\u7ec4\u6570\u91cf\u4e3a===>" + taskList.size()));
        for (List<String> date : taskList) {
            this.dao.getJdbcTemplate().batchUpdate(date.toArray(new String[0]));
        }
    }

    private Return unzipFile(MultipartFile file, String md5, String path) {
        String fileName = file.getOriginalFilename();
        long fileSize = file.getSize();
        Return msg = this.checkFile(fileName, fileSize);
        try {
            String s = CodecUtils.md5((InputStream)file.getInputStream());
            Ulog.info((String)("\u6587\u4ef6md5\u503c--" + s));
            if (!StrUtils.isNull((Object)md5) && !md5.equals(s)) {
                msg.setFailMsg("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                return msg;
            }
            File destFile = new File(path);
            if (!destFile.exists()) {
                destFile.mkdirs();
            }
            FileUtils.unzip((InputStream)file.getInputStream(), (String)path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return msg;
    }

    private Return checkFile(String fileName, long fileSize) {
        String suffix;
        Return msg = new Return();
        if (fileName.indexOf(".") < 0) {
            msg.setFailMsg("\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6");
        }
        if (ALLOW_SUFFIX.indexOf(suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) == -1) {
            msg.setFailMsg("\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6");
        }
        if (fileSize <= 0L) {
            msg.setFailMsg("\u6587\u4ef6\u5fc5\u987b\u5927\u4e8e0KB");
        }
        return msg;
    }

    public void getAllFiles(File dir, List<File> file, List<File> rateFile, List<File> publishList) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file1;
            if (files[i].isDirectory()) {
                this.getAllFiles(files[i], file, rateFile, publishList);
                continue;
            }
            String name = files[i].getName();
            if (name.endsWith("_publish.json")) {
                file1 = files[i];
                publishList.add(file1);
            } else if (name.endsWith(".json")) {
                file1 = files[i];
                file.add(file1);
            }
            if (name.endsWith(".xlsx") && !name.startsWith("~")) {
                File file2 = files[i];
                rateFile.add(file2);
            }
            Ulog.info((Object)files[i]);
        }
    }

    public static void main(String[] args) {
        String nodeSeq = "aV7Q8ESF.2M0ouiK6.9ioZTxhh.00PkTTHV.9ON51jay.ENWb5ms2.j5KQpXwA.XzCzkFPw.zy0JDlZU.";
        String[] split = nodeSeq.split("\\.");
        Ulog.info((Object)split.length);
        String selectRiskUuidNode = split[split.length - 5];
        Ulog.info((String)selectRiskUuidNode);
    }
}

