-- 1. 单证分类表
CREATE TABLE "pol_docs_type" (
                                 serno character varying(64),
                                 "docs_type" VARCHAR(64) NOT NULL,
                                 "docs_desc" VARCHAR(128) NOT NULL,
                                 "with_organ" VARCHAR(128) NOT NULL,
                                 "with_risk" VARCHAR(128) NOT NULL,
                                 "display_panel" VARCHAR(32) NOT NULL,
                                 "data_flag" VARCHAR(32),
                                 "crt_date" TIMESTAMP(0),
                                 "mdf_date" TIMESTAMP(0),
                                 "crt_user" VARCHAR(64),
                                 "mdf_user" VARCHAR(64),
                                 "data_auth" VARCHAR(256),
                                 "shard_code" VARCHAR(32),
                                 PRIMARY KEY ("docs_type")
)
    WITH (ORIENTATION = ROW, COMPRESSION = NO);

-- 字段注释（与你提供的模板格式完全一致）
COMMENT ON COLUMN "pol_docs_type"."docs_type" IS '单证类型';
COMMENT ON COLUMN "pol_docs_type"."docs_desc" IS '类型中文';
COMMENT ON COLUMN "pol_docs_type"."with_organ" IS '与机构相关';
COMMENT ON COLUMN "pol_docs_type"."with_risk" IS '与险种相关';
COMMENT ON COLUMN "pol_docs_type"."display_panel" IS '显示位置';
COMMENT ON COLUMN "pol_docs_type"."data_flag" IS '数据状态标识';
COMMENT ON COLUMN "pol_docs_type"."crt_date" IS '创建时间';
COMMENT ON COLUMN "pol_docs_type"."mdf_date" IS '修改时间';
COMMENT ON COLUMN "pol_docs_type"."crt_user" IS '创建人';
COMMENT ON COLUMN "pol_docs_type"."mdf_user" IS '修改人';
COMMENT ON COLUMN "pol_docs_type"."data_auth" IS '数据权限';
COMMENT ON COLUMN "pol_docs_type"."shard_code" IS '分片编码';

-- 表注释（与你提供的模板格式完全一致）
COMMENT ON TABLE "pol_docs_type" IS '单证分类表';

-- 2. 模板表
CREATE TABLE "pol_docs_template" (
                                     "serno" character varying(64),
                                     "docs_type" VARCHAR(64) NOT NULL,
                                     "tpl_uuid" VARCHAR(64) NOT NULL,
                                     "tpl_type" VARCHAR(64) NOT NULL,
                                     "tpl_name" VARCHAR(128) NOT NULL,
                                     "tpl_version" VARCHAR(32) NOT NULL,
                                     "tpl_risk" VARCHAR(32) NOT NULL,
                                     "data_flag" VARCHAR(32),
                                     "crt_date" TIMESTAMP(0),
                                     "mdf_date" TIMESTAMP(0),
                                     "crt_user" VARCHAR(64),
                                     "mdf_user" VARCHAR(64),
                                     "data_auth" VARCHAR(256),
                                     "shard_code" VARCHAR(32),
                                     PRIMARY KEY ("tpl_uuid")
)
    WITH (ORIENTATION = ROW, COMPRESSION = NO);

-- 字段注释（a:b 换行形式）
COMMENT ON COLUMN "pol_docs_template"."serno" IS '序列号';
COMMENT ON COLUMN "pol_docs_template"."docs_type" IS '单证类型';
COMMENT ON COLUMN "pol_docs_template"."tpl_uuid" IS '单证模板编码';
COMMENT ON COLUMN "pol_docs_template"."tpl_type" IS '单证模型类型';
COMMENT ON COLUMN "pol_docs_template"."tpl_name" IS '单证模板名称';
COMMENT ON COLUMN "pol_docs_template"."tpl_version" IS '单证模板版本';
COMMENT ON COLUMN "pol_docs_template"."tpl_risk" IS '模板内险种数量';
COMMENT ON COLUMN "pol_docs_template"."data_flag" IS '数据状态标识';
COMMENT ON COLUMN "pol_docs_template"."crt_date" IS '创建时间';
COMMENT ON COLUMN "pol_docs_template"."mdf_date" IS '修改时间';
COMMENT ON COLUMN "pol_docs_template"."crt_user" IS '创建人';
COMMENT ON COLUMN "pol_docs_template"."mdf_user" IS '修改人';
COMMENT ON COLUMN "pol_docs_template"."data_auth" IS '数据权限';
COMMENT ON COLUMN "pol_docs_template"."shard_code" IS '分片编码';

-- 表注释
COMMENT ON TABLE "pol_docs_template" IS '单证模板表';


-- 3.内容表
CREATE TABLE "pol_docs_content" (
                                    "serno" character varying(64),
                                    "tpl_uuid" VARCHAR(64) NOT NULL,
                                    "content_uuid" VARCHAR(64) NOT NULL,
                                    "content_type" VARCHAR(32),
                                    "content_source" VARCHAR(32) ,
                                    "content_role" VARCHAR(32) ,
                                    "content_both" TEXT,
                                    "content_pdf" TEXT,
                                    "content_h5" TEXT,
                                    "display_order" VARCHAR(32),
                                    "data_flag" VARCHAR(32),
                                    "crt_date" TIMESTAMP(0),
                                    "mdf_date" TIMESTAMP(0),
                                    "crt_user" VARCHAR(64),
                                    "mdf_user" VARCHAR(64),
                                    "data_auth" VARCHAR(256),
                                    "shard_code" VARCHAR(32),
                                    PRIMARY KEY ("content_uuid")
)
    WITH (ORIENTATION = ROW, COMPRESSION = NO);

-- 字段注释（a:b 换行形式）
COMMENT ON COLUMN "pol_docs_content"."serno" IS '序列号';
COMMENT ON COLUMN "pol_docs_content"."tpl_uuid" IS '单证模板编码';
COMMENT ON COLUMN "pol_docs_content"."content_uuid" IS '内容编码';
COMMENT ON COLUMN "pol_docs_content"."content_type" IS '内容类型';
COMMENT ON COLUMN "pol_docs_content"."content_source" IS '内容来源';
COMMENT ON COLUMN "pol_docs_content"."content_role" IS '内容角色';
COMMENT ON COLUMN "pol_docs_content"."content_both" IS '内容通用';
COMMENT ON COLUMN "pol_docs_content"."content_pdf" IS '内容pc';
COMMENT ON COLUMN "pol_docs_content"."content_h5" IS '内容h5';
COMMENT ON COLUMN "pol_docs_content"."display_order" IS '排序';
COMMENT ON COLUMN "pol_docs_content"."data_flag" IS '数据状态标识';
COMMENT ON COLUMN "pol_docs_content"."crt_date" IS '创建时间';
COMMENT ON COLUMN "pol_docs_content"."mdf_date" IS '修改时间';
COMMENT ON COLUMN "pol_docs_content"."crt_user" IS '创建人';
COMMENT ON COLUMN "pol_docs_content"."mdf_user" IS '修改人';
COMMENT ON COLUMN "pol_docs_content"."data_auth" IS '数据权限';
COMMENT ON COLUMN "pol_docs_content"."shard_code" IS '分片编码';

-- 表注释
COMMENT ON TABLE "pol_docs_content" IS '单证内容表';


-- 4. 模板变量表
CREATE TABLE "pol_docs_variable" (
                                     "serno" character varying(64),
                                     "content_uuid" VARCHAR(64) NOT NULL,
                                     "var_type" VARCHAR(32) NOT NULL,
                                     "var_uuid" VARCHAR(64) NOT NULL,
                                     "var_name" VARCHAR(128) NOT NULL,
                                     "ui_type" VARCHAR(32) NOT NULL,
                                     "var_content" TEXT,
                                     "display_logic" TEXT,
                                     "with_organ" VARCHAR(32),
                                     "api_url" VARCHAR(512),
                                     "data_flag" VARCHAR(32),
                                     "crt_date" TIMESTAMP(0),
                                     "mdf_date" TIMESTAMP(0),
                                     "crt_user" VARCHAR(64),
                                     "mdf_user" VARCHAR(64),
                                     "data_auth" VARCHAR(256),
                                     "shard_code" VARCHAR(32),
                                     PRIMARY KEY ("var_uuid")
)
    WITH (ORIENTATION = ROW, COMPRESSION = NO);

-- 字段注释（a:b 换行形式）
COMMENT ON COLUMN "pol_docs_variable"."serno" IS '序列号';
COMMENT ON COLUMN "pol_docs_variable"."content_uuid" IS '内容编码';
COMMENT ON COLUMN "pol_docs_variable"."var_type" IS '变量来源';
COMMENT ON COLUMN "pol_docs_variable"."var_uuid" IS '变量编码';
COMMENT ON COLUMN "pol_docs_variable"."var_name" IS '变量名称';
COMMENT ON COLUMN "pol_docs_variable"."ui_type" IS '值类型';
COMMENT ON COLUMN "pol_docs_variable"."var_content" IS '值内容';
COMMENT ON COLUMN "pol_docs_variable"."display_logic" IS '显示条件';
COMMENT ON COLUMN "pol_docs_variable"."with_organ" IS '与机构相关';
COMMENT ON COLUMN "pol_docs_variable"."api_url" IS '接口地址';
COMMENT ON COLUMN "pol_docs_variable"."data_flag" IS '数据状态标识';
COMMENT ON COLUMN "pol_docs_variable"."crt_date" IS '创建时间';
COMMENT ON COLUMN "pol_docs_variable"."mdf_date" IS '修改时间';
COMMENT ON COLUMN "pol_docs_variable"."crt_user" IS '创建人';
COMMENT ON COLUMN "pol_docs_variable"."mdf_user" IS '修改人';
COMMENT ON COLUMN "pol_docs_variable"."data_auth" IS '数据权限';
COMMENT ON COLUMN "pol_docs_variable"."shard_code" IS '分片编码';

-- 表注释
COMMENT ON TABLE "pol_docs_variable" IS '模板变量表';


-- 5. 机构模板表
CREATE TABLE "pol_organ_docs" (
                                  "serno" VARCHAR(64) COMMENT '序列号',
                                  "doc_var_uuid" VARCHAR(64) NOT NULL COMMENT '关系编码',
                                  "organ_id" VARCHAR(64) NOT NULL COMMENT '机构ID',
                                  "organ_name" VARCHAR(64) NOT NULL COMMENT '机构名称',
                                  "branch_id" VARCHAR(64) NOT NULL COMMENT '渠道编码',
                                  "tpl_uuid" VARCHAR(64) NOT NULL COMMENT '模板编码',
                                  "sign_read" VARCHAR(32) COMMENT '阅读签字',
                                  "is_record" VARCHAR(32) COMMENT '是否双录',
                                  "is_compel" VARCHAR(32) COMMENT '是否强制阅读',
                                  "display_order" INT COMMENT '排序',
                                  "sign_group" VARCHAR(64) COMMENT '签字分组',
                                  "display_logic" VARCHAR(64) COMMENT '显示条件',
                                  "start_time" TIMESTAMP(0) COMMENT '生效开始时间',
                                  "end_time" TIMESTAMP(0) COMMENT '生效结束时间',
                                  "data_flag" VARCHAR(32) COMMENT '数据状态标识',
                                  "crt_date" TIMESTAMP(0) COMMENT '创建时间',
                                  "mdf_date" TIMESTAMP(0) COMMENT '修改时间',
                                  "crt_user" VARCHAR(64) COMMENT '创建人',
                                  "mdf_user" VARCHAR(64) COMMENT '修改人',
                                  "data_auth" VARCHAR(256) COMMENT '数据权限',
                                  "shard_code" VARCHAR(32) COMMENT '分片编码',
                                  PRIMARY KEY ("doc_var_uuid") -- 主键约束：关系编码
);
