/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.rule;

import com.newtouch.base.model.DsnRules;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.product.transfer.domain.rule.RuleInfo;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class RuleNode
implements Comparable {
    private DsnStructure ruleStructure;
    private List<RuleInfo> rules = new ArrayList<RuleInfo>();

    public RuleNode load(DsnStructure ruleStructure) {
        this.ruleStructure = ruleStructure;
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        utils.queryRules(this.ruleStructure.getNodeNo()).forEach(rule -> {
            RuleInfo info = new RuleInfo();
            info.load((DsnRules)rule);
            this.rules.add(info);
        });
        return this;
    }

    public void merge(RuleNode ruleNode) {
        this.ruleStructure = ProductEqualsUtils.merge(this.ruleStructure, ruleNode.getRuleStructure());
        this.rules = ProductEqualsUtils.merge(this.rules, ruleNode.getRules(), RuleInfo.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        update.update((AbsModel)this.ruleStructure);
        this.rules.forEach(ruleInfo -> ruleInfo.save());
    }

    public DsnStructure getRuleStructure() {
        return this.ruleStructure;
    }

    public void setRuleStructure(DsnStructure ruleStructure) {
        this.ruleStructure = ruleStructure;
    }

    public List<RuleInfo> getRules() {
        return this.rules;
    }

    public void setRules(List<RuleInfo> rules) {
        this.rules = rules;
    }

    public int hashCode() {
        return this.ruleStructure.getOtherProperty("md5").hashCode();
    }

    public int compareTo(Object o) {
        ProductUpdateUtils.UpdateFlag flag = (ProductUpdateUtils.UpdateFlag)((Object)this.ruleStructure.getOtherProperty("update_flag", ProductUpdateUtils.UpdateFlag.class));
        if (flag == ProductUpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }
}

