/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.schedul.service;

import cn.hutool.core.io.FileUtil;
import com.uniapis.logger.Env;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.StrUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BackUpService {
    @Value(value="${spring.datasource.url}")
    private String url;
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;
    @Value(value="${dict.simple.ignoreTableRegEx}")
    private String ignoreTableRegEx;
    @Autowired
    private AbsModelRepository dao;

    public ReturnMsg databaseBackup() {
        Return r = new Return();
        String fileName = "backup_" + new Date().getTime() + ".sql";
        String filePath = Env.env().baseDir() + "db_backup/" + fileName;
        FileUtils.createDirs((String)filePath);
        String tempUrl = this.url.substring(0, this.url.indexOf("?"));
        String databaseName = tempUrl.substring(tempUrl.lastIndexOf("/") + 1);
        String port = tempUrl.substring(tempUrl.lastIndexOf(":") + 1, tempUrl.lastIndexOf("/"));
        String host = tempUrl.substring(tempUrl.lastIndexOf("//") + 2, tempUrl.lastIndexOf(":"));
        StringBuffer sb = new StringBuffer();
        sb.append("mysqldump -u" + this.username + " -P " + port + " -h " + host + " -p" + this.password + " --databases " + databaseName);
        sb.append(" --single-transaction");
        if (!StrUtils.isNull((Object)this.ignoreTableRegEx)) {
            Pattern pattern = Pattern.compile(this.ignoreTableRegEx);
            ArrayList<String> ignoreTableList = new ArrayList<String>();
            ArrayList<String> tableList = new ArrayList<String>();
            try {
                Connection conn = this.dao.getJdbcTemplate().getDataSource().getConnection();
                String[] types = new String[]{"TABLE"};
                ResultSet rs = conn.getMetaData().getTables(null, null, "%", types);
                while (rs.next()) {
                    String tabName = StrUtils.trimStr((Object)rs.getObject("TABLE_NAME"));
                    tableList.add(tabName);
                    Matcher matcher = pattern.matcher(tabName);
                    if (!matcher.matches()) continue;
                    ignoreTableList.add(tabName);
                }
                rs.close();
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            for (String tableName : ignoreTableList) {
                sb.append(" --ignore-table=" + databaseName + "." + tableName);
            }
        }
        sb.append(" > " + filePath);
        String cmd = sb.toString();
        Ulog.info((String)("cmd=====>" + cmd));
        BufferedReader reader = null;
        InputStreamReader ir = null;
        InputStream es = null;
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            es = proc.getErrorStream();
            ir = new InputStreamReader(es, "gbk");
            reader = new BufferedReader(ir);
            String line = null;
            StringBuffer buffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                Ulog.info((String)line);
                buffer.append(line);
            }
            Ulog.info((String)buffer.toString());
            int wait = proc.waitFor();
            Ulog.info((String)("\u8fd0\u884c\u7ed3\u679c" + wait));
            r.getDataTable().put("exitValue", wait);
            if (wait == 0) {
                r.getDataTable().put("filePath", filePath);
                ReturnMsg returnMsg = r.msg();
                return returnMsg;
            }
            r.getDataTable().put("errorInfo", buffer.toString());
            ReturnMsg returnMsg = r.msg();
            return returnMsg;
        }
        catch (Exception e) {
            Ulog.info((String)("\u3010\u5907\u4efd\u6570\u636e\u5e93\u3011\u5931\u8d25\uff1a{}" + e.getMessage()));
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (ir != null) {
                    ir.close();
                }
                if (es != null) {
                    es.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (proc != null) {
                proc.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnMsg databaseBackupNonDump() {
        Return r = new Return();
        long time = new Date().getTime();
        String fileName = "backup_" + time;
        String filePath = Env.env().baseDir() + "db_backup/";
        ArrayList<String> list = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        Statement tableDefSm = null;
        ResultSet tableDefRs = null;
        Statement tableSm = null;
        ResultSet tableRs = null;
        try {
            conn = this.dao.getJdbcTemplate().getDataSource().getConnection();
            stmt = conn.createStatement();
            tableDefSm = conn.createStatement();
            tableSm = conn.createStatement();
            String tempUrl = this.url.substring(0, this.url.indexOf("?"));
            String databaseName = tempUrl.substring(tempUrl.lastIndexOf("/") + 1);
            Map<String, String> urlParamMap = this.urlSplit(this.url);
            String schema = urlParamMap.get("currentSchema");
            if (StrUtils.isNull((Object)schema)) {
                schema = this.username;
            }
            rs = stmt.executeQuery("select table_name from information_schema.tables where table_schema='" + schema + "'");
            while (rs.next()) {
                Pattern pattern;
                Matcher matcher;
                list = new ArrayList<String>();
                String tableName = rs.getString(1);
                if (!StrUtils.isNull((Object)this.ignoreTableRegEx) && (matcher = (pattern = Pattern.compile(this.ignoreTableRegEx)).matcher(tableName)).matches()) continue;
                String singleFileName = "backup_" + tableName + ".sql";
                FileUtil.del((String)(filePath + singleFileName));
                StringBuilder createSql = new StringBuilder("DROP table IF exists " + tableName + ";\n");
                tableDefRs = tableDefSm.executeQuery("SELECT PG_CATALOG.PG_GET_TABLEDEF('" + tableName + "')");
                while (tableDefRs.next()) {
                    String tableDefStr = tableDefRs.getString(1);
                    createSql.append(tableDefStr);
                }
                Ulog.info((String)("\u5efa\u8868createSql-->" + createSql));
                list.add(createSql.toString());
                int batchSize = 1000;
                tableRs = tableSm.executeQuery("select  count(*) from " + tableName);
                tableRs.next();
                int sumCount = tableRs.getInt(1);
                int epoch = 0;
                while (epoch * batchSize < sumCount) {
                    tableRs = tableSm.executeQuery("select  * from " + tableName + " limit " + batchSize + " offset " + epoch * batchSize);
                    ResultSetMetaData metaData = tableRs.getMetaData();
                    int columnCount = metaData.getColumnCount();
                    while (tableRs.next()) {
                        StringBuilder insertSql = new StringBuilder("INSERT INTO " + tableName + " VALUES (");
                        for (int i = 1; i <= columnCount; ++i) {
                            String columnValue = tableRs.getString(i);
                            int columnType = metaData.getColumnType(i);
                            if (columnValue == null) {
                                insertSql.append(columnValue);
                            } else if (4 == columnType) {
                                insertSql.append(columnValue);
                            } else {
                                insertSql.append("'").append(columnValue.replaceAll("'", "''")).append("'");
                            }
                            if (i >= columnCount) continue;
                            insertSql.append(",");
                        }
                        insertSql.append(");");
                        list.add(insertSql.toString());
                    }
                    list.add("\n");
                    FileUtils.writeFile((String)(filePath + singleFileName), list, (boolean)true);
                    ++epoch;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            r.getDataTable().put("errorInfo", e.getMessage());
            ReturnMsg returnMsg = r.msg();
            return returnMsg;
        }
        finally {
            if (tableRs != null) {
                try {
                    tableRs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (tableSm != null) {
                try {
                    tableSm.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (tableDefRs != null) {
                try {
                    tableDefRs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (tableDefSm != null) {
                try {
                    tableDefSm.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        String targetZipPath = filePath + fileName + ".zip";
        FileUtils.zip((String)filePath, (String)targetZipPath, (String[])new String[]{".sql"});
        r.getDataTable().put("exitValue", "0");
        r.getDataTable().put("filePath", targetZipPath);
        return r.msg();
    }

    public static void main(String[] args) {
        String str = "sys_trade_log";
        String regEx = "^sys_.*";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(str);
        boolean rs = matcher.matches();
        System.out.println(rs);
    }

    public Map<String, String> urlSplit(String URL2) {
        LinkedHashMap<String, String> mapRequest = new LinkedHashMap<String, String>();
        String[] arrSplit = null;
        String strUrlParam = this.truncateUrlPage(URL2);
        if (strUrlParam == null) {
            return mapRequest;
        }
        for (String strSplit : arrSplit = strUrlParam.split("[&]")) {
            String[] arrSplitEqual = null;
            arrSplitEqual = strSplit.split("[=]");
            if (arrSplitEqual.length > 1) {
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);
                continue;
            }
            if (arrSplitEqual[0] == "") continue;
            mapRequest.put(arrSplitEqual[0], "");
        }
        return mapRequest;
    }

    public String truncateUrlPage(String strURL) {
        String strAllParam = null;
        String[] arrSplit = null;
        strURL = strURL.trim();
        arrSplit = strURL.split("[?]");
        if (strURL.length() > 1 && arrSplit.length > 1) {
            for (int i = 1; i < arrSplit.length; ++i) {
                strAllParam = arrSplit[i];
            }
        }
        return strAllParam;
    }
}

