/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.schedul.redission;

import com.uniapis.cache.redis.RedisPasswordDecode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonConfig {
    @Autowired
    private RedisProperties redisProperties;
    @Autowired
    private RedisPasswordDecode decode;
    private static String ADDRESS_PREFIX = "redis://";

    @Bean
    @ConditionalOnProperty(name={"spring.redis.mode"}, havingValue="single")
    public RedissonClient redissonSingle() {
        Config config = new Config();
        String redisAddress = ADDRESS_PREFIX + this.redisProperties.getHost() + ":" + this.redisProperties.getPort();
        SingleServerConfig serverConfig = config.useSingleServer().setAddress(redisAddress).setDatabase(Integer.valueOf(this.redisProperties.getDatabase()).intValue());
        if (!StringUtils.isEmpty((CharSequence)this.redisProperties.getPassword())) {
            serverConfig.setPassword(this.decode.decodePassword(this.redisProperties.getPassword()));
        }
        return Redisson.create((Config)config);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.redis.mode"}, havingValue="sentinel")
    public RedissonClient redissonSentinel() {
        String masterName = this.redisProperties.getSentinel().getMaster();
        String password = this.redisProperties.getPassword();
        Config config = new Config();
        SentinelServersConfig sentinelServersConfig = config.useSentinelServers();
        sentinelServersConfig.setScanInterval(2000);
        if (!StringUtils.isEmpty((CharSequence)password)) {
            sentinelServersConfig.setPassword(this.decode.decodePassword(password));
        }
        sentinelServersConfig.setMasterName(masterName);
        String[] nodeArr = (String[])this.redisProperties.getSentinel().getNodes().toArray();
        for (int i = 0; i < nodeArr.length; ++i) {
            nodeArr[i] = ADDRESS_PREFIX + nodeArr[i];
        }
        sentinelServersConfig.addSentinelAddress(nodeArr);
        return Redisson.create((Config)config);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.redis.mode"}, havingValue="cluster")
    public RedissonClient redissonCluster() {
        List nodes = this.redisProperties.getCluster().getNodes();
        String password = this.redisProperties.getPassword();
        Config config = new Config();
        ClusterServersConfig clusterServersConfig = config.useClusterServers();
        clusterServersConfig.setScanInterval(2000);
        if (!StringUtils.isEmpty((CharSequence)password)) {
            clusterServersConfig.setPassword(this.decode.decodePassword(this.redisProperties.getPassword()));
        }
        for (String node : nodes) {
            clusterServersConfig.addNodeAddress(new String[]{ADDRESS_PREFIX + node});
        }
        return Redisson.create((Config)config);
    }
}

