/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.pol.service.impl;

import com.newtouch.nms.sip.model.PolDocsContent;
import com.newtouch.nms.sip.model.PolDocsTemplate;
import com.newtouch.nms.sip.model.PolDocsType;
import com.newtouch.nms.sip.model.PolDocsVariable;
import com.newtouch.nms.sip.model.PolOrganDocs;
import com.newtouch.nms.sip.model.RiskDocRelation;
import com.newtouch.nms.sip.product.pol.service.IDocumentService;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class DocumentServiceImpl
implements IDocumentService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public ReturnMsg queryDocTypeList() {
        PolDocsType queryModel = ((PolDocsType)PolDocsType.n().where().addEq(PolDocsType.DATA_FLAG, (Object)"1").model()).setOrderBy(new Sort.Order[]{PolDocsType.CRT_DATE.desc()});
        List resultList = this.dao.findAll((AbsModel)queryModel);
        Return msg = new Return();
        msg.setDataList(resultList, PolDocsType.class);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addOrUpdateDocTemplate(PolDocsTemplate docTemplateRequest) {
        boolean saveFlag = StringUtils.isEmpty((CharSequence)docTemplateRequest.getTplUuid());
        List contentCodes = docTemplateRequest.getContentList().stream().map(PolDocsContent::getContentUuid).collect(Collectors.toList());
        if (contentCodes.size() != new HashSet(contentCodes).size()) {
            throw new BusinessException("\u5355\u8bc1\u5185\u5bb9\u7f16\u7801\u5b58\u5728\u91cd\u590d\u503c");
        }
        List variableCodes = docTemplateRequest.getContentList().stream().flatMap(polDocsContent -> polDocsContent.getVariableList().stream()).map(PolDocsVariable::getVarUuid).collect(Collectors.toList());
        if (variableCodes.size() != new HashSet(variableCodes).size()) {
            throw new BusinessException("\u53d8\u91cf\u7f16\u7801\u5b58\u5728\u91cd\u590d\u503c");
        }
        Return msg = new Return();
        try {
            if (docTemplateRequest == null) {
                throw new BusinessException("\u5355\u8bc1\u6a21\u677f\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtils.isNull((Object)docTemplateRequest.getDocsType())) {
                throw new BusinessException("\u5355\u8bc1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtils.isNull((Object)docTemplateRequest.getTplName())) {
                throw new BusinessException("\u5355\u8bc1\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtils.isNull((Object)docTemplateRequest.getTplVersion())) {
                throw new BusinessException("\u5355\u8bc1\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            PolDocsType docCategoryModel = (PolDocsType)PolDocsType.n().where().addEq(PolDocsType.DATA_FLAG, (Object)"1").addEq(PolDocsType.DOCS_TYPE, (Object)docTemplateRequest.getDocsType()).model();
            PolDocsType docCategory = (PolDocsType)this.dao.findOne((AbsModel)docCategoryModel);
            if (docCategory == null) {
                throw new BusinessException("\u5355\u8bc1\u7c7b\u578b\u65e0\u6548");
            }
            PolDocsTemplate polDocsTemplate = (PolDocsTemplate)this.dao.findOne(PolDocsTemplate.n().where().addEq(PolDocsTemplate.DATA_FLAG, (Object)"1").addEq(PolDocsTemplate.DOCS_TYPE, (Object)docTemplateRequest.getDocsType()).addEq(PolDocsTemplate.TPL_NAME, (Object)docTemplateRequest.getTplName()).addEq(PolDocsTemplate.TPL_VERSION, (Object)docTemplateRequest.getTplVersion()).model());
            if (saveFlag) {
                if (polDocsTemplate != null) {
                    throw new BusinessException("\u5355\u8bc1\u6a21\u677f\u7c7b\u522b\u3001\u540d\u79f0\u3001\u7248\u672c\u5bf9\u5e94\u6570\u636e\u5df2\u5b58\u5728\uff01");
                }
                docTemplateRequest.setTplUuid(UUID.uuid());
                docTemplateRequest.setDataFlag("1");
                this.dao.save((AbsModel)docTemplateRequest);
            } else {
                PolDocsTemplate polDocsTemplateNow = (PolDocsTemplate)this.dao.findOne(PolDocsTemplate.n().where().addEq(PolDocsTemplate.DATA_FLAG, (Object)"1").addEq(PolDocsTemplate.TPL_UUID, (Object)docTemplateRequest.getTplUuid()).model());
                if (polDocsTemplateNow == null) {
                    throw new BusinessException("\u672a\u627e\u5230\u8be5\u5355\u8bc1\u6a21\u677f");
                }
                if (polDocsTemplate != null && !polDocsTemplate.getTplUuid().equals(docTemplateRequest.getTplUuid())) {
                    throw new BusinessException("\u5355\u8bc1\u6a21\u677f\u7c7b\u522b\u3001\u540d\u79f0\u3001\u7248\u672c\u5bf9\u5e94\u6570\u636e\u5df2\u5b58\u5728\uff01");
                }
                this.dao.update(docTemplateRequest.getTplUuid(), (AbsModel)docTemplateRequest);
            }
            if (docTemplateRequest.getContentList() == null || docTemplateRequest.getContentList().size() == 0) {
                throw new BusinessException("\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (PolDocsContent polDocsContent2 : docTemplateRequest.getContentList()) {
                if (StrUtils.isNull((Object)polDocsContent2.getContentUuid())) {
                    throw new BusinessException("\u5355\u8bc1\u5185\u5bb9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                PolDocsContent polDocsContentModel = (PolDocsContent)this.dao.findOne(PolDocsContent.n().where().addEq(PolDocsContent.DATA_FLAG, (Object)"1").addEq(PolDocsContent.CONTENT_UUID, (Object)polDocsContent2.getContentUuid()).model());
                if (saveFlag) {
                    if (polDocsContentModel != null) {
                        throw new BusinessException("\u5355\u8bc1\u5185\u5bb9\u7f16\u7801\u5bf9\u5e94\u6570\u636e\u5df2\u5b58\u5728\uff01");
                    }
                    polDocsContent2.setTplUuid(docTemplateRequest.getTplUuid());
                    polDocsContent2.setDataFlag("1");
                    this.dao.save((AbsModel)polDocsContent2);
                } else {
                    if (polDocsContentModel != null && !polDocsContentModel.getContentUuid().equals(polDocsContent2.getContentUuid())) {
                        throw new BusinessException("\u5355\u8bc1\u5185\u5bb9\u7f16\u7801\u5bf9\u5e94\u6570\u636e\u5df2\u5b58\u5728\uff01");
                    }
                    this.dao.update(polDocsContent2.getContentUuid(), (AbsModel)polDocsContent2);
                }
                List polDocsVariableList = polDocsContent2.getVariableList();
                if (polDocsVariableList == null || polDocsVariableList.size() == 0) {
                    throw new BusinessException("\u5185\u5bb9\u6a21\u677f\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                for (PolDocsVariable polDocsVariable : polDocsVariableList) {
                    if (StrUtils.isNull((Object)polDocsVariable.getVarUuid())) {
                        throw new BusinessException("\u53d8\u91cf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    PolDocsVariable polDocsVariableModel = (PolDocsVariable)this.dao.findOne(PolDocsVariable.n().where().addEq(PolDocsVariable.DATA_FLAG, (Object)"1").addEq(PolDocsVariable.VAR_UUID, (Object)polDocsVariable.getVarUuid()).model());
                    if (saveFlag) {
                        if (polDocsVariableModel != null) {
                            throw new BusinessException("\u53d8\u91cf\u7f16\u7801\u5df2\u5b58\u5728");
                        }
                        polDocsVariable.setContentUuid(polDocsContent2.getContentUuid());
                        polDocsVariable.setDataFlag("1");
                        this.dao.save((AbsModel)polDocsVariable);
                        continue;
                    }
                    if (polDocsVariableModel != null && !polDocsVariableModel.getVarUuid().equals(polDocsVariable.getVarUuid())) {
                        throw new BusinessException("\u53d8\u91cf\u7f16\u7801\u5df2\u5b58\u5728");
                    }
                    this.dao.update(polDocsVariable.getVarUuid(), (AbsModel)polDocsVariable);
                }
            }
            msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        }
        catch (BusinessException e) {
            msg.setFailMsg(e.getMessage());
        }
        catch (Exception e) {
            msg.setFailMsg("\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage());
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg delDocTemplate(PolDocsTemplate docTemplateRequest) {
        Return msg = new Return();
        if (docTemplateRequest == null) {
            msg.setFailMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)docTemplateRequest.getTplUuid())) {
            msg.setFailMsg("\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        PolOrganDocs queryModel = (PolOrganDocs)PolOrganDocs.n().where().model();
        queryModel.where().addEq(PolOrganDocs.DATA_FLAG, (Object)"1").addEq(PolOrganDocs.TPL_UUID, (Object)docTemplateRequest.getTplUuid());
        List resultList = this.dao.findAll((AbsModel)queryModel);
        if (resultList.size() > 0) {
            msg.setFailMsg("\u8be5\u6a21\u677f\u5df2\u5173\u8054\u673a\u6784\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
            return msg.msg();
        }
        System.err.println("\u6821\u9a8c\u9669\u79cd\u5173\u8054\u5173\u7cfb\u5f85\u786e\u8ba4");
        PolDocsTemplate polDocsTemplate = (PolDocsTemplate)this.dao.findOne(PolDocsTemplate.n().where().addEq(PolDocsTemplate.DATA_FLAG, (Object)"1").addEq(PolDocsTemplate.TPL_UUID, (Object)docTemplateRequest.getTplUuid()).model());
        if (polDocsTemplate == null) {
            msg.setFailMsg("\u672a\u627e\u5230\u8be5\u5355\u8bc1\u6a21\u677f");
            return msg.msg();
        }
        PolDocsContent polDocsContentModel = ((PolDocsContent)PolDocsContent.n().where().addEq(PolDocsContent.DATA_FLAG, (Object)"1").addEq(PolDocsContent.TPL_UUID, (Object)docTemplateRequest.getTplUuid()).model()).setOrderBy(new Sort.Order[]{PolDocsContent.CRT_DATE.desc()});
        List polDocsContentList = this.dao.findAll((AbsModel)polDocsContentModel);
        for (PolDocsContent polDocsContent : polDocsContentList) {
            PolDocsVariable polDocsVariableModel = ((PolDocsVariable)PolDocsVariable.n().where().addEq(PolDocsVariable.CONTENT_UUID, (Object)polDocsContent.getContentUuid()).model()).setOrderBy(new Sort.Order[]{PolDocsType.CRT_DATE.desc()});
            List polDocsVariableList = this.dao.findAll((AbsModel)polDocsVariableModel);
            for (PolDocsVariable polDocsVariable : polDocsVariableList) {
                this.dao.delete(polDocsVariable.getSerno(), polDocsVariable.getClass());
            }
            this.dao.delete(polDocsContent.getSerno(), polDocsContent.getClass());
        }
        this.dao.delete(polDocsTemplate.getSerno(), polDocsTemplate.getClass());
        return msg.msg();
    }

    @Override
    public ReturnMsg queryDocTemplateList(PolDocsTemplate polDocsTemplate) {
        PolDocsTemplate queryModel = ((PolDocsTemplate)PolDocsTemplate.n().where().model()).setOrderBy(new Sort.Order[]{PolDocsTemplate.CRT_DATE.desc()});
        queryModel.where().addEq(PolDocsTemplate.DATA_FLAG, (Object)"1");
        if (polDocsTemplate != null) {
            if (!StrUtils.isNull((Object)polDocsTemplate.getDocsType())) {
                queryModel.where().addEq(PolDocsTemplate.DOCS_TYPE, (Object)polDocsTemplate.getDocsType());
            }
            if (!StrUtils.isNull((Object)polDocsTemplate.getTplVersion())) {
                queryModel.where().addEq(PolDocsTemplate.TPL_VERSION, (Object)polDocsTemplate.getTplVersion());
            }
            if (!StrUtils.isNull((Object)polDocsTemplate.getTplName())) {
                queryModel.where().addLike(PolDocsTemplate.TPL_NAME, (Object)polDocsTemplate.getTplName());
            }
        }
        List resultList = this.dao.findAll((AbsModel)queryModel, Boolean.valueOf(true));
        for (PolDocsTemplate docTemplateModel : resultList) {
            PolDocsType docCategoryModel = (PolDocsType)PolDocsType.n().where().addEq(PolDocsType.DATA_FLAG, (Object)"1").addEq(PolDocsType.DOCS_TYPE, (Object)docTemplateModel.getDocsType()).model();
            if (docCategoryModel == null) continue;
            docTemplateModel.setDocsDesc(docCategoryModel.getDocsDesc());
        }
        Return msg = new Return();
        msg.setDataList(resultList, PolDocsTemplate.class);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryDocTemplate(String tplUuid) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)tplUuid)) {
            msg.setFailMsg("\u5355\u8bc1\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        PolDocsTemplate docTemplate = (PolDocsTemplate)this.dao.findOne(PolDocsTemplate.n().where().addEq(PolDocsTemplate.DATA_FLAG, (Object)"1").addEq(PolDocsTemplate.TPL_UUID, (Object)tplUuid).model());
        if (docTemplate == null) {
            msg.setFailMsg("\u672a\u627e\u5230\u8be5\u5355\u8bc1\u6a21\u677f");
            return msg.msg();
        }
        PolDocsContent polDocsContentModel = ((PolDocsContent)PolDocsContent.n().where().addEq(PolDocsContent.DATA_FLAG, (Object)"1").addEq(PolDocsContent.TPL_UUID, (Object)tplUuid).model()).setOrderBy(new Sort.Order[]{PolDocsContent.CRT_DATE.desc()});
        List polDocsContentList = this.dao.findAll((AbsModel)polDocsContentModel);
        for (PolDocsContent polDocsContent : polDocsContentList) {
            PolDocsVariable polDocsVariableModel = ((PolDocsVariable)PolDocsVariable.n().where().addEq(PolDocsVariable.CONTENT_UUID, (Object)polDocsContent.getContentUuid()).model()).setOrderBy(new Sort.Order[]{PolDocsContent.CRT_DATE.desc()});
            List polDocsVariableList = this.dao.findAll((AbsModel)polDocsVariableModel);
            polDocsContent.setVariableList(polDocsVariableList);
        }
        docTemplate.setContentList(polDocsContentList);
        msg.setDataTable(new Object[]{docTemplate});
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addOrUpdateDocOrganization(PolOrganDocs polOrganDocs) {
        Return msg = new Return();
        if (polOrganDocs == null) {
            msg.setFailMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)polOrganDocs.getOrganId())) {
            msg.setFailMsg("\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)polOrganDocs.getOrganName())) {
            msg.setFailMsg("\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)polOrganDocs.getTplUuid())) {
            msg.setFailMsg("\u5355\u8bc1\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        PolDocsTemplate docTemplate = (PolDocsTemplate)this.dao.findOne(PolDocsTemplate.n().where().addEq(PolDocsTemplate.DATA_FLAG, (Object)"1").addEq(PolDocsTemplate.TPL_UUID, (Object)polOrganDocs.getTplUuid()).model());
        if (docTemplate == null) {
            msg.setFailMsg("\u5355\u8bc1\u6a21\u677f\u7f16\u7801\u65e0\u6548");
            return msg.msg();
        }
        PolOrganDocs polOrganDocsModel = (PolOrganDocs)this.dao.findOne(PolOrganDocs.n().where().addEq(PolOrganDocs.DATA_FLAG, (Object)"1").addEq(PolOrganDocs.ORGAN_ID, (Object)polOrganDocs.getOrganId()).addEq(PolOrganDocs.TPL_UUID, (Object)polOrganDocs.getTplUuid()).model());
        if (polOrganDocs.getDocVarUuid() != null) {
            if (polOrganDocsModel != null && !polOrganDocsModel.getDocVarUuid().equals(polOrganDocs.getDocVarUuid())) {
                msg.setFailMsg("\u673a\u6784\u6a21\u677f\u5df2\u5b58\u5728\u7ed1\u5b9a\u5173\u7cfb\uff01");
                return msg.msg();
            }
            this.dao.update(polOrganDocs.getDocVarUuid(), (AbsModel)polOrganDocs);
        } else {
            if (polOrganDocsModel != null) {
                msg.setFailMsg("\u673a\u6784\u6a21\u677f\u5df2\u5b58\u5728\u7ed1\u5b9a\u5173\u7cfb\uff01");
                return msg.msg();
            }
            polOrganDocs.setDocVarUuid(UUID.uuid());
            polOrganDocs.setDataFlag("1");
            this.dao.save((AbsModel)polOrganDocs);
        }
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryDocOrganizationList(PolOrganDocs polOrganDocs) {
        PolOrganDocs queryModel = (PolOrganDocs)PolOrganDocs.n().where().addEq(PolOrganDocs.DATA_FLAG, (Object)"1").model();
        if (polOrganDocs != null) {
            if (!StrUtils.isNull((Object)polOrganDocs.getOrganId())) {
                queryModel.where().addEq(PolOrganDocs.ORGAN_ID, (Object)polOrganDocs.getOrganId());
            }
            if (!StrUtils.isNull((Object)polOrganDocs.getOrganName())) {
                queryModel.where().addLike(PolOrganDocs.ORGAN_NAME, (Object)polOrganDocs.getOrganName());
            }
        }
        List resultList = this.dao.findAll((AbsModel)queryModel, Boolean.valueOf(true));
        Return msg = new Return();
        msg.setDataList(resultList, PolOrganDocs.class);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg delDocOrganization(PolOrganDocs polOrganDocs) {
        Return msg = new Return();
        if (polOrganDocs == null) {
            msg.setFailMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)polOrganDocs.getDocVarUuid())) {
            msg.setFailMsg("\u5173\u8054\u5173\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        PolOrganDocs queryModel = (PolOrganDocs)PolOrganDocs.n().where().addEq(PolOrganDocs.DATA_FLAG, (Object)"1").model();
        queryModel.where().addEq(PolOrganDocs.DOC_VAR_UUID, (Object)polOrganDocs.getDocVarUuid());
        PolOrganDocs polOrganDocsPO = (PolOrganDocs)this.dao.findOne((AbsModel)queryModel);
        if (polOrganDocsPO != null) {
            this.dao.delete(polOrganDocsPO.getSerno(), polOrganDocsPO.getClass());
            msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        } else {
            msg.setFailMsg("\u672a\u627e\u5230\u8be5\u673a\u6784\u5355\u8bc1\u8bbe\u7f6e");
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg queryDocOrganization(String relationCode) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)relationCode)) {
            msg.setFailMsg("\u5173\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        PolOrganDocs polOrganDocs = (PolOrganDocs)this.dao.findOne(PolOrganDocs.n().where().addEq(PolOrganDocs.DATA_FLAG, (Object)"1").addEq(PolOrganDocs.DOC_VAR_UUID, (Object)relationCode).model());
        if (polOrganDocs != null) {
            msg.setDataTable(new Object[]{polOrganDocs});
            msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        } else {
            msg.setFailMsg("\u672a\u627e\u5230\u8be5\u673a\u6784\u5355\u8bc1");
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg queryTemplateVariable(String orgCode, String riskCode) {
        List resultList;
        PolOrganDocs queryModel;
        Return msg = new Return();
        HashSet<String> set = new HashSet<String>();
        if (StrUtils.isNull((Object)orgCode) && StrUtils.isNull((Object)riskCode)) {
            msg.setFailMsg("\u673a\u6784/\u9669\u79cd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (!StrUtils.isNull((Object)orgCode)) {
            queryModel = (PolOrganDocs)PolOrganDocs.n().where().model();
            queryModel.where().addEq(PolOrganDocs.DATA_FLAG, (Object)"1").addEq(PolOrganDocs.ORGAN_ID, (Object)orgCode);
            resultList = this.dao.findAll((AbsModel)queryModel);
            for (PolOrganDocs polOrganDocs : resultList) {
                set.add(polOrganDocs.getTplUuid());
            }
        }
        if (!StrUtils.isNull((Object)riskCode)) {
            queryModel = (RiskDocRelation)RiskDocRelation.n().where().model();
            queryModel.where().addEq(PolOrganDocs.DATA_FLAG, (Object)"1").addEq(RiskDocRelation.RISK_CODE, (Object)riskCode);
            resultList = this.dao.findAll((AbsModel)queryModel);
            for (RiskDocRelation riskDocRelation : resultList) {
                set.add(riskDocRelation.getDocTemplateCode());
            }
        }
        if (set.size() == 0) {
            msg.setFailMsg("\u5f53\u524d\u673a\u6784/\u9669\u79cd\u4e0b\u65e0\u53d8\u91cf\u4fe1\u606f\uff01");
            return msg.msg();
        }
        queryModel = (PolDocsVariable)PolDocsVariable.n().where().addEq(PolOrganDocs.DATA_FLAG, (Object)"1").model();
        PolDocsContent polDocsContentModel = (PolDocsContent)PolDocsContent.n().where().addEq(PolOrganDocs.DATA_FLAG, (Object)"1").addIn(PolDocsContent.TPL_UUID, new ArrayList(set)).model();
        List polDocsContenttList = this.dao.findAll((AbsModel)polDocsContentModel);
        List resultList2 = null;
        if (!polDocsContenttList.isEmpty()) {
            ((PolDocsVariable)queryModel.where().addIn(PolDocsVariable.VAR_UUID, polDocsContenttList.stream().map(PolDocsContent::getContentUuid).collect(Collectors.toList())).model()).setOrderBy(new Sort.Order[]{PolDocsVariable.CRT_DATE.desc()});
            resultList2 = this.dao.findAll((AbsModel)queryModel, Boolean.valueOf(true));
        } else {
            resultList2 = new ArrayList();
        }
        msg.setDataList(resultList2, PolDocsVariable.class);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addOrUpdateDocRisk(RiskDocRelation riskDocRelation) {
        Return msg = new Return();
        if (riskDocRelation == null) {
            msg.setFailMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)riskDocRelation.getDocTemplateCode())) {
            msg.setFailMsg("\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)riskDocRelation.getRiskCode())) {
            msg.setFailMsg("\u9669\u79cd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        try {
            PolDocsTemplate polDocsTemplate = (PolDocsTemplate)this.dao.findOne(PolDocsTemplate.n().where().addEq(PolOrganDocs.DATA_FLAG, (Object)"1").addEq(PolOrganDocs.TPL_UUID, (Object)riskDocRelation.getDocTemplateCode()).model());
            if (polDocsTemplate == null) {
                msg.setFailMsg("\u5355\u8bc1\u6a21\u677f\u7f16\u7801\u65e0\u6548");
                return msg.msg();
            }
            RiskDocRelation existing = (RiskDocRelation)this.dao.findOne(RiskDocRelation.n().where().addEq(RiskDocRelation.DOC_TEMPLATE_CODE, (Object)riskDocRelation.getDocTemplateCode()).addEq(RiskDocRelation.RISK_CODE, (Object)riskDocRelation.getRiskCode()).model());
            if (riskDocRelation.getRelationCode() != null) {
                if (existing != null && !riskDocRelation.getRelationCode().equals(existing.getRelationCode())) {
                    msg.setFailMsg("\u9669\u79cd\u6a21\u677f\u5df2\u5b58\u5728\u7ed1\u5b9a\u5173\u7cfb\uff01");
                    return msg.msg();
                }
                this.dao.update(riskDocRelation.getRelationCode(), (AbsModel)riskDocRelation);
            } else {
                if (existing != null) {
                    msg.setFailMsg("\u9669\u79cd\u6a21\u677f\u5df2\u5b58\u5728\u7ed1\u5b9a\u5173\u7cfb\uff01");
                    return msg.msg();
                }
                riskDocRelation.setRelationCode(UUID.uuid());
                riskDocRelation.setDataFlag("1");
                this.dao.save((AbsModel)riskDocRelation);
            }
            msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        }
        catch (Exception e) {
            msg.setFailMsg("\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage());
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg queryDocRiskList(RiskDocRelation riskDocRelation) {
        RiskDocRelation queryModel = ((RiskDocRelation)RiskDocRelation.n().where().addEq(PolOrganDocs.DATA_FLAG, (Object)"1").model()).setOrderBy(new Sort.Order[]{RiskDocRelation.CRT_DATE.desc()});
        if (riskDocRelation != null) {
            if (!StrUtils.isNull((Object)riskDocRelation.getRiskCode())) {
                queryModel.where().addEq(RiskDocRelation.RISK_CODE, (Object)riskDocRelation.getRiskCode());
            }
            if (!StrUtils.isNull((Object)riskDocRelation.getDocTemplateCode())) {
                queryModel.where().addEq(RiskDocRelation.DOC_TEMPLATE_CODE, (Object)riskDocRelation.getDocTemplateCode());
            }
        }
        List resultList = this.dao.findAll((AbsModel)queryModel, Boolean.valueOf(true));
        for (RiskDocRelation riskDoc : resultList) {
            PolDocsTemplate docTemplate = (PolDocsTemplate)this.dao.findOne(PolDocsTemplate.n().where().addEq(PolDocsTemplate.TPL_UUID, (Object)riskDoc.getDocTemplateCode()).addEq(PolDocsTemplate.DATA_FLAG, (Object)"1").model());
            if (docTemplate == null) continue;
            riskDoc.setDocTemplateName(docTemplate.getTplUuid());
            riskDoc.setDocTemplateVersion(docTemplate.getTplVersion());
            PolDocsType docCategoryModel = (PolDocsType)PolDocsType.n().where().addEq(PolDocsType.DATA_FLAG, (Object)"1").addEq(PolDocsType.DOCS_TYPE, (Object)docTemplate.getDocsType()).model();
            if (docCategoryModel == null) continue;
            riskDoc.setTypeCnName(docCategoryModel.getDocsDesc());
        }
        Return msg = new Return();
        msg.setDataList(resultList, RiskDocRelation.class);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryDocRisk(String relationCode) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)relationCode)) {
            msg.setFailMsg("\u5173\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        RiskDocRelation riskDocRelation = (RiskDocRelation)this.dao.findOne(RiskDocRelation.n().where().addEq(RiskDocRelation.RELATION_CODE, (Object)relationCode).addEq(PolDocsTemplate.DATA_FLAG, (Object)"1").model());
        if (riskDocRelation != null) {
            PolDocsTemplate docTemplate = (PolDocsTemplate)this.dao.findOne(PolDocsTemplate.n().where().addEq(PolDocsTemplate.TPL_UUID, (Object)riskDocRelation.getDocTemplateCode()).addEq(PolDocsTemplate.DATA_FLAG, (Object)"1").model());
            if (docTemplate != null) {
                riskDocRelation.setDocTemplateName(docTemplate.getTplUuid());
                riskDocRelation.setDocTemplateVersion(docTemplate.getTplVersion());
                PolDocsType docCategoryModel = (PolDocsType)PolDocsType.n().where().addEq(PolDocsType.DATA_FLAG, (Object)"1").addEq(PolDocsType.DOCS_TYPE, (Object)docTemplate.getDocsType()).model();
                if (docCategoryModel != null) {
                    riskDocRelation.setTypeCnName(docCategoryModel.getDocsDesc());
                }
            }
            msg.setDataTable(new Object[]{riskDocRelation});
            msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        } else {
            msg.setFailMsg("\u672a\u627e\u5230\u8be5\u9669\u79cd\u5355\u8bc1\u8bbe\u7f6e");
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg delDocRisk(String relationCode) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)relationCode)) {
            msg.setFailMsg("\u5173\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        RiskDocRelation riskDocRelation = (RiskDocRelation)this.dao.findOne(RiskDocRelation.n().where().addEq(RiskDocRelation.RELATION_CODE, (Object)relationCode).addEq(PolDocsTemplate.DATA_FLAG, (Object)"1").model());
        if (riskDocRelation != null) {
            this.dao.delete(riskDocRelation.getSerno(), riskDocRelation.getClass());
            msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        } else {
            msg.setFailMsg("\u672a\u627e\u5230\u8be5\u9669\u79cd\u5355\u8bc1\u8bbe\u7f6e");
        }
        return msg.msg();
    }
}

