-- 1.单证分类表
CREATE TABLE "t_doc_category" (
                                  serno character varying(64),
                                  "doc_type" VARCHAR(64) NOT NULL,
                                  "type_cn_name" VARCHAR(128) NOT NULL,
                                  "display_position" VARCHAR(32) NOT NULL,
                                  "data_flag" VARCHAR(32),
                                  "crt_date" TIMESTAMP(0),
                                  "mdf_date" TIMESTAMP(0),
                                  "crt_user" VARCHAR(64),
                                  "mdf_user" VARCHAR(64),
                                  "data_auth" VARCHAR(256),
                                  "shard_code" VARCHAR(32),
                                  PRIMARY KEY ("doc_type")
);

-- 2.模板表
CREATE TABLE "t_doc_template" (
                                  serno character varying(64),
                                  "doc_type" VARCHAR(64) NOT NULL,
                                  "doc_template_code" VARCHAR(64) NOT NULL,
                                  "doc_template_name" VARCHAR(128) NOT NULL,
                                  "doc_template_version" VARCHAR(32) NOT NULL,
                                  "data_flag" VARCHAR(32),
                                  "crt_date" TIMESTAMP(0),
                                  "mdf_date" TIMESTAMP(0),
                                  "crt_user" VARCHAR(64),
                                  "mdf_user" VARCHAR(64),
                                  "data_auth" VARCHAR(256),
                                  "shard_code" VARCHAR(32),
                                  PRIMARY KEY ("doc_template_code"),
                                  CONSTRAINT "fk_template_doc_type"
                                      FOREIGN KEY ("doc_type")
                                          REFERENCES "t_doc_category" ("doc_type")
)
WITH (ORIENTATION = ROW, COMPRESSION = NO);
COMMENT ON COLUMN "t_doc_template"."doc_type" IS '单证类型';
COMMENT ON COLUMN "t_doc_template"."doc_template_code" IS '单证模板编码';
COMMENT ON COLUMN "t_doc_template"."doc_template_name" IS '单证模板名称';
COMMENT ON COLUMN "t_doc_template"."doc_template_version" IS '单证模板版本';
COMMENT ON COLUMN "t_doc_template"."data_flag" IS '数据标识';
COMMENT ON COLUMN "t_doc_template"."crt_date" IS '创建时间';
COMMENT ON COLUMN "t_doc_template"."mdf_date" IS '修改时间';
COMMENT ON COLUMN "t_doc_template"."crt_user" IS '创建人';
COMMENT ON COLUMN "t_doc_template"."mdf_user" IS '修改人';
COMMENT ON COLUMN "t_doc_template"."data_auth" IS '数据权限';
COMMENT ON COLUMN "t_doc_template"."shard_code" IS '分片编码';
-- 表注释
COMMENT ON TABLE "t_doc_template" IS '模板表';

-- 3.内容表
CREATE TABLE "t_doc_content" (
                                 serno character varying(64),
                                 "doc_template_code" VARCHAR(64) NOT NULL,
                                 "content_code" VARCHAR(64) NOT NULL,
                                 "content_type" VARCHAR(32) NOT NULL,
                                 "content_source" VARCHAR(32) NOT NULL,
                                 "content_value_common" TEXT,
                                 "content_value_pc" TEXT,
                                 "content_value_mobile" TEXT,
                                 "sort_num" VARCHAR(32),
                                 "data_flag" VARCHAR(32),
                                 "crt_date" TIMESTAMP(0),
                                 "mdf_date" TIMESTAMP(0),
                                 "crt_user" VARCHAR(64),
                                 "mdf_user" VARCHAR(64),
                                 "data_auth" VARCHAR(256),
                                 "shard_code" VARCHAR(32),
                                 PRIMARY KEY ("content_code"),
                                 CONSTRAINT "fk_content_template_code"
                                     FOREIGN KEY ("doc_template_code")
                                         REFERENCES "t_doc_template" ("doc_template_code")
)
WITH (ORIENTATION = ROW, COMPRESSION = NO);

COMMENT ON COLUMN "t_doc_content"."doc_template_code" IS '单证模板编码';
COMMENT ON COLUMN "t_doc_content"."content_code" IS '内容编码';
COMMENT ON COLUMN "t_doc_content"."content_type" IS '内容类型（码表）';
COMMENT ON COLUMN "t_doc_content"."content_source" IS '内容来源（码表）';
COMMENT ON COLUMN "t_doc_content"."content_value_common" IS '内容值(通用)';
COMMENT ON COLUMN "t_doc_content"."content_value_pc" IS '内容值(PC)';
COMMENT ON COLUMN "t_doc_content"."content_value_mobile" IS '内容值(移动)';
COMMENT ON COLUMN "t_doc_content"."sort_num" IS '排序序号';
COMMENT ON COLUMN "t_doc_content"."data_flag" IS '数据标识';
COMMENT ON COLUMN "t_doc_content"."crt_date" IS '创建时间';
COMMENT ON COLUMN "t_doc_content"."mdf_date" IS '修改时间';
COMMENT ON COLUMN "t_doc_content"."crt_user" IS '创建人';
COMMENT ON COLUMN "t_doc_content"."mdf_user" IS '修改人';
COMMENT ON COLUMN "t_doc_content"."data_auth" IS '数据权限';
COMMENT ON COLUMN "t_doc_content"."shard_code" IS '分片编码';
-- 表注释
COMMENT ON TABLE "t_doc_content" IS '内容表';

-- 4.模板变量表
CREATE TABLE "t_doc_template_variable" (
                                           serno character varying(64),
                                           "content_code" VARCHAR(64) NOT NULL,
                                           "variable_category" VARCHAR(32) NOT NULL,
                                           "variable_code" VARCHAR(64) NOT NULL,
                                           "variable_name" VARCHAR(128) NOT NULL,
                                           "value_type" VARCHAR(32) NOT NULL,
                                           "variable_value" TEXT,
                                           "display_condition" TEXT,
                                           "is_distinguish_org" VARCHAR(32),
                                           "interface_url" VARCHAR(512),
                                           "data_flag" VARCHAR(32),
                                           "crt_date" TIMESTAMP(0),
                                           "mdf_date" TIMESTAMP(0),
                                           "crt_user" VARCHAR(64),
                                           "mdf_user" VARCHAR(64),
                                           "data_auth" VARCHAR(256),
                                           "shard_code" VARCHAR(32),
                                           PRIMARY KEY ("content_code", "variable_code"),
                                           CONSTRAINT "fk_variable_content_code"
                                               FOREIGN KEY ("content_code")
                                                   REFERENCES "t_doc_content" ("content_code")
)
WITH (ORIENTATION = ROW, COMPRESSION = NO);
COMMENT ON COLUMN "t_doc_template_variable"."content_code" IS '内容编码';
COMMENT ON COLUMN "t_doc_template_variable"."variable_category" IS '变量类别（码表）';
COMMENT ON COLUMN "t_doc_template_variable"."variable_code" IS '变量编码';
COMMENT ON COLUMN "t_doc_template_variable"."variable_name" IS '变量名称';
COMMENT ON COLUMN "t_doc_template_variable"."value_type" IS '值类型（码表）';
COMMENT ON COLUMN "t_doc_template_variable"."variable_value" IS '变量值';
COMMENT ON COLUMN "t_doc_template_variable"."display_condition" IS '显示条件（规则公式）';
COMMENT ON COLUMN "t_doc_template_variable"."is_distinguish_org" IS '区分机构（1是0否）';
COMMENT ON COLUMN "t_doc_template_variable"."interface_url" IS '接口地址';
COMMENT ON COLUMN "t_doc_template_variable"."data_flag" IS '数据标识';
COMMENT ON COLUMN "t_doc_template_variable"."crt_date" IS '创建时间';
COMMENT ON COLUMN "t_doc_template_variable"."mdf_date" IS '修改时间';
COMMENT ON COLUMN "t_doc_template_variable"."crt_user" IS '创建人';
COMMENT ON COLUMN "t_doc_template_variable"."mdf_user" IS '修改人';
COMMENT ON COLUMN "t_doc_template_variable"."data_auth" IS '数据权限';
COMMENT ON COLUMN "t_doc_template_variable"."shard_code" IS '分片编码';
-- 表注释
COMMENT ON TABLE "t_doc_template_variable" IS '模板变量表';

-- 5.机构模板表
CREATE TABLE "t_org_doc_relation" (
                                      "serno" VARCHAR(64),
                                      "relation_code" VARCHAR(64) NOT NULL,
                                      "org_code" VARCHAR(64) NOT NULL,
                                      "org_name" VARCHAR(64) NOT NULL,
                                      "channel_code" VARCHAR(64) NOT NULL,
                                      "doc_template_code" VARCHAR(64) NOT NULL,
                                      "is_double_record" VARCHAR(32),
                                      "read_sign_type" VARCHAR(32),
                                      "is_force_read" VARCHAR(32),
                                      "display_order" INT,
                                      "sign_group" VARCHAR(64),
                                      "start_time" TIMESTAMP(0),
                                      "finish_time" TIMESTAMP(0),
                                      "data_flag" VARCHAR(32),
                                      "crt_date" TIMESTAMP(0),
                                      "mdf_date" TIMESTAMP(0),
                                      "crt_user" VARCHAR(64),
                                      "mdf_user" VARCHAR(64),
                                      "data_auth" VARCHAR(256),
                                      "shard_code" VARCHAR(32),
                                      PRIMARY KEY ("relation_code"),
                                      CONSTRAINT "fk_relation_template_code"
                                          FOREIGN KEY ("doc_template_code")
                                              REFERENCES "t_doc_template" ("doc_template_code")
)
WITH (ORIENTATION = ROW, COMPRESSION = NO);

COMMENT ON COLUMN "t_org_doc_relation"."serno" IS '序列号';
COMMENT ON COLUMN "t_org_doc_relation"."relation_code" IS '关系编码';
COMMENT ON COLUMN "t_org_doc_relation"."org_code" IS '机构编码';
COMMENT ON COLUMN "t_org_doc_relation"."channel_code" IS '渠道编码';
COMMENT ON COLUMN "t_org_doc_relation"."doc_template_code" IS '单证模板编码';
COMMENT ON COLUMN "t_org_doc_relation"."is_double_record" IS '是否双录（1是0否）';
COMMENT ON COLUMN "t_org_doc_relation"."read_sign_type" IS '阅读/签字';
COMMENT ON COLUMN "t_org_doc_relation"."is_force_read" IS '是否强制阅读（1是0否）';
COMMENT ON COLUMN "t_org_doc_relation"."display_order" IS '显示顺序';
COMMENT ON COLUMN "t_org_doc_relation"."sign_group" IS '签字分组';
COMMENT ON COLUMN "t_org_doc_relation"."start_time" IS '开始时间';
COMMENT ON COLUMN "t_org_doc_relation"."finish_time" IS '完成时间';
COMMENT ON COLUMN "t_org_doc_relation"."data_flag" IS '数据标识';
COMMENT ON COLUMN "t_org_doc_relation"."crt_date" IS '创建时间';
COMMENT ON COLUMN "t_org_doc_relation"."mdf_date" IS '修改时间';
COMMENT ON COLUMN "t_org_doc_relation"."crt_user" IS '创建人';
COMMENT ON COLUMN "t_org_doc_relation"."mdf_user" IS '修改人';
COMMENT ON COLUMN "t_org_doc_relation"."data_auth" IS '数据权限';
COMMENT ON COLUMN "t_org_doc_relation"."shard_code" IS '分片编码';
-- 表注释
COMMENT ON TABLE "t_org_doc_relation" IS '机构单证关系表';

-- 6.险种单证关系表
CREATE TABLE "t_risk_doc_relation" (
                                       "serno" VARCHAR(64),
                                       "relation_code" VARCHAR(64) NOT NULL,
                                       "risk_code" VARCHAR(64) NOT NULL,
                                       "doc_template_code" VARCHAR(64) NOT NULL,
                                       "data_flag" VARCHAR(32),
                                       "crt_date" TIMESTAMP(0),
                                       "mdf_date" TIMESTAMP(0),
                                       "crt_user" VARCHAR(64),
                                       "mdf_user" VARCHAR(64),
                                       "data_auth" VARCHAR(256),
                                       "shard_code" VARCHAR(32),
                                       PRIMARY KEY ("relation_code")
)
WITH (ORIENTATION = ROW, COMPRESSION = NO);

COMMENT ON COLUMN "t_risk_doc_relation"."serno" IS '序列号';
COMMENT ON COLUMN "t_risk_doc_relation"."relation_code" IS '关系编码';
COMMENT ON COLUMN "t_risk_doc_relation"."risk_code" IS '险种编码';
COMMENT ON COLUMN "t_risk_doc_relation"."doc_template_code" IS '单证模板编码';
COMMENT ON COLUMN "t_risk_doc_relation"."data_flag" IS '数据标识';
COMMENT ON COLUMN "t_risk_doc_relation"."crt_date" IS '创建时间';
COMMENT ON COLUMN "t_risk_doc_relation"."mdf_date" IS '修改时间';
COMMENT ON COLUMN "t_risk_doc_relation"."crt_user" IS '创建人';
COMMENT ON COLUMN "t_risk_doc_relation"."mdf_user" IS '修改人';
COMMENT ON COLUMN "t_risk_doc_relation"."data_auth" IS '数据权限';
COMMENT ON COLUMN "t_risk_doc_relation"."shard_code" IS '分片编码';
-- 表注释（GaussDB标准写法）
COMMENT ON TABLE "t_risk_doc_relation" IS '险种单证关系表';
