/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.factory.service.impl;

import com.newtouch.base.utils.SysTradeLog;
import com.newtouch.base.utils.SystemAbutmentUtil;
import com.newtouch.nms.sip.design.product.detail.services.IDetailsService;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.enums.SmsEnum;
import com.newtouch.nms.sip.product.factory.service.ProductFactoryService;
import com.newtouch.nms.sip.product.main.services.IProductAddService;
import com.newtouch.nms.sip.product.main.services.IProductListQueryService;
import com.uniapis.logger.Ulog;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.HttpUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProductFactoryServiceImp
implements ProductFactoryService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private IProductAddService productAddService;
    @Autowired
    private IDetailsService detailsService;
    @Autowired
    private IProductListQueryService listQueryService;
    @Value(value="${factory.releaseUrl}")
    private String releaseUrl;
    @Value(value="${factory.saleDateUrl}")
    private String saleDateUrl;
    @Autowired
    private SystemAbutmentUtil systemAbutmentUtil;

    @Override
    public String saleDate(Map<String, Object> param) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        resMap.put("success", "false");
        String productNo = (String)param.get("productNo");
        if (StrUtils.isNull((Object)productNo)) {
            resMap.put("errorMsg", "\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return JsonUtils.toJson(resMap);
        }
        try {
            Date retirementEndDate;
            Date retirementBeginDate;
            Date eDate;
            Date beginDate;
            String resultSaleDate = "";
            String transno = UUID.shortUUID();
            SysTradeLog sysTradeLog = new SysTradeLog();
            sysTradeLog.setTransNo(transno);
            sysTradeLog.setParamType(SmsEnum.paramType.paramTypeReq.getType());
            sysTradeLog.setInterfaceNo(SmsEnum.abutmentInterface.abutmentQTS.getType());
            sysTradeLog.setSystemNo(SmsEnum.callSystem.Systemfactory.getType());
            sysTradeLog.setParamData(this.saleDateUrl + "&officialId=" + productNo);
            this.systemAbutmentUtil.insertSysTradeLog(sysTradeLog);
            resultSaleDate = HttpUtils.get((String)(this.saleDateUrl + "&officialId=" + productNo));
            sysTradeLog.setParamData(resultSaleDate);
            sysTradeLog.setParamType(SmsEnum.paramType.paramTypeRes.getType());
            this.systemAbutmentUtil.insertSysTradeLog(sysTradeLog);
            Map resultSale = (Map)JsonUtils.json2Map((String)resultSaleDate).get("result");
            Map messageBody = (Map)param.get("messageBody");
            Map officialInfo = (Map)messageBody.get("officialInfo");
            Date startDate = null;
            Date gudingDate = new SimpleDateFormat("yyyy-MM-dd").parse("9999-12-31");
            Date date = beginDate = StrUtils.isNull(officialInfo.get("beginDate")) ? null : (Date)officialInfo.get("beginDate");
            if (!StrUtils.isNull((Object)beginDate)) {
                startDate = beginDate;
            }
            Date endDate = null;
            Date date2 = eDate = StrUtils.isNull(officialInfo.get("endDate")) ? null : (Date)officialInfo.get("endDate");
            if (!StrUtils.isNull((Object)eDate)) {
                endDate = eDate;
            } else if (StrUtils.isNull((Object)eDate) && !StrUtils.isNull((Object)beginDate)) {
                endDate = gudingDate;
            }
            Date BeginDateyl = null;
            Date date3 = retirementBeginDate = StrUtils.isNull(officialInfo.get("retirementBeginDate")) ? null : (Date)officialInfo.get("retirementBeginDate");
            if (!StrUtils.isNull((Object)retirementBeginDate)) {
                BeginDateyl = retirementBeginDate;
            }
            Date EndDateyl = null;
            Date date4 = retirementEndDate = StrUtils.isNull(officialInfo.get("retirementEndDate")) ? null : (Date)officialInfo.get("retirementEndDate");
            if (!StrUtils.isNull((Object)retirementEndDate)) {
                EndDateyl = retirementEndDate;
            } else if (StrUtils.isNull((Object)retirementEndDate) && !StrUtils.isNull((Object)retirementBeginDate)) {
                EndDateyl = gudingDate;
            }
            List riskList = (List)officialInfo.get("productInfos");
            SipProducts productnull = new SipProducts();
            productnull.where().addEq(SipProducts.PRODUCT_NO, (Object)((String)officialInfo.get("officialCode")));
            List productnullList = this.dao.findAll((AbsModel)productnull);
            if (CollectionUtils.isEmpty((Collection)productnullList) || productnullList.size() == 0) {
                resMap.put("success", "true");
                resMap.put("errorMsg", "\u7cfb\u7edf\u4e0d\u6d89\u53ca\u6b64\u4ea7\u54c1");
                return JsonUtils.toJson(resMap);
            }
            for (Map risk : riskList) {
                SipRisks sipRisk = new SipRisks();
                sipRisk.setStartDate(startDate);
                sipRisk.setEndDate(endDate);
                sipRisk.setStartDateYl(BeginDateyl);
                sipRisk.setEndDateYl(EndDateyl);
                sipRisk.where().addEq(SipRisks.POLICY_ID, (Object)((String)risk.get("productId")));
                this.dao.update((AbsModel)sipRisk);
            }
            SipProducts product = new SipProducts();
            product.setStartDate(startDate);
            product.setEndDate(endDate);
            product.setStartDateYl(BeginDateyl);
            product.setEndDateYl(EndDateyl);
            product.where().addEq(SipProducts.PRODUCT_NO, (Object)((String)officialInfo.get("officialCode")));
            this.dao.update((AbsModel)product);
            resMap.put("success", "true");
            resMap.put("errorMsg", "");
            return JsonUtils.toJson(resMap);
        }
        catch (Exception e) {
            Ulog.error((Throwable)e);
            resMap.put("errorMsg", e);
            return JsonUtils.toJson(resMap);
        }
    }

    @Override
    public String release(Map<String, Object> param) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        resMap.put("success", "false");
        String productNo = (String)param.get("productNo");
        if (StrUtils.isNull((Object)productNo)) {
            resMap.put("errorMsg", "\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return JsonUtils.toJson(resMap);
        }
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("officialId", productNo);
        String resultStr = "";
        try {
            String eDate;
            String beginDate;
            resultStr = HttpUtils.get((String)(this.releaseUrl + "&officialId=" + productNo));
            Map result = (Map)JsonUtils.json2Map((String)resultStr).get("result");
            if (StrUtils.isNull((Object)result)) {
                resMap.put("errorMsg", "\u4ea7\u54c1\u5de5\u5382-\u4ea7\u54c1\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
                return JsonUtils.toJson(resMap);
            }
            Map products = (Map)result.get("officialInfo");
            Map productBasic = (Map)products.get("basicInfo");
            Map productSort = (Map)products.get("classifiedInfo");
            Map exemptInfo = (Map)products.get("exemptInfo");
            List riskList = (List)result.get("productInfos");
            String targetPrdName = (String)productBasic.get("officialName");
            String productNoNew = (String)productBasic.get("officialId");
            Date startDate = null;
            String string = beginDate = StrUtils.isNull(productBasic.get("beginDate")) ? "" : (String)productBasic.get("beginDate");
            if (!beginDate.equals("")) {
                startDate = new SimpleDateFormat("yyyy-MM-dd").parse(beginDate);
            }
            Date endDate = null;
            String string2 = eDate = StrUtils.isNull(productBasic.get("endDate")) ? "" : (String)productBasic.get("endDate");
            if (!eDate.equals("")) {
                endDate = new SimpleDateFormat("yyyy-MM-dd").parse(eDate);
            }
            String sourcePrdUuid = "5BZYFb8X";
            String mainRiskUuid = "";
            String riskMNo = "";
            String policyId = "";
            String riskANo = "";
            String riskWNo = "";
            String riskMUuid = "";
            String riskAUuid = "";
            String accyRisksNodeNo = "";
            String addType = "";
            HashMap<String, String> riskMap = new HashMap<String, String>();
            if (StrUtils.isNull((Object)targetPrdName)) {
                resMap.put("errorMsg", "\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                return JsonUtils.toJson(resMap);
            }
            if (this.isRiskM(riskList) && Objects.equals((String)exemptInfo.get("exemptProductFlag"), "N")) {
                DsnStructure dsn = new DsnStructure();
                dsn.where().addEq(DsnStructure.NODE_NAME, (Object)targetPrdName);
                dsn.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.PRD.code());
                dsn.setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()});
                List dsnList = this.dao.findAll((AbsModel)dsn);
                if (CollectionUtils.isEmpty((Collection)dsnList)) {
                    this.productAddService.addProduct4Template(sourcePrdUuid, targetPrdName, riskMap);
                }
                SipProductRisks sip = new SipProductRisks();
                sip.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)this.getProductUuid(targetPrdName));
                List proRiskList = this.dao.findAll((AbsModel)sip);
                if (!CollectionUtils.isEmpty((Collection)proRiskList)) {
                    for (SipProductRisks productRisks : proRiskList) {
                        this.listQueryService.doCancelProductRiskRelation(this.getProductUuid(targetPrdName), productRisks.getRiskUuid());
                    }
                }
                for (Map riskM : riskList) {
                    Map riskMBasic = (Map)riskM.get("productItemBasic");
                    Map riskMproductOperationRule = (Map)riskM.get("productOperationRule");
                    Map riskMuwRuleInfo = (Map)riskMproductOperationRule.get("uwRuleInfo");
                    addType = (String)riskMBasic.get("insType");
                    riskMNo = (String)riskMBasic.get("internalId");
                    policyId = Integer.toString((Integer)riskMBasic.get("productId"));
                    if (StrUtils.isNull((Object)addType)) {
                        resMap.put("errorMsg", "\u9669\u79cd\u4e3b\u9644\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                        return JsonUtils.toJson(resMap);
                    }
                    if (!Objects.equals(addType, "1")) continue;
                    addType = "M";
                    List<SipRisks> sipRisksList = this.queryRiskList(riskMNo, addType);
                    if (CollectionUtils.isEmpty(sipRisksList)) {
                        HashMap<String, String> riskMList = new HashMap<String, String>();
                        riskMList.put("2TJdiKxY", (String)riskMBasic.get("productAbbr"));
                        riskMList.put("UU5gx2gv", (String)riskMBasic.get("productAbbr"));
                        this.productAddService.addMainRisk4Template(addType, sourcePrdUuid, targetPrdName, riskMList, mainRiskUuid, accyRisksNodeNo);
                    }
                    riskMUuid = this.getRiskUuid((String)riskMBasic.get("productAbbr")).getRiskUuid();
                    mainRiskUuid = this.getMainRiskUuid(riskMUuid);
                    SipRisks sipRiskM = new SipRisks();
                    sipRiskM.setRiskNo(policyId);
                    sipRiskM.setPolicyId(riskMNo);
                    sipRiskM.setPolicyCode(riskMNo);
                    sipRiskM.setRiskName((String)riskMBasic.get("productAbbr"));
                    sipRiskM.setRiskShortName((String)riskMBasic.get("productAbbr"));
                    if (riskMuwRuleInfo.get("minInsuredAge") != null && !riskMuwRuleInfo.get("minInsuredAge").equals("")) {
                        String agetypeM = "";
                        String minRelatedUnit = (String)riskMuwRuleInfo.get("minRelatedUnit");
                        if (minRelatedUnit.equals("1")) {
                            agetypeM = "D";
                        } else if (minRelatedUnit.equals("2")) {
                            agetypeM = "Y";
                        }
                        sipRiskM.setMinAge((String)riskMuwRuleInfo.get("minInsuredAge") + agetypeM);
                    } else {
                        sipRiskM.setMinAge((String)riskMuwRuleInfo.get("minInsuredAge"));
                    }
                    sipRiskM.setMinAmount((String)riskMuwRuleInfo.get("minAmount"));
                    sipRiskM.setStartDate(startDate);
                    sipRiskM.setEndDate(endDate);
                    sipRiskM.where().addEq(SipRisks.RISK_NAME, (Object)((String)riskMBasic.get("productAbbr")));
                    this.dao.update((AbsModel)sipRiskM);
                    HashMap<String, Object> productRiskMap = new HashMap<String, Object>();
                    ArrayList riskMlist = new ArrayList();
                    HashMap<String, String> riskMP = new HashMap<String, String>();
                    riskMP.put("risk_uuid", riskMUuid);
                    riskMP.put("risk_name", (String)riskMBasic.get("productAbbr"));
                    riskMlist.add(riskMP);
                    productRiskMap.put("product_uuid", this.getProductUuid(targetPrdName));
                    productRiskMap.put("risk_list", riskMlist);
                    this.listQueryService.addRisk(productRiskMap);
                    List<SipRiskRelation> sipRiskRelationList = this.queryRiskRelationList(riskMUuid);
                    if (!CollectionUtils.isEmpty(sipRiskRelationList)) {
                        for (SipRiskRelation riskRelation : sipRiskRelationList) {
                            this.cancelRisksRelation(riskMUuid, riskRelation.getRiskUuid(), NodeType.N_ACCY_RISKS.code());
                        }
                    }
                    for (Map riskA : riskList) {
                        Map riskMA;
                        Map riskABasic = (Map)riskA.get("productItemBasic");
                        Map riskAproductOperationRule = (Map)riskA.get("productOperationRule");
                        Map riskAuwRuleInfo = (Map)riskAproductOperationRule.get("uwRuleInfo");
                        Map riskRelations = (Map)riskA.get("productCombination");
                        List itemCombinationInfos = (List)riskRelations.get("itemCombinationInfos");
                        addType = (String)riskABasic.get("insType");
                        riskANo = (String)riskABasic.get("internalId");
                        if (StrUtils.isNull((Object)addType)) {
                            resMap.put("errorMsg", "\u9669\u79cd\u4e3b\u9644\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                            return JsonUtils.toJson(resMap);
                        }
                        Iterator iterator = itemCombinationInfos.iterator();
                        while (iterator.hasNext() && Objects.equals((riskMA = (Map)iterator.next()).get("internalId"), riskMNo)) {
                            if (!Objects.equals(addType, "2") || !Objects.equals(riskMA.get("comboInternalId"), riskANo)) continue;
                            addType = "A";
                            List<SipRisks> sipRisksAList = this.queryRiskList(riskANo, addType);
                            if (CollectionUtils.isEmpty(sipRisksAList)) {
                                HashMap<String, String> riskAMList = new HashMap<String, String>();
                                riskAMList.put("BUVexWgo", (String)riskABasic.get("productAbbr"));
                                riskAMList.put("U0kHtB5K", (String)riskABasic.get("productAbbr"));
                                this.productAddService.addMainRisk4Template(addType, sourcePrdUuid, targetPrdName, riskAMList, mainRiskUuid, accyRisksNodeNo);
                            }
                            riskAUuid = this.getRiskUuid((String)riskABasic.get("productAbbr")).getRiskUuid();
                            SipRisks sipRiskA = new SipRisks();
                            sipRiskA.setRiskNo(policyId);
                            sipRiskA.setPolicyId(riskMNo);
                            sipRiskA.setPolicyCode(riskMNo);
                            sipRiskA.setRiskName((String)riskABasic.get("productAbbr"));
                            sipRiskA.setRiskShortName((String)riskABasic.get("productAbbr"));
                            String agetypeA = "";
                            String minRelatedUnitA = (String)riskMuwRuleInfo.get("minRelatedUnit");
                            if (minRelatedUnitA.equals("1")) {
                                agetypeA = "D";
                            } else if (minRelatedUnitA.equals("2")) {
                                agetypeA = "Y";
                            }
                            sipRiskA.setMinAge((String)riskAuwRuleInfo.get("minInsuredAge") + agetypeA);
                            sipRiskA.setMinAmount((String)riskAuwRuleInfo.get("minAmount"));
                            sipRiskA.setStartDate(startDate);
                            sipRiskA.setEndDate(endDate);
                            sipRiskA.where().addEq(SipRisks.RISK_NAME, (Object)((String)riskABasic.get("productAbbr")));
                            this.dao.update((AbsModel)sipRiskA);
                        }
                    }
                }
                SipProducts product = new SipProducts();
                product.setProductNo(productNoNew);
                product.setProductTip((String)productSort.get("cbircDesignType"));
                product.setStartDate(startDate);
                product.setEndDate(endDate);
                product.where().addEq(SipProducts.PRODUCT_NAME, (Object)targetPrdName);
                this.dao.update((AbsModel)product);
                List<DsnBizAttributeOption> productTipList = this.queryAllAttr(this.getProductUuid(targetPrdName), "product_tip", (String)productSort.get("cbircDesignType"));
                if (CollectionUtils.isEmpty(productTipList)) {
                    StringBuilder sql1 = new StringBuilder("insert into dsn_biz_attribute_option  (serno, biz_uuid, option_no, option_name, option_value, option_order, crt_date, mdf_date, crt_user, mdf_user, data_flag) SELECT '" + UUID.shortUUID() + "',biz_uuid,'" + UUID.shortUUID() + "','" + this.getProductTip((String)productSort.get("cbircDesignType")) + "','" + (String)productSort.get("cbircDesignType") + "'," + Integer.valueOf((String)productSort.get("cbircDesignType")) + ",sysdate,sysdate,'login_user','login_user','1'FROM dsn_biz_attribute WHERE biz_uuid in (SELECT node_no FROM dsn_structure WHERE up_node = '" + this.getProductUuid(targetPrdName) + "' )  and attr_no = '" + "product_tip" + "'");
                    this.dao.update(sql1.toString(), new Object[0]);
                }
            } else if (Objects.equals((String)exemptInfo.get("exemptProductFlag"), "Y")) {
                for (Map riskW : riskList) {
                    Map riskWBasic = (Map)riskW.get("productItemBasic");
                    Map riskWproductOperationRule = (Map)riskW.get("productOperationRule");
                    Map riskWuwRuleInfo = (Map)riskWproductOperationRule.get("uwRuleInfo");
                    Map riskWRelations = (Map)riskW.get("productCombination");
                    List itemCombinationInfos = (List)riskWRelations.get("itemCombinationInfos");
                    addType = (String)riskWBasic.get("insType");
                    riskWNo = (String)riskWBasic.get("internalId");
                    if (StrUtils.isNull((Object)addType)) {
                        resMap.put("errorMsg", "\u9669\u79cd\u4e3b\u9644\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                        return JsonUtils.toJson(resMap);
                    }
                    for (Map riskMAW : itemCombinationInfos) {
                        String minRelatedUnitW;
                        String agetypeW;
                        SipRisks sipRiskW;
                        HashMap<String, String> riskAMList;
                        SipRisks sipRisksW;
                        if (!Objects.equals(riskMAW.get("comboInternalId"), riskWNo)) continue;
                        SipRisks sipRisk = this.queryRisk((String)riskMAW.get("internalId"));
                        if (!StrUtils.isNull((Object)sipRisk) && Objects.equals(sipRisk.getIsMainRisk(), "M")) {
                            addType = "M_W";
                            sipRisksW = this.queryRisk(riskWNo);
                            mainRiskUuid = this.getMainRiskUuid(sipRisk.getRiskUuid());
                            if (StrUtils.isNull((Object)sipRisksW)) {
                                riskAMList = new HashMap<String, String>();
                                riskAMList.put("dL1ze2yO", (String)riskWBasic.get("productAbbr"));
                                riskAMList.put("GOhTZT9F", (String)riskWBasic.get("productAbbr"));
                                this.productAddService.addMainRisk4Template(addType, sourcePrdUuid, targetPrdName, riskAMList, mainRiskUuid, accyRisksNodeNo);
                            }
                            sipRiskW = new SipRisks();
                            sipRiskW.setRiskNo(policyId);
                            sipRiskW.setPolicyId(riskMNo);
                            sipRiskW.setPolicyCode(riskMNo);
                            sipRiskW.setRiskName((String)riskWBasic.get("productAbbr"));
                            sipRiskW.setRiskShortName((String)riskWBasic.get("productAbbr"));
                            agetypeW = "";
                            minRelatedUnitW = (String)riskWuwRuleInfo.get("minRelatedUnit");
                            if (minRelatedUnitW.equals("1")) {
                                agetypeW = "D";
                            } else if (minRelatedUnitW.equals("2")) {
                                agetypeW = "Y";
                            }
                            sipRiskW.setMinAge((String)riskWuwRuleInfo.get("minInsuredAge") + agetypeW);
                            sipRiskW.setMinAmount((String)riskWuwRuleInfo.get("minAmount"));
                            sipRiskW.setStartDate(startDate);
                            sipRiskW.setEndDate(endDate);
                            sipRiskW.where().addEq(SipRisks.RISK_NAME, (Object)((String)riskWBasic.get("productAbbr")));
                            this.dao.update((AbsModel)sipRiskW);
                            continue;
                        }
                        if (StrUtils.isNull((Object)sipRisk) || !Objects.equals(sipRisk.getIsMainRisk(), "A")) continue;
                        addType = "A_W";
                        sipRisksW = this.queryRisk(riskWNo);
                        accyRisksNodeNo = this.getMainRiskUuid(sipRisk.getRiskUuid());
                        if (StrUtils.isNull((Object)sipRisksW)) {
                            riskAMList = new HashMap();
                            riskAMList.put("dL1ze2yO12345", (String)riskWBasic.get("productAbbr"));
                            riskAMList.put("dzl2D9ih", (String)riskWBasic.get("productAbbr"));
                            this.productAddService.addMainRisk4Template(addType, sourcePrdUuid, targetPrdName, riskAMList, mainRiskUuid, accyRisksNodeNo);
                        }
                        sipRiskW = new SipRisks();
                        sipRiskW.setRiskNo(policyId);
                        sipRiskW.setPolicyId(riskMNo);
                        sipRiskW.setPolicyCode(riskMNo);
                        sipRiskW.setRiskName((String)riskWBasic.get("productAbbr"));
                        sipRiskW.setRiskShortName((String)riskWBasic.get("productAbbr"));
                        agetypeW = "";
                        minRelatedUnitW = (String)riskWuwRuleInfo.get("minRelatedUnit");
                        if (minRelatedUnitW.equals("1")) {
                            agetypeW = "D";
                        } else if (minRelatedUnitW.equals("2")) {
                            agetypeW = "Y";
                        }
                        sipRiskW.setMinAge((String)riskWuwRuleInfo.get("minInsuredAge") + agetypeW);
                        sipRiskW.setMinAmount((String)riskWuwRuleInfo.get("minAmount"));
                        sipRiskW.setStartDate(startDate);
                        sipRiskW.setEndDate(endDate);
                        sipRiskW.where().addEq(SipRisks.RISK_NAME, (Object)((String)riskWBasic.get("productAbbr")));
                        this.dao.update((AbsModel)sipRiskW);
                    }
                }
            } else {
                for (Map riskA : riskList) {
                    Map riskABasic = (Map)riskA.get("productItemBasic");
                    Map riskAproductOperationRule = (Map)riskA.get("productOperationRule");
                    Map riskAuwRuleInfo = (Map)riskAproductOperationRule.get("uwRuleInfo");
                    Map riskRelations = (Map)riskA.get("productCombination");
                    List itemCombinationInfos = (List)riskRelations.get("itemCombinationInfos");
                    addType = (String)riskABasic.get("insType");
                    riskANo = (String)riskABasic.get("internalId");
                    if (StrUtils.isNull((Object)addType)) {
                        resMap.put("errorMsg", "\u9669\u79cd\u4e3b\u9644\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                        return JsonUtils.toJson(resMap);
                    }
                    for (Map riskMA : itemCombinationInfos) {
                        SipRisks sipRisk;
                        if (!Objects.equals(riskMA.get("comboInternalId"), riskANo) || StrUtils.isNull((Object)(sipRisk = this.queryRisk((String)riskMA.get("internalId")))) || !Objects.equals(sipRisk.getIsMainRisk(), "M")) continue;
                        addType = "A";
                        List<SipRisks> sipRisksAList = this.queryRiskList(riskANo, addType);
                        mainRiskUuid = this.getMainRiskUuid(sipRisk.getRiskUuid());
                        if (CollectionUtils.isEmpty(sipRisksAList)) {
                            HashMap<String, String> riskAMList = new HashMap<String, String>();
                            riskAMList.put("BUVexWgo", (String)riskABasic.get("productAbbr"));
                            riskAMList.put("U0kHtB5K", (String)riskABasic.get("productAbbr"));
                            this.productAddService.addMainRisk4Template(addType, sourcePrdUuid, targetPrdName, riskAMList, mainRiskUuid, accyRisksNodeNo);
                        }
                        riskAUuid = this.getRiskUuid((String)riskABasic.get("productAbbr")).getRiskUuid();
                        SipRisks sipRiskA = new SipRisks();
                        sipRiskA.setRiskNo(policyId);
                        sipRiskA.setPolicyId(riskMNo);
                        sipRiskA.setPolicyCode(riskMNo);
                        sipRiskA.setRiskName((String)riskABasic.get("productAbbr"));
                        sipRiskA.setRiskShortName((String)riskABasic.get("productAbbr"));
                        String agetypeA = "";
                        String minRelatedUnitA = (String)riskAuwRuleInfo.get("minRelatedUnit");
                        if (minRelatedUnitA.equals("1")) {
                            agetypeA = "D";
                        } else if (minRelatedUnitA.equals("2")) {
                            agetypeA = "Y";
                        }
                        sipRiskA.setMinAge((String)riskAuwRuleInfo.get("minInsuredAge") + agetypeA);
                        sipRiskA.setMinAmount((String)riskAuwRuleInfo.get("minAmount"));
                        sipRiskA.setStartDate(startDate);
                        sipRiskA.setEndDate(endDate);
                        sipRiskA.where().addEq(SipRisks.RISK_NAME, (Object)((String)riskABasic.get("productAbbr")));
                        this.dao.update((AbsModel)sipRiskA);
                    }
                }
            }
            resMap.put("success", "true");
            resMap.put("errorMsg", "");
            return JsonUtils.toJson(resMap);
        }
        catch (Exception e) {
            Ulog.error((Throwable)e);
            resMap.put("errorMsg", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u540c\u6b65\u5931\u8d25");
            return JsonUtils.toJson(resMap);
        }
    }

    public String getProductTip(String productTip) {
        String productTipDesc = "";
        switch (productTip) {
            case "1": {
                productTipDesc = "\u666e\u901a\u578b";
                break;
            }
            case "2": {
                productTipDesc = "\u5206\u7ea2\u578b";
                break;
            }
            case "3": {
                productTipDesc = "\u4e07\u80fd\u578b";
                break;
            }
            case "4": {
                productTipDesc = "\u6295\u8d44\u8fde\u7ed3\u578b";
            }
        }
        return productTipDesc;
    }

    public String getProductType(String productType) {
        String productTypeDesc = "";
        switch (productType) {
            case "1": {
                productTypeDesc = "\u5b9a\u671f\u5bff\u9669";
                break;
            }
            case "2": {
                productTypeDesc = "\u7ec8\u8eab\u5bff\u9669";
                break;
            }
            case "3": {
                productTypeDesc = "\u4e24\u5168\u4fdd\u9669";
                break;
            }
            case "4": {
                productTypeDesc = "\u975e\u517b\u8001\u5e74\u91d1\u7684\u5176\u4ed6\u5e74\u91d1\u4fdd\u9669";
                break;
            }
            case "5": {
                productTypeDesc = "\u517b\u8001\u5e74\u91d1\u4fdd\u9669";
                break;
            }
            case "6": {
                productTypeDesc = "\u75be\u75c5\u4fdd\u9669";
                break;
            }
            case "7": {
                productTypeDesc = "\u533b\u7597\u4fdd\u9669";
                break;
            }
            case "8": {
                productTypeDesc = "\u62a4\u7406\u4fdd\u9669";
                break;
            }
            case "9": {
                productTypeDesc = "\u5931\u80fd\u6536\u5165\u635f\u5931\u4fdd\u9669";
                break;
            }
            case "10": {
                productTypeDesc = "\u533b\u7597\u610f\u5916\u4fdd\u9669";
                break;
            }
            case "11": {
                productTypeDesc = "\u5065\u5eb7\u4fdd\u969c\u59d4\u6258\u7ba1\u7406\u4ea7\u54c1";
                break;
            }
            case "12": {
                productTypeDesc = "\u5065\u5eb7\u7ba1\u7406\u670d\u52a1\u4ea7\u54c1";
                break;
            }
            case "13": {
                productTypeDesc = "\u610f\u5916\u4f24\u5bb3\u4fdd\u9669";
            }
        }
        return productTypeDesc;
    }

    private List<DsnBizAttributeOption> queryAllAttr(String upNode, String attrNo, String optionValue) {
        String queryAttr = "select * from dsn_biz_attribute_option where biz_uuid =   (SELECT biz_uuid FROM    dsn_biz_attribute    WHERE biz_uuid in       (SELECT node_no FROM        dsn_structure        WHERE up_node = ? )         and attr_no = ?)  and option_value = ?";
        List allAttrList = this.dao.findAll(queryAttr, DsnBizAttributeOption.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{upNode, attrNo, optionValue})});
        return allAttrList;
    }

    public boolean isRiskM(List<Map<String, Object>> riskList) {
        boolean isRiskM = false;
        for (Map<String, Object> riskM : riskList) {
            Map riskMBasic = (Map)riskM.get("productItemBasic");
            String addType = (String)riskMBasic.get("insType");
            if (!Objects.equals(addType, "1")) continue;
            isRiskM = true;
            return isRiskM;
        }
        return isRiskM;
    }

    public String getProductUuid(String targetPrdName) {
        SipProducts sip = new SipProducts();
        sip.where().addEq(SipProducts.PRODUCT_NAME, (Object)targetPrdName);
        SipProducts sipProducts = (SipProducts)this.dao.findOne((AbsModel)sip);
        return sipProducts.getProductUuid();
    }

    public List<SipRiskRelation> queryRiskRelationList(String riskUuid) {
        SipRiskRelation sipRisks = new SipRiskRelation();
        sipRisks.where().addEq(SipRiskRelation.MAIN_RISK, (Object)riskUuid);
        List sipRiskRelationList = this.dao.findAll((AbsModel)sipRisks);
        return sipRiskRelationList;
    }

    public void cancelRisksRelation(String mainRisk, String riskUuid, String relationType) {
        String sqlMainRiskNodeNo = "SELECT * FROM dsn_structure WHERE node_no IN (SELECT up_node FROM dsn_structure WHERE node_no LIKE ?);";
        ArrayList<String> searchMainRiskNodeNo = new ArrayList<String>();
        searchMainRiskNodeNo.add(mainRisk);
        List mainRiskNodeNoList = this.dao.findAll(sqlMainRiskNodeNo, DsnStructure.class, new AbsModelRepository.Args[]{this.dao.args(searchMainRiskNodeNo)});
        String mainRiskNodeNo = ((DsnStructure)mainRiskNodeNoList.get(0)).getNodeNo();
        String sqlRiskUuidNodeNo = "SELECT * FROM dsn_structure WHERE node_no IN (SELECT up_node FROM dsn_structure WHERE  node_no LIKE ?);";
        ArrayList<String> searchRiskUuidNodeNo = new ArrayList<String>();
        searchRiskUuidNodeNo.add(riskUuid);
        List riskUuidNodeNoList = this.dao.findAll(sqlRiskUuidNodeNo, DsnStructure.class, new AbsModelRepository.Args[]{this.dao.args(searchRiskUuidNodeNo)});
        if (!CollectionUtils.isEmpty((Collection)riskUuidNodeNoList)) {
            String riskUuidNodeNo = ((DsnStructure)riskUuidNodeNoList.get(0)).getNodeNo();
            List dss = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)riskUuidNodeNo).model());
            DsnStructure downRiskNode = new DsnStructure();
            downRiskNode.where().addLike(DsnStructure.UP_NODE, (Object)mainRiskNodeNo);
            switch (relationType) {
                case "n_accy_risks": {
                    downRiskNode.where().addLike(DsnStructure.NODE_TYPE, (Object)"n_accy_risks");
                    break;
                }
                case "n_exempt": {
                    downRiskNode.where().addLike(DsnStructure.NODE_TYPE, (Object)"n_exempt");
                }
            }
            String downRiskNodeNo = ((DsnStructure)this.dao.findOne((AbsModel)downRiskNode)).getNodeNo();
            String relationNodeSeq = mainRiskNodeNo + "." + downRiskNodeNo + "." + riskUuidNodeNo + ".";
            DsnStructure dsnStructure = (DsnStructure)DsnStructure.n().where().addEq(DsnStructure.DATA_FLAG, (Object)"1").model();
            dsnStructure.where().addLikeL(DsnStructure.NODE_SEQ, (Object)relationNodeSeq);
            this.dao.delete((AbsModel)dsnStructure);
            SipRiskRelation sipRiskRelation = (SipRiskRelation)SipRiskRelation.n().where().addEq(SipRiskRelation.DATA_FLAG, (Object)"1").model();
            if (!StrUtils.isNull((Object)mainRisk)) {
                sipRiskRelation.where().addEq(SipRiskRelation.MAIN_RISK, (Object)mainRisk);
            }
            if (!StrUtils.isNull((Object)riskUuid)) {
                sipRiskRelation.where().addEq(SipRiskRelation.RISK_UUID, (Object)riskUuid);
            }
            this.dao.delete((AbsModel)sipRiskRelation);
        }
    }

    public List<SipRisks> queryRiskList(String riskNo, String addType) {
        SipRisks sipRisks = new SipRisks();
        sipRisks.where().addEq(SipRisks.RISK_NO, (Object)riskNo);
        sipRisks.where().addEq(SipRisks.IS_MAIN_RISK, (Object)addType);
        List sipRisksList = this.dao.findAll((AbsModel)sipRisks);
        return sipRisksList;
    }

    public SipRisks queryRisk(String riskNo) {
        SipRisks sipRisks = new SipRisks();
        sipRisks.where().addEq(SipRisks.RISK_NO, (Object)riskNo);
        SipRisks sipRisksList = (SipRisks)this.dao.findOne((AbsModel)sipRisks);
        return sipRisksList;
    }

    public DsnStructure getStructure(String uuid) {
        DsnStructure mainRiskDetailDsnStructure = new DsnStructure();
        mainRiskDetailDsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)uuid);
        DsnStructure mainRiskDetailDsnStructureList = (DsnStructure)this.dao.findOne((AbsModel)mainRiskDetailDsnStructure);
        return mainRiskDetailDsnStructureList;
    }

    public String getMainRiskUuid(String riskUuid) {
        DsnStructure mainRiskDetailDsnStructure = new DsnStructure();
        mainRiskDetailDsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)riskUuid);
        DsnStructure mainRiskDetailDsnStructureList = (DsnStructure)this.dao.findOne((AbsModel)mainRiskDetailDsnStructure);
        DsnStructure mainRiskDsnStructure = new DsnStructure();
        mainRiskDsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)mainRiskDetailDsnStructureList.getUpNode());
        DsnStructure mainRiskDsnStructureList = (DsnStructure)this.dao.findOne((AbsModel)mainRiskDsnStructure);
        return mainRiskDsnStructureList.getNodeNo();
    }

    public SipRisks getRiskUuid(String riskName) {
        SipRisks sipRisks = (SipRisks)this.dao.findOne(SipRisks.n().where().addEq(SipRisks.RISK_NAME, (Object)riskName).model());
        return sipRisks;
    }

    public static void main(String[] args) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        resMap.put("success", "false");
        resMap.put("success", "true");
        resMap.put("errorMsg", "\u9a8c\u8bc1");
        System.out.println("ceshi1+++:" + JsonUtils.toJson(resMap));
        System.out.println("ceshi2+++:" + UUID.shortUUID());
    }
}

