/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.doc.service.impl;

import com.newtouch.nms.sip.model.DocCategory;
import com.newtouch.nms.sip.model.DocContent;
import com.newtouch.nms.sip.model.DocOrgRelation;
import com.newtouch.nms.sip.model.DocTemplate;
import com.newtouch.nms.sip.model.DocTemplateVariable;
import com.newtouch.nms.sip.model.RiskDocRelation;
import com.newtouch.nms.sip.product.doc.service.IDocumentService;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class DocumentServiceImpl
implements IDocumentService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public ReturnMsg queryDocTypeList(DocCategory docCategoryRequest) {
        DocCategory queryModel = ((DocCategory)DocCategory.n().where().addEq(DocCategory.DATA_FLAG, (Object)"1").model()).setOrderBy(new Sort.Order[]{DocCategory.CRT_DATE.desc()});
        List resultList = this.dao.findAll((AbsModel)queryModel);
        Return msg = new Return();
        msg.setDataList(resultList, DocCategory.class);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addOrUpdateDocTemplate(DocTemplate docTemplateRequest) {
        boolean saveFlag = docTemplateRequest.getDocTemplateCode() == null;
        List contentCodes = docTemplateRequest.getDocContentList().stream().map(DocContent::getContentCode).collect(Collectors.toList());
        if (contentCodes.size() != new HashSet(contentCodes).size()) {
            throw new BusinessException("\u5355\u8bc1\u5185\u5bb9\u7f16\u7801\u5b58\u5728\u91cd\u590d\u503c");
        }
        List variableCodes = docTemplateRequest.getDocContentList().stream().flatMap(docContent -> docContent.getDocTemplateVariableList().stream()).map(DocTemplateVariable::getVariableCode).collect(Collectors.toList());
        if (variableCodes.size() != new HashSet(variableCodes).size()) {
            throw new BusinessException("\u53d8\u91cf\u7f16\u7801\u5b58\u5728\u91cd\u590d\u503c");
        }
        Return msg = new Return();
        try {
            if (docTemplateRequest == null) {
                throw new BusinessException("\u5355\u8bc1\u6a21\u677f\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtils.isNull((Object)docTemplateRequest.getDocType())) {
                throw new BusinessException("\u5355\u8bc1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtils.isNull((Object)docTemplateRequest.getDocTemplateName())) {
                throw new BusinessException("\u5355\u8bc1\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtils.isNull((Object)docTemplateRequest.getDocTemplateVersion())) {
                throw new BusinessException("\u5355\u8bc1\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            DocCategory docCategoryModel = (DocCategory)DocCategory.n().where().addEq(DocCategory.DATA_FLAG, (Object)"1").addEq(DocCategory.DOC_TYPE, (Object)docTemplateRequest.getDocType()).model();
            DocCategory docCategory = (DocCategory)this.dao.findOne((AbsModel)docCategoryModel);
            if (docCategory == null) {
                throw new BusinessException("\u5355\u8bc1\u7c7b\u578b\u65e0\u6548");
            }
            DocTemplate docTemplate = (DocTemplate)this.dao.findOne(DocTemplate.n().where().addEq(DocTemplate.DATA_FLAG, (Object)"1").addEq(DocTemplate.DOC_TYPE, (Object)docTemplateRequest.getDocType()).addEq(DocTemplate.DOC_TEMPLATE_NAME, (Object)docTemplateRequest.getDocTemplateName()).addEq(DocTemplate.DOC_TEMPLATE_VERSION, (Object)docTemplateRequest.getDocTemplateVersion()).model());
            if (saveFlag) {
                if (docTemplate != null) {
                    throw new BusinessException("\u5355\u8bc1\u6a21\u677f\u7c7b\u522b\u3001\u540d\u79f0\u3001\u7248\u672c\u5bf9\u5e94\u6570\u636e\u5df2\u5b58\u5728\uff01");
                }
                docTemplateRequest.setDocTemplateCode(UUID.uuid());
                docTemplateRequest.setDataFlag("1");
                this.dao.save((AbsModel)docTemplateRequest);
            } else {
                if (docTemplate != null && !docTemplate.getDocTemplateCode().equals(docTemplateRequest.getDocTemplateCode())) {
                    throw new BusinessException("\u5355\u8bc1\u6a21\u677f\u7c7b\u522b\u3001\u540d\u79f0\u3001\u7248\u672c\u5bf9\u5e94\u6570\u636e\u5df2\u5b58\u5728\uff01");
                }
                this.dao.update(docTemplateRequest.getDocTemplateCode(), (AbsModel)docTemplateRequest);
            }
            if (docTemplateRequest.getDocContentList() == null || docTemplateRequest.getDocContentList().size() == 0) {
                throw new BusinessException("\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (DocContent docContent2 : docTemplateRequest.getDocContentList()) {
                if (StrUtils.isNull((Object)docContent2.getContentCode())) {
                    throw new BusinessException("\u5355\u8bc1\u5185\u5bb9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StrUtils.isNull((Object)docContent2.getContentType())) {
                    throw new BusinessException("\u5355\u8bc1\u5185\u5bb9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StrUtils.isNull((Object)docContent2.getContentSource())) {
                    throw new BusinessException("\u5355\u8bc1\u5185\u5bb9\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StrUtils.isNull((Object)docContent2.getContentValueCommon())) {
                    throw new BusinessException("\u5355\u8bc1\u5185\u5bb9\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                DocContent docContentModel = (DocContent)this.dao.findOne(DocContent.n().where().addEq(DocContent.DATA_FLAG, (Object)"1").addEq(DocContent.CONTENT_CODE, (Object)docContent2.getContentCode()).model());
                if (saveFlag) {
                    if (docContentModel != null) {
                        throw new BusinessException("\u5355\u8bc1\u5185\u5bb9\u7f16\u7801\u5bf9\u5e94\u6570\u636e\u5df2\u5b58\u5728\uff01");
                    }
                    docContent2.setDocTemplateCode(docTemplateRequest.getDocTemplateCode());
                    docContent2.setDataFlag("1");
                    this.dao.save((AbsModel)docContent2);
                } else {
                    if (docContentModel != null && !docContentModel.getContentCode().equals(docContent2.getContentCode())) {
                        throw new BusinessException("\u5355\u8bc1\u5185\u5bb9\u7f16\u7801\u5bf9\u5e94\u6570\u636e\u5df2\u5b58\u5728\uff01");
                    }
                    this.dao.update(docContent2.getContentCode(), (AbsModel)docContent2);
                }
                List docTemplateVariableList = docContent2.getDocTemplateVariableList();
                if (docTemplateVariableList == null || docTemplateVariableList.size() == 0) {
                    throw new BusinessException("\u5185\u5bb9\u6a21\u677f\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                for (DocTemplateVariable docTemplateVariable : docTemplateVariableList) {
                    if (StrUtils.isNull((Object)docTemplateVariable.getVariableCode())) {
                        throw new BusinessException("\u53d8\u91cf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StrUtils.isNull((Object)docTemplateVariable.getVariableCategory())) {
                        throw new BusinessException("\u53d8\u91cf\u7c7b\u522b\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StrUtils.isNull((Object)docTemplateVariable.getVariableName())) {
                        throw new BusinessException("\u53d8\u91cf\u540d\u79f0\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StrUtils.isNull((Object)docTemplateVariable.getValueType())) {
                        throw new BusinessException("\u53d8\u91cf\u503c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StrUtils.isNull((Object)docTemplateVariable.getVariableValue())) {
                        throw new BusinessException("\u53d8\u91cf\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StrUtils.isNull((Object)docTemplateVariable.getDisplayCondition())) {
                        throw new BusinessException("\u663e\u793a\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StrUtils.isNull((Object)docTemplateVariable.getIsDistinguishOrg())) {
                        throw new BusinessException("\u533a\u5206\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    DocTemplateVariable docTemplateVariableModel = (DocTemplateVariable)this.dao.findOne(DocTemplateVariable.n().where().addEq(DocTemplateVariable.DATA_FLAG, (Object)"1").addEq(DocTemplateVariable.VARIABLE_CODE, (Object)docTemplateVariable.getVariableCode()).model());
                    if (saveFlag) {
                        if (docTemplateVariableModel != null) {
                            throw new BusinessException("\u53d8\u91cf\u7f16\u7801\u5df2\u5b58\u5728");
                        }
                        docTemplateVariable.setContentCode(docContent2.getContentCode());
                        docTemplateVariable.setDataFlag("1");
                        this.dao.save((AbsModel)docTemplateVariable);
                        continue;
                    }
                    if (docTemplateVariableModel != null && !docTemplateVariableModel.getVariableCode().equals(docTemplateVariable.getVariableCode())) {
                        throw new BusinessException("\u53d8\u91cf\u7f16\u7801\u5df2\u5b58\u5728");
                    }
                    this.dao.update(docTemplateVariable.getVariableCode(), (AbsModel)docTemplateVariable);
                }
            }
            msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        }
        catch (BusinessException e) {
            msg.setFailMsg(e.getMessage());
        }
        catch (Exception e) {
            msg.setFailMsg("\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage());
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg delDocTemplate(DocTemplate docTemplateRequest) {
        Return msg = new Return();
        if (docTemplateRequest == null) {
            msg.setFailMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)docTemplateRequest.getDocTemplateCode())) {
            msg.setFailMsg("\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        DocOrgRelation queryModel = (DocOrgRelation)DocOrgRelation.n().where().model();
        queryModel.where().addEq(DocOrgRelation.DATA_FLAG, (Object)"1").addEq(DocOrgRelation.DOC_TEMPLATE_CODE, (Object)docTemplateRequest.getDocTemplateCode());
        List resultList = this.dao.findAll((AbsModel)queryModel);
        if (resultList.size() > 0) {
            msg.setFailMsg("\u8be5\u6a21\u677f\u5df2\u5173\u8054\u673a\u6784\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
            return msg.msg();
        }
        queryModel = (RiskDocRelation)RiskDocRelation.n().where().model();
        queryModel.where().addEq(DocOrgRelation.DATA_FLAG, (Object)"1").addEq(RiskDocRelation.DOC_TEMPLATE_CODE, (Object)docTemplateRequest.getDocTemplateCode());
        resultList = this.dao.findAll((AbsModel)queryModel);
        if (resultList.size() > 0) {
            msg.setFailMsg("\u8be5\u6a21\u677f\u5df2\u5173\u8054\u9669\u79cd\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
            return msg.msg();
        }
        DocTemplate docTemplate = (DocTemplate)this.dao.findOne(DocTemplate.n().where().addEq(DocCategory.DATA_FLAG, (Object)"1").addEq(DocTemplate.DOC_TEMPLATE_CODE, (Object)docTemplateRequest.getDocTemplateCode()).model());
        if (docTemplate == null) {
            msg.setFailMsg("\u672a\u627e\u5230\u8be5\u5355\u8bc1\u6a21\u677f");
            return msg.msg();
        }
        DocContent docContentModel = ((DocContent)DocContent.n().where().addEq(DocCategory.DATA_FLAG, (Object)"1").addEq(DocContent.DOC_TEMPLATE_CODE, (Object)docTemplateRequest.getDocTemplateCode()).model()).setOrderBy(new Sort.Order[]{DocCategory.CRT_DATE.desc()});
        List docContentList = this.dao.findAll((AbsModel)docContentModel);
        for (DocContent docContent : docContentList) {
            DocTemplateVariable docTemplateVariableModel = ((DocTemplateVariable)DocTemplateVariable.n().where().addEq(DocTemplateVariable.CONTENT_CODE, (Object)docContent.getContentCode()).model()).setOrderBy(new Sort.Order[]{DocCategory.CRT_DATE.desc()});
            List docTemplateVariableList = this.dao.findAll((AbsModel)docTemplateVariableModel);
            for (DocTemplateVariable docTemplateVariable : docTemplateVariableList) {
                this.dao.delete(docTemplateVariable.getSerno(), docTemplateVariable.getClass());
            }
            this.dao.delete(docContent.getSerno(), docContent.getClass());
        }
        this.dao.delete(docTemplate.getSerno(), docTemplate.getClass());
        return msg.msg();
    }

    @Override
    public ReturnMsg queryDocTemplateList(DocTemplate docTemplate) {
        DocTemplate queryModel = ((DocTemplate)DocTemplate.n().where().model()).setOrderBy(new Sort.Order[]{DocTemplate.CRT_DATE.desc()});
        queryModel.where().addEq(DocTemplate.DATA_FLAG, (Object)"1");
        if (docTemplate != null) {
            if (!StrUtils.isNull((Object)docTemplate.getDocType())) {
                queryModel.where().addEq(DocTemplate.DOC_TYPE, (Object)docTemplate.getDocType());
            }
            if (!StrUtils.isNull((Object)docTemplate.getDocTemplateVersion())) {
                queryModel.where().addEq(DocTemplate.DOC_TEMPLATE_VERSION, (Object)docTemplate.getDocTemplateVersion());
            }
            if (!StrUtils.isNull((Object)docTemplate.getDocTemplateName())) {
                queryModel.where().addLike(DocTemplate.DOC_TEMPLATE_NAME, (Object)docTemplate.getDocTemplateName());
            }
        }
        List resultList = this.dao.findAll((AbsModel)queryModel, Boolean.valueOf(true));
        for (DocTemplate docTemplateModel : resultList) {
            DocCategory docCategoryModel = (DocCategory)DocCategory.n().where().addEq(DocCategory.DATA_FLAG, (Object)"1").addEq(DocCategory.DOC_TYPE, (Object)docTemplateModel.getDocType()).model();
            if (docCategoryModel == null) continue;
            docTemplateModel.setDocTypeName(docCategoryModel.getTypeCnName());
        }
        Return msg = new Return();
        msg.setDataList(resultList, DocTemplate.class);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryDocTemplate(String docTemplateCode) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)docTemplateCode)) {
            msg.setFailMsg("\u5355\u8bc1\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        DocTemplate docTemplate = (DocTemplate)this.dao.findOne(DocTemplate.n().where().addEq(DocCategory.DATA_FLAG, (Object)"1").addEq(DocTemplate.DOC_TEMPLATE_CODE, (Object)docTemplateCode).model());
        if (docTemplate == null) {
            msg.setFailMsg("\u672a\u627e\u5230\u8be5\u5355\u8bc1\u6a21\u677f");
            return msg.msg();
        }
        DocContent docContentModel = ((DocContent)DocContent.n().where().addEq(DocCategory.DATA_FLAG, (Object)"1").addEq(DocContent.DOC_TEMPLATE_CODE, (Object)docTemplateCode).model()).setOrderBy(new Sort.Order[]{DocCategory.CRT_DATE.desc()});
        List docContentList = this.dao.findAll((AbsModel)docContentModel);
        for (DocContent docContent : docContentList) {
            DocTemplateVariable docTemplateVariableModel = ((DocTemplateVariable)DocTemplateVariable.n().where().addEq(DocTemplateVariable.CONTENT_CODE, (Object)docContent.getContentCode()).model()).setOrderBy(new Sort.Order[]{DocCategory.CRT_DATE.desc()});
            List docTemplateVariableList = this.dao.findAll((AbsModel)docTemplateVariableModel);
            docContent.setDocTemplateVariableList(docTemplateVariableList);
        }
        docTemplate.setDocContentList(docContentList);
        msg.setDataTable(new Object[]{docTemplate});
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addOrUpdateDocOrganization(DocOrgRelation docOrgRelation) {
        Return msg = new Return();
        if (docOrgRelation == null) {
            msg.setFailMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)docOrgRelation.getOrgCode())) {
            msg.setFailMsg("\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)docOrgRelation.getOrgName())) {
            msg.setFailMsg("\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)docOrgRelation.getDocTemplateCode())) {
            msg.setFailMsg("\u5355\u8bc1\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        DocTemplate docTemplate = (DocTemplate)this.dao.findOne(DocTemplate.n().where().addEq(DocTemplate.DATA_FLAG, (Object)"1").addEq(DocTemplate.DOC_TEMPLATE_CODE, (Object)docOrgRelation.getDocTemplateCode()).model());
        if (docTemplate == null) {
            msg.setFailMsg("\u5355\u8bc1\u6a21\u677f\u7f16\u7801\u65e0\u6548");
            return msg.msg();
        }
        DocOrgRelation docOrgRelationModel = (DocOrgRelation)this.dao.findOne(DocOrgRelation.n().where().addEq(DocOrgRelation.DATA_FLAG, (Object)"1").addEq(DocOrgRelation.ORG_CODE, (Object)docOrgRelation.getOrgCode()).addEq(DocOrgRelation.DOC_TEMPLATE_CODE, (Object)docOrgRelation.getDocTemplateCode()).model());
        if (docOrgRelation.getRelationCode() != null) {
            if (docOrgRelationModel != null && !docOrgRelationModel.getRelationCode().equals(docOrgRelation.getRelationCode())) {
                msg.setFailMsg("\u673a\u6784\u6a21\u677f\u5df2\u5b58\u5728\u7ed1\u5b9a\u5173\u7cfb\uff01");
                return msg.msg();
            }
            this.dao.update(docOrgRelation.getRelationCode(), (AbsModel)docOrgRelation);
        } else {
            if (docOrgRelationModel != null) {
                msg.setFailMsg("\u673a\u6784\u6a21\u677f\u5df2\u5b58\u5728\u7ed1\u5b9a\u5173\u7cfb\uff01");
                return msg.msg();
            }
            docOrgRelation.setRelationCode(UUID.uuid());
            docOrgRelation.setDataFlag("1");
            this.dao.save((AbsModel)docOrgRelation);
        }
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryDocOrganizationList(DocOrgRelation docOrgRelation) {
        DocOrgRelation queryModel = (DocOrgRelation)DocOrgRelation.n().where().addEq(DocOrgRelation.DATA_FLAG, (Object)"1").model();
        if (docOrgRelation != null) {
            if (!StrUtils.isNull((Object)docOrgRelation.getOrgCode())) {
                queryModel.where().addEq(DocOrgRelation.ORG_CODE, (Object)docOrgRelation.getOrgCode());
            }
            if (!StrUtils.isNull((Object)docOrgRelation.getOrgName())) {
                queryModel.where().addLike(DocOrgRelation.ORG_NAME, (Object)docOrgRelation.getOrgName());
            }
        }
        List resultList = this.dao.findAll((AbsModel)queryModel, Boolean.valueOf(true));
        Return msg = new Return();
        msg.setDataList(resultList, DocOrgRelation.class);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg delDocOrganization(DocOrgRelation docOrgRelation) {
        Return msg = new Return();
        if (docOrgRelation == null) {
            msg.setFailMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)docOrgRelation.getRelationCode())) {
            msg.setFailMsg("\u5173\u8054\u5173\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        DocOrgRelation queryModel = (DocOrgRelation)DocOrgRelation.n().where().addEq(DocOrgRelation.DATA_FLAG, (Object)"1").model();
        queryModel.where().addEq(DocOrgRelation.RELATION_CODE, (Object)docOrgRelation.getRelationCode());
        DocOrgRelation docOrgRelationPO = (DocOrgRelation)this.dao.findOne((AbsModel)queryModel);
        if (docOrgRelationPO != null) {
            this.dao.delete(docOrgRelationPO.getSerno(), docOrgRelationPO.getClass());
            msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        } else {
            msg.setFailMsg("\u672a\u627e\u5230\u8be5\u673a\u6784\u5355\u8bc1\u8bbe\u7f6e");
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg queryDocOrganization(String relationCode) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)relationCode)) {
            msg.setFailMsg("\u5173\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        DocOrgRelation docOrgRelation = (DocOrgRelation)this.dao.findOne(DocOrgRelation.n().where().addEq(DocOrgRelation.DATA_FLAG, (Object)"1").addEq(DocOrgRelation.RELATION_CODE, (Object)relationCode).model());
        if (docOrgRelation != null) {
            msg.setDataTable(new Object[]{docOrgRelation});
            msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        } else {
            msg.setFailMsg("\u672a\u627e\u5230\u8be5\u673a\u6784\u5355\u8bc1");
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg queryTemplateVariable(String orgCode, String riskCode) {
        List resultList;
        DocOrgRelation queryModel;
        Return msg = new Return();
        HashSet<String> set = new HashSet<String>();
        if (StrUtils.isNull((Object)orgCode) && StrUtils.isNull((Object)riskCode)) {
            msg.setFailMsg("\u673a\u6784/\u9669\u79cd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (!StrUtils.isNull((Object)orgCode)) {
            queryModel = (DocOrgRelation)DocOrgRelation.n().where().model();
            queryModel.where().addEq(DocOrgRelation.DATA_FLAG, (Object)"1").addEq(DocOrgRelation.ORG_CODE, (Object)orgCode);
            resultList = this.dao.findAll((AbsModel)queryModel);
            for (DocOrgRelation docOrgRelation : resultList) {
                set.add(docOrgRelation.getDocTemplateCode());
            }
        }
        if (!StrUtils.isNull((Object)riskCode)) {
            queryModel = (RiskDocRelation)RiskDocRelation.n().where().model();
            queryModel.where().addEq(DocOrgRelation.DATA_FLAG, (Object)"1").addEq(RiskDocRelation.RISK_CODE, (Object)riskCode);
            resultList = this.dao.findAll((AbsModel)queryModel);
            for (RiskDocRelation riskDocRelation : resultList) {
                set.add(riskDocRelation.getDocTemplateCode());
            }
        }
        if (set.size() == 0) {
            msg.setFailMsg("\u5f53\u524d\u673a\u6784/\u9669\u79cd\u4e0b\u65e0\u53d8\u91cf\u4fe1\u606f\uff01");
            return msg.msg();
        }
        queryModel = (DocTemplateVariable)DocTemplateVariable.n().where().addEq(DocOrgRelation.DATA_FLAG, (Object)"1").model();
        DocContent docContentModel = (DocContent)DocContent.n().where().addEq(DocOrgRelation.DATA_FLAG, (Object)"1").addIn(DocContent.DOC_TEMPLATE_CODE, new ArrayList(set)).model();
        List docContenttList = this.dao.findAll((AbsModel)docContentModel);
        List resultList2 = null;
        if (!docContenttList.isEmpty()) {
            ((DocTemplateVariable)queryModel.where().addIn(DocTemplateVariable.CONTENT_CODE, docContenttList.stream().map(DocContent::getContentCode).collect(Collectors.toList())).model()).setOrderBy(new Sort.Order[]{DocTemplateVariable.CRT_DATE.desc()});
            resultList2 = this.dao.findAll((AbsModel)queryModel, Boolean.valueOf(true));
        } else {
            resultList2 = new ArrayList();
        }
        msg.setDataList(resultList2, DocTemplateVariable.class);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addOrUpdateDocRisk(RiskDocRelation riskDocRelation) {
        Return msg = new Return();
        if (riskDocRelation == null) {
            msg.setFailMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)riskDocRelation.getDocTemplateCode())) {
            msg.setFailMsg("\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)riskDocRelation.getRiskCode())) {
            msg.setFailMsg("\u9669\u79cd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        try {
            DocTemplate docTemplate = (DocTemplate)this.dao.findOne(DocTemplate.n().where().addEq(DocOrgRelation.DATA_FLAG, (Object)"1").addEq(DocOrgRelation.DOC_TEMPLATE_CODE, (Object)riskDocRelation.getDocTemplateCode()).model());
            if (docTemplate == null) {
                msg.setFailMsg("\u5355\u8bc1\u6a21\u677f\u7f16\u7801\u65e0\u6548");
                return msg.msg();
            }
            RiskDocRelation existing = (RiskDocRelation)this.dao.findOne(RiskDocRelation.n().where().addEq(RiskDocRelation.DOC_TEMPLATE_CODE, (Object)riskDocRelation.getDocTemplateCode()).addEq(RiskDocRelation.RISK_CODE, (Object)riskDocRelation.getRiskCode()).model());
            if (riskDocRelation.getRelationCode() != null) {
                if (existing != null && !riskDocRelation.getRelationCode().equals(existing.getRelationCode())) {
                    msg.setFailMsg("\u9669\u79cd\u6a21\u677f\u5df2\u5b58\u5728\u7ed1\u5b9a\u5173\u7cfb\uff01");
                    return msg.msg();
                }
                this.dao.update(riskDocRelation.getRelationCode(), (AbsModel)riskDocRelation);
            } else {
                if (existing != null) {
                    msg.setFailMsg("\u9669\u79cd\u6a21\u677f\u5df2\u5b58\u5728\u7ed1\u5b9a\u5173\u7cfb\uff01");
                    return msg.msg();
                }
                riskDocRelation.setRelationCode(UUID.uuid());
                riskDocRelation.setDataFlag("1");
                this.dao.save((AbsModel)riskDocRelation);
            }
            msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        }
        catch (Exception e) {
            msg.setFailMsg("\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage());
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg queryDocRiskList(RiskDocRelation riskDocRelation) {
        RiskDocRelation queryModel = ((RiskDocRelation)RiskDocRelation.n().where().addEq(DocOrgRelation.DATA_FLAG, (Object)"1").model()).setOrderBy(new Sort.Order[]{RiskDocRelation.CRT_DATE.desc()});
        if (riskDocRelation != null) {
            if (!StrUtils.isNull((Object)riskDocRelation.getRiskCode())) {
                queryModel.where().addEq(RiskDocRelation.RISK_CODE, (Object)riskDocRelation.getRiskCode());
            }
            if (!StrUtils.isNull((Object)riskDocRelation.getDocTemplateCode())) {
                queryModel.where().addEq(RiskDocRelation.DOC_TEMPLATE_CODE, (Object)riskDocRelation.getDocTemplateCode());
            }
        }
        List resultList = this.dao.findAll((AbsModel)queryModel, Boolean.valueOf(true));
        for (RiskDocRelation riskDoc : resultList) {
            DocTemplate docTemplate = (DocTemplate)this.dao.findOne(DocTemplate.n().where().addEq(DocTemplate.DOC_TEMPLATE_CODE, (Object)riskDoc.getDocTemplateCode()).addEq(DocTemplate.DATA_FLAG, (Object)"1").model());
            if (docTemplate == null) continue;
            riskDoc.setDocTemplateName(docTemplate.getDocTemplateCode());
            riskDoc.setDocTemplateVersion(docTemplate.getDocTemplateVersion());
            DocCategory docCategoryModel = (DocCategory)DocCategory.n().where().addEq(DocCategory.DATA_FLAG, (Object)"1").addEq(DocCategory.DOC_TYPE, (Object)docTemplate.getDocType()).model();
            if (docCategoryModel == null) continue;
            riskDoc.setTypeCnName(docCategoryModel.getTypeCnName());
        }
        Return msg = new Return();
        msg.setDataList(resultList, RiskDocRelation.class);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryDocRisk(String relationCode) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)relationCode)) {
            msg.setFailMsg("\u5173\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        RiskDocRelation riskDocRelation = (RiskDocRelation)this.dao.findOne(RiskDocRelation.n().where().addEq(RiskDocRelation.RELATION_CODE, (Object)relationCode).addEq(DocTemplate.DATA_FLAG, (Object)"1").model());
        if (riskDocRelation != null) {
            DocTemplate docTemplate = (DocTemplate)this.dao.findOne(DocTemplate.n().where().addEq(DocTemplate.DOC_TEMPLATE_CODE, (Object)riskDocRelation.getDocTemplateCode()).addEq(DocTemplate.DATA_FLAG, (Object)"1").model());
            if (docTemplate != null) {
                riskDocRelation.setDocTemplateName(docTemplate.getDocTemplateCode());
                riskDocRelation.setDocTemplateVersion(docTemplate.getDocTemplateVersion());
                DocCategory docCategoryModel = (DocCategory)DocCategory.n().where().addEq(DocCategory.DATA_FLAG, (Object)"1").addEq(DocCategory.DOC_TYPE, (Object)docTemplate.getDocType()).model();
                if (docCategoryModel != null) {
                    riskDocRelation.setTypeCnName(docCategoryModel.getTypeCnName());
                }
            }
            msg.setDataTable(new Object[]{riskDocRelation});
            msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        } else {
            msg.setFailMsg("\u672a\u627e\u5230\u8be5\u9669\u79cd\u5355\u8bc1\u8bbe\u7f6e");
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg delDocRisk(String relationCode) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)relationCode)) {
            msg.setFailMsg("\u5173\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        RiskDocRelation riskDocRelation = (RiskDocRelation)this.dao.findOne(RiskDocRelation.n().where().addEq(RiskDocRelation.RELATION_CODE, (Object)relationCode).addEq(DocTemplate.DATA_FLAG, (Object)"1").model());
        if (riskDocRelation != null) {
            this.dao.delete(riskDocRelation.getSerno(), riskDocRelation.getClass());
            msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        } else {
            msg.setFailMsg("\u672a\u627e\u5230\u8be5\u9669\u79cd\u5355\u8bc1\u8bbe\u7f6e");
        }
        return msg.msg();
    }
}

