/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.design.upload.controller;

import com.newtouch.nms.sip.design.upload.services.IFileUploader;
import com.newtouch.nms.sip.product.excel.ExcelView;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import com.uniapis.web.utils.RequestUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Controller
public class FileUploaderController {
    private static Map<String, Map<String, Object>> FILE_TYPE = new HashMap<String, Map<String, Object>>();
    @Autowired
    private IFileUploader fileService;
    private String allowSuffix = "jpg,png,gif,jpeg,xls,xlsx";
    private long allowSize = 2L;
    private String fileName;
    private String[] fileNames;

    @ResponseBody
    @RequestMapping(value={"/doFileUploader.do"})
    public String doFileUploader(@RequestParam(value="file") MultipartFile file, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map map = RequestUtils.getRequestMap((HttpServletRequest)request);
        String service = StrUtils.trimStr(map.get("uploadService"));
        String[] ser = service.split("\\.");
        String bean = ser[0];
        String method = ser[1];
        map.put("file", file);
        Object obj = SpringContext.getBean((String)bean);
        Class[] argTypes = new Class[]{Map.class};
        Method method1 = obj.getClass().getMethod(method, argTypes);
        Object[] argValues = new Object[]{map};
        ReturnMsg returnMsg = (ReturnMsg)method1.invoke(obj, argValues);
        if (!StrUtils.isNull(map.get("cbsuc"))) {
            returnMsg.getDataTable().put("cbsuc", map.get("cbsuc"));
        }
        if (!StrUtils.isNull(map.get("cbfail"))) {
            returnMsg.getDataTable().put("cbfail", map.get("cbfail"));
        }
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/uploadFile2Repostry.do"})
    public String uploadFile2Repostry(@RequestParam(value="file") MultipartFile file, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map map = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.fileService.saveFile(file, StrUtils.trimStr(map.get("file_no")), StrUtils.trimStr(map.get("md5")), StrUtils.trimStr(map.get("fileSize")));
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/uploadBase64File2Repostry.do"})
    public String uploadBase64File2Repostry(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map map = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.fileService.saveFile(StrUtils.trimStr(map.get("file")), StrUtils.trimStr(map.get("file_name")), StrUtils.trimStr(map.get("file_no")), StrUtils.trimStr(map.get("md5")));
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/goFileUploader.do"})
    public String goFileUploader(HttpServletRequest request, HttpServletResponse response) {
        this.initFileType();
        Map map = RequestUtils.getRequestMap((HttpServletRequest)request);
        if (!StrUtils.isNull(map.get("fileType"))) {
            map.putAll(FILE_TYPE.get(map.get("fileType")));
        } else {
            map.putAll(FILE_TYPE.get("default"));
        }
        Return msg = new Return();
        msg.setDataTable(map);
        return RequestUtils.return2Json((ReturnMsg)msg.msg());
    }

    @RequestMapping(value={"/goFileUploaderModal.do"})
    public String goFileUploaderModal(HttpServletRequest request, HttpServletResponse response) {
        this.initFileType();
        Map map = RequestUtils.getRequestMap((HttpServletRequest)request);
        if (!StrUtils.isNull(map.get("fileType"))) {
            map.putAll(FILE_TYPE.get(map.get("fileType")));
        } else {
            map.putAll(FILE_TYPE.get("default"));
        }
        Return msg = new Return();
        msg.setDataTable(map);
        return RequestUtils.return2Json((ReturnMsg)msg.msg());
    }

    @RequestMapping(value={"/goFileUploaderModal4Image.do"})
    public String goFileUploaderModal4Image(HttpServletRequest request, HttpServletResponse response) {
        this.initFileType();
        Map map = RequestUtils.getRequestMap((HttpServletRequest)request);
        if (!StrUtils.isNull(map.get("fileType"))) {
            map.putAll(FILE_TYPE.get(map.get("fileType")));
        } else {
            map.putAll(FILE_TYPE.get("default"));
        }
        Return msg = new Return();
        msg.setDataTable(map);
        return RequestUtils.return2Json((ReturnMsg)msg.msg());
    }

    @RequestMapping(value={"/downloadExcel.do"})
    public ModelAndView doFileDownloadder(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setCharacterEncoding("utf-8");
        Map map = RequestUtils.getRequestMap((HttpServletRequest)request);
        String service = StrUtils.trimStr(map.get("downloadService"));
        String[] ser = service.split("\\.");
        String bean = ser[0];
        String method = ser[1];
        Object obj = SpringContext.getBean((String)bean);
        Class[] argTypes = new Class[]{Map.class};
        Method method1 = obj.getClass().getMethod(method, argTypes);
        Object[] argValues = new Object[]{map};
        ReturnMsg returnMsg = (ReturnMsg)method1.invoke(obj, argValues);
        ExcelView excelView = new ExcelView();
        return new ModelAndView((View)excelView, returnMsg.getDataTable());
    }

    private void initFileType() {
        HashMap<String, String> excel = new HashMap<String, String>();
        excel.put("ext_title", "excel");
        excel.put("ext_mimeTypes", "application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        excel.put("ext_extensions", "xls,xlsx");
        FILE_TYPE.put("excel", excel);
        HashMap<String, String> image = new HashMap<String, String>();
        image.put("ext_title", "Images");
        image.put("ext_mimeTypes", "image/*");
        image.put("ext_extensions", "gif,jpg,jpeg,bmp,png");
        FILE_TYPE.put("image", image);
        HashMap<String, String> _default = new HashMap<String, String>();
        _default.put("ext_title", "Images");
        _default.put("ext_mimeTypes", "application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,image/*,text/plain,text/xml,application/pdf,application/zip,application/msword,application/vnd.ms-powerpoint,application/vnd.openxmlformats-officedocument.wordprocessingml.document,application/vnd.openxmlformats-officedocument.presentationml.presentation,text/html");
        _default.put("ext_extensions", "png,gif,jpg,jpeg,bmp,tiff,txt,text,xml,pdf,doc,ppt,xls,docx,pptx,xlsx,html,htm,zip");
        FILE_TYPE.put("default", _default);
    }

    public void upload(MultipartFile file, String destDir, HttpServletRequest request) throws Exception {
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path;
        String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        int length = this.getAllowSuffix().indexOf(suffix);
        if (length == -1) {
            throw new Exception("\u8bf7\u4e0a\u4f20\u5141\u8bb8\u683c\u5f0f\u7684\u6587\u4ef6");
        }
        if (file.getSize() > this.getAllowSize()) {
            throw new Exception("\u60a8\u4e0a\u4f20\u7684\u6587\u4ef6\u5927\u5c0f\u5df2\u7ecf\u8d85\u51fa\u8303\u56f4");
        }
        String realPath = request.getSession().getServletContext().getRealPath("/");
        File destFile = new File(realPath + destDir);
        if (!destFile.exists()) {
            destFile.mkdirs();
        }
        String fileNameNew = this.getFileNameNew() + "." + suffix;
        File f = new File(destFile.getAbsoluteFile() + "/" + fileNameNew);
        file.transferTo(f);
        f.createNewFile();
        this.fileName = basePath + destDir + fileNameNew;
    }

    private void uploads(MultipartFile[] files, String destDir, HttpServletRequest request) throws Exception {
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path;
        this.fileNames = new String[files.length];
        int index = 0;
        for (MultipartFile file : files) {
            String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
            int length = this.getAllowSuffix().indexOf(suffix);
            if (length == -1) {
                throw new Exception("\u8bf7\u4e0a\u4f20\u5141\u8bb8\u683c\u5f0f\u7684\u6587\u4ef6");
            }
            if (file.getSize() > this.getAllowSize()) {
                throw new Exception("\u60a8\u4e0a\u4f20\u7684\u6587\u4ef6\u5927\u5c0f\u5df2\u7ecf\u8d85\u51fa\u8303\u56f4");
            }
            String realPath = request.getSession().getServletContext().getRealPath("/");
            File destFile = new File(realPath + destDir);
            if (!destFile.exists()) {
                destFile.mkdirs();
            }
            String fileNameNew = this.getFileNameNew() + "." + suffix;
            File f = new File(destFile.getAbsoluteFile() + "\\" + fileNameNew);
            file.transferTo(f);
            f.createNewFile();
            this.fileNames[index++] = basePath + destDir + fileNameNew;
        }
    }

    private String getFileNameNew() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return fmt.format(new Date());
    }

    public String getAllowSuffix() {
        return this.allowSuffix;
    }

    public void setAllowSuffix(String allowSuffix) {
        this.allowSuffix = allowSuffix;
    }

    public long getAllowSize() {
        return this.allowSize * 1024L * 1024L;
    }

    public void setAllowSize(long allowSize) {
        this.allowSize = allowSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public void setFileNames(String[] fileNames) {
        this.fileNames = fileNames;
    }
}

