/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.controller;

import com.newtouch.nms.sip.model.SipProductSyncTask;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.product.transfer.services.IProductTransferAsyncService;
import com.newtouch.nms.sip.product.transfer.services.IProductTransferService;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.context.pojo.User;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class ProductTransferController {
    @Autowired
    IProductTransferService productTransferService;
    @Autowired
    HttpServletResponse response;
    @Autowired
    private IProductTransferAsyncService productTransferAsyncService;
    @Autowired
    private AbsModelRepository dao;

    @RequestMapping(value={"/exportProduct.do"})
    public String exportProduct(HttpServletRequest request) {
        Return r = new Return();
        Map productMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        Map downDataMap = (Map)productMap.get("downData");
        List productList = (List)downDataMap.get("checkbox");
        if (CollectionUtils.isEmpty((Collection)productList)) {
            r.setFailMsg("checkbox\u4e0d\u80fd\u4e3a\u7a7a");
            return RequestUtils.return2Json((ReturnMsg)r.msg());
        }
        for (Map prdMap : productList) {
            if (!StrUtils.isNull(prdMap.get("product_uuid"))) continue;
            r.setFailMsg("product_uuid\u4e0d\u80fd\u4e3a\u7a7a");
            return RequestUtils.return2Json((ReturnMsg)r.msg());
        }
        SipProducts product = SipProducts.n();
        List productUuidList = productList.stream().map(p -> StrUtils.trimStr(p.get("product_uuid"))).collect(Collectors.toList());
        product.where().addIn(SipProducts.PRODUCT_UUID, productUuidList);
        List sipProductsList = this.dao.findAll((AbsModel)product);
        StringJoiner nameJoiner = new StringJoiner(",");
        StringJoiner uuidJoiner = new StringJoiner(",");
        sipProductsList.forEach(p -> {
            nameJoiner.add(p.getProductName());
            uuidJoiner.add(p.getProductUuid());
        });
        SipProductSyncTask task = new SipProductSyncTask();
        task.setTaskName(nameJoiner.toString());
        task.setProductUuid(uuidJoiner.toString());
        task.setFuncModule("PRODUCT");
        task.setTaskType("EXP");
        task.setTaskState("ING");
        task.setIsZipDel("1");
        String serno = UUID.uuid();
        task.setSerno(serno);
        this.dao.save((AbsModel)task);
        ((Map)productList.get(0)).put("serno", serno);
        User user = ThreadLocalContext.get().getUser();
        this.productTransferAsyncService.exportProductAsync(productList, user);
        ((ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class)).clearProductUtilsCache();
        return RequestUtils.return2Json((ReturnMsg)r.msg());
    }

    @RequestMapping(value={"/importProduct.do"})
    public String importProduct(String md5, String taskType, @RequestParam(value="file") MultipartFile file) {
        ReturnMsg msg = this.productTransferService.importProduct(file, md5, taskType);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/compareProduct.do", "/compareProduct.serv"})
    public String compare(@RequestParam(value="newFile") MultipartFile newFile) {
        ReturnMsg msg = this.productTransferService.compareProduct(newFile);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/createDir.do"})
    public String createDir(HttpServletRequest request) {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        String pathname = (String)requestMap.get("pathname");
        File file = new File(pathname);
        boolean isExist = file.exists();
        boolean dr = false;
        if (!isExist) {
            dr = file.mkdirs();
        }
        Return r = new Return();
        r.getDataTable().put("isExist", isExist);
        r.getDataTable().put("res", dr);
        return RequestUtils.return2Json((ReturnMsg)r.msg());
    }

    @RequestMapping(value={"/transferRule.do"})
    public String transferRule(HttpServletRequest request) {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        String delFlag = (String)requestMap.get("del_flag");
        ReturnMsg msg = this.productTransferService.transferRule(delFlag);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/transPrdPackageToGrandOp.do"})
    public String transPrdPackageToGrandOp(HttpServletRequest request) {
        Return r = new Return();
        User user = ThreadLocalContext.get().getUser();
        if (StrUtils.isNull(user.getUserExtendInfo().get("X-Auth-Token"))) {
            user.getUserExtendInfo().put("X-Auth-Token", request.getSession().getId());
        }
        Map productMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        Map downDataMap = (Map)productMap.get("downData");
        String taskType = (String)downDataMap.get("taskType");
        List productList = (List)downDataMap.get("checkbox");
        this.productTransferAsyncService.transProductAsync(productList, taskType, user);
        return RequestUtils.return2Json((ReturnMsg)r.msg());
    }

    @RequestMapping(value={"/queryAsyncTask.do"})
    public String queryAsyncTask(HttpServletRequest request) {
        RequestMap paramMap = RequestUtils.getRequest((HttpServletRequest)request);
        SipProductSyncTask task = (SipProductSyncTask)RequestUtils.getRequestMap((Map)paramMap.getParam(), SipProductSyncTask.class);
        ReturnMsg msg = this.productTransferService.querySyncTask(task);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

