/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.risk.services.impl;

import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.nms.sip.design.data.service.StructureService;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipOrganProducts;
import com.newtouch.nms.sip.model.SipOrganRiskRelation;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.risk.services.IRiskDelService;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RiskDelServiceImpl
implements IRiskDelService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private StructureService structureService;
    @Value(value="${productUuid}")
    private String productUuid;
    private final String allowSuffix = "png,gif,jpg,jpeg,bmp,tiff,txt,xml,pdf,zip,rar,doc,ppt,xls,docx,pptx,xlsx,html,htm,webp";
    private final long allowSize = 0x500000L;
    private final String FIELD_VALUE = "field_value";

    @Override
    public ReturnMsg delRisk(Map<String, Object> paramMap) {
        Return msg = new Return();
        List riskList = (List)paramMap.get("dsn_structure");
        if (null == riskList || riskList.isEmpty()) {
            msg.setWarnMsg("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u9669\u79cd\uff01");
            return msg.msg();
        }
        for (Map risk : riskList) {
            List dss;
            String nodeNo = StrUtils.trimStr(risk.get("node_no"));
            String relateTab = StrUtils.trimStr(risk.get("relate_tab"));
            String serno = StrUtils.trimStr(risk.get("serno"));
            String riskName = StrUtils.trimStr(risk.get("node_name"));
            List sprs = this.dao.findAll("SELECT risk_uuid FROM " + relateTab + " WHERE serno = ? \uff03NOTCHECK", SipProductRisks.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{serno})});
            if (sprs.isEmpty()) {
                msg.setFailMsg(riskName + "\u672a\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u9669\u79cd\u5173\u7cfb\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u662f\u5426\u6b63\u786e");
                return msg.msg();
            }
            String riskUuid = ((SipProductRisks)sprs.get(0)).getRiskUuid();
            List sorrs = this.dao.findAll("SELECT * FROM sip_organ_risk_relation WHERE main_risk = ? OR risk_uuid = ? and data_flag = ? \uff03NOTCHECK", SipOrganRiskRelation.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{riskUuid, riskUuid, "1"})});
            if (!sorrs.isEmpty()) {
                msg.setFailMsg(riskName + "\u9669\u79cd\u5df2\u4e0a\u67b6\uff0c\u65e0\u6cd5\u5220\u9664\u9669\u79cd");
                return msg.msg();
            }
            List sipProductRisks = this.dao.findAll(SipProductRisks.n().where().addEq(SipProductRisks.RISK_UUID, (Object)riskUuid).addNotEq(SipOrganProducts.PRODUCT_UUID, (Object)this.productUuid).model());
            if (!sipProductRisks.isEmpty()) {
                msg.setFailMsg("\u6b64\u4e3b\u9669\u5df2\u5173\u8054\u4ea7\u54c1\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
            }
            if ((dss = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)nodeNo).model())).size() >= 2) {
                msg.setFailMsg(riskName + "\u9669\u79cd\u5df2\u88ab\u5176\u4ed6\u4ea7\u54c1\u4f7f\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u9669\u79cd\u64cd\u4f5c\uff0c\u53ea\u80fd\u8fdb\u884c\u53d6\u6d88\u9669\u79cd\u5173\u7cfb\u64cd\u4f5c");
                return msg.msg();
            }
            dss = this.dao.findAll(DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)nodeNo).addNotEq(DsnStructure.NODE_NO, (Object)nodeNo).addIn(DsnStructure.NODE_TYPE, new String[]{NodeType.ACCY_RISKS.code(), NodeType.EXEMPT.code(), NodeType.SUB_RISKS.code()}).model());
            if (!dss.isEmpty()) {
                msg.setFailMsg(riskName + "\u5b58\u5728\u4e0b\u7ea7\u9669\u79cd\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u5148\u5220\u9664\u6216\u8005\u53d6\u6d88\u4e0b\u7ea7\u5173\u7cfb\u4e4b\u540e\u518d\u5220\u9664\u5f53\u524d\u9669\u79cd");
                return msg.msg();
            }
            RiskDelServiceImpl.queryChildNodeAndDel(nodeNo, this.dao);
            DsnStructure delRisk = (DsnStructure)DsnStructure.n().where().addEq(DsnStructure.SERNO, (Object)serno).model();
            this.dao.delete((AbsModel)delRisk);
        }
        return msg.msg();
    }

    public static void queryChildNodeAndDel(String upNode, AbsModelRepository dao) {
        List nodeList = dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)upNode).model());
        if (nodeList.isEmpty()) {
            return;
        }
        for (DsnStructure node : nodeList) {
            switch (NodeType.valueOf((String)node.getNodeType().toUpperCase())) {
                case PRD: {
                    break;
                }
                case ATTR: 
                case ATTR_DETAIL: 
                case ATTR4RATE: {
                    RiskDelServiceImpl.delDnsBizAttribute(node, dao);
                    break;
                }
                case N_RISK_DETAIL: {
                    RiskDelServiceImpl.delSipRisks(node, dao);
                    break;
                }
                case RULE: {
                    dao.delete(DsnRules.n().where().addEq(DsnRules.RELATE_FK, (Object)node.getNodeNo()).model());
                    dao.delete(DsnRulesConst.n().where().addEq(DsnRulesConst.RULE_ID, (Object)node.getNodeNo()).model());
                    break;
                }
                case RATE: 
                case ATTR4LIABILITY: {
                    try {
                        if (!StrUtils.isNull((Object)node.getRelateTab())) {
                            dao.getJdbcTemplate().execute("DROP TABLE IF EXISTS " + node.getRelateTab());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    dao.delete(DsnDynamicData.n().where().addEq(DsnDynamicData.RELATE_TAB, (Object)"dsn_structure").addEq(DsnDynamicData.RELATE_FIELD, (Object)"node_no").addEq(DsnDynamicData.RELATE_FK, (Object)node.getNodeNo()).model());
                    break;
                }
                case N_RULE: {
                    break;
                }
                case N_RATE: {
                    break;
                }
                case N_BENEFIT: {
                    break;
                }
                case N_RISK: {
                    break;
                }
                case MAIN_RISKS: {
                    break;
                }
                case ACCY_RISKS: {
                    break;
                }
                case SUB_RISKS: {
                    break;
                }
                case EXEMPT: {
                    break;
                }
                case N_RISK_ATTR: {
                    break;
                }
                case N_ACCY_RISKS: {
                    break;
                }
                case N_EXEMPT: {
                    break;
                }
                case N_SUB_RISKS: {
                    break;
                }
                case N_TBR: {
                    break;
                }
                case N_BBR: {
                    break;
                }
                case N_SYR: {
                    break;
                }
            }
            RiskDelServiceImpl.queryChildNodeAndDel(node.getNodeNo(), dao);
            dao.delete(node.where().addEq(DsnStructure.SERNO, (Object)node.getSerno()).model());
        }
    }

    private static void delSipRisks(DsnStructure node, AbsModelRepository dao) {
        dao.delete(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)node.getNodeNo()).model());
        RiskDelServiceImpl.delRiskRelation(node, dao);
    }

    private static void delRiskRelation(DsnStructure node, AbsModelRepository dao) {
        String[] nodeSeqArray = node.getNodeSeq().split("\\.");
        boolean isMainRiks = nodeSeqArray.length == 4;
        String serno = nodeSeqArray[nodeSeqArray.length - 2];
        if (isMainRiks) {
            dao.delete(SipProductRisks.n().where().addEq(SipProductRisks.SERNO, (Object)serno).model());
            return;
        }
        dao.delete(SipRiskRelation.n().where().addEq(SipRiskRelation.SERNO, (Object)serno).model());
    }

    private static void delDnsBizAttribute(DsnStructure node, AbsModelRepository dao) {
        dao.delete(DsnBizAttribute.n().where().addEq(DsnBizAttribute.BIZ_UUID, (Object)node.getNodeNo()).model());
        dao.delete(DsnBizAttributeOption.n().where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)node.getNodeNo()).model());
    }
}

