/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.risk.controller;

import com.newtouch.nms.sip.design.product.detail.services.IDetailsService;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.product.risk.services.IRiskListQueryService;
import com.newtouch.nms.sip.product.risk.services.IRiskService;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/risk")
public class RiskController {
    @Autowired
    private IRiskService riskServiceImp;
    @Autowired
    private IRiskListQueryService riskListQueryServiceImp;
    @Autowired
    private IDetailsService detailsService;

    @RequestMapping(value={"/goRiskAdd.do"})
    public String goRiskAdd(HttpServletRequest request, HttpServletResponse response) {
        DsnStructure node = (DsnStructure)RequestUtils.getRequestMap((HttpServletRequest)request, DsnStructure.class);
        Return ret = new Return();
        ret.setDataTable(new Object[]{node, DsnStructure.class});
        return RequestUtils.return2Json((ReturnMsg)ret.msg());
    }

    @RequestMapping(value={"/doRiskAdd.do"})
    public String doRiskAdd(HttpServletRequest request, HttpServletResponse response) {
        RequestMap paramMap = RequestUtils.getRequest((HttpServletRequest)request);
        DsnStructure node = (DsnStructure)RequestUtils.getRequestMap((Map)paramMap.getParam(), DsnStructure.class);
        ReturnMsg msg = this.riskServiceImp.addRisk(node, paramMap.getParam());
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doRiskCopy.do"})
    public String doRiskCopy(HttpServletRequest request, HttpServletResponse response) {
        Map paramMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = null;
        return RequestUtils.return2Json(msg);
    }

    @RequestMapping(value={"/goRiskInfo.do"})
    public String goRiskInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        DsnStructure node = (DsnStructure)RequestUtils.getRequestMap((HttpServletRequest)request, DsnStructure.class);
        ReturnMsg msg = this.detailsService.queryDetailsInfo(node);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/saveRiskInfo.do"})
    public String saveRiskInfo(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        DsnStructure structure = (DsnStructure)RequestUtils.getRequestMap((Map)param.getParam(), DsnStructure.class);
        ReturnMsg msg = this.detailsService.saveProductDetails(structure, param.getParam());
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/goValidateProductName.do"})
    public String validateProductName(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        ReturnMsg msg = this.riskServiceImp.doValidateProductName(param.get("node_type"), param.get("node_name"));
        if (msg.getDataList().size() > 0) {
            response.getWriter().write("false");
        } else {
            response.getWriter().write("true");
        }
        return null;
    }

    @GetMapping(value={"/delRiskCacheByNo.do", "/delRiskCacheByNo.serv"})
    public String delRiskCacheByNo(@RequestParam Map<String, Object> map) {
        String riskNos = (String)map.get("risk_nos");
        ReturnMsg msg = this.riskServiceImp.delRiskCacheByNo(riskNos);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

