/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.risk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.risk.LiabilityRisk;
import com.newtouch.nms.sip.product.transfer.domain.risk.Risk;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class LiabilityRiskNode {
    private DsnStructure liabilityRisk;
    private List<LiabilityRisk> liabilityRiskList = new ArrayList<LiabilityRisk>();
    @JsonIgnore
    private Risk risk;

    public LiabilityRiskNode load(String upNode) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.liabilityRisk = utils.queryStructure(upNode, NodeType.N_SUB_RISKS.code());
        if (this.liabilityRisk != null) {
            utils.queryStructures(this.liabilityRisk.getNodeNo()).forEach(liabilityRisk -> {
                LiabilityRisk risk = new LiabilityRisk();
                risk.setMainRisk(this.risk);
                risk.load((DsnStructure)liabilityRisk);
                this.liabilityRiskList.add(risk);
            });
        }
        return this;
    }

    public void merge(LiabilityRiskNode liabilityRiskNode) {
        this.liabilityRisk = ProductEqualsUtils.merge(this.liabilityRisk, liabilityRiskNode.getLiabilityRisk());
        this.liabilityRiskList = ProductEqualsUtils.merge(this.liabilityRiskList, liabilityRiskNode.getLiabilityRiskList(), LiabilityRisk.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update((AbsModel)this.liabilityRisk);
        }
        if (this.liabilityRiskList != null) {
            this.liabilityRiskList.forEach(risk -> risk.save());
        }
    }

    public TreeNode fetchTreeNode() {
        if (this.liabilityRisk == null) {
            return null;
        }
        TreeNode treeNode = new TreeNode(CompareEnum.NodeType.RISK_RESPONSIBILITY.getTag() + this.liabilityRisk.getSerno(), CompareEnum.NodeType.RISK_RESPONSIBILITY.getLable());
        treeNode.getChildren().add(new TreeNode(this.liabilityRisk.getSerno(), this.liabilityRisk, CompareEnum.NodeType.STRUCTURE));
        if (this.liabilityRiskList != null && this.liabilityRiskList.size() > 0) {
            TreeNode liabilityRiskList = new TreeNode(CompareEnum.NodeType.LIABILITY_RISK_ARRAY.getTag() + this.liabilityRisk.getSerno(), CompareEnum.NodeType.LIABILITY_RISK_ARRAY.getLable());
            treeNode.getChildren().add(liabilityRiskList);
            for (LiabilityRisk risk : this.liabilityRiskList) {
                liabilityRiskList.getChildren().add(risk.fetchTreeNode());
            }
        }
        return treeNode;
    }

    public void setRisk(Risk risk) {
        this.risk = risk;
    }

    public DsnStructure getLiabilityRisk() {
        return this.liabilityRisk;
    }

    public void setLiabilityRisk(DsnStructure liabilityRisk) {
        this.liabilityRisk = liabilityRisk;
    }

    public List<LiabilityRisk> getLiabilityRiskList() {
        return this.liabilityRiskList;
    }

    public void setLiabilityRiskList(List<LiabilityRisk> liabilityRiskList) {
        this.liabilityRiskList = liabilityRiskList;
    }

    public Risk getRisk() {
        return this.risk;
    }
}

