/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.main.services.impl;

import com.newtouch.nms.sip.design.product.utils.NodeSeqUtils;
import com.newtouch.nms.sip.model.DsnAttributeOption;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.main.services.IProductCopyService;
import com.newtouch.nms.sip.product.utils.PinYin4J;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ProductCopyServiceImpl
implements IProductCopyService {
    @Value(value="${riskTemplate}")
    private String riskTemplate;
    @Autowired
    private AbsModelRepository dao;

    public static void dnsBizAttributeNew(DsnBizAttribute attr, DsnStructure newNode, AbsModelRepository dao) {
        newNode.setRelateTab("dsn_biz_attribute");
        newNode.setRelateField("biz_uuid");
        newNode.setRelateFk(newNode.getNodeNo());
        DsnBizAttribute attrWhere = DsnBizAttribute.n();
        attrWhere.where().addEq(DsnBizAttribute.ATTR_UUID, (Object)attr.getAttrUuid());
        if (!StrUtils.isNull((Object)attr.getAttrName())) {
            attrWhere.where().addEq(DsnBizAttribute.ATTR_NAME, (Object)attr.getAttrName());
        }
        if (!StrUtils.isNull((Object)attr.getAttrNo())) {
            attrWhere.where().addEq(DsnBizAttribute.ATTR_NO, (Object)attr.getAttrNo());
        }
        if (!StrUtils.isNull((Object)attr.getUiType())) {
            attrWhere.where().addEq(DsnBizAttribute.UI_TYPE, (Object)attr.getUiType());
        }
        if (!StrUtils.isNull((Object)attr.getNotNull())) {
            attrWhere.where().addEq(DsnBizAttribute.NOT_NULL, (Object)attr.getNotNull());
        }
        DsnBizAttribute oldAttr = (DsnBizAttribute)dao.findOne((AbsModel)attrWhere);
        oldAttr.setSerno(null);
        oldAttr.setBizUuid(newNode.getNodeNo());
        dao.save((AbsModel)oldAttr);
        List optionList = dao.findAll(DsnAttributeOption.n().where().addEq(DsnAttributeOption.ATTR_UUID, (Object)oldAttr.getAttrUuid()).model());
        List bizOptionList = optionList.stream().map(opt -> {
            opt.setSerno(null);
            DsnBizAttributeOption bizOpt = new DsnBizAttributeOption();
            BeanUtils.copyProperties((Object)opt, (Object)bizOpt);
            bizOpt.setBizUuid(oldAttr.getBizUuid());
            return bizOpt;
        }).collect(Collectors.toList());
        dao.save(bizOptionList);
    }

    @Override
    public SipProducts copyProduct(String sourceNodeNo, String targetPrdName, Map<String, String> riskName) {
        DsnStructure sourceNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)sourceNodeNo).model());
        String sourcePrdNodeNo = sourceNode.getUpNode();
        DsnStructure prdStructure = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)sourcePrdNodeNo).model());
        String nodeNo = UUID.shortUUID();
        DsnStructure targetRootNode = this.copyDsnStructure(prdStructure, nodeNo, targetPrdName, nodeNo + ".", "prd_root");
        this.dao.save((AbsModel)targetRootNode);
        this.queryChildNodeAndCopy("ProductCopy", prdStructure.getNodeNo(), targetRootNode.getNodeNo(), targetRootNode.getNodeSeq(), riskName, targetPrdName, "");
        DsnStructure prdStructure2 = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)nodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.PRD_DETAIL.code()).model());
        SipProducts product = (SipProducts)this.dao.findOne(SipProducts.n().where().addEq(SipProducts.PRODUCT_UUID, (Object)prdStructure2.getNodeNo()).model());
        return product;
    }

    @Override
    public SipRisks copyRisk(String addType, String sourceNodeNo, String targetPrdName, Map<String, String> riskName, String mainRiskNodeNo, String accyRisksNodeNo) {
        if ("M".equals(addType)) {
            DsnStructure sourceNode1 = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)this.riskTemplate).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK.code()).model());
            DsnStructure prdDetailDs = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)sourceNodeNo).model());
            String prdDetailNodeSeq = prdDetailDs.getNodeSeq();
            String[] nodeSeqArray = NodeSeqUtils.splitNodeSeq(prdDetailNodeSeq);
            DsnStructure sourceNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)nodeSeqArray[0]).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.MAIN_RISKS.code()).model());
            this.queryChildNodeAndCopy(addType, sourceNode.getUpNode(), sourceNode1.getNodeNo(), sourceNode1.getNodeSeq(), riskName, "", sourceNodeNo);
            DsnStructure prdStructure2 = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)sourceNode.getNodeNo()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model());
            SipRisks sipRisks = (SipRisks)this.dao.findOne(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)prdStructure2.getNodeNo()).model());
            return sipRisks;
        }
        if ("A".equals(addType)) {
            DsnStructure sourceNode1 = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)(this.riskTemplate + "%" + mainRiskNodeNo)).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_ACCY_RISKS.code()).model());
            DsnStructure prdDetailDs = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)sourceNodeNo).model());
            String prdDetailNodeSeq = prdDetailDs.getNodeSeq();
            String[] nodeSeqArray = NodeSeqUtils.splitNodeSeq(prdDetailNodeSeq);
            DsnStructure sourceNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)nodeSeqArray[0]).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.ACCY_RISKS.code()).model());
            if (sourceNode == null || "".equals(sourceNode.getNodeNo())) {
                throw new BusinessException("\u8bf7\u786e\u8ba4\u9644\u52a0\u9669\u6dfb\u52a0\u5728\u54ea\u4e2a\u4e3b\u9669\u4e0b");
            }
            this.queryChildNodeAndCopy(addType, sourceNode.getUpNode(), sourceNode1.getNodeNo(), sourceNode1.getNodeSeq(), riskName, "", sourceNodeNo);
            DsnStructure prdStructure2 = (DsnStructure)this.dao.findOne((AbsModel)((DsnStructure)DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)sourceNode1.getNodeNo()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.CRT_DATE.desc()}));
            SipRisks sipRisks = (SipRisks)this.dao.findOne(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)prdStructure2.getNodeNo()).model());
            return sipRisks;
        }
        if ("M_W".equals(addType)) {
            DsnStructure mainSourceNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)(this.riskTemplate + "%" + mainRiskNodeNo)).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.MAIN_RISKS.code()).model());
            DsnStructure sourceNode1 = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)mainSourceNode.getNodeNo()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_EXEMPT.code()).model());
            DsnStructure prdDetailDs = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)sourceNodeNo).model());
            String prdDetailNodeSeq = prdDetailDs.getNodeSeq();
            String[] nodeSeqArray = NodeSeqUtils.splitNodeSeq(prdDetailNodeSeq);
            List sourceNodeList = this.dao.findAll((AbsModel)((DsnStructure)DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)nodeSeqArray[0]).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.EXEMPT.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.NODE_SEQ.desc()}));
            String nodeSeq = sourceNodeList.stream().map(DsnStructure::getNodeSeq).min(Comparator.comparing(String::length)).orElse(null);
            DsnStructure sourceNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_SEQ, (Object)nodeSeq).model());
            if (sourceNode == null || "".equals(sourceNode.getNodeNo())) {
                throw new BusinessException("\u8bf7\u786e\u8ba4\u8c41\u514d\u9669\u6dfb\u52a0\u5728\u54ea\u4e2a\u4e3b\u9669\u4e0b");
            }
            this.queryChildNodeAndCopy("W", sourceNode.getUpNode(), sourceNode1.getNodeNo(), sourceNode1.getNodeSeq(), riskName, "", sourceNodeNo);
            DsnStructure prdStructure2 = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)sourceNode.getNodeNo()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model());
            SipRisks sipRisks = (SipRisks)this.dao.findOne(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)prdStructure2.getNodeNo()).model());
            return sipRisks;
        }
        if ("A_W".equals(addType)) {
            DsnStructure accyRisksNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)accyRisksNodeNo).model());
            DsnStructure sourceNode1 = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)accyRisksNode.getNodeNo()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_EXEMPT.code()).model());
            DsnStructure prdDetailDs = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)sourceNodeNo).model());
            String prdDetailNodeSeq = prdDetailDs.getNodeSeq();
            String[] nodeSeqArray = NodeSeqUtils.splitNodeSeq(prdDetailNodeSeq);
            List sourceNodeList = this.dao.findAll((AbsModel)((DsnStructure)DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)nodeSeqArray[0]).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.EXEMPT.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.NODE_SEQ.desc()}));
            String nodeSeq = sourceNodeList.stream().map(DsnStructure::getNodeSeq).max(Comparator.comparing(String::length)).orElse(null);
            DsnStructure sourceNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_SEQ, (Object)nodeSeq).model());
            if (sourceNode == null || "".equals(sourceNode.getNodeNo())) {
                throw new BusinessException("\u8bf7\u786e\u8ba4\u8c41\u514d\u9669\u6dfb\u52a0\u5728\u54ea\u4e2a\u9644\u4ef6\u9669\u4e0b");
            }
            this.queryChildNodeAndCopy("W", sourceNode.getUpNode(), sourceNode1.getNodeNo(), sourceNode1.getNodeSeq(), riskName, "", sourceNodeNo);
            DsnStructure prdStructure2 = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)sourceNode.getNodeNo()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model());
            SipRisks sipRisks = (SipRisks)this.dao.findOne(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)prdStructure2.getNodeNo()).model());
            return sipRisks;
        }
        if ("S".equals(addType)) {
            return null;
        }
        return null;
    }

    private void queryChildNodeAndCopy(String addType, String upNode, String targetUpNode, String targetUpNodeSeq, Map<String, String> riskName, String targetPrdName, String templateProductUuid) {
        List nodeList = null;
        nodeList = "ProductCopy".equals(addType) ? this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)upNode).addIn(DsnStructure.NODE_TYPE, new String[]{NodeType.PRD.code(), NodeType.PRD_DETAIL.code(), NodeType.N_RISK.code(), NodeType.ATTR_DETAIL.code()}).model()) : ("M".equals(addType) ? this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)upNode).addNotIn(DsnStructure.NODE_TYPE, new String[]{NodeType.PRD.code(), NodeType.PRD_DETAIL.code(), NodeType.N_RISK.code(), NodeType.ACCY_RISKS.code(), NodeType.EXEMPT.code(), NodeType.SUB_RISKS.code()}).model()) : ("A".equals(addType) ? this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)upNode).addNotIn(DsnStructure.NODE_TYPE, new String[]{NodeType.PRD.code(), NodeType.PRD_DETAIL.code(), NodeType.N_RISK.code(), NodeType.EXEMPT.code(), NodeType.SUB_RISKS.code()}).model()) : this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)upNode).addNotIn(DsnStructure.NODE_TYPE, new String[]{NodeType.PRD.code(), NodeType.PRD_DETAIL.code(), NodeType.N_RISK.code()}).model())));
        if (nodeList.isEmpty()) {
            return;
        }
        for (DsnStructure node : nodeList) {
            String nodeNo = UUID.shortUUID();
            DsnStructure newNode = this.copyDsnStructure(node, nodeNo, riskName.get(node.getNodeNo()), targetUpNodeSeq + nodeNo + ".", targetUpNode);
            switch (NodeType.valueOf((String)newNode.getNodeType().toUpperCase())) {
                case PRD_DETAIL: {
                    this.dealPrdDetail(targetPrdName, node.getNodeNo(), newNode);
                    break;
                }
                case N_RISK: {
                    break;
                }
                case MAIN_RISKS: {
                    newNode.setRelateTab("sip_product_risks");
                    newNode.setRelateField("serno");
                    newNode.setRelateFk(newNode.getSerno());
                    break;
                }
                case ATTR: 
                case ATTR_DETAIL: 
                case ATTR4RATE: {
                    ProductCopyServiceImpl.dnsBizAttribute(node.getNodeNo(), null, newNode, this.dao);
                    break;
                }
                case N_RISK_DETAIL: {
                    this.sipRisks(newNode, addType, templateProductUuid);
                    break;
                }
                case ACCY_RISKS: 
                case SUB_RISKS: 
                case EXEMPT: {
                    this.sipRiskRelation(nodeNo, newNode);
                    break;
                }
                case RULE: {
                    newNode.setRelateTab("dsn_rules");
                    newNode.setRelateField("node_no");
                    newNode.setRelateFk(nodeNo);
                    break;
                }
                case N_RULE: {
                    break;
                }
                case N_RATE: {
                    break;
                }
                case N_BENEFIT: {
                    break;
                }
                case N_RISK_ATTR: {
                    break;
                }
                case N_ACCY_RISKS: {
                    break;
                }
                case N_EXEMPT: {
                    break;
                }
                case N_SUB_RISKS: {
                    break;
                }
                case N_TBR: {
                    break;
                }
                case N_BBR: {
                    break;
                }
                case N_SYR: {
                    break;
                }
            }
            this.dao.save((AbsModel)newNode);
            this.queryChildNodeAndCopy(addType, node.getNodeNo(), newNode.getNodeNo(), newNode.getNodeSeq(), riskName, "", templateProductUuid);
        }
    }

    private void dealPrdDetail(String targetPrdName, String nodeNo, DsnStructure newNode) {
        Integer displayOrder = (Integer)((DsnStructure)this.dao.findOne(((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.NODE_TYPE, (Object)"prd").model()).groupBy().max(DsnStructure.DISPLAY_ORDER))).getOtherProperty("max_display_order", Integer.class);
        if (StrUtils.isNull((Object)displayOrder)) {
            displayOrder = 1;
        }
        newNode.setRelateTab("sip_products");
        newNode.setRelateField("product_uuid");
        newNode.setRelateFk(newNode.getNodeNo());
        newNode.setDisplayOrder(displayOrder);
        SipProducts product = (SipProducts)this.dao.findOne(SipProducts.n().where().addEq(SipProducts.PRODUCT_UUID, (Object)nodeNo).model());
        product.setSerno(UUID.shortUUID());
        if (!StrUtils.isNull((Object)targetPrdName)) {
            product.setProductName(targetPrdName);
            product.setProductNameJianpin(PinYin4J.createFirstSpell(targetPrdName));
            product.setProductNamePinyin(PinYin4J.createSpell(targetPrdName));
        }
        product.setIsMaster("N");
        product.setProductUuid(newNode.getNodeNo());
        product.setProductNo(newNode.getNodeNo());
        product.setDisplayOrder(String.valueOf(displayOrder));
        this.dao.save((AbsModel)product);
    }

    private void sipRisks(DsnStructure newNode, String addType, String templateProductUuid) {
        newNode.setRelateTab("sip_risks");
        newNode.setRelateField("risk_uuid");
        newNode.setRelateFk(newNode.getNodeNo());
        SipRisks risk = new SipRisks();
        risk.setRiskUuid(newNode.getNodeNo());
        risk.setRiskName(newNode.getNodeName());
        risk.setIsMainRisk(addType);
        risk.setTemplateProductUuid(templateProductUuid);
        this.dao.save((AbsModel)risk);
        newNode.setNodeName("\u9669\u79cd\u4fe1\u606f");
        ProductCopyServiceImpl.saveRiskRelation(newNode, this.dao);
    }

    public static void saveRiskRelation(DsnStructure node, AbsModelRepository dao) {
        DsnStructure nameNode = (DsnStructure)dao.findOne((AbsModel)new DsnStructure(true).setNodeNo(node.getUpNode()));
        List relationList = dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)nameNode.getUpNode()).model());
        SipRiskRelation srr = SipRiskRelation.n();
        SipProductRisks spr = SipProductRisks.n();
        HashMap<String, DsnStructure> nodeSernoMap = new HashMap<String, DsnStructure>();
        for (DsnStructure ds : relationList) {
            nodeSernoMap.put(ds.getSerno(), ds);
            srr.where().addIn(SipRiskRelation.SERNO, new String[]{ds.getSerno()});
            spr.where().addIn(SipProductRisks.SERNO, new String[]{ds.getSerno()});
        }
        List srrList = dao.findAll((AbsModel)srr);
        List sprList = dao.findAll((AbsModel)spr);
        for (SipRiskRelation aSrr : srrList) {
            nodeSernoMap.remove(aSrr.getSerno());
        }
        for (SipProductRisks aSpr : sprList) {
            nodeSernoMap.remove(aSpr.getSerno());
        }
        Collection dsnList = nodeSernoMap.values();
        for (DsnStructure dsn : dsnList) {
            node.setNodeSeq(dsn.getNodeSeq() + node.getNodeNo() + ".");
            ProductCopyServiceImpl.saveRelation(dsn, node, dao);
        }
    }

    private static void saveRelation(DsnStructure nameNode, DsnStructure node, AbsModelRepository dao) {
        boolean isMainRiks;
        String[] nodeSeqArray = node.getNodeSeq().split("\\.");
        String[] nameNodeSeqArray = nameNode.getNodeSeq().split("\\.");
        String mainRiks = nameNodeSeqArray[nameNodeSeqArray.length - 3];
        mainRiks = ((DsnStructure)dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)mainRiks).addIn(DsnStructure.NODE_TYPE, new String[]{NodeType.PRD_DETAIL.code(), NodeType.N_RISK_DETAIL.code()}).model())).getNodeNo();
        boolean bl = isMainRiks = nodeSeqArray.length == 4;
        if (isMainRiks) {
            SipProductRisks spr = SipProductRisks.n();
            spr.setSerno(nameNode.getSerno());
            spr.setProductUuid(mainRiks);
            spr.setRiskUuid(node.getNodeNo());
            dao.save((AbsModel)spr);
            return;
        }
        SipRiskRelation srr = SipRiskRelation.n();
        srr.setSerno(nameNode.getSerno());
        srr.setRiskUuid(nodeSeqArray[nodeSeqArray.length - 1]);
        String relationType = NodeSeqUtils.getRelationType(node.getNodeSeq());
        srr.setMainRisk(mainRiks);
        srr.setRelationType(relationType);
        dao.save((AbsModel)srr);
    }

    public static void dnsBizAttribute(String bizUuid, String attrUuid, DsnStructure newNode, AbsModelRepository dao) {
        newNode.setRelateTab("dsn_biz_attribute");
        newNode.setRelateField("biz_uuid");
        newNode.setRelateFk(newNode.getNodeNo());
        DsnBizAttribute attrWhere = DsnBizAttribute.n();
        if (!StrUtils.isNull((Object)bizUuid)) {
            attrWhere.where().addEq(DsnBizAttribute.BIZ_UUID, (Object)bizUuid);
        }
        if (!StrUtils.isNull((Object)attrUuid)) {
            attrWhere.where().addEq(DsnBizAttribute.ATTR_UUID, (Object)attrUuid);
        }
        DsnBizAttribute attr = (DsnBizAttribute)dao.findOne((AbsModel)attrWhere);
        attr.setSerno(null);
        attr.setBizUuid(newNode.getNodeNo());
        dao.save((AbsModel)attr);
        List optionList = dao.findAll(DsnAttributeOption.n().where().addEq(DsnAttributeOption.ATTR_UUID, (Object)attr.getAttrUuid()).model());
        List bizOptionList = optionList.stream().map(opt -> {
            opt.setSerno(null);
            DsnBizAttributeOption bizOpt = new DsnBizAttributeOption();
            BeanUtils.copyProperties((Object)opt, (Object)bizOpt);
            bizOpt.setBizUuid(attr.getBizUuid());
            return bizOpt;
        }).collect(Collectors.toList());
        dao.save(bizOptionList);
    }

    private void sipRiskRelation(String nodeNo, DsnStructure newNode) {
        newNode.setRelateTab("sip_risk_relation");
        newNode.setRelateField("serno");
        newNode.setRelateFk(newNode.getSerno());
    }

    private DsnStructure copyDsnStructure(DsnStructure source, String nodeNo, String nodeName, String nodeSeq, String targetUpNode) {
        DsnStructure target = DsnStructure.n();
        BeanUtils.copyProperties((Object)source, (Object)target);
        target.setSerno(UUID.shortUUID());
        target.setNodeNo(UUID.shortUUID());
        if (!StrUtils.isNull((Object)nodeNo)) {
            target.setNodeNo(nodeNo);
        }
        if (!StrUtils.isNull((Object)nodeName)) {
            target.setNodeName(nodeName);
        }
        if (!StrUtils.isNull((Object)nodeSeq)) {
            target.setNodeSeq(nodeSeq);
        }
        if (!StrUtils.isNull((Object)targetUpNode)) {
            target.setUpNode(targetUpNode);
        }
        return target;
    }
}

