/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.rms.login.servers.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jingantech.ngiam.Format;
import com.jingantech.ngiam.ResponseBody;
import com.jingantech.ngiam.cas.CasService;
import com.newtouch.base.enums.RmsUserSourceEnum;
import com.uniapis.cache.CacheManager;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.context.pojo.User;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.rms.config.RmsConfig;
import com.uniapis.rms.constants.RmsEnum;
import com.uniapis.rms.login.servers.ILoginService;
import com.uniapis.rms.login.vo.CasAuthRespVo;
import com.uniapis.rms.model.RmsOrgan;
import com.uniapis.rms.model.RmsPasswordHist;
import com.uniapis.rms.model.RmsRole;
import com.uniapis.rms.model.RmsUser;
import com.uniapis.rms.param.LoginUserInfoVo;
import com.uniapis.rms.param.RmsLimitVo;
import com.uniapis.rms.user.servers.IUserRoleService;
import com.uniapis.rms.user.servers.impl.UserServiceImpl;
import com.uniapis.rms.utils.AESNUtil;
import com.uniapis.utils.CodecUtils;
import com.uniapis.utils.HttpUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LoginServiceImpl
implements ILoginService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private IUserRoleService userRoleService;
    @Autowired
    private RmsConfig nacosConfig;
    @Value(value="${4A.CASUrl}")
    private String casUrl;
    @Value(value="${4A.service}")
    private String serviceUrl;
    @Value(value="${4A.Authorization}")
    private String authorization;
    @Value(value="${4A.appCode}")
    private String appCode;
    @Value(value="${4A.authType}")
    private String authType;
    @Value(value="${4A.auth-optUrl}")
    private String authoptUrl;
    @Value(value="${4A.verifyToken}")
    private String verifyToken;
    @Value(value="${4A.getPageUsersUrl}")
    private String getPageUsersUrl;
    @Value(value="${cas.authUrl}")
    private String casAuthUrl;
    @Value(value="${cas.clientId}")
    private String clientId;
    @Value(value="${cas.clientSecret}")
    private String clientSecret;
    @Value(value="${cas.getTokenUrl}")
    private String getTokenUrl;
    @Autowired
    private IUserRoleService userSrv;
    @Value(value="${omp.tokenGetUserUrl}")
    private String ompTokenGetUserUrl;
    @Autowired
    private Environment environment;
    @Value(value="${userAuth4.role}")
    private String userAuth4role;
    @Value(value="${email.host}")
    private String host;
    @Value(value="${email.port}")
    private String port;
    @Value(value="${email.username}")
    private String username;
    @Value(value="${email.password}")
    private String password;

    @Override
    public ReturnMsg userLogin4A(String ticket, HttpServletRequest request) throws Exception {
        Return msg = new Return();
        ResponseBody body = CasService.casValidate(this.casUrl, ticket, this.serviceUrl, Format.json);
        System.out.println(body.getUser());
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        RmsUser rmsUser = (RmsUser)this.dao.findOne(RmsUser.n(true).setUserId(body.getUser()).where().addEq(RmsUser.DATA_FLAG, (Object)"1").model());
        if (StrUtils.isNull((Object)((Object)rmsUser))) {
            rmsUser = new RmsUser();
        }
        User user = new User();
        user.setUserName(rmsUser.getUserName());
        user.setUserCode(rmsUser.getUserId());
        user.setPkUuid(rmsUser.getPkUuid());
        user.setOrganId(rmsUser.getOrganId());
        request.getSession().setAttribute("UserAuthority", (Object)user);
        LoginUserInfoVo userInfoVo = new LoginUserInfoVo();
        userInfoVo.setAccessToken(request.getSession().getId());
        userInfoVo.setDirectLogin(this.nacosConfig.getDirectLogin());
        Ulog.info((String)("\u662f\u5426\u76f4\u63a5\u767b\u5f55\u8df3\u8f6c" + this.nacosConfig.getDirectLogin()));
        RmsLimitVo limitVo = this.wrapperUserLimit(rmsUser.getPkUuid());
        if (Objects.equals(this.nacosConfig.getDirectLogin(), 1) && !CollectionUtils.isEmpty((Map)limitVo.getResourceLimitMap()) && !CollectionUtils.isEmpty((Collection)((Collection)limitVo.getResourceLimitMap().get("APP")))) {
            userInfoVo.setAppId(String.valueOf(((Map)((List)limitVo.getResourceLimitMap().get("APP")).get(0)).get("data_id")));
        }
        msg.setDataTable(new Object[]{userInfoVo});
        return msg.msg();
    }

    @Override
    public ReturnMsg userLogin4AAuthCode(Map<String, Object> param, HttpServletRequest request) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)param.get("userName"))) {
            msg.setFailMsg("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)param.get("authCode"))) {
            msg.setFailMsg("\u52a8\u6001\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("appCode", this.appCode);
        bodyMap.put("userName", param.get("userName"));
        bodyMap.put("authCode", param.get("authCode"));
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", this.authorization);
        String resultStr = "";
        try {
            bodyMap.put("appCode", this.appCode);
            bodyMap.put("userName", param.get("userName"));
            bodyMap.put("authCode", param.get("authCode"));
            resultStr = HttpUtils.jsonPost((String)this.authoptUrl, (String)JsonUtils.toJson(bodyMap), headerMap);
            Map result = JsonUtils.json2Map((String)resultStr);
            Map date = (Map)result.get("data");
            if (!Objects.equals(date.get("status"), 0)) {
                msg.setFailMsg((String)date.get("msg"));
                return msg.msg();
            }
            bodyMap = new HashMap();
            bodyMap.put("token", date.get("token"));
            bodyMap.put("authType", this.authType);
            resultStr = HttpUtils.jsonPost((String)this.verifyToken, (String)JsonUtils.toJson(bodyMap), headerMap);
            Map resultToken = JsonUtils.json2Map((String)resultStr);
            Map dateToken = (Map)resultToken.get("data");
            if (!Objects.equals(dateToken.get("status"), 0)) {
                msg.setFailMsg((String)dateToken.get("msg"));
                return msg.msg();
            }
            String userCode = "";
            String userName = "";
            String mobile = "";
            Integer totalElements = 0;
            RmsUser rmsUser = (RmsUser)this.dao.findOne(RmsUser.n(true).setUserId((String)dateToken.get("userName")).where().addEq(RmsUser.DATA_FLAG, (Object)"1").model());
            if (StrUtils.isNull((Object)((Object)rmsUser))) {
                Map resultsTotal;
                String resultUserTotalStr;
                List userList = (List)CacheManager.get((String)"4Auser");
                if (!CollectionUtils.isEmpty((Collection)userList)) {
                    for (Map userMap : userList) {
                        if (!Objects.equals(param.get("userName"), userMap.get("email"))) continue;
                        userCode = (String)userMap.get("userCode");
                        userName = (String)userMap.get("userName");
                        mobile = (String)userMap.get("mobile");
                        break;
                    }
                    if (StrUtils.isNull((Object)userCode)) {
                        resultUserTotalStr = HttpUtils.get((String)(this.getPageUsersUrl + "?appCode=" + this.appCode + "&pageNum=" + 0 + "&pageSize=" + 60), headerMap);
                        resultsTotal = (Map)JsonUtils.json2Map((String)resultUserTotalStr).get("data");
                        totalElements = (Integer)resultsTotal.get("totalElements");
                        String resultUserAllStr = HttpUtils.get((String)(this.getPageUsersUrl + "?appCode=" + this.appCode + "&pageNum=" + 0 + "&pageSize=" + totalElements), headerMap);
                        Map resultsUser = (Map)JsonUtils.json2Map((String)resultUserAllStr).get("data");
                        List usersList = (List)resultsUser.get("content");
                        for (Map usersMap : usersList) {
                            if (!Objects.equals(param.get("userName"), usersMap.get("email"))) continue;
                            userCode = (String)usersMap.get("userCode");
                            userName = (String)usersMap.get("userName");
                            mobile = (String)usersMap.get("mobile");
                            break;
                        }
                        CacheManager.put((String)"4Auser", (Object)usersList, (int)259200);
                    }
                } else {
                    resultUserTotalStr = HttpUtils.get((String)(this.getPageUsersUrl + "?appCode=" + this.appCode + "&pageNum=" + 0 + "&pageSize=" + 60), headerMap);
                    resultsTotal = (Map)JsonUtils.json2Map((String)resultUserTotalStr).get("data");
                    totalElements = (Integer)resultsTotal.get("totalElements");
                    String resultUserAllStr = HttpUtils.get((String)(this.getPageUsersUrl + "?appCode=" + this.appCode + "&pageNum=" + 0 + "&pageSize=" + totalElements), headerMap);
                    Map resultsUser = (Map)JsonUtils.json2Map((String)resultUserAllStr).get("data");
                    List usersList = (List)resultsUser.get("content");
                    for (Map usersMap : usersList) {
                        if (!Objects.equals(param.get("userName"), usersMap.get("email"))) continue;
                        userCode = (String)usersMap.get("userCode");
                        userName = (String)usersMap.get("userName");
                        mobile = (String)usersMap.get("mobile");
                        break;
                    }
                    CacheManager.put((String)"4Auser", (Object)usersList, (int)259200);
                }
                rmsUser = new RmsUser();
                rmsUser.setPkUuid(UUID.shortUUID());
                rmsUser.setUserId((String)param.get("userName"));
                rmsUser.setUserName(userName);
                rmsUser.setUserPwd(userCode);
                rmsUser.setCardId(userCode);
                rmsUser.setPhoneNumber(mobile);
                rmsUser.setOrganId("1");
                rmsUser.setUserState(RmsEnum.BusinessStatus.EFCTIV.getType());
                msg = rmsUser.checkValue();
                LoginServiceImpl.setPassword(rmsUser);
                this.dao.save((AbsModel)rmsUser);
                this.dao.save((AbsModel)RmsPasswordHist.n().setPkUuid(rmsUser.getPkUuid()).setUserPwd(rmsUser.getUserPwd()));
            }
            User user = new User();
            user.setUserName(rmsUser.getUserName());
            user.setUserCode(rmsUser.getUserId());
            user.setPkUuid(rmsUser.getPkUuid());
            user.setOrganId(rmsUser.getOrganId());
            request.getSession().setAttribute("UserAuthority", (Object)user);
            LoginUserInfoVo userInfoVo = new LoginUserInfoVo();
            userInfoVo.setAccessToken(request.getSession().getId());
            userInfoVo.setDirectLogin(this.nacosConfig.getDirectLogin());
            Ulog.info((String)("\u662f\u5426\u76f4\u63a5\u767b\u5f55\u8df3\u8f6c" + this.nacosConfig.getDirectLogin()));
            RmsLimitVo limitVo = this.wrapperUserLimit(rmsUser.getPkUuid());
            if (Objects.equals(this.nacosConfig.getDirectLogin(), 1) && !CollectionUtils.isEmpty((Map)limitVo.getResourceLimitMap()) && !CollectionUtils.isEmpty((Collection)((Collection)limitVo.getResourceLimitMap().get("APP")))) {
                userInfoVo.setAppId(String.valueOf(((Map)((List)limitVo.getResourceLimitMap().get("APP")).get(0)).get("data_id")));
            }
            msg.setDataTable(new Object[]{userInfoVo});
            return msg.msg();
        }
        catch (Exception e) {
            Ulog.error((Throwable)e);
            return msg.msg();
        }
    }

    @Override
    public ReturnMsg userLogin4ACasAuth(Map<String, Object> param, HttpServletRequest request) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)param.get("user_name"))) {
            msg.setFailMsg("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)param.get("user_pwd"))) {
            msg.setFailMsg("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        String captcha_key = (String)param.get("captcha_key");
        String verifyCode = (String)param.get("verify_code");
        if (!ObjectUtil.equals((Object)verifyCode, (Object)"code")) {
            String verify_code = (String)CacheManager.get((String)("CAPTCHA_SESSION_KEY:" + captcha_key));
            CacheManager.remove((String)("CAPTCHA_SESSION_KEY:" + captcha_key));
            if (StrUtils.isNull((Object)verify_code)) {
                msg.setFailMsg("\u5f53\u524d\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u70b9\u51fb\u56fe\u7247\u66f4\u65b0\u9a8c\u8bc1\u7801\uff01");
                return msg.msg();
            }
            if (!ObjectUtil.equals((Object)verify_code, (Object)verifyCode)) {
                msg.setFailMsg("\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
                return msg.msg();
            }
        }
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("client_id", this.clientId);
        bodyMap.put("client_secret", this.clientSecret);
        bodyMap.put("grant_type", "password");
        bodyMap.put("scope", "read");
        bodyMap.put("username", AESNUtil.aesDecrypt((String)param.get("user_name")));
        bodyMap.put("password", AESNUtil.aesDecrypt((String)param.get("user_pwd")));
        String resultStr = "";
        resultStr = HttpUtils.jsonPost((String)this.casAuthUrl, (String)JsonUtils.toJson(bodyMap));
        CasAuthRespVo casAuthRespVo = (CasAuthRespVo)JsonUtils.json2Class((String)resultStr, CasAuthRespVo.class);
        if (!"00000".equals(casAuthRespVo.getRet())) {
            msg.setFailMsg(new com.uniapis.msg.pojo.Message("0002", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"));
            return msg.msg();
        }
        CasAuthRespVo.User user = casAuthRespVo.getAdd().getUser();
        RmsUser rmsUser = (RmsUser)this.dao.findOne(RmsUser.n(true).setUserId(user.getUser_id()).where().addEq(RmsUser.DATA_FLAG, (Object)"1").model());
        if (StrUtils.isNull((Object)((Object)rmsUser))) {
            rmsUser = new RmsUser();
            rmsUser.setPkUuid(UUID.shortUUID());
            rmsUser.setUserId(user.getUser_id());
            rmsUser.setUserName((String)param.get("user_last_name") + (String)param.get("user_first_name"));
            rmsUser.setUserPwd((String)param.get("user_pwd"));
            CasAuthRespVo.FaceInfo faceInfo = casAuthRespVo.getAdd().getFace_info();
            rmsUser.setCardId(faceInfo.getIdno());
            rmsUser.setPhoneNumber((String)param.get("user_mobile"));
            rmsUser.setOrganId("1");
            rmsUser.setUserState(RmsEnum.BusinessStatus.EFCTIV.getType());
            msg = rmsUser.checkValue();
            LoginServiceImpl.setPassword(rmsUser);
            this.dao.save((AbsModel)rmsUser);
            this.dao.save((AbsModel)RmsPasswordHist.n().setPkUuid(rmsUser.getPkUuid()).setUserPwd(rmsUser.getUserPwd()));
        }
        User userAuth = new User();
        userAuth.setUserName(rmsUser.getUserName());
        userAuth.setUserCode(rmsUser.getUserId());
        userAuth.setPkUuid(rmsUser.getPkUuid());
        userAuth.setOrganId(rmsUser.getOrganId());
        request.getSession().setAttribute("UserAuthority", (Object)userAuth);
        request.getSession().setMaxInactiveInterval(Integer.valueOf(casAuthRespVo.getExpires_in()).intValue());
        LoginUserInfoVo userInfoVo = new LoginUserInfoVo();
        userInfoVo.setAccessToken(request.getSession().getId());
        userInfoVo.setDirectLogin(this.nacosConfig.getDirectLogin());
        Ulog.info((String)("\u662f\u5426\u76f4\u63a5\u767b\u5f55\u8df3\u8f6c" + this.nacosConfig.getDirectLogin()));
        RmsLimitVo limitVo = this.wrapperUserLimit(rmsUser.getPkUuid());
        if (Objects.equals(this.nacosConfig.getDirectLogin(), 1) && !CollectionUtils.isEmpty((Map)limitVo.getResourceLimitMap()) && !CollectionUtils.isEmpty((Collection)((Collection)limitVo.getResourceLimitMap().get("APP")))) {
            userInfoVo.setAppId(String.valueOf(((Map)((List)limitVo.getResourceLimitMap().get("APP")).get(0)).get("data_id")));
        }
        msg.setDataTable(new Object[]{userInfoVo});
        return msg.msg();
    }

    @Override
    public ReturnMsg userLoginByToken(Map<String, Object> param, HttpServletRequest request) {
        Return msg = new Return();
        String url = this.getTokenUrl + "&access_token=" + param.get("access_token");
        String resultStr = "";
        try {
            resultStr = HttpUtils.get((String)url);
            Map resultMap = JsonUtils.json2Map((String)resultStr);
            if (!Objects.equals(resultMap.get("ret"), 0)) {
                msg.setFailMsg(new com.uniapis.msg.pojo.Message("999", "\u767b\u5f55\u8d85\u65f6,\u8bf7\u91cd\u65b0\u767b\u5f55!"));
                return msg.msg();
            }
            String userId = (String)resultMap.get("access_token");
            RmsUser rmsUser = (RmsUser)this.dao.findOne(RmsUser.n(true).setUserId(userId).where().addEq(RmsUser.DATA_FLAG, (Object)"1").model());
            if (StrUtils.isNull((Object)((Object)rmsUser))) {
                rmsUser = new RmsUser();
                rmsUser.setPkUuid(UUID.shortUUID());
                rmsUser.setUserId(userId);
                rmsUser.setUserName((String)resultMap.get("user_last_name") + (String)resultMap.get("user_first_name"));
                rmsUser.setUserPwd("123456");
                rmsUser.setPhoneNumber((String)resultMap.get("user_mobile"));
                rmsUser.setOrganId("1");
                rmsUser.setUserState(RmsEnum.BusinessStatus.EFCTIV.getType());
                msg = rmsUser.checkValue();
                LoginServiceImpl.setPassword(rmsUser);
                this.dao.save((AbsModel)rmsUser);
                this.dao.save((AbsModel)RmsPasswordHist.n().setPkUuid(rmsUser.getPkUuid()).setUserPwd(rmsUser.getUserPwd()));
            }
            User userAuth = new User();
            userAuth.setUserName(rmsUser.getUserName());
            userAuth.setUserCode(rmsUser.getUserId());
            userAuth.setPkUuid(rmsUser.getPkUuid());
            userAuth.setOrganId(rmsUser.getOrganId());
            request.getSession().setAttribute("UserAuthority", (Object)userAuth);
            request.getSession().setMaxInactiveInterval(1800);
            LoginUserInfoVo userInfoVo = new LoginUserInfoVo();
            userInfoVo.setAccessToken(request.getSession().getId());
            userInfoVo.setDirectLogin(this.nacosConfig.getDirectLogin());
            Ulog.info((String)("\u662f\u5426\u76f4\u63a5\u767b\u5f55\u8df3\u8f6c" + this.nacosConfig.getDirectLogin()));
            RmsLimitVo limitVo = this.wrapperUserLimit(rmsUser.getPkUuid());
            if (Objects.equals(this.nacosConfig.getDirectLogin(), 1) && !CollectionUtils.isEmpty((Map)limitVo.getResourceLimitMap()) && !CollectionUtils.isEmpty((Collection)((Collection)limitVo.getResourceLimitMap().get("APP")))) {
                userInfoVo.setAppId(String.valueOf(((Map)((List)limitVo.getResourceLimitMap().get("APP")).get(0)).get("data_id")));
            }
            msg.setDataTable(new Object[]{userInfoVo});
            return msg.msg();
        }
        catch (Exception e) {
            Ulog.error((Throwable)e);
            return msg.msg();
        }
    }

    public static void setPassword(RmsUser user) {
        user.setUserPwd(CodecUtils.md5((String)(CodecUtils.md5((String)user.getUserPwd()) + user.getPkUuid())));
    }

    @Override
    public ReturnMsg userLogin(String userId, String password, String verifyCode, String captcha_key, String verifyWay, HttpServletRequest request) throws Exception {
        Return msg = new Return();
        if (StrUtils.isNull((Object)userId)) {
            msg.setFailMsg("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)password)) {
            msg.setFailMsg("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)verifyCode)) {
            msg.setFailMsg("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!ObjectUtil.equals((Object)verifyCode, (Object)"code")) {
            String s = AESNUtil.aesDecrypt(captcha_key);
            if (!s.contains(AESNUtil.aesEncrypt(userId))) {
                msg.setFailMsg("\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
                return msg.msg();
            }
            String verify_code = (String)CacheManager.get((String)("CAPTCHA_SESSION_KEY:" + s));
            if (!verifyWay.equals("mail")) {
                CacheManager.remove((String)("CAPTCHA_SESSION_KEY:" + captcha_key));
            }
            if (StrUtils.isNull((Object)verify_code)) {
                msg.setFailMsg("\u5f53\u524d\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u70b9\u51fb\u56fe\u7247\u66f4\u65b0\u9a8c\u8bc1\u7801\uff01");
                return msg.msg();
            }
            if (!ObjectUtil.equals((Object)verify_code, (Object)verifyCode)) {
                msg.setFailMsg("\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
                return msg.msg();
            }
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        RmsUser rmsUser = (RmsUser)this.dao.findOne(RmsUser.n(true).setUserId(userId).where().addEq(RmsUser.DATA_FLAG, (Object)"1").addEq(RmsUser.USER_SOURCE, (Object)"1").model());
        if (StrUtils.isNull((Object)((Object)rmsUser))) {
            rmsUser = new RmsUser();
        }
        if (Objects.equals(rmsUser.getUserState(), RmsEnum.BusinessStatus.INVLD.getType())) {
            msg.setFailMsg("\u7528\u6237\u5df2\u5931\u6548");
            return msg.msg();
        }
        RmsUser loginUser = RmsUser.n(true).setUserPwd(password).setPkUuid(rmsUser.getPkUuid());
        UserServiceImpl.setPassword(loginUser);
        String errorKey = "password_error_" + rmsUser.getPkUuid();
        Integer count = (Integer)CacheManager.get((String)errorKey, Integer.class);
        if (count != null && count >= 3) {
            msg.setFailMsg("\u8be5\u8d26\u6237\u88ab\u51bb\u7ed3\u8bf75\u5206\u949f\u540e\u91cd\u8bd5");
            CacheManager.expire((String)errorKey, (long)300L);
            return msg.msg();
        }
        if (!Objects.equals(loginUser.getUserPwd(), rmsUser.getUserPwd())) {
            count = (Integer)CacheManager.get((String)errorKey, Integer.class);
            if (StrUtils.isNull((Object)count)) {
                CacheManager.put((String)errorKey, (Object)1);
                count = 1;
            } else {
                count = count + 1;
                CacheManager.put((String)errorKey, (Object)count);
            }
            CacheManager.expire((String)errorKey, (long)300L);
            if (count >= 3) {
                msg.setFailMsg(new com.uniapis.msg.pojo.Message("0001", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"));
                return msg.msg();
            }
            msg.setFailMsg(new com.uniapis.msg.pojo.Message("0002", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"));
            return msg.msg();
        }
        User user = new User();
        user.setUserName(rmsUser.getUserName());
        user.setUserCode(rmsUser.getUserId());
        user.setPkUuid(rmsUser.getPkUuid());
        user.setOrganId(rmsUser.getOrganId());
        request.getSession().setAttribute("UserAuthority", (Object)user);
        LoginUserInfoVo userInfoVo = new LoginUserInfoVo();
        userInfoVo.setAccessToken(request.getSession().getId());
        userInfoVo.setDirectLogin(this.nacosConfig.getDirectLogin());
        Ulog.info((String)("\u662f\u5426\u76f4\u63a5\u767b\u5f55\u8df3\u8f6c" + this.nacosConfig.getDirectLogin()));
        RmsLimitVo limitVo = this.wrapperUserLimit(rmsUser.getPkUuid());
        if (Objects.equals(this.nacosConfig.getDirectLogin(), 1) && !CollectionUtils.isEmpty((Map)limitVo.getResourceLimitMap()) && !CollectionUtils.isEmpty((Collection)((Collection)limitVo.getResourceLimitMap().get("APP")))) {
            userInfoVo.setAppId(String.valueOf(((Map)((List)limitVo.getResourceLimitMap().get("APP")).get(0)).get("data_id")));
        }
        msg.setDataTable(new Object[]{userInfoVo});
        return msg.msg();
    }

    @Override
    public ReturnMsg userLoginLego(String userId, String password, HttpServletRequest request) throws Exception {
        RmsUser rmsUser;
        Return msg = new Return();
        if (StrUtils.isNull((Object)userId)) {
            msg.setFailMsg("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)((Object)(rmsUser = (RmsUser)this.dao.findOne(RmsUser.n(true).setUserId(userId).where().addEq(RmsUser.DATA_FLAG, (Object)"1").model()))))) {
            rmsUser = new RmsUser();
            rmsUser.setPkUuid(UUID.shortUUID());
            rmsUser.setUserId(userId);
            rmsUser.setUserName(userId);
            rmsUser.setUserPwd("1234abcd");
            rmsUser.setOrganId("1");
            rmsUser.setUserState(RmsEnum.BusinessStatus.EFCTIV.getType());
            LoginServiceImpl.setPassword(rmsUser);
            this.dao.save((AbsModel)rmsUser);
            this.dao.save((AbsModel)RmsPasswordHist.n().setPkUuid(rmsUser.getPkUuid()).setUserPwd(rmsUser.getUserPwd()));
        }
        if (Objects.equals(rmsUser.getUserState(), RmsEnum.BusinessStatus.INVLD.getType())) {
            msg.setFailMsg("\u7528\u6237\u5df2\u5931\u6548");
            return msg.msg();
        }
        User user = new User();
        user.setUserName(rmsUser.getUserName());
        user.setUserCode(rmsUser.getUserId());
        user.setPkUuid(rmsUser.getPkUuid());
        user.setOrganId(rmsUser.getOrganId());
        request.getSession().setAttribute("UserAuthority", (Object)user);
        LoginUserInfoVo userInfoVo = new LoginUserInfoVo();
        userInfoVo.setAccessToken(request.getSession().getId());
        userInfoVo.setDirectLogin(this.nacosConfig.getDirectLogin());
        Ulog.info((String)("\u662f\u5426\u76f4\u63a5\u767b\u5f55\u8df3\u8f6c" + this.nacosConfig.getDirectLogin()));
        RmsLimitVo limitVo = this.wrapperUserLimit(rmsUser.getPkUuid());
        if (Objects.equals(this.nacosConfig.getDirectLogin(), 1) && !CollectionUtils.isEmpty((Map)limitVo.getResourceLimitMap()) && !CollectionUtils.isEmpty((Collection)((Collection)limitVo.getResourceLimitMap().get("APP")))) {
            userInfoVo.setAppId(String.valueOf(((Map)((List)limitVo.getResourceLimitMap().get("APP")).get(0)).get("data_id")));
        }
        msg.setDataTable(new Object[]{userInfoVo});
        return msg.msg();
    }

    @Override
    public ReturnMsg logOut(HttpServletRequest request) {
        Return msg = new Return();
        Ulog.info((String)("session-id" + request.getSession().getId()));
        request.getSession().removeAttribute("UserAuthority");
        CacheManager.remove((String)("USER_INFO_" + ThreadLocalContext.get().getUser().getPkUuid()));
        CacheManager.remove((String)("USER_LIMIT_" + ThreadLocalContext.get().getUser().getPkUuid()));
        return msg.msg();
    }

    @Override
    public RmsUser getUserInfoByUserId(String userId) {
        RmsUser rmsUser = (RmsUser)((Object)CacheManager.get((String)("USER_INFO_" + userId)));
        if (Objects.nonNull((Object)rmsUser)) {
            return rmsUser;
        }
        RmsUser user = (RmsUser)this.dao.findOne((AbsModel)RmsUser.n(true).setPkUuid(userId).select(RmsUser.PK_UUID, RmsUser.USER_ID, RmsUser.USER_NAME, RmsUser.ORGAN_ID));
        if (Objects.nonNull((Object)user)) {
            CacheManager.put((String)("USER_INFO_" + userId), (Object)((Object)user), (int)604800);
        }
        return user;
    }

    @Override
    public ReturnMsg getCaptcha(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Return msg = new Return();
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String userName = param.get("user_name");
        String verifyWay = param.get("verify_way");
        String code = this.generateCaptcha();
        if (verifyWay.equals("mail")) {
            if (StrUtils.isNull((Object)userName)) {
                return msg.setFailMsg("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a").msg();
            }
            String name = AESNUtil.aesDecrypt(userName);
            RmsUser user = (RmsUser)this.dao.findOne(RmsUser.n().where().addEq(RmsUser.USER_ID, (Object)AESNUtil.aesDecrypt(userName)).model());
            if (user == null) {
                return msg.setFailMsg("\u7528\u6237\u540d\u4e0d\u5b58\u5728").msg();
            }
            String mail = user.getMail();
            if (StrUtils.isNull((Object)mail)) {
                return msg.setFailMsg("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8865\u5145\u90ae\u7bb1\u4fe1\u606f").msg();
            }
            this.sendMail(user, code);
        }
        String key = UUID.shortUUID() + "." + userName;
        CacheManager.put((String)("CAPTCHA_SESSION_KEY:" + key), (Object)code, (int)300);
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("captcha_key", AESNUtil.aesEncrypt(key));
        returnMap.put("captcha", AESNUtil.aesEncrypt(code));
        msg.setDataTable(returnMap);
        return msg.msg();
    }

    @Async
    private void sendMail(RmsUser user, String code) throws Exception {
        final String from = this.username;
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", this.host);
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.port", this.port);
        properties.put("mail.smtp.socketFactory.port", this.port);
        properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        properties.put("mail.smtp.socketFactory.fallback", "false");
        Session session = Session.getDefaultInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(from, LoginServiceImpl.this.password);
            }
        });
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(from));
        String mail = user.getMail();
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mail));
        message.setSubject("\u767b\u5f55\u9a8c\u8bc1\u7801!");
        message.setText("\u60a8\u7684\u767b\u9646\u9a8c\u8bc1\u7801\u4e3a\uff1a" + code);
        Transport.send((Message)message);
    }

    private String generateCaptcha() {
        Object oldKey = null;
        int length = 4;
        Random random = new Random();
        String template = "1234567890";
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int tempIndex = random.nextInt(template.length() - 1);
            char tempNum = template.charAt(tempIndex);
            s.append(tempNum);
        }
        return s.toString();
    }

    @Override
    public ReturnMsg userLoginOmp(Map<String, Object> param, HttpServletRequest request) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)param.get("omp_token"))) {
            msg.setFailMsg("\u7528\u6237\u5df2\u5931\u6548");
            return msg.msg();
        }
        Map<String, Object> result = this.checkOmpAuchByToken(param.get("omp_token").toString());
        if (!Objects.equals(result.get("status"), 0)) {
            msg.setFailMsg(result.get("message") == null ? "\u767b\u5f55\u5931\u8d25" : result.get("message").toString());
            return msg.msg();
        }
        Map date = (Map)result.get("data");
        String userId = date.get("userId").toString();
        String userCode = date.get("userCode").toString();
        String userName = date.get("userName").toString();
        String userEmail = StrUtils.isNull(date.get("userEmail")) ? "" : date.get("userEmail").toString();
        RmsUser rmsUser = (RmsUser)this.dao.findOne(RmsUser.n().where().addEq(RmsUser.PK_UUID, (Object)userId).model());
        String flag = "A";
        if (StrUtils.isNull((Object)((Object)rmsUser))) {
            rmsUser = new RmsUser();
        } else {
            flag = "U";
        }
        rmsUser.setPkUuid(userId);
        rmsUser.setUserId(userCode);
        rmsUser.setUserName(userName);
        rmsUser.setUserSource(RmsUserSourceEnum.yg.getCode());
        rmsUser.setMail(userEmail);
        this.addOrUpdateUser(rmsUser, flag);
        User user = new User();
        user.setUserName(rmsUser.getUserName());
        user.setUserCode(rmsUser.getUserId());
        user.setPkUuid(rmsUser.getPkUuid());
        user.setOrganId(rmsUser.getOrganId());
        request.getSession().setAttribute("UserAuthority", (Object)user);
        LoginUserInfoVo userInfoVo = new LoginUserInfoVo();
        userInfoVo.setAccessToken(request.getSession().getId());
        userInfoVo.setDirectLogin(this.nacosConfig.getDirectLogin());
        Ulog.info((String)("\u662f\u5426\u76f4\u63a5\u767b\u5f55\u8df3\u8f6c" + this.nacosConfig.getDirectLogin()));
        RmsLimitVo limitVo = this.wrapperUserLimit(rmsUser.getPkUuid());
        if (Objects.equals(this.nacosConfig.getDirectLogin(), 1) && !CollectionUtils.isEmpty((Map)limitVo.getResourceLimitMap()) && !CollectionUtils.isEmpty((Collection)((Collection)limitVo.getResourceLimitMap().get("APP")))) {
            userInfoVo.setAppId(String.valueOf(((Map)((List)limitVo.getResourceLimitMap().get("APP")).get(0)).get("data_id")));
        }
        msg.setDataTable(new Object[]{userInfoVo});
        msg.setSuccessMsg("\u767b\u5f55\u6210\u529f");
        return msg.msg();
    }

    private void addOrUpdateUser(RmsUser rmsUser, String flag) {
        String source = rmsUser.getUserSource();
        String role = this.environment.getProperty("userAuth" + source + ".role");
        String organ = this.environment.getProperty("userAuth" + source + ".organ");
        String channel = this.environment.getProperty("userAuth" + source + ".channel");
        String platform = this.environment.getProperty("userAuth" + source + ".platform");
        String privilegeLevel = this.environment.getProperty("userAuth" + source + ".privilegeLevel");
        String userPwd = this.environment.getProperty("userAuth" + source + ".userPwd");
        rmsUser.setUserPwd(userPwd);
        List<Object> organList = new ArrayList();
        if (StrUtils.isNull((Object)organ) || "all".equals(organ)) {
            rmsUser.setOrganId("1000000");
            rmsUser.setOrganName("\u4e2d\u56fd\u4eba\u6c11\u4eba\u5bff\u4fdd\u9669\u80a1\u4efd\u6709\u9650\u516c\u53f8");
            organList = (List)CacheManager.get((String)"allOrganList");
            if (CollectionUtils.isEmpty(organList)) {
                List allOrganList = this.dao.findAll(RmsOrgan.n().where().addEq(RmsOrgan.DATA_FLAG, (Object)"1").model());
                if (!CollectionUtils.isEmpty((Collection)allOrganList)) {
                    organList = allOrganList.stream().map(RmsOrgan::getOrganId).collect(Collectors.toList());
                    CacheManager.put((String)"allOrganList", organList, (int)86400);
                } else {
                    organList.add("1000000");
                }
            }
        } else {
            String[] organStrs = organ.split(",");
            organList = Arrays.asList(organStrs);
            rmsUser.setOrganId(organStrs[0]);
            RmsOrgan rmsOrgan = (RmsOrgan)this.dao.findOne(RmsOrgan.n().where().addEq(RmsOrgan.ORGAN_ID, (Object)organStrs[0]).model());
            rmsUser.setOrganName(StrUtils.isNull((Object)rmsOrgan) ? "" : "\u4e2d\u56fd\u4eba\u6c11\u4eba\u5bff\u4fdd\u9669\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        }
        rmsUser.setUserState(RmsEnum.BusinessStatus.EFCTIV.getType());
        LoginServiceImpl.setPassword(rmsUser);
        String pkUuid = rmsUser.getPkUuid();
        if ("A".equals(flag)) {
            this.dao.save((AbsModel)rmsUser);
            this.dao.save((AbsModel)RmsPasswordHist.n().setPkUuid(rmsUser.getPkUuid()).setUserPwd(rmsUser.getUserPwd()));
            this.userSrv.addRole(pkUuid, Arrays.asList(role.split(",")));
            ArrayList<String> halfCheckList = new ArrayList<String>();
            halfCheckList.add("");
            this.userSrv.addDataAuth(pkUuid, "ORGAN", organList, halfCheckList);
            this.userSrv.addDataAuth(pkUuid, "CHANNEL", Arrays.asList(channel.split(",")), halfCheckList);
            this.userSrv.addDataAuth(pkUuid, "Platform", Arrays.asList(platform.split(",")), halfCheckList);
            this.userSrv.addDataAuth(pkUuid, "PrivilegeLevel", Arrays.asList(privilegeLevel.split(",")), halfCheckList);
        } else {
            rmsUser.where().addEq(RmsUser.PK_UUID, (Object)pkUuid);
            this.dao.update((AbsModel)rmsUser);
            CacheManager.remove((String)("USER_INFO_" + pkUuid));
            CacheManager.remove((String)("USER_LIMIT_" + pkUuid));
        }
    }

    private RmsLimitVo wrapperUserLimit(String pkUuid) {
        String sql = "SELECT rur.pk_uuid, rr.* FROM rms_user_roles rur, rms_role rr       WHERE rur.role_id = rr.role_id AND rur.pk_uuid = ?";
        List roles = this.dao.findAll(sql, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(new Object[]{pkUuid})});
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return new RmsLimitVo();
        }
        List rolesList = roles.stream().map(o -> (RmsRole)JsonUtils.map2Class((Map)o, RmsRole.class)).collect(Collectors.toList());
        String roleAuthSql = "select t1.* from rms_resources_auth t1  where t1.relate_tab = ?  and t1.relate_field = ?  and t1.relate_fk in (select   role_id from rms_user_roles p1  where p1.pk_uuid = ?) ";
        List roleAuthList = this.dao.findAll(roleAuthSql + " \uff03NOTCHECK", Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(new Object[]{"rms_role", "role_id", pkUuid})});
        Map<Object, Object> roleAuthMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)roleAuthList)) {
            roleAuthMap = roleAuthList.stream().collect(Collectors.groupingBy(o -> String.valueOf(o.get("resource_type"))));
        }
        String userAuthSql = "select t1.* from rms_resources_auth t1  where t1.relate_tab = ?  and t1.relate_field = ?  and t1.relate_fk = ?";
        List userAuthList = this.dao.findAll(userAuthSql + " \uff03NOTCHECK", Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(new Object[]{"rms_user", "pk_uuid", pkUuid})});
        Map<Object, Object> userAuthMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)userAuthList)) {
            userAuthMap = userAuthList.stream().collect(Collectors.groupingBy(o -> String.valueOf(o.get("resource_type"))));
        }
        RmsLimitVo vo = new RmsLimitVo();
        vo.setRolesList(rolesList);
        vo.getResourceLimitMap().putAll(userAuthMap);
        vo.getResourceLimitMap().putAll(roleAuthMap);
        CacheManager.put((String)("USER_LIMIT_" + pkUuid), (Object)vo, (int)604800);
        return vo;
    }

    public Map<String, Object> checkOmpAuchByToken(String token) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", "Bearer " + token);
        String resultStr = "";
        String testFlag = this.environment.getProperty("userAuth" + RmsUserSourceEnum.yg.getCode() + ".flag");
        try {
            resultStr = "1".equals(testFlag) ? "{\"status\":0,\"statusText\":\"Success\",\"message\":\"Success\",\"timestamp\":1717645583682,\"data\":{\"userId\":\"b88f1480\",\"userName\":\"\u6d4b\u8bd5\u8fd0\u7ba120250324\",\"userCode\":\"testestyg20250324\",\"userEmail\":\"\"}}" : HttpUtils.get((String)this.ompTokenGetUserUrl, headerMap);
            Map result = JsonUtils.json2Map((String)resultStr);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

