/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Pattern;

public class DateUtil {
    public static final String FORMAT_ONE = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_TWO = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_THREE = "yyyyMMdd-HHmmss";
    public static final String FORMAT_FOUR = "yyyyMMddHHmmss";
    public static final String FORMAT_FIVE = "MM-dd HH:mm";
    public static final String LONG_DATE_FORMAT = "yyyy-MM-dd";
    public static final String EIGHT_STYLE_DATE_FORMAT = "yyyyMMdd";
    public static final String SHORT_DATE_FORMAT = "MM-dd";
    public static final String LONG_TIME_FORMAT = "HH:mm:ss";
    public static final String MONTG_DATE_FORMAT = "yyyy-MM";
    public static final String MONTH_DATE_FORMAT_2 = "yyyy/MM";
    public static final String MONTH_DATE_FORMAT_3 = "yyyyMM";
    public static final int SUB_YEAR = 1;
    public static final int SUB_MONTH = 2;
    public static final int SUB_DAY = 5;
    public static final int SUB_HOUR = 10;
    public static final int SUB_MINUTE = 12;
    public static final int SUB_SECOND = 13;
    public static final String FORMAT_Five_New = "yyyyMMddHHmmssSS";
    static final String[] dayNames = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Date toDate(String dateStr) {
        Date d = null;
        SimpleDateFormat formater = new SimpleDateFormat(FORMAT_ONE);
        try {
            formater.setLenient(false);
            d = formater.parse(dateStr);
        }
        catch (Exception e) {
            d = null;
        }
        return d;
    }

    public static Date toDate(String dateStr, String format) {
        Date d = null;
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            formater.setLenient(false);
            d = formater.parse(dateStr);
        }
        catch (Exception e) {
            d = null;
        }
        return d;
    }

    public static String formatDateTime(Date date) {
        String result = "";
        SimpleDateFormat formater = new SimpleDateFormat(FORMAT_ONE);
        try {
            result = formater.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String formatDateTime(Date date, String format) {
        String result = "";
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            result = formater.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getCurrDate(String format) {
        return DateUtil.formatDateTime(new Date(), format);
    }

    public static String dateSub(int dateKind, String dateStr, int amount) {
        Date date = DateUtil.toDate(dateStr, FORMAT_ONE);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(dateKind, amount);
        return DateUtil.formatDateTime(calendar.getTime(), FORMAT_ONE);
    }

    public static long timeSub(String firstTime, String secTime) {
        long first = DateUtil.toDate(firstTime, FORMAT_ONE).getTime();
        long second = DateUtil.toDate(secTime, FORMAT_ONE).getTime();
        return (second - first) / 1000L;
    }

    public static long timeSub(Date firstTime, Date secTime) {
        long first = firstTime.getTime();
        long second = secTime.getTime();
        return (second - first) / 1000L;
    }

    public static int getDaysOfMonth(String year, String month) {
        int days = 0;
        days = month.equals("1") || month.equals("3") || month.equals("5") || month.equals("7") || month.equals("8") || month.equals("10") || month.equals("12") ? 31 : (month.equals("4") || month.equals("6") || month.equals("9") || month.equals("11") ? 30 : (Integer.parseInt(year) % 4 == 0 && Integer.parseInt(year) % 100 != 0 || Integer.parseInt(year) % 400 == 0 ? 29 : 28));
        return days;
    }

    public static int getDaysOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        return calendar.getActualMaximum(5);
    }

    public static int getToday() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(5);
    }

    public static int getToMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1;
    }

    public static int getToYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }

    public static int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static long dayDiff(Date date1, Date date2) {
        return (date2.getTime() - date1.getTime()) / 86400000L;
    }

    public static int yearDiff(String before, String after) {
        Date beforeDay = DateUtil.toDate(before, LONG_DATE_FORMAT);
        Date afterDay = DateUtil.toDate(after, LONG_DATE_FORMAT);
        return DateUtil.getYear(afterDay) - DateUtil.getYear(beforeDay);
    }

    public static int monthDiff(Date before, Date after) {
        return DateUtil.getMonth(after) - DateUtil.getMonth(before);
    }

    public static int yearDiffCurr(String after) {
        Date beforeDay = new Date();
        Date afterDay = DateUtil.toDate(after, LONG_DATE_FORMAT);
        return DateUtil.getYear(beforeDay) - DateUtil.getYear(afterDay);
    }

    public static long dayDiffCurr(String before) {
        Date currDate = DateUtil.toDate(DateUtil.currDay(), LONG_DATE_FORMAT);
        Date beforeDate = DateUtil.toDate(before, LONG_DATE_FORMAT);
        return (currDate.getTime() - beforeDate.getTime()) / 86400000L;
    }

    public static int getFirstWeekdayOfMonth(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(7);
        c.set(year, month - 1, 1);
        return c.get(7);
    }

    public static int getLastWeekdayOfMonth(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(7);
        c.set(year, month - 1, DateUtil.getDaysOfMonth(year, month));
        return c.get(7);
    }

    public static String getNow() {
        Calendar today = Calendar.getInstance();
        return DateUtil.formatDateTime(today.getTime(), FORMAT_ONE);
    }

    public static String getAstro(String birth) {
        if (!DateUtil.isDate(birth)) {
            birth = "2000" + birth;
        }
        if (!DateUtil.isDate(birth)) {
            return "";
        }
        int month = Integer.parseInt(birth.substring(birth.indexOf("-") + 1, birth.lastIndexOf("-")));
        int day = Integer.parseInt(birth.substring(birth.lastIndexOf("-") + 1));
        String s = "\u9b54\u7faf\u6c34\u74f6\u53cc\u9c7c\u7261\u7f8a\u91d1\u725b\u53cc\u5b50\u5de8\u87f9\u72ee\u5b50\u5904\u5973\u5929\u79e4\u5929\u874e\u5c04\u624b\u9b54\u7faf";
        int[] arr = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 23, 22, 22};
        int start = month * 2 - (day < arr[month - 1] ? 2 : 0);
        return s.substring(start, start + 2) + "\u5ea7";
    }

    public static boolean isDate(String date) {
        StringBuffer reg = new StringBuffer("^((\\d{2}(([02468][048])|([13579][26]))-?((((0?");
        reg.append("[13578])|(1[02]))-?((0?[1-9])|([1-2][0-9])|(3[01])))");
        reg.append("|(((0?[469])|(11))-?((0?[1-9])|([1-2][0-9])|(30)))|");
        reg.append("(0?2-?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][12");
        reg.append("35679])|([13579][01345789]))-?((((0?[13578])|(1[02]))");
        reg.append("-?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))");
        reg.append("-?((0?[1-9])|([1-2][0-9])|(30)))|(0?2-?((0?[");
        reg.append("1-9])|(1[0-9])|(2[0-8]))))))");
        Pattern p = Pattern.compile(reg.toString());
        return p.matcher(date).matches();
    }

    public static Date nextMonth(Date date, int months) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(2, months);
        return cal.getTime();
    }

    public static Date getStartOfQuarter(Date date) {
        int month;
        int year;
        String dateString = "";
        if (null == date) {
            Calendar localTime = Calendar.getInstance();
            year = localTime.get(1);
            month = localTime.get(2) + 1;
        } else {
            year = DateUtil.getYear(date);
            month = DateUtil.getMonth(date);
        }
        if (month >= 1 && month <= 3) {
            dateString = year + "-01-01 00:00:00";
        }
        if (month >= 4 && month <= 6) {
            dateString = year + "-04-01 00:00:00";
        }
        if (month >= 7 && month <= 9) {
            dateString = year + "-07-01 00:00:00";
        }
        if (month >= 10 && month <= 12) {
            dateString = year + "-10-01 00:00:00";
        }
        return DateUtil.toDate(dateString);
    }

    public static Date nextYear(Date date, int year) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(1, year);
        return cal.getTime();
    }

    public static Date nextDay(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(6, day);
        return cal.getTime();
    }

    public static Date nextMinute(Date date, int minute) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(12, minute);
        return cal.getTime();
    }

    public static String nextDay(int day, String format) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(6, day);
        return DateUtil.formatDateTime(cal.getTime(), format);
    }

    public static Date nextWeek(Date date, int week) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(4, week);
        return cal.getTime();
    }

    public static String currDay() {
        return DateUtil.formatDateTime(new Date(), LONG_DATE_FORMAT);
    }

    public static String currDays() {
        return DateUtil.formatDateTime(new Date(), FORMAT_ONE);
    }

    public static String befoDay() {
        return DateUtil.befoDay(LONG_DATE_FORMAT);
    }

    public static String befoDay(String format) {
        return DateUtil.formatDateTime(DateUtil.nextDay(new Date(), -1), format);
    }

    public static String befoMonth(String format) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, -1);
        return DateUtil.formatDateTime(cal.getTime(), format);
    }

    public static String afterDay() {
        return DateUtil.formatDateTime(DateUtil.nextDay(new Date(), 1), LONG_DATE_FORMAT);
    }

    public static int getDayNum() {
        int daynum = 0;
        GregorianCalendar gd = new GregorianCalendar();
        Date dt = gd.getTime();
        GregorianCalendar gd1 = new GregorianCalendar(1900, 1, 1);
        Date dt1 = gd1.getTime();
        daynum = (int)((dt.getTime() - dt1.getTime()) / 86400000L);
        return daynum;
    }

    public static Date getDateByNum(int day) {
        GregorianCalendar gd = new GregorianCalendar(1900, 1, 1);
        Date date = gd.getTime();
        date = DateUtil.nextDay(date, day);
        return date;
    }

    public static String getYmdDateCN(String datestr) {
        if (datestr == null) {
            return "";
        }
        if (datestr.length() < 10) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(datestr.substring(0, 4)).append(datestr.substring(5, 7)).append(datestr.substring(8, 10));
        return buf.toString();
    }

    public static String getFirstDayOfMonth(String format) {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        return DateUtil.formatDateTime(cal.getTime(), format);
    }

    public static Date getFirstDayOfMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static String getFirstDayOfMonth(Date date, String format) {
        if (date == null) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return DateUtil.formatDateTime(cal.getTime(), format);
    }

    public static String getFirstSecondOfMonth(String format) {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return DateUtil.formatDateTime(cal.getTime(), format);
    }

    public static Date getFirstSecondOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getStartOfDay(date));
        cal.set(5, 1);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getFirstSecondOfMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getStartOfDay(new Date()));
        cal.set(5, 1);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndSecondOfMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getEndOfDay(new Date()));
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static Date getEndSecondOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getEndOfDay(date));
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static String getLastDayOfMonth(String format) {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return DateUtil.formatDateTime(cal.getTime(), format);
    }

    public static String getLastDayOfMonth(Date date, String format) {
        if (date == null) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return DateUtil.formatDateTime(cal.getTime(), format);
    }

    public static Date getLastDayOfMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getStartOfDay(Date day) {
        return DateUtil.getStartOfDay(day, Calendar.getInstance());
    }

    public static Date getTodayStart() {
        return DateUtil.getStartOfDay(new Date());
    }

    public static Date getBeforeDate(Date mirror, int dayNum) {
        Calendar current = Calendar.getInstance();
        current.setTime(mirror);
        current.add(10, -24 * dayNum);
        return current.getTime();
    }

    public static Date yesterday() {
        return DateUtil.offsetDay(new Date(), -1);
    }

    public static Date tomorrow() {
        return DateUtil.offsetDay(new Date(), 1);
    }

    public static Date lastWeek() {
        return DateUtil.offsetWeek(new Date(), -1);
    }

    public static Date nextWeek() {
        return DateUtil.offsetWeek(new Date(), 1);
    }

    public static Date lastMonth() {
        return DateUtil.offsetMonth(new Date(), -1);
    }

    public static Date nextMonth() {
        return DateUtil.offsetMonth(new Date(), 1);
    }

    public static Date offsetMillisecond(Date date, int offset) {
        return DateUtil.offset(date, 14, offset);
    }

    public static Date offsetSecond(Date date, int offset) {
        return DateUtil.offset(date, 13, offset);
    }

    public static Date offsetMinute(Date date, int offset) {
        return DateUtil.offset(date, 12, offset);
    }

    public static Date offsetHour(Date date, int offset) {
        return DateUtil.offset(date, 11, offset);
    }

    public static Date offsetDay(Date date, int offset) {
        return DateUtil.offset(date, 6, offset);
    }

    public static Date offsetWeek(Date date, int offset) {
        return DateUtil.offset(date, 3, offset);
    }

    public static Date offsetMonth(Date date, int offset) {
        return DateUtil.offset(date, 2, offset);
    }

    public static Date offset(Date mirror, int datePart, int offset) {
        Calendar current = Calendar.getInstance();
        current.setTime(mirror);
        current.add(datePart, -24 * offset);
        return current.getTime();
    }

    public static Date getStartOfDay(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        return cal.getTime();
    }

    public static Date getEndOfDay(Date day) {
        return DateUtil.getEndOfDay(day, Calendar.getInstance());
    }

    public static Date getEndOfDay(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(11, cal.getMaximum(11));
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        return cal.getTime();
    }

    public static Long timeDiffForDay(Date pBeginTime, Date pEndTime) throws ParseException {
        Long beginL = pBeginTime.getTime();
        Long endL = pEndTime.getTime();
        Long day = (endL - beginL) / 86400000L;
        return day;
    }

    @Deprecated
    public static Long timeDiffForHour(Date pBeginTime, Date pEndTime) {
        Long beginL = pBeginTime.getTime();
        Long endL = pEndTime.getTime();
        return (endL - beginL) % 86400000L / 3600000L;
    }

    public static Long timeDiffForMin(Date pBeginTime, Date pEndTime) throws ParseException {
        Long beginL = pBeginTime.getTime();
        Long endL = pEndTime.getTime();
        Long min = (endL - beginL) % 86400000L % 3600000L / 60000L;
        return min;
    }

    public static String getTime(Date time) {
        String result = null;
        Long temp = null;
        Date currentDate = new Date();
        try {
            temp = DateUtil.timeDiffForDay(time, currentDate);
            if (temp > 0L) {
                result = temp + "\u5929\u524d";
            } else {
                temp = DateUtil.timeDiffForHour(time, currentDate);
                if (temp > 0L) {
                    result = temp + "\u5c0f\u65f6\u524d";
                } else {
                    temp = DateUtil.timeDiffForMin(time, currentDate);
                    if (temp > 0L) {
                        result = temp + "\u5206\u79cd\u524d";
                    }
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result == null ? "\u521a\u624d" : result;
    }

    public static Date getMonthDelay(Date currentDay, int month) {
        Calendar current = Calendar.getInstance();
        current.setTime(currentDay);
        current.add(2, month);
        current.add(10, -24);
        return current.getTime();
    }

    public static Date getStartOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        cal.set(5, 1);
        cal.add(2, -1);
        return cal.getTime();
    }

    public static Date getStartOfToday() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        return cal.getTime();
    }

    public static Date getEndOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getMaximum(11));
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getMinEndOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static int getDaysOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.get(5);
    }

    public static int getWorkTime(String starttime, String endtime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_DATE_FORMAT);
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(starttime);
            dateTo = dateFormat.parse(endtime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int workdays = 0;
        Calendar cal = null;
        while (dateFrom.before(dateTo) || dateFrom.equals(dateTo)) {
            cal = Calendar.getInstance();
            cal.setTime(dateFrom);
            if (cal.get(7) != 7 && cal.get(7) != 1) {
                ++workdays;
            }
            cal.add(5, 1);
            dateFrom = cal.getTime();
        }
        return workdays;
    }

    public static int getYearDays(Calendar cal) {
        cal.set(6, 1);
        cal.roll(6, -1);
        int yearDays = cal.get(6);
        return yearDays;
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        cal.set(7, cal.getFirstDayOfWeek());
        return cal.getTime();
    }

    public static Date getFirstDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(DateUtil.getStartOfDay(new Date()));
        cal.set(7, cal.getFirstDayOfWeek());
        return cal.getTime();
    }

    public static Date getEndOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(1);
        cal.setTime(DateUtil.getEndOfDay(new Date()));
        cal.add(4, 1);
        cal.set(7, cal.getFirstDayOfWeek());
        return cal.getTime();
    }

    public static int getWeekOfMonth() {
        Calendar c = Calendar.getInstance();
        return c.get(4);
    }

    public static Date getLastDayOfWeek(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setFirstDayOfWeek(2);
        cal.setTime(new Date());
        cal.set(7, cal.getFirstDayOfWeek() + 6);
        return cal.getTime();
    }

    public static Date getStartOfLastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        cal.set(7, 2);
        cal.add(4, -1);
        return cal.getTime();
    }

    public static Date getEndOfLastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getMaximum(11));
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        cal.set(7, 1);
        return cal.getTime();
    }

    public static Date getEndOfLastWed(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dateNum = cal.get(7);
        if (dateNum < 5) {
            cal.add(4, -1);
        }
        cal.set(11, cal.getMaximum(11));
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        cal.set(7, 4);
        return cal.getTime();
    }

    public static Date getStartOfLastThu(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dateNum = cal.get(7);
        if (dateNum < 5) {
            cal.add(4, -2);
        } else {
            cal.add(4, -1);
        }
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        cal.set(7, 5);
        return cal.getTime();
    }

    public static Date getStartOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        cal.set(6, cal.getMinimum(6));
        return cal.getTime();
    }

    public static Date getEndSecondOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getEndOfDay(new Date()));
        cal.set(6, cal.getActualMaximum(6));
        return cal.getTime();
    }

    public static String getNextMonth0fDay(Date date, String format) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.add(2, 2);
        cal.add(5, -1);
        return DateUtil.formatDateTime(cal.getTime(), format);
    }

    public static long getRecentTimeVal() {
        long millisecondsIn38 = 1198368000L;
        return System.currentTimeMillis() / 1000L - millisecondsIn38;
    }

    public static int getDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        return cal.get(7);
    }

    public static Date getNextMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        int dayOfWeek = cal.get(7);
        cal.add(5, (7 - dayOfWeek + 2) % 7);
        return cal.getTime();
    }

    public static int getHourOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        return cal.get(11);
    }

    public static Long getRemainingSeconds() {
        return DateUtil.timeSub(new Date(), DateUtil.getEndOfDay(new Date()));
    }

    public static int getDiscrepantDays(Date dateStart, Date dateEnd) {
        return (int)((dateEnd.getTime() - dateStart.getTime()) / 1000L / 60L / 60L / 24L);
    }

    public static Date getFirstSecondNextMonth(Date date, int month) {
        Calendar cal = Calendar.getInstance();
        cal.add(2, month);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getFirstSecondOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getStartOfDay(date));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static void main(String[] args) throws ParseException {
        Long diffForHour = DateUtil.timeDiffForHour(DateUtil.toDate("2020-05-13 10:00:00"), new Date());
        System.out.println(diffForHour);
        System.out.println(DateUtil.getFirstSecondOfDay(new Date()));
        Date firstSecondOfDay = DateUtil.getFirstSecondOfDay(new Date());
        Date date = DateUtil.nextDay(firstSecondOfDay, -2);
        System.out.println(DateUtil.getFirstDayOfMonth(EIGHT_STYLE_DATE_FORMAT));
        System.out.println(DateUtil.getCurrentMonth("2023-05"));
        System.out.println(0);
        System.out.println(1);
    }

    public static String dateSub(String dateStr, String format, int day, int dateKind) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.get(dateKind) + day);
        return DateUtil.formatDateTime(calendar.getTime(), format);
    }

    public static String lastYearEndDate(String month) throws ParseException {
        Date format1 = new SimpleDateFormat(LONG_DATE_FORMAT).parse(month + "-01");
        String longDate = new SimpleDateFormat(LONG_DATE_FORMAT).format(format1);
        SimpleDateFormat f = new SimpleDateFormat(LONG_DATE_FORMAT, Locale.CHINA);
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setTime(f.parse(longDate));
        c.add(1, -1);
        c.set(6, c.getActualMaximum(6));
        return f.format(c.getTime());
    }

    public static String yearNewDate(String month) throws ParseException {
        Date format1 = new SimpleDateFormat(LONG_DATE_FORMAT).parse(month + "-01");
        String longDate = new SimpleDateFormat(LONG_DATE_FORMAT).format(format1);
        SimpleDateFormat f = new SimpleDateFormat(LONG_DATE_FORMAT, Locale.CHINA);
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setTime(f.parse(longDate));
        c.clear(2);
        return f.format(c.getTime());
    }

    public static String yearEndDate(String month) throws ParseException {
        Date format1 = new SimpleDateFormat(LONG_DATE_FORMAT).parse(month + "-01");
        String longDate = new SimpleDateFormat(LONG_DATE_FORMAT).format(format1);
        SimpleDateFormat f = new SimpleDateFormat(LONG_DATE_FORMAT, Locale.CHINA);
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setTime(f.parse(longDate));
        c.set(6, c.getActualMaximum(6));
        return f.format(c.getTime());
    }

    public static String monthEndDate(String month) throws ParseException {
        Date format1 = new SimpleDateFormat(LONG_DATE_FORMAT).parse(month + "-01");
        String longDate = new SimpleDateFormat(LONG_DATE_FORMAT).format(format1);
        SimpleDateFormat f = new SimpleDateFormat(LONG_DATE_FORMAT, Locale.CHINA);
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setTime(f.parse(longDate));
        c.set(2, c.getActualMaximum(2));
        return f.format(c.getTime());
    }

    public static String lastYearMonth(String month) throws ParseException {
        Date format1 = new SimpleDateFormat(LONG_DATE_FORMAT).parse(month + "-01");
        String longDate = new SimpleDateFormat(LONG_DATE_FORMAT).format(format1);
        SimpleDateFormat f = new SimpleDateFormat(LONG_DATE_FORMAT, Locale.CHINA);
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setTime(f.parse(longDate));
        c.add(1, -1);
        String lastYearMonth = f.format(c.getTime()).substring(0, 7);
        return lastYearMonth;
    }

    public static String lastYearLastMonth(String month) throws ParseException {
        Date format1 = new SimpleDateFormat(LONG_DATE_FORMAT).parse(month + "-01");
        String longDate = new SimpleDateFormat(LONG_DATE_FORMAT).format(format1);
        SimpleDateFormat f = new SimpleDateFormat(LONG_DATE_FORMAT, Locale.CHINA);
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setTime(f.parse(longDate));
        c.add(1, -1);
        c.add(2, -1);
        String lastYearMonth = f.format(c.getTime()).substring(0, 7);
        return lastYearMonth;
    }

    public static String lastMonths(String month, int monthBetween) throws ParseException {
        Date format1 = new SimpleDateFormat(LONG_DATE_FORMAT).parse(month + "-01");
        String longDate = new SimpleDateFormat(LONG_DATE_FORMAT).format(format1);
        SimpleDateFormat f = new SimpleDateFormat(LONG_DATE_FORMAT, Locale.CHINA);
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setTime(f.parse(longDate));
        c.add(2, monthBetween);
        String newTime = f.format(c.getTime()).substring(0, 7);
        return newTime;
    }

    public static String lastMonth(String month) throws ParseException {
        Date format1 = new SimpleDateFormat(LONG_DATE_FORMAT).parse(month + "-01");
        String longDate = new SimpleDateFormat(LONG_DATE_FORMAT).format(format1);
        SimpleDateFormat f = new SimpleDateFormat(LONG_DATE_FORMAT, Locale.CHINA);
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setTime(f.parse(longDate));
        c.add(2, -1);
        String lastMonth = f.format(c.getTime()).substring(0, 7);
        return lastMonth;
    }

    public static String lastYear(String month) throws ParseException {
        Date format1 = new SimpleDateFormat(LONG_DATE_FORMAT).parse(month + "-01");
        String longDate = new SimpleDateFormat(LONG_DATE_FORMAT).format(format1);
        SimpleDateFormat f = new SimpleDateFormat(LONG_DATE_FORMAT, Locale.CHINA);
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setTime(f.parse(longDate));
        c.add(1, -1);
        String lastYear = f.format(c.getTime()).substring(0, 4);
        return lastYear;
    }

    public static String lastYearEndMonth(String month) throws ParseException {
        Date format1 = new SimpleDateFormat(LONG_DATE_FORMAT).parse(month + "-01");
        String longDate = new SimpleDateFormat(LONG_DATE_FORMAT).format(format1);
        SimpleDateFormat f = new SimpleDateFormat(LONG_DATE_FORMAT, Locale.CHINA);
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setTime(f.parse(longDate));
        c.add(1, -1);
        c.set(6, c.getActualMaximum(6));
        String lastYearEndMonth = f.format(c.getTime()).substring(0, 7);
        return lastYearEndMonth;
    }

    public static int getCurrentMonth(String month) throws ParseException {
        Date format1 = new SimpleDateFormat(LONG_DATE_FORMAT).parse(month + "-01");
        String longDate = new SimpleDateFormat(LONG_DATE_FORMAT).format(format1);
        SimpleDateFormat f = new SimpleDateFormat(LONG_DATE_FORMAT, Locale.CHINA);
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setTime(f.parse(longDate));
        return c.get(2) + 1;
    }

    public static int getCurrentQuarter(String date, int month) throws ParseException {
        if (month != 0) {
            date = DateUtil.lastMonths(date, month);
        }
        int thisMonth = DateUtil.getCurrentMonth(date);
        int quarter = 0;
        if (thisMonth >= 1 && thisMonth <= 3) {
            quarter = 1;
        }
        if (thisMonth >= 4 && thisMonth <= 6) {
            quarter = 2;
        }
        if (thisMonth >= 7 && thisMonth <= 9) {
            quarter = 3;
        }
        if (thisMonth >= 10 && thisMonth <= 12) {
            quarter = 4;
        }
        return quarter;
    }

    public static String getEndOfQuarter(String date, int month) throws ParseException {
        if (month != 0) {
            date = DateUtil.lastMonths(date, month);
        }
        int thisMonth = DateUtil.getCurrentMonth(date);
        String[] time = date.split("-");
        String year = time[0];
        String quarter = "03";
        if (thisMonth >= 4 && thisMonth <= 6) {
            quarter = "06";
        }
        if (thisMonth >= 7 && thisMonth <= 9) {
            quarter = "09";
        }
        if (thisMonth >= 10 && thisMonth <= 12) {
            quarter = "12";
        }
        return year + "-" + quarter;
    }
}

