/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.risk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.risk.RiskAttribute;
import com.newtouch.nms.sip.product.transfer.domain.risk.RiskDetail;
import com.newtouch.nms.sip.product.transfer.domain.rule.Rule;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;

public class Risk
implements Comparable {
    private DsnStructure riskNode;
    private RiskDetail detail;
    private RiskAttribute attribute;
    private Rule rule;
    private boolean onlyReslation;

    public Risk load(DsnStructure riskNode) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.riskNode = riskNode;
        this.detail = new RiskDetail();
        this.detail.load(this.riskNode.getNodeNo(), this.detailNodeType());
        this.attribute = new RiskAttribute();
        this.attribute.load(this.riskNode.getNodeNo());
        this.rule = new Rule();
        this.rule.load(riskNode.getNodeNo(), NodeType.N_RULE.code());
        return this;
    }

    public void merge(Risk risk) {
        this.riskNode = ProductEqualsUtils.merge(this.riskNode, risk.getRiskNode());
        this.detail = ProductEqualsUtils.merge(this.detail, risk.getDetail(), RiskDetail.class);
        this.attribute = ProductEqualsUtils.merge(this.attribute, risk.getAttribute(), RiskAttribute.class);
        this.rule = ProductEqualsUtils.merge(this.rule, risk.getRule(), Rule.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (this.riskNode != null && !ProductEqualsUtils.isPropose(source)) {
            update.update((AbsModel)this.riskNode);
        }
        if (this.detail != null && !this.isOnlyReslation()) {
            this.detail.save();
        }
        if (this.attribute != null && !this.isOnlyReslation()) {
            this.attribute.save();
        }
        if (this.rule != null && !this.isOnlyReslation()) {
            this.rule.save();
        }
    }

    public String detailNodeType() {
        return NodeType.N_RISK_DETAIL.code();
    }

    @JsonIgnore
    public Risk getBaseRisk() {
        Risk risk = new Risk();
        risk.setRiskNode(this.getRiskNode());
        risk.setDetail(this.getDetail());
        risk.setAttribute(this.getAttribute());
        this.setRule(this.getRule());
        return risk;
    }

    public TreeNode fetchTreeNode() {
        CompareEnum.NodeType nodeType = CompareEnum.NodeType.RISK;
        if (this.detail == null) {
            return null;
        }
        TreeNode node = new TreeNode(nodeType.getTag() + this.detail.getRisk().getRiskNo(), this.detail.getRisk().getRiskName());
        node.getChildren().add(this.detail.fetchTreeNode());
        if (this.riskNode != null) {
            node.getChildren().add(new TreeNode(this.riskNode.getSerno(), this.riskNode, CompareEnum.NodeType.STRUCTURE));
        }
        if (this.attribute != null) {
            node.getChildren().add(this.attribute.fetchTreeNode());
        }
        if (this.rule != null) {
            node.getChildren().add(this.rule.fetchTreeNode());
        }
        return node;
    }

    @JsonIgnore
    public DsnStructure detailNode() {
        return this.getDetail().getRiskDetail();
    }

    public DsnStructure getRiskNode() {
        return this.riskNode;
    }

    public void setRiskNode(DsnStructure riskNode) {
        this.riskNode = riskNode;
    }

    public RiskDetail getDetail() {
        return this.detail;
    }

    public void setDetail(RiskDetail detail) {
        this.detail = detail;
    }

    public RiskAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(RiskAttribute attribute) {
        this.attribute = attribute;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public boolean isOnlyReslation() {
        return this.onlyReslation;
    }

    public void setOnlyReslation(boolean onlyReslation) {
        this.onlyReslation = onlyReslation;
    }

    public int hashCode() {
        return this.riskNode.getOtherProperty("md5").hashCode();
    }

    public int compareTo(Object o) {
        ProductUpdateUtils.UpdateFlag flag = (ProductUpdateUtils.UpdateFlag)((Object)this.riskNode.getOtherProperty("update_flag", ProductUpdateUtils.UpdateFlag.class));
        if (flag == ProductUpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }
}

