/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.product;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.attribute.Attribute;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class ProductDetail {
    private DsnStructure prdDetail;
    private List<Attribute> attributeList;
    private SipProducts products;

    public ProductDetail load(String upNode) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.prdDetail = utils.queryStructure(upNode, NodeType.PRD_DETAIL.code());
        if (this.prdDetail == null) {
            return this;
        }
        this.attributeList = new ArrayList<Attribute>();
        List<DsnStructure> dsnAttrList = null;
        dsnAttrList = utils.queryStructures(this.prdDetail.getNodeNo());
        for (DsnStructure dsnAttr : dsnAttrList) {
            Attribute attr = new Attribute();
            attr.load(dsnAttr);
            this.attributeList.add(attr);
        }
        this.products = utils.queryProduct(this.prdDetail.getNodeNo());
        return this;
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update((AbsModel)this.prdDetail);
        }
        this.attributeList.forEach(attr -> {
            if (("prp_start_date".equals(attr.getBizAttribute().getAttrNo()) || "prp_end_date".equals(attr.getBizAttribute().getAttrNo()) || "product_image".equals(attr.getBizAttribute().getAttrNo())) && ProductEqualsUtils.isPropose(source)) {
                attr.save();
            }
            if (!("prp_start_date".equals(attr.getBizAttribute().getAttrNo()) || "prp_end_date".equals(attr.getBizAttribute().getAttrNo()) || "product_image".equals(attr.getBizAttribute().getAttrNo()) || ProductEqualsUtils.isPropose(source))) {
                attr.save();
            }
        });
        if (!ProductEqualsUtils.isPropose(source)) {
            String productImage = update.getProductImage(this.products.getProductNo());
            this.products.setProductImage(productImage);
            update.update((AbsModel)this.products);
        } else {
            SipProducts newSip = new SipProducts();
            newSip.setProductImage(this.products.getProductImage());
            newSip.setSerno(this.products.getSerno());
            newSip.putOtherProperty("update_flag", this.products.getOtherProperty("update_flag", ProductUpdateUtils.UpdateFlag.class));
            update.update((AbsModel)newSip);
        }
    }

    public void merge(ProductDetail detail) {
        this.prdDetail = ProductEqualsUtils.merge(this.prdDetail, detail.getPrdDetail());
        this.products = ProductEqualsUtils.merge(this.products, detail.getProducts());
        this.attributeList = ProductEqualsUtils.merge(this.attributeList, detail.getAttributeList(), Attribute.class);
    }

    public TreeNode fetchTreeNode() {
        if (this.prdDetail == null) {
            return null;
        }
        TreeNode node = new TreeNode(CompareEnum.NodeType.DETAIL.getTag() + this.prdDetail.getSerno(), CompareEnum.NodeType.DETAIL.getLable());
        node.getChildren().add(new TreeNode(this.prdDetail.getSerno(), this.prdDetail, CompareEnum.NodeType.STRUCTURE));
        if (this.attributeList != null && this.attributeList.size() > 0) {
            TreeNode attributeList = new TreeNode(CompareEnum.NodeType.ATTRIBUTES.getTag() + this.prdDetail.getSerno(), CompareEnum.NodeType.ATTRIBUTES.getLable());
            node.getChildren().add(attributeList);
            for (Attribute attribute : this.attributeList) {
                attributeList.getChildren().add(attribute.fetchTreeNode());
            }
        }
        node.getChildren().add(new TreeNode(this.products.getSerno(), this.products, CompareEnum.NodeType.INFO));
        return node;
    }

    public DsnStructure getPrdDetail() {
        return this.prdDetail;
    }

    public void setPrdDetail(DsnStructure prdDetail) {
        this.prdDetail = prdDetail;
    }

    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(List<Attribute> attributeList) {
        this.attributeList = attributeList;
    }

    public SipProducts getProducts() {
        return this.products;
    }

    public void setProducts(SipProducts products) {
        this.products = products;
    }
}

