/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.design.rule.services.impl;

import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.base.service.RuleUsedService;
import com.newtouch.nms.sip.design.rule.model.DsnRulesAndConst;
import com.newtouch.nms.sip.design.rule.services.IPublicRuleService;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SysEnumConf;
import com.newtouch.nms.sip.model.WsLifeTCompanyOrgan;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.model.enums.RuleTypeName;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class PublicRuleServiceImpl
implements IPublicRuleService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private RuleUsedService ruleUsedService;

    @Override
    public ReturnMsg delRule(Map<String, Object> paramMap) {
        Return r = new Return();
        List nodeList = (List)paramMap.get("node_list");
        for (Map nodeNoMap : nodeList) {
            String nodeNo = StrUtils.trimStr(nodeNoMap.get("node_no"));
            Ulog.info((String)("\u8981\u5220\u9664\u7684\u89c4\u5219\u7684node_no--->" + nodeNo));
            DsnStructure node = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)nodeNo).model());
            if (StrUtils.isNull((Object)node)) {
                r.setFailMsg("\u65e0\u6cd5\u5220\u9664\u89c4\u5219\uff01");
                return r.msg();
            }
            this.dao.delete(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)node.getNodeNo()).model());
            this.ruleUsedService.delRuleInfo(nodeNo);
        }
        return r.msg();
    }

    @Override
    public ReturnMsg saveRulesInfo(List<DsnRulesAndConst> rules, String nodeNo, String flag) {
        Return result = new Return();
        if (StrUtils.isNull((Object)nodeNo)) {
            result.setFailMsg("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return result.msg();
        }
        this.saveRules(rules, nodeNo);
        List<DsnRules> ruleInfoList = this.queryDsnRules(nodeNo, flag);
        result.setDataList(ruleInfoList, DsnRules.class);
        return result.msg();
    }

    private List<DsnRules> queryDsnRules(String nodeNo, String flag) {
        DsnRules rule = (DsnRules)DsnRules.n().where().addEq(DsnRules.RELATE_FK, (Object)nodeNo).model();
        if (!"1".equals(flag)) {
            rule.where().addEq(DsnRules.STATUS, (Object)"1");
        }
        rule.setOrderBy(new Sort.Order[]{DsnRules.SCHEDULE_ORDER.asc()});
        List ruleInfoList = this.dao.findAll((AbsModel)rule);
        return ruleInfoList;
    }

    private void saveRules(List<DsnRulesAndConst> ruleList, String nodeNo) {
        if (ruleList == null || ruleList.isEmpty()) {
            return;
        }
        String userNo = ThreadLocalContext.get().getUser().getUserCode();
        this.dao.delete(DsnRules.n().where().addEq(DsnRules.RELATE_FK, (Object)nodeNo).model());
        for (DsnRulesAndConst rule : ruleList) {
            rule.setRelateFk(nodeNo);
            if (StrUtils.isNull((Object)rule.getRuleId())) {
                rule.setRuleId(UUID.shortUUID());
            }
            this.saveRuleConst(rule);
            rule.checkValue();
            this.dao.save((AbsModel)rule);
        }
    }

    private void saveRuleConst(DsnRulesAndConst rule) {
        Map<String, Object> json2Map = rule.getConstMap();
        if (json2Map == null || json2Map.isEmpty()) {
            return;
        }
        this.dao.delete(DsnRulesConst.n().where().addEq(DsnRulesConst.RULE_ID, (Object)rule.getRuleId()).model());
        for (Map.Entry<String, Object> entry : json2Map.entrySet()) {
            if ("####".equals(entry.getKey())) {
                throw new BusinessException(new Message("\u5e38\u91cf\u89c4\u5219\u4fdd\u5b58\u5165\u53c2\u9519\u8bef"));
            }
            DsnRulesConst ruleConst = DsnRulesConst.n();
            ruleConst.setConstId(entry.getKey());
            ruleConst.setConstMapping(StrUtils.trimStr((Object)entry.getValue()));
            ruleConst.setRuleId(rule.getRuleId());
            this.dao.save((AbsModel)ruleConst);
        }
    }

    @Override
    public ReturnMsg queryAllRulesInfoByNodeNo(String nodeNo) {
        Return result = new Return();
        if (StrUtils.isNull((Object)nodeNo)) {
            result.setFailMsg("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return result.msg();
        }
        DsnStructure nRuleNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)nodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RULE.code()).model());
        if (StrUtils.isNull((Object)nRuleNode)) {
            return result.msg();
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> sqlList = new ArrayList<String>();
        sql.append("select dsr.*,dr.rule_type from dsn_structure_rules dsr \nleft join dsn_rules dr on dsr.node_no = dr.relate_fk and dsr.rule_id = dr.rule_id \nwhere dsr.node_no = ? ");
        String nodeNoSelect = nRuleNode.getNodeNo();
        sqlList.add(nodeNoSelect);
        List all4Map = this.dao.findAll(sql.toString(), new AbsModelRepository.Args[]{this.dao.args(sqlList)});
        all4Map.forEach(p -> {
            String pRuleType = StrUtils.isNull(p.get("rule_type")) ? "" : p.get("rule_type").toString();
            p.put("rule_type_name", RuleTypeName.getName((String)pRuleType));
            if (!StrUtils.isNull(p.get("is_quote")) && "Y".equals(p.get("is_quote"))) {
                DsnRules dsnRules = new DsnRules();
                dsnRules.where().addEq(DsnRules.RULE_ID, p.get("quote_rule_id"));
                dsnRules = (DsnRules)this.dao.findOne((AbsModel)dsnRules);
                if (!StrUtils.isNull((Object)dsnRules)) {
                    String ruleType = dsnRules.getRuleType();
                    p.put("rule_type", ruleType);
                    p.put("rule_type_name", RuleTypeName.getName((String)ruleType));
                }
            }
            p.put("event_name", NodeType.getName((String)StrUtils.trimStr(p.get("event_type"))));
            List wsLifeTCompanyOrgan = this.dao.findAll(WsLifeTCompanyOrgan.n().where().addIn(WsLifeTCompanyOrgan.ORGAN_ID, Arrays.asList(StrUtils.trimStr(p.get("organ_id")).split(","))).model());
            String organStr = wsLifeTCompanyOrgan.stream().map(WsLifeTCompanyOrgan::getCompanyName).collect(Collectors.joining(","));
            p.put("organ_name", organStr);
            List sysEnumConf = this.dao.findAll(SysEnumConf.n().where().addEq(SysEnumConf.UP_ENUM, (Object)"channel_type").addIn(SysEnumConf.ENUM_CODE, Arrays.asList(StrUtils.trimStr(p.get("channel_no")).split(","))).model());
            String channelStr = sysEnumConf.stream().map(SysEnumConf::getEnumName).collect(Collectors.joining(","));
            p.put("channel_name", channelStr);
        });
        result.setDataList(all4Map);
        return result.msg();
    }
}

